"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "vendor-chunks/@lexical";
exports.ids = ["vendor-chunks/@lexical"];
exports.modules = {

/***/ "(rsc)/./node_modules/@lexical/clipboard/LexicalClipboard.dev.mjs":
/*!******************************************************************!*\
  !*** ./node_modules/@lexical/clipboard/LexicalClipboard.dev.mjs ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   $generateJSONFromSelectedNodes: () => (/* binding */ $generateJSONFromSelectedNodes),\n/* harmony export */   $generateNodesFromSerializedNodes: () => (/* binding */ $generateNodesFromSerializedNodes),\n/* harmony export */   $getClipboardDataFromSelection: () => (/* binding */ $getClipboardDataFromSelection),\n/* harmony export */   $getHtmlContent: () => (/* binding */ $getHtmlContent),\n/* harmony export */   $getLexicalContent: () => (/* binding */ $getLexicalContent),\n/* harmony export */   $insertDataTransferForPlainText: () => (/* binding */ $insertDataTransferForPlainText),\n/* harmony export */   $insertDataTransferForRichText: () => (/* binding */ $insertDataTransferForRichText),\n/* harmony export */   $insertGeneratedNodes: () => (/* binding */ $insertGeneratedNodes),\n/* harmony export */   copyToClipboard: () => (/* binding */ copyToClipboard),\n/* harmony export */   setLexicalClipboardDataTransfer: () => (/* binding */ setLexicalClipboardDataTransfer)\n/* harmony export */ });\n/* harmony import */ var _lexical_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lexical/html */ \"(rsc)/./node_modules/@lexical/html/LexicalHtml.dev.mjs\");\n/* harmony import */ var _lexical_selection__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lexical/selection */ \"(rsc)/./node_modules/@lexical/selection/LexicalSelection.dev.mjs\");\n/* harmony import */ var _lexical_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lexical/utils */ \"(rsc)/./node_modules/@lexical/utils/LexicalUtils.dev.mjs\");\n/* harmony import */ var lexical__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lexical */ \"(rsc)/./node_modules/lexical/Lexical.dev.mjs\");\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\n\n\n\n\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\n// Do not require this module directly! Use normal `invariant` calls.\n\nfunction formatDevErrorMessage(message) {\n  throw new Error(message);\n}\n\n/**\n * Returns the *currently selected* Lexical content as an HTML string, relying on the\n * logic defined in the exportDOM methods on the LexicalNode classes. Note that\n * this will not return the HTML content of the entire editor (unless all the content is included\n * in the current selection).\n *\n * @param editor - LexicalEditor instance to get HTML content from\n * @param selection - The selection to use (default is $getSelection())\n * @returns a string of HTML content\n */\nfunction $getHtmlContent(editor, selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)()) {\n  if (selection == null) {\n    {\n      formatDevErrorMessage(`Expected valid LexicalSelection`);\n    }\n  }\n\n  // If we haven't selected anything\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection) && selection.isCollapsed() || selection.getNodes().length === 0) {\n    return '';\n  }\n  return (0,_lexical_html__WEBPACK_IMPORTED_MODULE_1__.$generateHtmlFromNodes)(editor, selection);\n}\n\n/**\n * Returns the *currently selected* Lexical content as a JSON string, relying on the\n * logic defined in the exportJSON methods on the LexicalNode classes. Note that\n * this will not return the JSON content of the entire editor (unless all the content is included\n * in the current selection).\n *\n * @param editor  - LexicalEditor instance to get the JSON content from\n * @param selection - The selection to use (default is $getSelection())\n * @returns\n */\nfunction $getLexicalContent(editor, selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)()) {\n  if (selection == null) {\n    {\n      formatDevErrorMessage(`Expected valid LexicalSelection`);\n    }\n  }\n\n  // If we haven't selected anything\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection) && selection.isCollapsed() || selection.getNodes().length === 0) {\n    return null;\n  }\n  return JSON.stringify($generateJSONFromSelectedNodes(editor, selection));\n}\n\n/**\n * Attempts to insert content of the mime-types text/plain or text/uri-list from\n * the provided DataTransfer object into the editor at the provided selection.\n * text/uri-list is only used if text/plain is not also provided.\n *\n * @param dataTransfer an object conforming to the [DataTransfer interface] (https://html.spec.whatwg.org/multipage/dnd.html#the-datatransfer-interface)\n * @param selection the selection to use as the insertion point for the content in the DataTransfer object\n */\nfunction $insertDataTransferForPlainText(dataTransfer, selection) {\n  const text = dataTransfer.getData('text/plain') || dataTransfer.getData('text/uri-list');\n  if (text != null) {\n    selection.insertRawText(text);\n  }\n}\n\n/**\n * Attempts to insert content of the mime-types application/x-lexical-editor, text/html,\n * text/plain, or text/uri-list (in descending order of priority) from the provided DataTransfer\n * object into the editor at the provided selection.\n *\n * @param dataTransfer an object conforming to the [DataTransfer interface] (https://html.spec.whatwg.org/multipage/dnd.html#the-datatransfer-interface)\n * @param selection the selection to use as the insertion point for the content in the DataTransfer object\n * @param editor the LexicalEditor the content is being inserted into.\n */\nfunction $insertDataTransferForRichText(dataTransfer, selection, editor) {\n  const lexicalString = dataTransfer.getData('application/x-lexical-editor');\n  if (lexicalString) {\n    try {\n      const payload = JSON.parse(lexicalString);\n      if (payload.namespace === editor._config.namespace && Array.isArray(payload.nodes)) {\n        const nodes = $generateNodesFromSerializedNodes(payload.nodes);\n        return $insertGeneratedNodes(editor, nodes, selection);\n      }\n    } catch (_unused) {\n      // Fail silently.\n    }\n  }\n  const htmlString = dataTransfer.getData('text/html');\n  const plainString = dataTransfer.getData('text/plain');\n\n  // Skip HTML handling if it matches the plain text representation.\n  // This avoids unnecessary processing for plain text strings created by\n  // iOS Safari autocorrect, which incorrectly includes a `text/html` type.\n  if (htmlString && plainString !== htmlString) {\n    try {\n      const parser = new DOMParser();\n      const dom = parser.parseFromString(trustHTML(htmlString), 'text/html');\n      const nodes = (0,_lexical_html__WEBPACK_IMPORTED_MODULE_1__.$generateNodesFromDOM)(editor, dom);\n      return $insertGeneratedNodes(editor, nodes, selection);\n    } catch (_unused2) {\n      // Fail silently.\n    }\n  }\n\n  // Multi-line plain text in rich text mode pasted as separate paragraphs\n  // instead of single paragraph with linebreaks.\n  // Webkit-specific: Supports read 'text/uri-list' in clipboard.\n  const text = plainString || dataTransfer.getData('text/uri-list');\n  if (text != null) {\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      const parts = text.split(/(\\r?\\n|\\t)/);\n      if (parts[parts.length - 1] === '') {\n        parts.pop();\n      }\n      for (let i = 0; i < parts.length; i++) {\n        const currentSelection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n        if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(currentSelection)) {\n          const part = parts[i];\n          if (part === '\\n' || part === '\\r\\n') {\n            currentSelection.insertParagraph();\n          } else if (part === '\\t') {\n            currentSelection.insertNodes([(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createTabNode)()]);\n          } else {\n            currentSelection.insertText(part);\n          }\n        }\n      }\n    } else {\n      selection.insertRawText(text);\n    }\n  }\n}\nfunction trustHTML(html) {\n  if (window.trustedTypes && window.trustedTypes.createPolicy) {\n    const policy = window.trustedTypes.createPolicy('lexical', {\n      createHTML: input => input\n    });\n    return policy.createHTML(html);\n  }\n  return html;\n}\n\n/**\n * Inserts Lexical nodes into the editor using different strategies depending on\n * some simple selection-based heuristics. If you're looking for a generic way to\n * to insert nodes into the editor at a specific selection point, you probably want\n * {@link lexical.$insertNodes}\n *\n * @param editor LexicalEditor instance to insert the nodes into.\n * @param nodes The nodes to insert.\n * @param selection The selection to insert the nodes into.\n */\nfunction $insertGeneratedNodes(editor, nodes, selection) {\n  if (!editor.dispatchCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.SELECTION_INSERT_CLIPBOARD_NODES_COMMAND, {\n    nodes,\n    selection\n  })) {\n    selection.insertNodes(nodes);\n  }\n  return;\n}\nfunction exportNodeToJSON(node) {\n  const serializedNode = node.exportJSON();\n  const nodeClass = node.constructor;\n  if (serializedNode.type !== nodeClass.getType()) {\n    {\n      formatDevErrorMessage(`LexicalNode: Node ${nodeClass.name} does not implement .exportJSON().`);\n    }\n  }\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(node)) {\n    const serializedChildren = serializedNode.children;\n    if (!Array.isArray(serializedChildren)) {\n      {\n        formatDevErrorMessage(`LexicalNode: Node ${nodeClass.name} is an element but .exportJSON() does not have a children array.`);\n      }\n    }\n  }\n  return serializedNode;\n}\nfunction $appendNodesToJSON(editor, selection, currentNode, targetArray = []) {\n  let shouldInclude = selection !== null ? currentNode.isSelected(selection) : true;\n  const shouldExclude = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(currentNode) && currentNode.excludeFromCopy('html');\n  let target = currentNode;\n  if (selection !== null) {\n    let clone = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$cloneWithProperties)(currentNode);\n    clone = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(clone) && selection !== null ? (0,_lexical_selection__WEBPACK_IMPORTED_MODULE_2__.$sliceSelectedTextNodeContent)(selection, clone) : clone;\n    target = clone;\n  }\n  const children = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(target) ? target.getChildren() : [];\n  const serializedNode = exportNodeToJSON(target);\n\n  // TODO: TextNode calls getTextContent() (NOT node.__text) within its exportJSON method\n  // which uses getLatest() to get the text from the original node with the same key.\n  // This is a deeper issue with the word \"clone\" here, it's still a reference to the\n  // same node as far as the LexicalEditor is concerned since it shares a key.\n  // We need a way to create a clone of a Node in memory with its own key, but\n  // until then this hack will work for the selected text extract use case.\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(target)) {\n    const text = target.__text;\n    // If an uncollapsed selection ends or starts at the end of a line of specialized,\n    // TextNodes, such as code tokens, we will get a 'blank' TextNode here, i.e., one\n    // with text of length 0. We don't want this, it makes a confusing mess. Reset!\n    if (text.length > 0) {\n      serializedNode.text = text;\n    } else {\n      shouldInclude = false;\n    }\n  }\n  for (let i = 0; i < children.length; i++) {\n    const childNode = children[i];\n    const shouldIncludeChild = $appendNodesToJSON(editor, selection, childNode, serializedNode.children);\n    if (!shouldInclude && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(currentNode) && shouldIncludeChild && currentNode.extractWithChild(childNode, selection, 'clone')) {\n      shouldInclude = true;\n    }\n  }\n  if (shouldInclude && !shouldExclude) {\n    targetArray.push(serializedNode);\n  } else if (Array.isArray(serializedNode.children)) {\n    for (let i = 0; i < serializedNode.children.length; i++) {\n      const serializedChildNode = serializedNode.children[i];\n      targetArray.push(serializedChildNode);\n    }\n  }\n  return shouldInclude;\n}\n\n// TODO why $ function with Editor instance?\n/**\n * Gets the Lexical JSON of the nodes inside the provided Selection.\n *\n * @param editor LexicalEditor to get the JSON content from.\n * @param selection Selection to get the JSON content from.\n * @returns an object with the editor namespace and a list of serializable nodes as JavaScript objects.\n */\nfunction $generateJSONFromSelectedNodes(editor, selection) {\n  const nodes = [];\n  const root = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getRoot)();\n  const topLevelChildren = root.getChildren();\n  for (let i = 0; i < topLevelChildren.length; i++) {\n    const topLevelNode = topLevelChildren[i];\n    $appendNodesToJSON(editor, selection, topLevelNode, nodes);\n  }\n  return {\n    namespace: editor._config.namespace,\n    nodes\n  };\n}\n\n/**\n * This method takes an array of objects conforming to the BaseSeralizedNode interface and returns\n * an Array containing instances of the corresponding LexicalNode classes registered on the editor.\n * Normally, you'd get an Array of BaseSerialized nodes from {@link $generateJSONFromSelectedNodes}\n *\n * @param serializedNodes an Array of objects conforming to the BaseSerializedNode interface.\n * @returns an Array of Lexical Node objects.\n */\nfunction $generateNodesFromSerializedNodes(serializedNodes) {\n  const nodes = [];\n  for (let i = 0; i < serializedNodes.length; i++) {\n    const serializedNode = serializedNodes[i];\n    const node = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$parseSerializedNode)(serializedNode);\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(node)) {\n      (0,_lexical_selection__WEBPACK_IMPORTED_MODULE_2__.$addNodeStyle)(node);\n    }\n    nodes.push(node);\n  }\n  return nodes;\n}\nconst EVENT_LATENCY = 50;\nlet clipboardEventTimeout = null;\n\n// TODO custom selection\n// TODO potentially have a node customizable version for plain text\n/**\n * Copies the content of the current selection to the clipboard in\n * text/plain, text/html, and application/x-lexical-editor (Lexical JSON)\n * formats.\n *\n * @param editor the LexicalEditor instance to copy content from\n * @param event the native browser ClipboardEvent to add the content to.\n * @returns\n */\nasync function copyToClipboard(editor, event, data) {\n  if (clipboardEventTimeout !== null) {\n    // Prevent weird race conditions that can happen when this function is run multiple times\n    // synchronously. In the future, we can do better, we can cancel/override the previously running job.\n    return false;\n  }\n  if (event !== null) {\n    return new Promise((resolve, reject) => {\n      editor.update(() => {\n        resolve($copyToClipboardEvent(editor, event, data));\n      });\n    });\n  }\n  const rootElement = editor.getRootElement();\n  const editorWindow = editor._window || window;\n  const windowDocument = window.document;\n  const domSelection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.getDOMSelection)(editorWindow);\n  if (rootElement === null || domSelection === null) {\n    return false;\n  }\n  const element = windowDocument.createElement('span');\n  element.style.cssText = 'position: fixed; top: -1000px;';\n  element.append(windowDocument.createTextNode('#'));\n  rootElement.append(element);\n  const range = new Range();\n  range.setStart(element, 0);\n  range.setEnd(element, 1);\n  domSelection.removeAllRanges();\n  domSelection.addRange(range);\n  return new Promise((resolve, reject) => {\n    const removeListener = editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.COPY_COMMAND, secondEvent => {\n      if ((0,_lexical_utils__WEBPACK_IMPORTED_MODULE_3__.objectKlassEquals)(secondEvent, ClipboardEvent)) {\n        removeListener();\n        if (clipboardEventTimeout !== null) {\n          window.clearTimeout(clipboardEventTimeout);\n          clipboardEventTimeout = null;\n        }\n        resolve($copyToClipboardEvent(editor, secondEvent, data));\n      }\n      // Block the entire copy flow while we wait for the next ClipboardEvent\n      return true;\n    }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_CRITICAL);\n    // If the above hack execCommand hack works, this timeout code should never fire. Otherwise,\n    // the listener will be quickly freed so that the user can reuse it again\n    clipboardEventTimeout = window.setTimeout(() => {\n      removeListener();\n      clipboardEventTimeout = null;\n      resolve(false);\n    }, EVENT_LATENCY);\n    windowDocument.execCommand('copy');\n    element.remove();\n  });\n}\n\n// TODO shouldn't pass editor (pass namespace directly)\nfunction $copyToClipboardEvent(editor, event, data) {\n  if (data === undefined) {\n    const domSelection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.getDOMSelection)(editor._window);\n    if (!domSelection) {\n      return false;\n    }\n    const anchorDOM = domSelection.anchorNode;\n    const focusDOM = domSelection.focusNode;\n    if (anchorDOM !== null && focusDOM !== null && !(0,lexical__WEBPACK_IMPORTED_MODULE_0__.isSelectionWithinEditor)(editor, anchorDOM, focusDOM)) {\n      return false;\n    }\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (selection === null) {\n      return false;\n    }\n    data = $getClipboardDataFromSelection(selection);\n  }\n  event.preventDefault();\n  const clipboardData = event.clipboardData;\n  if (clipboardData === null) {\n    return false;\n  }\n  setLexicalClipboardDataTransfer(clipboardData, data);\n  return true;\n}\nconst clipboardDataFunctions = [['text/html', $getHtmlContent], ['application/x-lexical-editor', $getLexicalContent]];\n\n/**\n * Serialize the content of the current selection to strings in\n * text/plain, text/html, and application/x-lexical-editor (Lexical JSON)\n * formats (as available).\n *\n * @param selection the selection to serialize (defaults to $getSelection())\n * @returns LexicalClipboardData\n */\nfunction $getClipboardDataFromSelection(selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)()) {\n  const clipboardData = {\n    'text/plain': selection ? selection.getTextContent() : ''\n  };\n  if (selection) {\n    const editor = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getEditor)();\n    for (const [mimeType, $editorFn] of clipboardDataFunctions) {\n      const v = $editorFn(editor, selection);\n      if (v !== null) {\n        clipboardData[mimeType] = v;\n      }\n    }\n  }\n  return clipboardData;\n}\n\n/**\n * Call setData on the given clipboardData for each MIME type present\n * in the given data (from {@link $getClipboardDataFromSelection})\n *\n * @param clipboardData the event.clipboardData to populate from data\n * @param data The lexical data\n */\nfunction setLexicalClipboardDataTransfer(clipboardData, data) {\n  for (const k in data) {\n    const v = data[k];\n    if (v !== undefined) {\n      clipboardData.setData(k, v);\n    }\n  }\n}\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@lexical/clipboard/LexicalClipboard.dev.mjs\n");

/***/ }),

/***/ "(rsc)/./node_modules/@lexical/headless/LexicalHeadless.dev.mjs":
/*!****************************************************************!*\
  !*** ./node_modules/@lexical/headless/LexicalHeadless.dev.mjs ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   createHeadlessEditor: () => (/* binding */ createHeadlessEditor)\n/* harmony export */ });\n/* harmony import */ var lexical__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lexical */ \"(rsc)/./node_modules/lexical/Lexical.dev.mjs\");\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\n\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\n\n/**\n * Generates a headless editor that allows lexical to be used without the need for a DOM, eg in Node.js.\n * Throws an error when unsupported methods are used.\n * @param editorConfig - The optional lexical editor configuration.\n * @returns - The configured headless editor.\n */\nfunction createHeadlessEditor(editorConfig) {\n  const editor = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.createEditor)(editorConfig);\n  editor._headless = true;\n  const unsupportedMethods = ['registerDecoratorListener', 'registerRootListener', 'registerMutationListener', 'getRootElement', 'setRootElement', 'getElementByKey', 'focus', 'blur'];\n  unsupportedMethods.forEach(method => {\n    editor[method] = () => {\n      throw new Error(`${method} is not supported in headless mode`);\n    };\n  });\n  return editor;\n}\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@lexical/headless/LexicalHeadless.dev.mjs\n");

/***/ }),

/***/ "(rsc)/./node_modules/@lexical/html/LexicalHtml.dev.mjs":
/*!********************************************************!*\
  !*** ./node_modules/@lexical/html/LexicalHtml.dev.mjs ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   $generateHtmlFromNodes: () => (/* binding */ $generateHtmlFromNodes),\n/* harmony export */   $generateNodesFromDOM: () => (/* binding */ $generateNodesFromDOM)\n/* harmony export */ });\n/* harmony import */ var _lexical_selection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lexical/selection */ \"(rsc)/./node_modules/@lexical/selection/LexicalSelection.dev.mjs\");\n/* harmony import */ var lexical__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lexical */ \"(rsc)/./node_modules/lexical/Lexical.dev.mjs\");\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\n\n\n\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\n\n/**\n * How you parse your html string to get a document is left up to you. In the browser you can use the native\n * DOMParser API to generate a document (see clipboard.ts), but to use in a headless environment you can use JSDom\n * or an equivalent library and pass in the document here.\n */\nfunction $generateNodesFromDOM(editor, dom) {\n  const elements = dom.body ? dom.body.childNodes : [];\n  let lexicalNodes = [];\n  const allArtificialNodes = [];\n  for (let i = 0; i < elements.length; i++) {\n    const element = elements[i];\n    if (!IGNORE_TAGS.has(element.nodeName)) {\n      const lexicalNode = $createNodesFromDOM(element, editor, allArtificialNodes, false);\n      if (lexicalNode !== null) {\n        lexicalNodes = lexicalNodes.concat(lexicalNode);\n      }\n    }\n  }\n  $unwrapArtificalNodes(allArtificialNodes);\n  return lexicalNodes;\n}\nfunction $generateHtmlFromNodes(editor, selection) {\n  if (typeof document === 'undefined' || typeof window === 'undefined' && typeof global.window === 'undefined') {\n    throw new Error('To use $generateHtmlFromNodes in headless mode please initialize a headless browser implementation such as JSDom before calling this function.');\n  }\n  const container = document.createElement('div');\n  const root = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getRoot)();\n  const topLevelChildren = root.getChildren();\n  for (let i = 0; i < topLevelChildren.length; i++) {\n    const topLevelNode = topLevelChildren[i];\n    $appendNodesToHTML(editor, topLevelNode, container, selection);\n  }\n  return container.innerHTML;\n}\nfunction $appendNodesToHTML(editor, currentNode, parentElement, selection = null) {\n  let shouldInclude = selection !== null ? currentNode.isSelected(selection) : true;\n  const shouldExclude = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(currentNode) && currentNode.excludeFromCopy('html');\n  let target = currentNode;\n  if (selection !== null) {\n    let clone = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$cloneWithProperties)(currentNode);\n    clone = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(clone) && selection !== null ? (0,_lexical_selection__WEBPACK_IMPORTED_MODULE_1__.$sliceSelectedTextNodeContent)(selection, clone) : clone;\n    target = clone;\n  }\n  const children = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(target) ? target.getChildren() : [];\n  const registeredNode = editor._nodes.get(target.getType());\n  let exportOutput;\n\n  // Use HTMLConfig overrides, if available.\n  if (registeredNode && registeredNode.exportDOM !== undefined) {\n    exportOutput = registeredNode.exportDOM(editor, target);\n  } else {\n    exportOutput = target.exportDOM(editor);\n  }\n  const {\n    element,\n    after\n  } = exportOutput;\n  if (!element) {\n    return false;\n  }\n  const fragment = document.createDocumentFragment();\n  for (let i = 0; i < children.length; i++) {\n    const childNode = children[i];\n    const shouldIncludeChild = $appendNodesToHTML(editor, childNode, fragment, selection);\n    if (!shouldInclude && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(currentNode) && shouldIncludeChild && currentNode.extractWithChild(childNode, selection, 'html')) {\n      shouldInclude = true;\n    }\n  }\n  if (shouldInclude && !shouldExclude) {\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element) || (0,lexical__WEBPACK_IMPORTED_MODULE_0__.isDocumentFragment)(element)) {\n      element.append(fragment);\n    }\n    parentElement.append(element);\n    if (after) {\n      const newElement = after.call(target, element);\n      if (newElement) {\n        if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.isDocumentFragment)(element)) {\n          element.replaceChildren(newElement);\n        } else {\n          element.replaceWith(newElement);\n        }\n      }\n    }\n  } else {\n    parentElement.append(fragment);\n  }\n  return shouldInclude;\n}\nfunction getConversionFunction(domNode, editor) {\n  const {\n    nodeName\n  } = domNode;\n  const cachedConversions = editor._htmlConversions.get(nodeName.toLowerCase());\n  let currentConversion = null;\n  if (cachedConversions !== undefined) {\n    for (const cachedConversion of cachedConversions) {\n      const domConversion = cachedConversion(domNode);\n      if (domConversion !== null && (currentConversion === null ||\n      // Given equal priority, prefer the last registered importer\n      // which is typically an application custom node or HTMLConfig['import']\n      (currentConversion.priority || 0) <= (domConversion.priority || 0))) {\n        currentConversion = domConversion;\n      }\n    }\n  }\n  return currentConversion !== null ? currentConversion.conversion : null;\n}\nconst IGNORE_TAGS = new Set(['STYLE', 'SCRIPT']);\nfunction $createNodesFromDOM(node, editor, allArtificialNodes, hasBlockAncestorLexicalNode, forChildMap = new Map(), parentLexicalNode) {\n  let lexicalNodes = [];\n  if (IGNORE_TAGS.has(node.nodeName)) {\n    return lexicalNodes;\n  }\n  let currentLexicalNode = null;\n  const transformFunction = getConversionFunction(node, editor);\n  const transformOutput = transformFunction ? transformFunction(node) : null;\n  let postTransform = null;\n  if (transformOutput !== null) {\n    postTransform = transformOutput.after;\n    const transformNodes = transformOutput.node;\n    currentLexicalNode = Array.isArray(transformNodes) ? transformNodes[transformNodes.length - 1] : transformNodes;\n    if (currentLexicalNode !== null) {\n      for (const [, forChildFunction] of forChildMap) {\n        currentLexicalNode = forChildFunction(currentLexicalNode, parentLexicalNode);\n        if (!currentLexicalNode) {\n          break;\n        }\n      }\n      if (currentLexicalNode) {\n        lexicalNodes.push(...(Array.isArray(transformNodes) ? transformNodes : [currentLexicalNode]));\n      }\n    }\n    if (transformOutput.forChild != null) {\n      forChildMap.set(node.nodeName, transformOutput.forChild);\n    }\n  }\n\n  // If the DOM node doesn't have a transformer, we don't know what\n  // to do with it but we still need to process any childNodes.\n  const children = node.childNodes;\n  let childLexicalNodes = [];\n  const hasBlockAncestorLexicalNodeForChildren = currentLexicalNode != null && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRootOrShadowRoot)(currentLexicalNode) ? false : currentLexicalNode != null && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isBlockElementNode)(currentLexicalNode) || hasBlockAncestorLexicalNode;\n  for (let i = 0; i < children.length; i++) {\n    childLexicalNodes.push(...$createNodesFromDOM(children[i], editor, allArtificialNodes, hasBlockAncestorLexicalNodeForChildren, new Map(forChildMap), currentLexicalNode));\n  }\n  if (postTransform != null) {\n    childLexicalNodes = postTransform(childLexicalNodes);\n  }\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.isBlockDomNode)(node)) {\n    if (!hasBlockAncestorLexicalNodeForChildren) {\n      childLexicalNodes = wrapContinuousInlines(node, childLexicalNodes, lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode);\n    } else {\n      childLexicalNodes = wrapContinuousInlines(node, childLexicalNodes, () => {\n        const artificialNode = new lexical__WEBPACK_IMPORTED_MODULE_0__.ArtificialNode__DO_NOT_USE();\n        allArtificialNodes.push(artificialNode);\n        return artificialNode;\n      });\n    }\n  }\n  if (currentLexicalNode == null) {\n    if (childLexicalNodes.length > 0) {\n      // If it hasn't been converted to a LexicalNode, we hoist its children\n      // up to the same level as it.\n      lexicalNodes = lexicalNodes.concat(childLexicalNodes);\n    } else {\n      if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.isBlockDomNode)(node) && isDomNodeBetweenTwoInlineNodes(node)) {\n        // Empty block dom node that hasnt been converted, we replace it with a linebreak if its between inline nodes\n        lexicalNodes = lexicalNodes.concat((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createLineBreakNode)());\n      }\n    }\n  } else {\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(currentLexicalNode)) {\n      // If the current node is a ElementNode after conversion,\n      // we can append all the children to it.\n      currentLexicalNode.append(...childLexicalNodes);\n    }\n  }\n  return lexicalNodes;\n}\nfunction wrapContinuousInlines(domNode, nodes, createWrapperFn) {\n  const textAlign = domNode.style.textAlign;\n  const out = [];\n  let continuousInlines = [];\n  // wrap contiguous inline child nodes in para\n  for (let i = 0; i < nodes.length; i++) {\n    const node = nodes[i];\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isBlockElementNode)(node)) {\n      if (textAlign && !node.getFormat()) {\n        node.setFormat(textAlign);\n      }\n      out.push(node);\n    } else {\n      continuousInlines.push(node);\n      if (i === nodes.length - 1 || i < nodes.length - 1 && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isBlockElementNode)(nodes[i + 1])) {\n        const wrapper = createWrapperFn();\n        wrapper.setFormat(textAlign);\n        wrapper.append(...continuousInlines);\n        out.push(wrapper);\n        continuousInlines = [];\n      }\n    }\n  }\n  return out;\n}\nfunction $unwrapArtificalNodes(allArtificialNodes) {\n  for (const node of allArtificialNodes) {\n    if (node.getNextSibling() instanceof lexical__WEBPACK_IMPORTED_MODULE_0__.ArtificialNode__DO_NOT_USE) {\n      node.insertAfter((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createLineBreakNode)());\n    }\n  }\n  // Replace artificial node with it's children\n  for (const node of allArtificialNodes) {\n    const children = node.getChildren();\n    for (const child of children) {\n      node.insertBefore(child);\n    }\n    node.remove();\n  }\n}\nfunction isDomNodeBetweenTwoInlineNodes(node) {\n  if (node.nextSibling == null || node.previousSibling == null) {\n    return false;\n  }\n  return (0,lexical__WEBPACK_IMPORTED_MODULE_0__.isInlineDomNode)(node.nextSibling) && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.isInlineDomNode)(node.previousSibling);\n}\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@lexical/html/LexicalHtml.dev.mjs\n");

/***/ }),

/***/ "(rsc)/./node_modules/@lexical/list/LexicalList.dev.mjs":
/*!********************************************************!*\
  !*** ./node_modules/@lexical/list/LexicalList.dev.mjs ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   $createListItemNode: () => (/* binding */ $createListItemNode),\n/* harmony export */   $createListNode: () => (/* binding */ $createListNode),\n/* harmony export */   $getListDepth: () => (/* binding */ $getListDepth),\n/* harmony export */   $handleListInsertParagraph: () => (/* binding */ $handleListInsertParagraph),\n/* harmony export */   $insertList: () => (/* binding */ $insertList),\n/* harmony export */   $isListItemNode: () => (/* binding */ $isListItemNode),\n/* harmony export */   $isListNode: () => (/* binding */ $isListNode),\n/* harmony export */   $removeList: () => (/* binding */ $removeList),\n/* harmony export */   INSERT_CHECK_LIST_COMMAND: () => (/* binding */ INSERT_CHECK_LIST_COMMAND),\n/* harmony export */   INSERT_ORDERED_LIST_COMMAND: () => (/* binding */ INSERT_ORDERED_LIST_COMMAND),\n/* harmony export */   INSERT_UNORDERED_LIST_COMMAND: () => (/* binding */ INSERT_UNORDERED_LIST_COMMAND),\n/* harmony export */   ListItemNode: () => (/* binding */ ListItemNode),\n/* harmony export */   ListNode: () => (/* binding */ ListNode),\n/* harmony export */   REMOVE_LIST_COMMAND: () => (/* binding */ REMOVE_LIST_COMMAND),\n/* harmony export */   insertList: () => (/* binding */ insertList),\n/* harmony export */   registerList: () => (/* binding */ registerList),\n/* harmony export */   removeList: () => (/* binding */ removeList)\n/* harmony export */ });\n/* harmony import */ var _lexical_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lexical/utils */ \"(rsc)/./node_modules/@lexical/utils/LexicalUtils.dev.mjs\");\n/* harmony import */ var lexical__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lexical */ \"(rsc)/./node_modules/lexical/Lexical.dev.mjs\");\n/* harmony import */ var _lexical_selection__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lexical/selection */ \"(rsc)/./node_modules/@lexical/selection/LexicalSelection.dev.mjs\");\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\n\n\n\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\n// Do not require this module directly! Use normal `invariant` calls.\n\nfunction formatDevErrorMessage(message) {\n  throw new Error(message);\n}\n\n/**\n * Checks the depth of listNode from the root node.\n * @param listNode - The ListNode to be checked.\n * @returns The depth of the ListNode.\n */\nfunction $getListDepth(listNode) {\n  let depth = 1;\n  let parent = listNode.getParent();\n  while (parent != null) {\n    if ($isListItemNode(parent)) {\n      const parentList = parent.getParent();\n      if ($isListNode(parentList)) {\n        depth++;\n        parent = parentList.getParent();\n        continue;\n      }\n      {\n        formatDevErrorMessage(`A ListItemNode must have a ListNode for a parent.`);\n      }\n    }\n    return depth;\n  }\n  return depth;\n}\n\n/**\n * Finds the nearest ancestral ListNode and returns it, throws an invariant if listItem is not a ListItemNode.\n * @param listItem - The node to be checked.\n * @returns The ListNode found.\n */\nfunction $getTopListNode(listItem) {\n  let list = listItem.getParent();\n  if (!$isListNode(list)) {\n    {\n      formatDevErrorMessage(`A ListItemNode must have a ListNode for a parent.`);\n    }\n  }\n  let parent = list;\n  while (parent !== null) {\n    parent = parent.getParent();\n    if ($isListNode(parent)) {\n      list = parent;\n    }\n  }\n  return list;\n}\n\n/**\n * A recursive Depth-First Search (Postorder Traversal) that finds all of a node's children\n * that are of type ListItemNode and returns them in an array.\n * @param node - The ListNode to start the search.\n * @returns An array containing all nodes of type ListItemNode found.\n */\n// This should probably be $getAllChildrenOfType\nfunction $getAllListItems(node) {\n  let listItemNodes = [];\n  const listChildren = node.getChildren().filter($isListItemNode);\n  for (let i = 0; i < listChildren.length; i++) {\n    const listItemNode = listChildren[i];\n    const firstChild = listItemNode.getFirstChild();\n    if ($isListNode(firstChild)) {\n      listItemNodes = listItemNodes.concat($getAllListItems(firstChild));\n    } else {\n      listItemNodes.push(listItemNode);\n    }\n  }\n  return listItemNodes;\n}\n\n/**\n * Checks to see if the passed node is a ListItemNode and has a ListNode as a child.\n * @param node - The node to be checked.\n * @returns true if the node is a ListItemNode and has a ListNode child, false otherwise.\n */\nfunction isNestedListNode(node) {\n  return $isListItemNode(node) && $isListNode(node.getFirstChild());\n}\n\n/**\n * Takes a deeply nested ListNode or ListItemNode and traverses up the branch to delete the first\n * ancestral ListNode (which could be the root ListNode) or ListItemNode with siblings, essentially\n * bringing the deeply nested node up the branch once. Would remove sublist if it has siblings.\n * Should not break ListItem -> List -> ListItem chain as empty List/ItemNodes should be removed on .remove().\n * @param sublist - The nested ListNode or ListItemNode to be brought up the branch.\n */\nfunction $removeHighestEmptyListParent(sublist) {\n  // Nodes may be repeatedly indented, to create deeply nested lists that each\n  // contain just one bullet.\n  // Our goal is to remove these (empty) deeply nested lists. The easiest\n  // way to do that is crawl back up the tree until we find a node that has siblings\n  // (e.g. is actually part of the list contents) and delete that, or delete\n  // the root of the list (if no list nodes have siblings.)\n  let emptyListPtr = sublist;\n  while (emptyListPtr.getNextSibling() == null && emptyListPtr.getPreviousSibling() == null) {\n    const parent = emptyListPtr.getParent();\n    if (parent == null || !($isListItemNode(parent) || $isListNode(parent))) {\n      break;\n    }\n    emptyListPtr = parent;\n  }\n  emptyListPtr.remove();\n}\n\n/**\n * Wraps a node into a ListItemNode.\n * @param node - The node to be wrapped into a ListItemNode\n * @returns The ListItemNode which the passed node is wrapped in.\n */\nfunction $wrapInListItem(node) {\n  const listItemWrapper = $createListItemNode();\n  return listItemWrapper.append(node);\n}\n\nfunction $isSelectingEmptyListItem(anchorNode, nodes) {\n  return $isListItemNode(anchorNode) && (nodes.length === 0 || nodes.length === 1 && anchorNode.is(nodes[0]) && anchorNode.getChildrenSize() === 0);\n}\n\n/**\n * Inserts a new ListNode. If the selection's anchor node is an empty ListItemNode and is a child of\n * the root/shadow root, it will replace the ListItemNode with a ListNode and the old ListItemNode.\n * Otherwise it will replace its parent with a new ListNode and re-insert the ListItemNode and any previous children.\n * If the selection's anchor node is not an empty ListItemNode, it will add a new ListNode or merge an existing ListNode,\n * unless the the node is a leaf node, in which case it will attempt to find a ListNode up the branch and replace it with\n * a new ListNode, or create a new ListNode at the nearest root/shadow root.\n * @param listType - The type of list, \"number\" | \"bullet\" | \"check\".\n */\nfunction $insertList(listType) {\n  const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n  if (selection !== null) {\n    let nodes = selection.getNodes();\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      const anchorAndFocus = selection.getStartEndPoints();\n      if (!(anchorAndFocus !== null)) {\n        formatDevErrorMessage(`insertList: anchor should be defined`);\n      }\n      const [anchor] = anchorAndFocus;\n      const anchorNode = anchor.getNode();\n      const anchorNodeParent = anchorNode.getParent();\n      if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRootOrShadowRoot)(anchorNode)) {\n        const firstChild = anchorNode.getFirstChild();\n        if (firstChild) {\n          nodes = firstChild.selectStart().getNodes();\n        } else {\n          const paragraph = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)();\n          anchorNode.append(paragraph);\n          nodes = paragraph.select().getNodes();\n        }\n      } else if ($isSelectingEmptyListItem(anchorNode, nodes)) {\n        const list = $createListNode(listType);\n        if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRootOrShadowRoot)(anchorNodeParent)) {\n          anchorNode.replace(list);\n          const listItem = $createListItemNode();\n          if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(anchorNode)) {\n            listItem.setFormat(anchorNode.getFormatType());\n            listItem.setIndent(anchorNode.getIndent());\n          }\n          list.append(listItem);\n        } else if ($isListItemNode(anchorNode)) {\n          const parent = anchorNode.getParentOrThrow();\n          append(list, parent.getChildren());\n          parent.replace(list);\n        }\n        return;\n      }\n    }\n    const handled = new Set();\n    for (let i = 0; i < nodes.length; i++) {\n      const node = nodes[i];\n      if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(node) && node.isEmpty() && !$isListItemNode(node) && !handled.has(node.getKey())) {\n        $createListOrMerge(node, listType);\n        continue;\n      }\n      if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isLeafNode)(node)) {\n        let parent = node.getParent();\n        while (parent != null) {\n          const parentKey = parent.getKey();\n          if ($isListNode(parent)) {\n            if (!handled.has(parentKey)) {\n              const newListNode = $createListNode(listType);\n              append(newListNode, parent.getChildren());\n              parent.replace(newListNode);\n              handled.add(parentKey);\n            }\n            break;\n          } else {\n            const nextParent = parent.getParent();\n            if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRootOrShadowRoot)(nextParent) && !handled.has(parentKey)) {\n              handled.add(parentKey);\n              $createListOrMerge(parent, listType);\n              break;\n            }\n            parent = nextParent;\n          }\n        }\n      }\n    }\n  }\n}\nfunction append(node, nodesToAppend) {\n  node.splice(node.getChildrenSize(), 0, nodesToAppend);\n}\nfunction $createListOrMerge(node, listType) {\n  if ($isListNode(node)) {\n    return node;\n  }\n  const previousSibling = node.getPreviousSibling();\n  const nextSibling = node.getNextSibling();\n  const listItem = $createListItemNode();\n  append(listItem, node.getChildren());\n  let targetList;\n  if ($isListNode(previousSibling) && listType === previousSibling.getListType()) {\n    previousSibling.append(listItem);\n    // if the same type of list is on both sides, merge them.\n    if ($isListNode(nextSibling) && listType === nextSibling.getListType()) {\n      append(previousSibling, nextSibling.getChildren());\n      nextSibling.remove();\n    }\n    targetList = previousSibling;\n  } else if ($isListNode(nextSibling) && listType === nextSibling.getListType()) {\n    nextSibling.getFirstChildOrThrow().insertBefore(listItem);\n    targetList = nextSibling;\n  } else {\n    const list = $createListNode(listType);\n    list.append(listItem);\n    node.replace(list);\n    targetList = list;\n  }\n  // listItem needs to be attached to root prior to setting indent\n  listItem.setFormat(node.getFormatType());\n  listItem.setIndent(node.getIndent());\n  node.remove();\n  return targetList;\n}\n\n/**\n * A recursive function that goes through each list and their children, including nested lists,\n * appending list2 children after list1 children and updating ListItemNode values.\n * @param list1 - The first list to be merged.\n * @param list2 - The second list to be merged.\n */\nfunction mergeLists(list1, list2) {\n  const listItem1 = list1.getLastChild();\n  const listItem2 = list2.getFirstChild();\n  if (listItem1 && listItem2 && isNestedListNode(listItem1) && isNestedListNode(listItem2)) {\n    mergeLists(listItem1.getFirstChild(), listItem2.getFirstChild());\n    listItem2.remove();\n  }\n  const toMerge = list2.getChildren();\n  if (toMerge.length > 0) {\n    list1.append(...toMerge);\n  }\n  list2.remove();\n}\n\n/**\n * Searches for the nearest ancestral ListNode and removes it. If selection is an empty ListItemNode\n * it will remove the whole list, including the ListItemNode. For each ListItemNode in the ListNode,\n * removeList will also generate new ParagraphNodes in the removed ListNode's place. Any child node\n * inside a ListItemNode will be appended to the new ParagraphNodes.\n */\nfunction $removeList() {\n  const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n    const listNodes = new Set();\n    const nodes = selection.getNodes();\n    const anchorNode = selection.anchor.getNode();\n    if ($isSelectingEmptyListItem(anchorNode, nodes)) {\n      listNodes.add($getTopListNode(anchorNode));\n    } else {\n      for (let i = 0; i < nodes.length; i++) {\n        const node = nodes[i];\n        if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isLeafNode)(node)) {\n          const listItemNode = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$getNearestNodeOfType)(node, ListItemNode);\n          if (listItemNode != null) {\n            listNodes.add($getTopListNode(listItemNode));\n          }\n        }\n      }\n    }\n    for (const listNode of listNodes) {\n      let insertionPoint = listNode;\n      const listItems = $getAllListItems(listNode);\n      for (const listItemNode of listItems) {\n        const paragraph = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)().setTextStyle(selection.style).setTextFormat(selection.format);\n        append(paragraph, listItemNode.getChildren());\n        insertionPoint.insertAfter(paragraph);\n        insertionPoint = paragraph;\n\n        // When the anchor and focus fall on the textNode\n        // we don't have to change the selection because the textNode will be appended to\n        // the newly generated paragraph.\n        // When selection is in empty nested list item, selection is actually on the listItemNode.\n        // When the corresponding listItemNode is deleted and replaced by the newly generated paragraph\n        // we should manually set the selection's focus and anchor to the newly generated paragraph.\n        if (listItemNode.__key === selection.anchor.key) {\n          (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$setPointFromCaret)(selection.anchor, (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$normalizeCaret)((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getChildCaret)(paragraph, 'next')));\n        }\n        if (listItemNode.__key === selection.focus.key) {\n          (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$setPointFromCaret)(selection.focus, (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$normalizeCaret)((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getChildCaret)(paragraph, 'next')));\n        }\n        listItemNode.remove();\n      }\n      listNode.remove();\n    }\n  }\n}\n\n/**\n * Takes the value of a child ListItemNode and makes it the value the ListItemNode\n * should be if it isn't already. Also ensures that checked is undefined if the\n * parent does not have a list type of 'check'.\n * @param list - The list whose children are updated.\n */\nfunction updateChildrenListItemValue(list) {\n  const isNotChecklist = list.getListType() !== 'check';\n  let value = list.getStart();\n  for (const child of list.getChildren()) {\n    if ($isListItemNode(child)) {\n      if (child.getValue() !== value) {\n        child.setValue(value);\n      }\n      if (isNotChecklist && child.getLatest().__checked != null) {\n        child.setChecked(undefined);\n      }\n      if (!$isListNode(child.getFirstChild())) {\n        value++;\n      }\n    }\n  }\n}\n\n/**\n * Merge the next sibling list if same type.\n * <ul> will merge with <ul>, but NOT <ul> with <ol>.\n * @param list - The list whose next sibling should be potentially merged\n */\nfunction mergeNextSiblingListIfSameType(list) {\n  const nextSibling = list.getNextSibling();\n  if ($isListNode(nextSibling) && list.getListType() === nextSibling.getListType()) {\n    mergeLists(list, nextSibling);\n  }\n}\n\n/**\n * Adds an empty ListNode/ListItemNode chain at listItemNode, so as to\n * create an indent effect. Won't indent ListItemNodes that have a ListNode as\n * a child, but does merge sibling ListItemNodes if one has a nested ListNode.\n * @param listItemNode - The ListItemNode to be indented.\n */\nfunction $handleIndent(listItemNode) {\n  // go through each node and decide where to move it.\n  const removed = new Set();\n  if (isNestedListNode(listItemNode) || removed.has(listItemNode.getKey())) {\n    return;\n  }\n  const parent = listItemNode.getParent();\n\n  // We can cast both of the below `isNestedListNode` only returns a boolean type instead of a user-defined type guards\n  const nextSibling = listItemNode.getNextSibling();\n  const previousSibling = listItemNode.getPreviousSibling();\n  // if there are nested lists on either side, merge them all together.\n\n  if (isNestedListNode(nextSibling) && isNestedListNode(previousSibling)) {\n    const innerList = previousSibling.getFirstChild();\n    if ($isListNode(innerList)) {\n      innerList.append(listItemNode);\n      const nextInnerList = nextSibling.getFirstChild();\n      if ($isListNode(nextInnerList)) {\n        const children = nextInnerList.getChildren();\n        append(innerList, children);\n        nextSibling.remove();\n        removed.add(nextSibling.getKey());\n      }\n    }\n  } else if (isNestedListNode(nextSibling)) {\n    // if the ListItemNode is next to a nested ListNode, merge them\n    const innerList = nextSibling.getFirstChild();\n    if ($isListNode(innerList)) {\n      const firstChild = innerList.getFirstChild();\n      if (firstChild !== null) {\n        firstChild.insertBefore(listItemNode);\n      }\n    }\n  } else if (isNestedListNode(previousSibling)) {\n    const innerList = previousSibling.getFirstChild();\n    if ($isListNode(innerList)) {\n      innerList.append(listItemNode);\n    }\n  } else {\n    // otherwise, we need to create a new nested ListNode\n\n    if ($isListNode(parent)) {\n      const newListItem = $createListItemNode().setTextFormat(parent.getTextFormat()).setTextStyle(parent.getTextStyle());\n      const newList = $createListNode(parent.getListType()).setTextFormat(parent.getTextFormat()).setTextStyle(parent.getTextStyle());\n      newListItem.append(newList);\n      newList.append(listItemNode);\n      if (previousSibling) {\n        previousSibling.insertAfter(newListItem);\n      } else if (nextSibling) {\n        nextSibling.insertBefore(newListItem);\n      } else {\n        parent.append(newListItem);\n      }\n    }\n  }\n}\n\n/**\n * Removes an indent by removing an empty ListNode/ListItemNode chain. An indented ListItemNode\n * has a great grandparent node of type ListNode, which is where the ListItemNode will reside\n * within as a child.\n * @param listItemNode - The ListItemNode to remove the indent (outdent).\n */\nfunction $handleOutdent(listItemNode) {\n  // go through each node and decide where to move it.\n\n  if (isNestedListNode(listItemNode)) {\n    return;\n  }\n  const parentList = listItemNode.getParent();\n  const grandparentListItem = parentList ? parentList.getParent() : undefined;\n  const greatGrandparentList = grandparentListItem ? grandparentListItem.getParent() : undefined;\n  // If it doesn't have these ancestors, it's not indented.\n\n  if ($isListNode(greatGrandparentList) && $isListItemNode(grandparentListItem) && $isListNode(parentList)) {\n    // if it's the first child in it's parent list, insert it into the\n    // great grandparent list before the grandparent\n    const firstChild = parentList ? parentList.getFirstChild() : undefined;\n    const lastChild = parentList ? parentList.getLastChild() : undefined;\n    if (listItemNode.is(firstChild)) {\n      grandparentListItem.insertBefore(listItemNode);\n      if (parentList.isEmpty()) {\n        grandparentListItem.remove();\n      }\n      // if it's the last child in it's parent list, insert it into the\n      // great grandparent list after the grandparent.\n    } else if (listItemNode.is(lastChild)) {\n      grandparentListItem.insertAfter(listItemNode);\n      if (parentList.isEmpty()) {\n        grandparentListItem.remove();\n      }\n    } else {\n      // otherwise, we need to split the siblings into two new nested lists\n      const listType = parentList.getListType();\n      const previousSiblingsListItem = $createListItemNode();\n      const previousSiblingsList = $createListNode(listType);\n      previousSiblingsListItem.append(previousSiblingsList);\n      listItemNode.getPreviousSiblings().forEach(sibling => previousSiblingsList.append(sibling));\n      const nextSiblingsListItem = $createListItemNode();\n      const nextSiblingsList = $createListNode(listType);\n      nextSiblingsListItem.append(nextSiblingsList);\n      append(nextSiblingsList, listItemNode.getNextSiblings());\n      // put the sibling nested lists on either side of the grandparent list item in the great grandparent.\n      grandparentListItem.insertBefore(previousSiblingsListItem);\n      grandparentListItem.insertAfter(nextSiblingsListItem);\n      // replace the grandparent list item (now between the siblings) with the outdented list item.\n      grandparentListItem.replace(listItemNode);\n    }\n  }\n}\n\n/**\n * Attempts to insert a ParagraphNode at selection and selects the new node. The selection must contain a ListItemNode\n * or a node that does not already contain text. If its grandparent is the root/shadow root, it will get the ListNode\n * (which should be the parent node) and insert the ParagraphNode as a sibling to the ListNode. If the ListNode is\n * nested in a ListItemNode instead, it will add the ParagraphNode after the grandparent ListItemNode.\n * Throws an invariant if the selection is not a child of a ListNode.\n * @returns true if a ParagraphNode was inserted succesfully, false if there is no selection\n * or the selection does not contain a ListItemNode or the node already holds text.\n */\nfunction $handleListInsertParagraph() {\n  const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n  if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection) || !selection.isCollapsed()) {\n    return false;\n  }\n  // Only run this code on empty list items\n  const anchor = selection.anchor.getNode();\n  if (!$isListItemNode(anchor) || anchor.getChildrenSize() !== 0) {\n    return false;\n  }\n  const topListNode = $getTopListNode(anchor);\n  const parent = anchor.getParent();\n  if (!$isListNode(parent)) {\n    formatDevErrorMessage(`A ListItemNode must have a ListNode for a parent.`);\n  }\n  const grandparent = parent.getParent();\n  let replacementNode;\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRootOrShadowRoot)(grandparent)) {\n    replacementNode = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)();\n    topListNode.insertAfter(replacementNode);\n  } else if ($isListItemNode(grandparent)) {\n    replacementNode = $createListItemNode();\n    grandparent.insertAfter(replacementNode);\n  } else {\n    return false;\n  }\n  replacementNode.setTextStyle(selection.style).setTextFormat(selection.format).select();\n  const nextSiblings = anchor.getNextSiblings();\n  if (nextSiblings.length > 0) {\n    const newList = $createListNode(parent.getListType());\n    if ($isListItemNode(replacementNode)) {\n      const newListItem = $createListItemNode();\n      newListItem.append(newList);\n      replacementNode.insertAfter(newListItem);\n    } else {\n      replacementNode.insertAfter(newList);\n    }\n    newList.append(...nextSiblings);\n  }\n\n  // Don't leave hanging nested empty lists\n  $removeHighestEmptyListParent(anchor);\n  return true;\n}\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\nfunction normalizeClassNames(...classNames) {\n  const rval = [];\n  for (const className of classNames) {\n    if (className && typeof className === 'string') {\n      for (const [s] of className.matchAll(/\\S+/g)) {\n        rval.push(s);\n      }\n    }\n  }\n  return rval;\n}\n\nfunction applyMarkerStyles(dom, node, prevNode) {\n  const styles = (0,_lexical_selection__WEBPACK_IMPORTED_MODULE_2__.getStyleObjectFromCSS)(node.__textStyle);\n  for (const k in styles) {\n    dom.style.setProperty(`--listitem-marker-${k}`, styles[k]);\n  }\n  if (prevNode) {\n    for (const k in (0,_lexical_selection__WEBPACK_IMPORTED_MODULE_2__.getStyleObjectFromCSS)(prevNode.__textStyle)) {\n      if (!(k in styles)) {\n        dom.style.removeProperty(`--listitem-marker-${k}`);\n      }\n    }\n  }\n}\n\n/** @noInheritDoc */\nclass ListItemNode extends lexical__WEBPACK_IMPORTED_MODULE_0__.ElementNode {\n  /** @internal */\n\n  /** @internal */\n\n  static getType() {\n    return 'listitem';\n  }\n  static clone(node) {\n    return new ListItemNode(node.__value, node.__checked, node.__key);\n  }\n  constructor(value, checked, key) {\n    super(key);\n    this.__value = value === undefined ? 1 : value;\n    this.__checked = checked;\n  }\n  createDOM(config) {\n    const element = document.createElement('li');\n    const parent = this.getParent();\n    if ($isListNode(parent) && parent.getListType() === 'check') {\n      updateListItemChecked(element, this, null);\n    }\n    element.value = this.__value;\n    $setListItemThemeClassNames(element, config.theme, this);\n    const nextStyle = this.__style;\n    if (nextStyle) {\n      element.style.cssText = nextStyle;\n    }\n    applyMarkerStyles(element, this, null);\n    return element;\n  }\n  updateDOM(prevNode, dom, config) {\n    const parent = this.getParent();\n    if ($isListNode(parent) && parent.getListType() === 'check') {\n      updateListItemChecked(dom, this, prevNode);\n    }\n    // @ts-expect-error - this is always HTMLListItemElement\n    dom.value = this.__value;\n    $setListItemThemeClassNames(dom, config.theme, this);\n    const prevStyle = prevNode.__style;\n    const nextStyle = this.__style;\n    if (prevStyle !== nextStyle) {\n      if (nextStyle === '') {\n        dom.removeAttribute('style');\n      } else {\n        dom.style.cssText = nextStyle;\n      }\n    }\n    applyMarkerStyles(dom, this, prevNode);\n    return false;\n  }\n  static transform() {\n    return node => {\n      if (!$isListItemNode(node)) {\n        formatDevErrorMessage(`node is not a ListItemNode`);\n      }\n      if (node.__checked == null) {\n        return;\n      }\n      const parent = node.getParent();\n      if ($isListNode(parent)) {\n        if (parent.getListType() !== 'check' && node.getChecked() != null) {\n          node.setChecked(undefined);\n        }\n      }\n    };\n  }\n  static importDOM() {\n    return {\n      li: () => ({\n        conversion: $convertListItemElement,\n        priority: 0\n      })\n    };\n  }\n  static importJSON(serializedNode) {\n    return $createListItemNode().updateFromJSON(serializedNode);\n  }\n  updateFromJSON(serializedNode) {\n    return super.updateFromJSON(serializedNode).setValue(serializedNode.value).setChecked(serializedNode.checked);\n  }\n  exportDOM(editor) {\n    const element = this.createDOM(editor._config);\n    element.style.textAlign = this.getFormatType();\n    const direction = this.getDirection();\n    if (direction) {\n      element.dir = direction;\n    }\n    return {\n      element\n    };\n  }\n  exportJSON() {\n    return {\n      ...super.exportJSON(),\n      checked: this.getChecked(),\n      value: this.getValue()\n    };\n  }\n  append(...nodes) {\n    for (let i = 0; i < nodes.length; i++) {\n      const node = nodes[i];\n      if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(node) && this.canMergeWith(node)) {\n        const children = node.getChildren();\n        this.append(...children);\n        node.remove();\n      } else {\n        super.append(node);\n      }\n    }\n    return this;\n  }\n  replace(replaceWithNode, includeChildren) {\n    if ($isListItemNode(replaceWithNode)) {\n      return super.replace(replaceWithNode);\n    }\n    this.setIndent(0);\n    const list = this.getParentOrThrow();\n    if (!$isListNode(list)) {\n      return replaceWithNode;\n    }\n    if (list.__first === this.getKey()) {\n      list.insertBefore(replaceWithNode);\n    } else if (list.__last === this.getKey()) {\n      list.insertAfter(replaceWithNode);\n    } else {\n      // Split the list\n      const newList = $createListNode(list.getListType());\n      let nextSibling = this.getNextSibling();\n      while (nextSibling) {\n        const nodeToAppend = nextSibling;\n        nextSibling = nextSibling.getNextSibling();\n        newList.append(nodeToAppend);\n      }\n      list.insertAfter(replaceWithNode);\n      replaceWithNode.insertAfter(newList);\n    }\n    if (includeChildren) {\n      if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(replaceWithNode)) {\n        formatDevErrorMessage(`includeChildren should only be true for ElementNodes`);\n      }\n      this.getChildren().forEach(child => {\n        replaceWithNode.append(child);\n      });\n    }\n    this.remove();\n    if (list.getChildrenSize() === 0) {\n      list.remove();\n    }\n    return replaceWithNode;\n  }\n  insertAfter(node, restoreSelection = true) {\n    const listNode = this.getParentOrThrow();\n    if (!$isListNode(listNode)) {\n      {\n        formatDevErrorMessage(`insertAfter: list node is not parent of list item node`);\n      }\n    }\n    if ($isListItemNode(node)) {\n      return super.insertAfter(node, restoreSelection);\n    }\n    const siblings = this.getNextSiblings();\n\n    // Split the lists and insert the node in between them\n    listNode.insertAfter(node, restoreSelection);\n    if (siblings.length !== 0) {\n      const newListNode = $createListNode(listNode.getListType());\n      siblings.forEach(sibling => newListNode.append(sibling));\n      node.insertAfter(newListNode, restoreSelection);\n    }\n    return node;\n  }\n  remove(preserveEmptyParent) {\n    const prevSibling = this.getPreviousSibling();\n    const nextSibling = this.getNextSibling();\n    super.remove(preserveEmptyParent);\n    if (prevSibling && nextSibling && isNestedListNode(prevSibling) && isNestedListNode(nextSibling)) {\n      mergeLists(prevSibling.getFirstChild(), nextSibling.getFirstChild());\n      nextSibling.remove();\n    }\n  }\n  insertNewAfter(_, restoreSelection = true) {\n    const newElement = $createListItemNode().updateFromJSON(this.exportJSON()).setChecked(this.getChecked() ? false : undefined);\n    this.insertAfter(newElement, restoreSelection);\n    return newElement;\n  }\n  collapseAtStart(selection) {\n    const paragraph = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)();\n    const children = this.getChildren();\n    children.forEach(child => paragraph.append(child));\n    const listNode = this.getParentOrThrow();\n    const listNodeParent = listNode.getParentOrThrow();\n    const isIndented = $isListItemNode(listNodeParent);\n    if (listNode.getChildrenSize() === 1) {\n      if (isIndented) {\n        // if the list node is nested, we just want to remove it,\n        // effectively unindenting it.\n        listNode.remove();\n        listNodeParent.select();\n      } else {\n        listNode.insertBefore(paragraph);\n        listNode.remove();\n        // If we have selection on the list item, we'll need to move it\n        // to the paragraph\n        const anchor = selection.anchor;\n        const focus = selection.focus;\n        const key = paragraph.getKey();\n        if (anchor.type === 'element' && anchor.getNode().is(this)) {\n          anchor.set(key, anchor.offset, 'element');\n        }\n        if (focus.type === 'element' && focus.getNode().is(this)) {\n          focus.set(key, focus.offset, 'element');\n        }\n      }\n    } else {\n      listNode.insertBefore(paragraph);\n      this.remove();\n    }\n    return true;\n  }\n  getValue() {\n    const self = this.getLatest();\n    return self.__value;\n  }\n  setValue(value) {\n    const self = this.getWritable();\n    self.__value = value;\n    return self;\n  }\n  getChecked() {\n    const self = this.getLatest();\n    let listType;\n    const parent = this.getParent();\n    if ($isListNode(parent)) {\n      listType = parent.getListType();\n    }\n    return listType === 'check' ? Boolean(self.__checked) : undefined;\n  }\n  setChecked(checked) {\n    const self = this.getWritable();\n    self.__checked = checked;\n    return self;\n  }\n  toggleChecked() {\n    const self = this.getWritable();\n    return self.setChecked(!self.__checked);\n  }\n  getIndent() {\n    // If we don't have a parent, we are likely serializing\n    const parent = this.getParent();\n    if (parent === null || !this.isAttached()) {\n      return this.getLatest().__indent;\n    }\n    // ListItemNode should always have a ListNode for a parent.\n    let listNodeParent = parent.getParentOrThrow();\n    let indentLevel = 0;\n    while ($isListItemNode(listNodeParent)) {\n      listNodeParent = listNodeParent.getParentOrThrow().getParentOrThrow();\n      indentLevel++;\n    }\n    return indentLevel;\n  }\n  setIndent(indent) {\n    if (!(typeof indent === 'number')) {\n      formatDevErrorMessage(`Invalid indent value.`);\n    }\n    indent = Math.floor(indent);\n    if (!(indent >= 0)) {\n      formatDevErrorMessage(`Indent value must be non-negative.`);\n    }\n    let currentIndent = this.getIndent();\n    while (currentIndent !== indent) {\n      if (currentIndent < indent) {\n        $handleIndent(this);\n        currentIndent++;\n      } else {\n        $handleOutdent(this);\n        currentIndent--;\n      }\n    }\n    return this;\n  }\n\n  /** @deprecated @internal */\n  canInsertAfter(node) {\n    return $isListItemNode(node);\n  }\n\n  /** @deprecated @internal */\n  canReplaceWith(replacement) {\n    return $isListItemNode(replacement);\n  }\n  canMergeWith(node) {\n    return $isListItemNode(node) || (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isParagraphNode)(node);\n  }\n  extractWithChild(child, selection) {\n    if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      return false;\n    }\n    const anchorNode = selection.anchor.getNode();\n    const focusNode = selection.focus.getNode();\n    return this.isParentOf(anchorNode) && this.isParentOf(focusNode) && this.getTextContent().length === selection.getTextContent().length;\n  }\n  isParentRequired() {\n    return true;\n  }\n  createParentElementNode() {\n    return $createListNode('bullet');\n  }\n  canMergeWhenEmpty() {\n    return true;\n  }\n}\nfunction $setListItemThemeClassNames(dom, editorThemeClasses, node) {\n  const classesToAdd = [];\n  const classesToRemove = [];\n  const listTheme = editorThemeClasses.list;\n  const listItemClassName = listTheme ? listTheme.listitem : undefined;\n  let nestedListItemClassName;\n  if (listTheme && listTheme.nested) {\n    nestedListItemClassName = listTheme.nested.listitem;\n  }\n  if (listItemClassName !== undefined) {\n    classesToAdd.push(...normalizeClassNames(listItemClassName));\n  }\n  if (listTheme) {\n    const parentNode = node.getParent();\n    const isCheckList = $isListNode(parentNode) && parentNode.getListType() === 'check';\n    const checked = node.getChecked();\n    if (!isCheckList || checked) {\n      classesToRemove.push(listTheme.listitemUnchecked);\n    }\n    if (!isCheckList || !checked) {\n      classesToRemove.push(listTheme.listitemChecked);\n    }\n    if (isCheckList) {\n      classesToAdd.push(checked ? listTheme.listitemChecked : listTheme.listitemUnchecked);\n    }\n  }\n  if (nestedListItemClassName !== undefined) {\n    const nestedListItemClasses = normalizeClassNames(nestedListItemClassName);\n    if (node.getChildren().some(child => $isListNode(child))) {\n      classesToAdd.push(...nestedListItemClasses);\n    } else {\n      classesToRemove.push(...nestedListItemClasses);\n    }\n  }\n  if (classesToRemove.length > 0) {\n    (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.removeClassNamesFromElement)(dom, ...classesToRemove);\n  }\n  if (classesToAdd.length > 0) {\n    (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.addClassNamesToElement)(dom, ...classesToAdd);\n  }\n}\nfunction updateListItemChecked(dom, listItemNode, prevListItemNode, listNode) {\n  // Only add attributes for leaf list items\n  if ($isListNode(listItemNode.getFirstChild())) {\n    dom.removeAttribute('role');\n    dom.removeAttribute('tabIndex');\n    dom.removeAttribute('aria-checked');\n  } else {\n    dom.setAttribute('role', 'checkbox');\n    dom.setAttribute('tabIndex', '-1');\n    if (!prevListItemNode || listItemNode.__checked !== prevListItemNode.__checked) {\n      dom.setAttribute('aria-checked', listItemNode.getChecked() ? 'true' : 'false');\n    }\n  }\n}\nfunction $convertListItemElement(domNode) {\n  const isGitHubCheckList = domNode.classList.contains('task-list-item');\n  if (isGitHubCheckList) {\n    for (const child of domNode.children) {\n      if (child.tagName === 'INPUT') {\n        return $convertCheckboxInput(child);\n      }\n    }\n  }\n  const ariaCheckedAttr = domNode.getAttribute('aria-checked');\n  const checked = ariaCheckedAttr === 'true' ? true : ariaCheckedAttr === 'false' ? false : undefined;\n  return {\n    node: $createListItemNode(checked)\n  };\n}\nfunction $convertCheckboxInput(domNode) {\n  const isCheckboxInput = domNode.getAttribute('type') === 'checkbox';\n  if (!isCheckboxInput) {\n    return {\n      node: null\n    };\n  }\n  const checked = domNode.hasAttribute('checked');\n  return {\n    node: $createListItemNode(checked)\n  };\n}\n\n/**\n * Creates a new List Item node, passing true/false will convert it to a checkbox input.\n * @param checked - Is the List Item a checkbox and, if so, is it checked? undefined/null: not a checkbox, true/false is a checkbox and checked/unchecked, respectively.\n * @returns The new List Item.\n */\nfunction $createListItemNode(checked) {\n  return (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$applyNodeReplacement)(new ListItemNode(undefined, checked));\n}\n\n/**\n * Checks to see if the node is a ListItemNode.\n * @param node - The node to be checked.\n * @returns true if the node is a ListItemNode, false otherwise.\n */\nfunction $isListItemNode(node) {\n  return node instanceof ListItemNode;\n}\n\n/** @noInheritDoc */\nclass ListNode extends lexical__WEBPACK_IMPORTED_MODULE_0__.ElementNode {\n  /** @internal */\n\n  /** @internal */\n\n  /** @internal */\n\n  static getType() {\n    return 'list';\n  }\n  static clone(node) {\n    const listType = node.__listType || TAG_TO_LIST_TYPE[node.__tag];\n    return new ListNode(listType, node.__start, node.__key);\n  }\n  constructor(listType = 'number', start = 1, key) {\n    super(key);\n    const _listType = TAG_TO_LIST_TYPE[listType] || listType;\n    this.__listType = _listType;\n    this.__tag = _listType === 'number' ? 'ol' : 'ul';\n    this.__start = start;\n  }\n  getTag() {\n    return this.__tag;\n  }\n  setListType(type) {\n    const writable = this.getWritable();\n    writable.__listType = type;\n    writable.__tag = type === 'number' ? 'ol' : 'ul';\n    return writable;\n  }\n  getListType() {\n    return this.__listType;\n  }\n  getStart() {\n    return this.__start;\n  }\n  setStart(start) {\n    const self = this.getWritable();\n    self.__start = start;\n    return self;\n  }\n\n  // View\n\n  createDOM(config, _editor) {\n    const tag = this.__tag;\n    const dom = document.createElement(tag);\n    if (this.__start !== 1) {\n      dom.setAttribute('start', String(this.__start));\n    }\n    // @ts-expect-error Internal field.\n    dom.__lexicalListType = this.__listType;\n    $setListThemeClassNames(dom, config.theme, this);\n    return dom;\n  }\n  updateDOM(prevNode, dom, config) {\n    if (prevNode.__tag !== this.__tag) {\n      return true;\n    }\n    $setListThemeClassNames(dom, config.theme, this);\n    return false;\n  }\n  static transform() {\n    return node => {\n      if (!$isListNode(node)) {\n        formatDevErrorMessage(`node is not a ListNode`);\n      }\n      mergeNextSiblingListIfSameType(node);\n      updateChildrenListItemValue(node);\n    };\n  }\n  static importDOM() {\n    return {\n      ol: () => ({\n        conversion: $convertListNode,\n        priority: 0\n      }),\n      ul: () => ({\n        conversion: $convertListNode,\n        priority: 0\n      })\n    };\n  }\n  static importJSON(serializedNode) {\n    return $createListNode().updateFromJSON(serializedNode);\n  }\n  updateFromJSON(serializedNode) {\n    return super.updateFromJSON(serializedNode).setListType(serializedNode.listType).setStart(serializedNode.start);\n  }\n  exportDOM(editor) {\n    const element = this.createDOM(editor._config, editor);\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element)) {\n      if (this.__start !== 1) {\n        element.setAttribute('start', String(this.__start));\n      }\n      if (this.__listType === 'check') {\n        element.setAttribute('__lexicalListType', 'check');\n      }\n    }\n    return {\n      element\n    };\n  }\n  exportJSON() {\n    return {\n      ...super.exportJSON(),\n      listType: this.getListType(),\n      start: this.getStart(),\n      tag: this.getTag()\n    };\n  }\n  canBeEmpty() {\n    return false;\n  }\n  canIndent() {\n    return false;\n  }\n  splice(start, deleteCount, nodesToInsert) {\n    let listItemNodesToInsert = nodesToInsert;\n    for (let i = 0; i < nodesToInsert.length; i++) {\n      const node = nodesToInsert[i];\n      if (!$isListItemNode(node)) {\n        if (listItemNodesToInsert === nodesToInsert) {\n          listItemNodesToInsert = [...nodesToInsert];\n        }\n        listItemNodesToInsert[i] = $createListItemNode().append((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(node) && !($isListNode(node) || node.isInline()) ? (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createTextNode)(node.getTextContent()) : node);\n      }\n    }\n    return super.splice(start, deleteCount, listItemNodesToInsert);\n  }\n  extractWithChild(child) {\n    return $isListItemNode(child);\n  }\n}\nfunction $setListThemeClassNames(dom, editorThemeClasses, node) {\n  const classesToAdd = [];\n  const classesToRemove = [];\n  const listTheme = editorThemeClasses.list;\n  if (listTheme !== undefined) {\n    const listLevelsClassNames = listTheme[`${node.__tag}Depth`] || [];\n    const listDepth = $getListDepth(node) - 1;\n    const normalizedListDepth = listDepth % listLevelsClassNames.length;\n    const listLevelClassName = listLevelsClassNames[normalizedListDepth];\n    const listClassName = listTheme[node.__tag];\n    let nestedListClassName;\n    const nestedListTheme = listTheme.nested;\n    const checklistClassName = listTheme.checklist;\n    if (nestedListTheme !== undefined && nestedListTheme.list) {\n      nestedListClassName = nestedListTheme.list;\n    }\n    if (listClassName !== undefined) {\n      classesToAdd.push(listClassName);\n    }\n    if (checklistClassName !== undefined && node.__listType === 'check') {\n      classesToAdd.push(checklistClassName);\n    }\n    if (listLevelClassName !== undefined) {\n      classesToAdd.push(...normalizeClassNames(listLevelClassName));\n      for (let i = 0; i < listLevelsClassNames.length; i++) {\n        if (i !== normalizedListDepth) {\n          classesToRemove.push(node.__tag + i);\n        }\n      }\n    }\n    if (nestedListClassName !== undefined) {\n      const nestedListItemClasses = normalizeClassNames(nestedListClassName);\n      if (listDepth > 1) {\n        classesToAdd.push(...nestedListItemClasses);\n      } else {\n        classesToRemove.push(...nestedListItemClasses);\n      }\n    }\n  }\n  if (classesToRemove.length > 0) {\n    (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.removeClassNamesFromElement)(dom, ...classesToRemove);\n  }\n  if (classesToAdd.length > 0) {\n    (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.addClassNamesToElement)(dom, ...classesToAdd);\n  }\n}\n\n/*\n * This function normalizes the children of a ListNode after the conversion from HTML,\n * ensuring that they are all ListItemNodes and contain either a single nested ListNode\n * or some other inline content.\n */\nfunction $normalizeChildren(nodes) {\n  const normalizedListItems = [];\n  for (let i = 0; i < nodes.length; i++) {\n    const node = nodes[i];\n    if ($isListItemNode(node)) {\n      normalizedListItems.push(node);\n      const children = node.getChildren();\n      if (children.length > 1) {\n        children.forEach(child => {\n          if ($isListNode(child)) {\n            normalizedListItems.push($wrapInListItem(child));\n          }\n        });\n      }\n    } else {\n      normalizedListItems.push($wrapInListItem(node));\n    }\n  }\n  return normalizedListItems;\n}\nfunction isDomChecklist(domNode) {\n  if (domNode.getAttribute('__lexicallisttype') === 'check' ||\n  // is github checklist\n  domNode.classList.contains('contains-task-list')) {\n    return true;\n  }\n  // if children are checklist items, the node is a checklist ul. Applicable for googledoc checklist pasting.\n  for (const child of domNode.childNodes) {\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(child) && child.hasAttribute('aria-checked')) {\n      return true;\n    }\n  }\n  return false;\n}\nfunction $convertListNode(domNode) {\n  const nodeName = domNode.nodeName.toLowerCase();\n  let node = null;\n  if (nodeName === 'ol') {\n    // @ts-ignore\n    const start = domNode.start;\n    node = $createListNode('number', start);\n  } else if (nodeName === 'ul') {\n    if (isDomChecklist(domNode)) {\n      node = $createListNode('check');\n    } else {\n      node = $createListNode('bullet');\n    }\n  }\n  return {\n    after: $normalizeChildren,\n    node\n  };\n}\nconst TAG_TO_LIST_TYPE = {\n  ol: 'number',\n  ul: 'bullet'\n};\n\n/**\n * Creates a ListNode of listType.\n * @param listType - The type of list to be created. Can be 'number', 'bullet', or 'check'.\n * @param start - Where an ordered list starts its count, start = 1 if left undefined.\n * @returns The new ListNode\n */\nfunction $createListNode(listType = 'number', start = 1) {\n  return (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$applyNodeReplacement)(new ListNode(listType, start));\n}\n\n/**\n * Checks to see if the node is a ListNode.\n * @param node - The node to be checked.\n * @returns true if the node is a ListNode, false otherwise.\n */\nfunction $isListNode(node) {\n  return node instanceof ListNode;\n}\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\nconst INSERT_UNORDERED_LIST_COMMAND = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.createCommand)('INSERT_UNORDERED_LIST_COMMAND');\nconst INSERT_ORDERED_LIST_COMMAND = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.createCommand)('INSERT_ORDERED_LIST_COMMAND');\nconst INSERT_CHECK_LIST_COMMAND = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.createCommand)('INSERT_CHECK_LIST_COMMAND');\nconst REMOVE_LIST_COMMAND = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.createCommand)('REMOVE_LIST_COMMAND');\nfunction registerList(editor) {\n  const removeListener = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.mergeRegister)(editor.registerCommand(INSERT_ORDERED_LIST_COMMAND, () => {\n    $insertList('number');\n    return true;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_LOW), editor.registerCommand(INSERT_UNORDERED_LIST_COMMAND, () => {\n    $insertList('bullet');\n    return true;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_LOW), editor.registerCommand(REMOVE_LIST_COMMAND, () => {\n    $removeList();\n    return true;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_LOW), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.INSERT_PARAGRAPH_COMMAND, () => $handleListInsertParagraph(), lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_LOW), editor.registerNodeTransform(ListItemNode, node => {\n    const firstChild = node.getFirstChild();\n    if (firstChild) {\n      if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(firstChild)) {\n        const style = firstChild.getStyle();\n        const format = firstChild.getFormat();\n        if (node.getTextStyle() !== style) {\n          node.setTextStyle(style);\n        }\n        if (node.getTextFormat() !== format) {\n          node.setTextFormat(format);\n        }\n      }\n    } else {\n      // If it's empty, check the selection\n      const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n      if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection) && (selection.style !== node.getTextStyle() || selection.format !== node.getTextFormat()) && selection.isCollapsed() && node.is(selection.anchor.getNode())) {\n        node.setTextStyle(selection.style).setTextFormat(selection.format);\n      }\n    }\n  }), editor.registerNodeTransform(lexical__WEBPACK_IMPORTED_MODULE_0__.TextNode, node => {\n    const listItemParentNode = node.getParent();\n    if ($isListItemNode(listItemParentNode) && node.is(listItemParentNode.getFirstChild())) {\n      const style = node.getStyle();\n      const format = node.getFormat();\n      if (style !== listItemParentNode.getTextStyle() || format !== listItemParentNode.getTextFormat()) {\n        listItemParentNode.setTextStyle(style).setTextFormat(format);\n      }\n    }\n  }));\n  return removeListener;\n}\n\n/**\n * @deprecated use {@link $insertList} from an update or command listener.\n *\n * Inserts a new ListNode. If the selection's anchor node is an empty ListItemNode and is a child of\n * the root/shadow root, it will replace the ListItemNode with a ListNode and the old ListItemNode.\n * Otherwise it will replace its parent with a new ListNode and re-insert the ListItemNode and any previous children.\n * If the selection's anchor node is not an empty ListItemNode, it will add a new ListNode or merge an existing ListNode,\n * unless the the node is a leaf node, in which case it will attempt to find a ListNode up the branch and replace it with\n * a new ListNode, or create a new ListNode at the nearest root/shadow root.\n * @param editor - The lexical editor.\n * @param listType - The type of list, \"number\" | \"bullet\" | \"check\".\n */\nfunction insertList(editor, listType) {\n  editor.update(() => $insertList(listType));\n}\n\n/**\n * @deprecated use {@link $removeList} from an update or command listener.\n *\n * Searches for the nearest ancestral ListNode and removes it. If selection is an empty ListItemNode\n * it will remove the whole list, including the ListItemNode. For each ListItemNode in the ListNode,\n * removeList will also generate new ParagraphNodes in the removed ListNode's place. Any child node\n * inside a ListItemNode will be appended to the new ParagraphNodes.\n * @param editor - The lexical editor.\n */\nfunction removeList(editor) {\n  editor.update(() => $removeList());\n}\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@lexical/list/LexicalList.dev.mjs\n");

/***/ }),

/***/ "(rsc)/./node_modules/@lexical/react/LexicalDecoratorBlockNode.dev.mjs":
/*!***********************************************************************!*\
  !*** ./node_modules/@lexical/react/LexicalDecoratorBlockNode.dev.mjs ***!
  \***********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   $isDecoratorBlockNode: () => (/* binding */ $isDecoratorBlockNode),\n/* harmony export */   DecoratorBlockNode: () => (/* binding */ DecoratorBlockNode)\n/* harmony export */ });\n/* harmony import */ var lexical__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lexical */ \"(rsc)/./node_modules/lexical/Lexical.dev.mjs\");\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\n\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\nclass DecoratorBlockNode extends lexical__WEBPACK_IMPORTED_MODULE_0__.DecoratorNode {\n  constructor(format, key) {\n    super(key);\n    this.__format = format || '';\n  }\n  exportJSON() {\n    return {\n      ...super.exportJSON(),\n      format: this.__format || ''\n    };\n  }\n  updateFromJSON(serializedNode) {\n    return super.updateFromJSON(serializedNode).setFormat(serializedNode.format || '');\n  }\n  canIndent() {\n    return false;\n  }\n  createDOM() {\n    return document.createElement('div');\n  }\n  updateDOM() {\n    return false;\n  }\n  setFormat(format) {\n    const self = this.getWritable();\n    self.__format = format;\n    return self;\n  }\n  isInline() {\n    return false;\n  }\n}\nfunction $isDecoratorBlockNode(node) {\n  return node instanceof DecoratorBlockNode;\n}\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@lexical/react/LexicalDecoratorBlockNode.dev.mjs\n");

/***/ }),

/***/ "(rsc)/./node_modules/@lexical/rich-text/LexicalRichText.dev.mjs":
/*!*****************************************************************!*\
  !*** ./node_modules/@lexical/rich-text/LexicalRichText.dev.mjs ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   $createHeadingNode: () => (/* binding */ $createHeadingNode),\n/* harmony export */   $createQuoteNode: () => (/* binding */ $createQuoteNode),\n/* harmony export */   $isHeadingNode: () => (/* binding */ $isHeadingNode),\n/* harmony export */   $isQuoteNode: () => (/* binding */ $isQuoteNode),\n/* harmony export */   DRAG_DROP_PASTE: () => (/* binding */ DRAG_DROP_PASTE),\n/* harmony export */   HeadingNode: () => (/* binding */ HeadingNode),\n/* harmony export */   QuoteNode: () => (/* binding */ QuoteNode),\n/* harmony export */   eventFiles: () => (/* binding */ eventFiles),\n/* harmony export */   registerRichText: () => (/* binding */ registerRichText)\n/* harmony export */ });\n/* harmony import */ var _lexical_clipboard__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lexical/clipboard */ \"(rsc)/./node_modules/@lexical/clipboard/LexicalClipboard.dev.mjs\");\n/* harmony import */ var _lexical_selection__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lexical/selection */ \"(rsc)/./node_modules/@lexical/selection/LexicalSelection.dev.mjs\");\n/* harmony import */ var _lexical_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lexical/utils */ \"(rsc)/./node_modules/@lexical/utils/LexicalUtils.dev.mjs\");\n/* harmony import */ var lexical__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lexical */ \"(rsc)/./node_modules/lexical/Lexical.dev.mjs\");\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\n\n\n\n\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\nfunction caretFromPoint(x, y) {\n  if (typeof document.caretRangeFromPoint !== 'undefined') {\n    const range = document.caretRangeFromPoint(x, y);\n    if (range === null) {\n      return null;\n    }\n    return {\n      node: range.startContainer,\n      offset: range.startOffset\n    };\n    // @ts-ignore\n  } else if (document.caretPositionFromPoint !== 'undefined') {\n    // @ts-ignore FF - no types\n    const range = document.caretPositionFromPoint(x, y);\n    if (range === null) {\n      return null;\n    }\n    return {\n      node: range.offsetNode,\n      offset: range.offset\n    };\n  } else {\n    // Gracefully handle IE\n    return null;\n  }\n}\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\nconst CAN_USE_DOM = typeof window !== 'undefined' && typeof window.document !== 'undefined' && typeof window.document.createElement !== 'undefined';\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\nconst documentMode = CAN_USE_DOM && 'documentMode' in document ? document.documentMode : null;\nconst CAN_USE_BEFORE_INPUT = CAN_USE_DOM && 'InputEvent' in window && !documentMode ? 'getTargetRanges' in new window.InputEvent('input') : false;\nconst IS_SAFARI = CAN_USE_DOM && /Version\\/[\\d.]+.*Safari/.test(navigator.userAgent);\nconst IS_IOS = CAN_USE_DOM && /iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream;\n\n// Keep these in case we need to use them in the future.\n// export const IS_WINDOWS: boolean = CAN_USE_DOM && /Win/.test(navigator.platform);\nconst IS_CHROME = CAN_USE_DOM && /^(?=.*Chrome).*/i.test(navigator.userAgent);\nconst IS_APPLE_WEBKIT = CAN_USE_DOM && /AppleWebKit\\/[\\d.]+/.test(navigator.userAgent) && !IS_CHROME;\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\nconst DRAG_DROP_PASTE = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.createCommand)('DRAG_DROP_PASTE_FILE');\n/** @noInheritDoc */\nclass QuoteNode extends lexical__WEBPACK_IMPORTED_MODULE_0__.ElementNode {\n  static getType() {\n    return 'quote';\n  }\n  static clone(node) {\n    return new QuoteNode(node.__key);\n  }\n\n  // View\n\n  createDOM(config) {\n    const element = document.createElement('blockquote');\n    (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.addClassNamesToElement)(element, config.theme.quote);\n    return element;\n  }\n  updateDOM(prevNode, dom) {\n    return false;\n  }\n  static importDOM() {\n    return {\n      blockquote: node => ({\n        conversion: $convertBlockquoteElement,\n        priority: 0\n      })\n    };\n  }\n  exportDOM(editor) {\n    const {\n      element\n    } = super.exportDOM(editor);\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element)) {\n      if (this.isEmpty()) {\n        element.append(document.createElement('br'));\n      }\n      const formatType = this.getFormatType();\n      element.style.textAlign = formatType;\n      const direction = this.getDirection();\n      if (direction) {\n        element.dir = direction;\n      }\n    }\n    return {\n      element\n    };\n  }\n  static importJSON(serializedNode) {\n    return $createQuoteNode().updateFromJSON(serializedNode);\n  }\n\n  // Mutation\n\n  insertNewAfter(_, restoreSelection) {\n    const newBlock = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)();\n    const direction = this.getDirection();\n    newBlock.setDirection(direction);\n    this.insertAfter(newBlock, restoreSelection);\n    return newBlock;\n  }\n  collapseAtStart() {\n    const paragraph = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)();\n    const children = this.getChildren();\n    children.forEach(child => paragraph.append(child));\n    this.replace(paragraph);\n    return true;\n  }\n  canMergeWhenEmpty() {\n    return true;\n  }\n}\nfunction $createQuoteNode() {\n  return (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$applyNodeReplacement)(new QuoteNode());\n}\nfunction $isQuoteNode(node) {\n  return node instanceof QuoteNode;\n}\n/** @noInheritDoc */\nclass HeadingNode extends lexical__WEBPACK_IMPORTED_MODULE_0__.ElementNode {\n  /** @internal */\n\n  static getType() {\n    return 'heading';\n  }\n  static clone(node) {\n    return new HeadingNode(node.__tag, node.__key);\n  }\n  constructor(tag, key) {\n    super(key);\n    this.__tag = tag;\n  }\n  getTag() {\n    return this.__tag;\n  }\n  setTag(tag) {\n    const self = this.getWritable();\n    this.__tag = tag;\n    return self;\n  }\n\n  // View\n\n  createDOM(config) {\n    const tag = this.__tag;\n    const element = document.createElement(tag);\n    const theme = config.theme;\n    const classNames = theme.heading;\n    if (classNames !== undefined) {\n      const className = classNames[tag];\n      (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.addClassNamesToElement)(element, className);\n    }\n    return element;\n  }\n  updateDOM(prevNode, dom, config) {\n    return prevNode.__tag !== this.__tag;\n  }\n  static importDOM() {\n    return {\n      h1: node => ({\n        conversion: $convertHeadingElement,\n        priority: 0\n      }),\n      h2: node => ({\n        conversion: $convertHeadingElement,\n        priority: 0\n      }),\n      h3: node => ({\n        conversion: $convertHeadingElement,\n        priority: 0\n      }),\n      h4: node => ({\n        conversion: $convertHeadingElement,\n        priority: 0\n      }),\n      h5: node => ({\n        conversion: $convertHeadingElement,\n        priority: 0\n      }),\n      h6: node => ({\n        conversion: $convertHeadingElement,\n        priority: 0\n      }),\n      p: node => {\n        // domNode is a <p> since we matched it by nodeName\n        const paragraph = node;\n        const firstChild = paragraph.firstChild;\n        if (firstChild !== null && isGoogleDocsTitle(firstChild)) {\n          return {\n            conversion: () => ({\n              node: null\n            }),\n            priority: 3\n          };\n        }\n        return null;\n      },\n      span: node => {\n        if (isGoogleDocsTitle(node)) {\n          return {\n            conversion: domNode => {\n              return {\n                node: $createHeadingNode('h1')\n              };\n            },\n            priority: 3\n          };\n        }\n        return null;\n      }\n    };\n  }\n  exportDOM(editor) {\n    const {\n      element\n    } = super.exportDOM(editor);\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element)) {\n      if (this.isEmpty()) {\n        element.append(document.createElement('br'));\n      }\n      const formatType = this.getFormatType();\n      element.style.textAlign = formatType;\n      const direction = this.getDirection();\n      if (direction) {\n        element.dir = direction;\n      }\n    }\n    return {\n      element\n    };\n  }\n  static importJSON(serializedNode) {\n    return $createHeadingNode(serializedNode.tag).updateFromJSON(serializedNode);\n  }\n  updateFromJSON(serializedNode) {\n    return super.updateFromJSON(serializedNode).setTag(serializedNode.tag);\n  }\n  exportJSON() {\n    return {\n      ...super.exportJSON(),\n      tag: this.getTag()\n    };\n  }\n\n  // Mutation\n  insertNewAfter(selection, restoreSelection = true) {\n    const anchorOffet = selection ? selection.anchor.offset : 0;\n    const lastDesc = this.getLastDescendant();\n    const isAtEnd = !lastDesc || selection && selection.anchor.key === lastDesc.getKey() && anchorOffet === lastDesc.getTextContentSize();\n    const newElement = isAtEnd || !selection ? (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)() : $createHeadingNode(this.getTag());\n    const direction = this.getDirection();\n    newElement.setDirection(direction);\n    this.insertAfter(newElement, restoreSelection);\n    if (anchorOffet === 0 && !this.isEmpty() && selection) {\n      const paragraph = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)();\n      paragraph.select();\n      this.replace(paragraph, true);\n    }\n    return newElement;\n  }\n  collapseAtStart() {\n    const newElement = !this.isEmpty() ? $createHeadingNode(this.getTag()) : (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)();\n    const children = this.getChildren();\n    children.forEach(child => newElement.append(child));\n    this.replace(newElement);\n    return true;\n  }\n  extractWithChild() {\n    return true;\n  }\n}\nfunction isGoogleDocsTitle(domNode) {\n  if (domNode.nodeName.toLowerCase() === 'span') {\n    return domNode.style.fontSize === '26pt';\n  }\n  return false;\n}\nfunction $convertHeadingElement(element) {\n  const nodeName = element.nodeName.toLowerCase();\n  let node = null;\n  if (nodeName === 'h1' || nodeName === 'h2' || nodeName === 'h3' || nodeName === 'h4' || nodeName === 'h5' || nodeName === 'h6') {\n    node = $createHeadingNode(nodeName);\n    if (element.style !== null) {\n      (0,lexical__WEBPACK_IMPORTED_MODULE_0__.setNodeIndentFromDOM)(element, node);\n      node.setFormat(element.style.textAlign);\n    }\n  }\n  return {\n    node\n  };\n}\nfunction $convertBlockquoteElement(element) {\n  const node = $createQuoteNode();\n  if (element.style !== null) {\n    node.setFormat(element.style.textAlign);\n    (0,lexical__WEBPACK_IMPORTED_MODULE_0__.setNodeIndentFromDOM)(element, node);\n  }\n  return {\n    node\n  };\n}\nfunction $createHeadingNode(headingTag = 'h1') {\n  return (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$applyNodeReplacement)(new HeadingNode(headingTag));\n}\nfunction $isHeadingNode(node) {\n  return node instanceof HeadingNode;\n}\nfunction onPasteForRichText(event, editor) {\n  event.preventDefault();\n  editor.update(() => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    const clipboardData = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.objectKlassEquals)(event, InputEvent) || (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.objectKlassEquals)(event, KeyboardEvent) ? null : event.clipboardData;\n    if (clipboardData != null && selection !== null) {\n      (0,_lexical_clipboard__WEBPACK_IMPORTED_MODULE_2__.$insertDataTransferForRichText)(clipboardData, selection, editor);\n    }\n  }, {\n    tag: 'paste'\n  });\n}\nasync function onCutForRichText(event, editor) {\n  await (0,_lexical_clipboard__WEBPACK_IMPORTED_MODULE_2__.copyToClipboard)(editor, (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.objectKlassEquals)(event, ClipboardEvent) ? event : null);\n  editor.update(() => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      selection.removeText();\n    } else if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isNodeSelection)(selection)) {\n      selection.getNodes().forEach(node => node.remove());\n    }\n  });\n}\n\n// Clipboard may contain files that we aren't allowed to read. While the event is arguably useless,\n// in certain occasions, we want to know whether it was a file transfer, as opposed to text. We\n// control this with the first boolean flag.\nfunction eventFiles(event) {\n  let dataTransfer = null;\n  if ((0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.objectKlassEquals)(event, DragEvent)) {\n    dataTransfer = event.dataTransfer;\n  } else if ((0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.objectKlassEquals)(event, ClipboardEvent)) {\n    dataTransfer = event.clipboardData;\n  }\n  if (dataTransfer === null) {\n    return [false, [], false];\n  }\n  const types = dataTransfer.types;\n  const hasFiles = types.includes('Files');\n  const hasContent = types.includes('text/html') || types.includes('text/plain');\n  return [hasFiles, Array.from(dataTransfer.files), hasContent];\n}\nfunction $handleIndentAndOutdent(indentOrOutdent) {\n  const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n  if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n    return false;\n  }\n  const alreadyHandled = new Set();\n  const nodes = selection.getNodes();\n  for (let i = 0; i < nodes.length; i++) {\n    const node = nodes[i];\n    const key = node.getKey();\n    if (alreadyHandled.has(key)) {\n      continue;\n    }\n    const parentBlock = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(node, parentNode => (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(parentNode) && !parentNode.isInline());\n    if (parentBlock === null) {\n      continue;\n    }\n    const parentKey = parentBlock.getKey();\n    if (parentBlock.canIndent() && !alreadyHandled.has(parentKey)) {\n      alreadyHandled.add(parentKey);\n      indentOrOutdent(parentBlock);\n    }\n  }\n  return alreadyHandled.size > 0;\n}\nfunction $isTargetWithinDecorator(target) {\n  const node = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getNearestNodeFromDOMNode)(target);\n  return (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isDecoratorNode)(node);\n}\nfunction $isSelectionAtEndOfRoot(selection) {\n  const focus = selection.focus;\n  return focus.key === 'root' && focus.offset === (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getRoot)().getChildrenSize();\n}\n\n/**\n * Resets the capitalization of the selection to default.\n * Called when the user presses space, tab, or enter key.\n * @param selection The selection to reset the capitalization of.\n */\nfunction $resetCapitalization(selection) {\n  for (const format of ['lowercase', 'uppercase', 'capitalize']) {\n    if (selection.hasFormat(format)) {\n      selection.toggleFormat(format);\n    }\n  }\n}\nfunction registerRichText(editor) {\n  const removeListener = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.mergeRegister)(editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.CLICK_COMMAND, payload => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isNodeSelection)(selection)) {\n      selection.clear();\n      return true;\n    }\n    return false;\n  }, 0), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.DELETE_CHARACTER_COMMAND, isBackward => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      selection.deleteCharacter(isBackward);\n      return true;\n    } else if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isNodeSelection)(selection)) {\n      selection.deleteNodes();\n      return true;\n    }\n    return false;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.DELETE_WORD_COMMAND, isBackward => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      return false;\n    }\n    selection.deleteWord(isBackward);\n    return true;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.DELETE_LINE_COMMAND, isBackward => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      return false;\n    }\n    selection.deleteLine(isBackward);\n    return true;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.CONTROLLED_TEXT_INSERTION_COMMAND, eventOrText => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (typeof eventOrText === 'string') {\n      if (selection !== null) {\n        selection.insertText(eventOrText);\n      }\n    } else {\n      if (selection === null) {\n        return false;\n      }\n      const dataTransfer = eventOrText.dataTransfer;\n      if (dataTransfer != null) {\n        (0,_lexical_clipboard__WEBPACK_IMPORTED_MODULE_2__.$insertDataTransferForRichText)(dataTransfer, selection, editor);\n      } else if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n        const data = eventOrText.data;\n        if (data) {\n          selection.insertText(data);\n        }\n        return true;\n      }\n    }\n    return true;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.REMOVE_TEXT_COMMAND, () => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      return false;\n    }\n    selection.removeText();\n    return true;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.FORMAT_TEXT_COMMAND, format => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      return false;\n    }\n    selection.formatText(format);\n    return true;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.FORMAT_ELEMENT_COMMAND, format => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection) && !(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isNodeSelection)(selection)) {\n      return false;\n    }\n    const nodes = selection.getNodes();\n    for (const node of nodes) {\n      const element = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(node, parentNode => (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(parentNode) && !parentNode.isInline());\n      if (element !== null) {\n        element.setFormat(format);\n      }\n    }\n    return true;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.INSERT_LINE_BREAK_COMMAND, selectStart => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      return false;\n    }\n    selection.insertLineBreak(selectStart);\n    return true;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.INSERT_PARAGRAPH_COMMAND, () => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      return false;\n    }\n    selection.insertParagraph();\n    return true;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.INSERT_TAB_COMMAND, () => {\n    (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$insertNodes)([(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createTabNode)()]);\n    return true;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.INDENT_CONTENT_COMMAND, () => {\n    return $handleIndentAndOutdent(block => {\n      const indent = block.getIndent();\n      block.setIndent(indent + 1);\n    });\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.OUTDENT_CONTENT_COMMAND, () => {\n    return $handleIndentAndOutdent(block => {\n      const indent = block.getIndent();\n      if (indent > 0) {\n        block.setIndent(indent - 1);\n      }\n    });\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.KEY_ARROW_UP_COMMAND, event => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isNodeSelection)(selection) && !$isTargetWithinDecorator(event.target)) {\n      // If selection is on a node, let's try and move selection\n      // back to being a range selection.\n      const nodes = selection.getNodes();\n      if (nodes.length > 0) {\n        nodes[0].selectPrevious();\n        return true;\n      }\n    } else if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      const possibleNode = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getAdjacentNode)(selection.focus, true);\n      if (!event.shiftKey && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isDecoratorNode)(possibleNode) && !possibleNode.isIsolated() && !possibleNode.isInline()) {\n        possibleNode.selectPrevious();\n        event.preventDefault();\n        return true;\n      }\n    }\n    return false;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.KEY_ARROW_DOWN_COMMAND, event => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isNodeSelection)(selection)) {\n      // If selection is on a node, let's try and move selection\n      // back to being a range selection.\n      const nodes = selection.getNodes();\n      if (nodes.length > 0) {\n        nodes[0].selectNext(0, 0);\n        return true;\n      }\n    } else if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      if ($isSelectionAtEndOfRoot(selection)) {\n        event.preventDefault();\n        return true;\n      }\n      const possibleNode = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getAdjacentNode)(selection.focus, false);\n      if (!event.shiftKey && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isDecoratorNode)(possibleNode) && !possibleNode.isIsolated() && !possibleNode.isInline()) {\n        possibleNode.selectNext();\n        event.preventDefault();\n        return true;\n      }\n    }\n    return false;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.KEY_ARROW_LEFT_COMMAND, event => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isNodeSelection)(selection)) {\n      // If selection is on a node, let's try and move selection\n      // back to being a range selection.\n      const nodes = selection.getNodes();\n      if (nodes.length > 0) {\n        event.preventDefault();\n        nodes[0].selectPrevious();\n        return true;\n      }\n    }\n    if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      return false;\n    }\n    if ((0,_lexical_selection__WEBPACK_IMPORTED_MODULE_3__.$shouldOverrideDefaultCharacterSelection)(selection, true)) {\n      const isHoldingShift = event.shiftKey;\n      event.preventDefault();\n      (0,_lexical_selection__WEBPACK_IMPORTED_MODULE_3__.$moveCharacter)(selection, isHoldingShift, true);\n      return true;\n    }\n    return false;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.KEY_ARROW_RIGHT_COMMAND, event => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isNodeSelection)(selection) && !$isTargetWithinDecorator(event.target)) {\n      // If selection is on a node, let's try and move selection\n      // back to being a range selection.\n      const nodes = selection.getNodes();\n      if (nodes.length > 0) {\n        event.preventDefault();\n        nodes[0].selectNext(0, 0);\n        return true;\n      }\n    }\n    if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      return false;\n    }\n    const isHoldingShift = event.shiftKey;\n    if ((0,_lexical_selection__WEBPACK_IMPORTED_MODULE_3__.$shouldOverrideDefaultCharacterSelection)(selection, false)) {\n      event.preventDefault();\n      (0,_lexical_selection__WEBPACK_IMPORTED_MODULE_3__.$moveCharacter)(selection, isHoldingShift, false);\n      return true;\n    }\n    return false;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.KEY_BACKSPACE_COMMAND, event => {\n    if ($isTargetWithinDecorator(event.target)) {\n      return false;\n    }\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      const {\n        anchor\n      } = selection;\n      const anchorNode = anchor.getNode();\n      if (selection.isCollapsed() && anchor.offset === 0 && !(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRootNode)(anchorNode)) {\n        const element = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$getNearestBlockElementAncestorOrThrow)(anchorNode);\n        if (element.getIndent() > 0) {\n          event.preventDefault();\n          return editor.dispatchCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.OUTDENT_CONTENT_COMMAND, undefined);\n        }\n      }\n\n      // Exception handling for iOS native behavior instead of Lexical's behavior when using Korean on iOS devices.\n      // more details - https://github.com/facebook/lexical/issues/5841\n      if (IS_IOS && navigator.language === 'ko-KR') {\n        return false;\n      }\n    } else if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isNodeSelection)(selection)) {\n      return false;\n    }\n    event.preventDefault();\n    return editor.dispatchCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.DELETE_CHARACTER_COMMAND, true);\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.KEY_DELETE_COMMAND, event => {\n    if ($isTargetWithinDecorator(event.target)) {\n      return false;\n    }\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (!((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection) || (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isNodeSelection)(selection))) {\n      return false;\n    }\n    event.preventDefault();\n    return editor.dispatchCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.DELETE_CHARACTER_COMMAND, false);\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.KEY_ENTER_COMMAND, event => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      return false;\n    }\n    $resetCapitalization(selection);\n    if (event !== null) {\n      // If we have beforeinput, then we can avoid blocking\n      // the default behavior. This ensures that the iOS can\n      // intercept that we're actually inserting a paragraph,\n      // and autocomplete, autocapitalize etc work as intended.\n      // This can also cause a strange performance issue in\n      // Safari, where there is a noticeable pause due to\n      // preventing the key down of enter.\n      if ((IS_IOS || IS_SAFARI || IS_APPLE_WEBKIT) && CAN_USE_BEFORE_INPUT) {\n        return false;\n      }\n      event.preventDefault();\n      if (event.shiftKey) {\n        return editor.dispatchCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.INSERT_LINE_BREAK_COMMAND, false);\n      }\n    }\n    return editor.dispatchCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.INSERT_PARAGRAPH_COMMAND, undefined);\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.KEY_ESCAPE_COMMAND, () => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      return false;\n    }\n    editor.blur();\n    return true;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.DROP_COMMAND, event => {\n    const [, files] = eventFiles(event);\n    if (files.length > 0) {\n      const x = event.clientX;\n      const y = event.clientY;\n      const eventRange = caretFromPoint(x, y);\n      if (eventRange !== null) {\n        const {\n          offset: domOffset,\n          node: domNode\n        } = eventRange;\n        const node = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getNearestNodeFromDOMNode)(domNode);\n        if (node !== null) {\n          const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createRangeSelection)();\n          if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(node)) {\n            selection.anchor.set(node.getKey(), domOffset, 'text');\n            selection.focus.set(node.getKey(), domOffset, 'text');\n          } else {\n            const parentKey = node.getParentOrThrow().getKey();\n            const offset = node.getIndexWithinParent() + 1;\n            selection.anchor.set(parentKey, offset, 'element');\n            selection.focus.set(parentKey, offset, 'element');\n          }\n          const normalizedSelection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$normalizeSelection__EXPERIMENTAL)(selection);\n          (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$setSelection)(normalizedSelection);\n        }\n        editor.dispatchCommand(DRAG_DROP_PASTE, files);\n      }\n      event.preventDefault();\n      return true;\n    }\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      return true;\n    }\n    return false;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.DRAGSTART_COMMAND, event => {\n    const [isFileTransfer] = eventFiles(event);\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (isFileTransfer && !(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      return false;\n    }\n    return true;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.DRAGOVER_COMMAND, event => {\n    const [isFileTransfer] = eventFiles(event);\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (isFileTransfer && !(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      return false;\n    }\n    const x = event.clientX;\n    const y = event.clientY;\n    const eventRange = caretFromPoint(x, y);\n    if (eventRange !== null) {\n      const node = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getNearestNodeFromDOMNode)(eventRange.node);\n      if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isDecoratorNode)(node)) {\n        // Show browser caret as the user is dragging the media across the screen. Won't work\n        // for DecoratorNode nor it's relevant.\n        event.preventDefault();\n      }\n    }\n    return true;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.SELECT_ALL_COMMAND, () => {\n    (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$selectAll)();\n    return true;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.COPY_COMMAND, event => {\n    (0,_lexical_clipboard__WEBPACK_IMPORTED_MODULE_2__.copyToClipboard)(editor, (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.objectKlassEquals)(event, ClipboardEvent) ? event : null);\n    return true;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.CUT_COMMAND, event => {\n    onCutForRichText(event, editor);\n    return true;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.PASTE_COMMAND, event => {\n    const [, files, hasTextContent] = eventFiles(event);\n    if (files.length > 0 && !hasTextContent) {\n      editor.dispatchCommand(DRAG_DROP_PASTE, files);\n      return true;\n    }\n\n    // if inputs then paste within the input ignore creating a new node on paste event\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.isDOMNode)(event.target) && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.isSelectionCapturedInDecoratorInput)(event.target)) {\n      return false;\n    }\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (selection !== null) {\n      onPasteForRichText(event, editor);\n      return true;\n    }\n    return false;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.KEY_SPACE_COMMAND, _ => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      $resetCapitalization(selection);\n    }\n    return false;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.KEY_TAB_COMMAND, _ => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      $resetCapitalization(selection);\n    }\n    return false;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR));\n  return removeListener;\n}\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@lexical/rich-text/LexicalRichText.dev.mjs\n");

/***/ }),

/***/ "(rsc)/./node_modules/@lexical/selection/LexicalSelection.dev.mjs":
/*!******************************************************************!*\
  !*** ./node_modules/@lexical/selection/LexicalSelection.dev.mjs ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   $addNodeStyle: () => (/* binding */ $addNodeStyle),\n/* harmony export */   $cloneWithProperties: () => (/* reexport safe */ lexical__WEBPACK_IMPORTED_MODULE_0__.$cloneWithProperties),\n/* harmony export */   $copyBlockFormatIndent: () => (/* binding */ $copyBlockFormatIndent),\n/* harmony export */   $ensureForwardRangeSelection: () => (/* binding */ $ensureForwardRangeSelection),\n/* harmony export */   $forEachSelectedTextNode: () => (/* binding */ $forEachSelectedTextNode),\n/* harmony export */   $getSelectionStyleValueForProperty: () => (/* binding */ $getSelectionStyleValueForProperty),\n/* harmony export */   $isAtNodeEnd: () => (/* binding */ $isAtNodeEnd),\n/* harmony export */   $isParentElementRTL: () => (/* binding */ $isParentElementRTL),\n/* harmony export */   $moveCaretSelection: () => (/* binding */ $moveCaretSelection),\n/* harmony export */   $moveCharacter: () => (/* binding */ $moveCharacter),\n/* harmony export */   $patchStyleText: () => (/* binding */ $patchStyleText),\n/* harmony export */   $selectAll: () => (/* reexport safe */ lexical__WEBPACK_IMPORTED_MODULE_0__.$selectAll),\n/* harmony export */   $setBlocksType: () => (/* binding */ $setBlocksType),\n/* harmony export */   $shouldOverrideDefaultCharacterSelection: () => (/* binding */ $shouldOverrideDefaultCharacterSelection),\n/* harmony export */   $sliceSelectedTextNodeContent: () => (/* binding */ $sliceSelectedTextNodeContent),\n/* harmony export */   $trimTextContentFromAnchor: () => (/* binding */ $trimTextContentFromAnchor),\n/* harmony export */   $wrapNodes: () => (/* binding */ $wrapNodes),\n/* harmony export */   createDOMRange: () => (/* binding */ createDOMRange),\n/* harmony export */   createRectsFromDOMRange: () => (/* binding */ createRectsFromDOMRange),\n/* harmony export */   getCSSFromStyleObject: () => (/* binding */ getCSSFromStyleObject),\n/* harmony export */   getStyleObjectFromCSS: () => (/* binding */ getStyleObjectFromCSS),\n/* harmony export */   trimTextContentFromAnchor: () => (/* binding */ trimTextContentFromAnchor)\n/* harmony export */ });\n/* harmony import */ var lexical__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lexical */ \"(rsc)/./node_modules/lexical/Lexical.dev.mjs\");\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\n\n\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\n// Do not require this module directly! Use normal `invariant` calls.\n\nfunction formatDevErrorMessage(message) {\n  throw new Error(message);\n}\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\nconst CSS_TO_STYLES = new Map();\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\nfunction getDOMTextNode(element) {\n  let node = element;\n  while (node != null) {\n    if (node.nodeType === Node.TEXT_NODE) {\n      return node;\n    }\n    node = node.firstChild;\n  }\n  return null;\n}\nfunction getDOMIndexWithinParent(node) {\n  const parent = node.parentNode;\n  if (parent == null) {\n    throw new Error('Should never happen');\n  }\n  return [parent, Array.from(parent.childNodes).indexOf(node)];\n}\n\n/**\n * Creates a selection range for the DOM.\n * @param editor - The lexical editor.\n * @param anchorNode - The anchor node of a selection.\n * @param _anchorOffset - The amount of space offset from the anchor to the focus.\n * @param focusNode - The current focus.\n * @param _focusOffset - The amount of space offset from the focus to the anchor.\n * @returns The range of selection for the DOM that was created.\n */\nfunction createDOMRange(editor, anchorNode, _anchorOffset, focusNode, _focusOffset) {\n  const anchorKey = anchorNode.getKey();\n  const focusKey = focusNode.getKey();\n  const range = document.createRange();\n  let anchorDOM = editor.getElementByKey(anchorKey);\n  let focusDOM = editor.getElementByKey(focusKey);\n  let anchorOffset = _anchorOffset;\n  let focusOffset = _focusOffset;\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(anchorNode)) {\n    anchorDOM = getDOMTextNode(anchorDOM);\n  }\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(focusNode)) {\n    focusDOM = getDOMTextNode(focusDOM);\n  }\n  if (anchorNode === undefined || focusNode === undefined || anchorDOM === null || focusDOM === null) {\n    return null;\n  }\n  if (anchorDOM.nodeName === 'BR') {\n    [anchorDOM, anchorOffset] = getDOMIndexWithinParent(anchorDOM);\n  }\n  if (focusDOM.nodeName === 'BR') {\n    [focusDOM, focusOffset] = getDOMIndexWithinParent(focusDOM);\n  }\n  const firstChild = anchorDOM.firstChild;\n  if (anchorDOM === focusDOM && firstChild != null && firstChild.nodeName === 'BR' && anchorOffset === 0 && focusOffset === 0) {\n    focusOffset = 1;\n  }\n  try {\n    range.setStart(anchorDOM, anchorOffset);\n    range.setEnd(focusDOM, focusOffset);\n  } catch (e) {\n    return null;\n  }\n  if (range.collapsed && (anchorOffset !== focusOffset || anchorKey !== focusKey)) {\n    // Range is backwards, we need to reverse it\n    range.setStart(focusDOM, focusOffset);\n    range.setEnd(anchorDOM, anchorOffset);\n  }\n  return range;\n}\n\n/**\n * Creates DOMRects, generally used to help the editor find a specific location on the screen.\n * @param editor - The lexical editor\n * @param range - A fragment of a document that can contain nodes and parts of text nodes.\n * @returns The selectionRects as an array.\n */\nfunction createRectsFromDOMRange(editor, range) {\n  const rootElement = editor.getRootElement();\n  if (rootElement === null) {\n    return [];\n  }\n  const rootRect = rootElement.getBoundingClientRect();\n  const computedStyle = getComputedStyle(rootElement);\n  const rootPadding = parseFloat(computedStyle.paddingLeft) + parseFloat(computedStyle.paddingRight);\n  const selectionRects = Array.from(range.getClientRects());\n  let selectionRectsLength = selectionRects.length;\n  //sort rects from top left to bottom right.\n  selectionRects.sort((a, b) => {\n    const top = a.top - b.top;\n    // Some rects match position closely, but not perfectly,\n    // so we give a 3px tolerance.\n    if (Math.abs(top) <= 3) {\n      return a.left - b.left;\n    }\n    return top;\n  });\n  let prevRect;\n  for (let i = 0; i < selectionRectsLength; i++) {\n    const selectionRect = selectionRects[i];\n    // Exclude rects that overlap preceding Rects in the sorted list.\n    const isOverlappingRect = prevRect && prevRect.top <= selectionRect.top && prevRect.top + prevRect.height > selectionRect.top && prevRect.left + prevRect.width > selectionRect.left;\n    // Exclude selections that span the entire element\n    const selectionSpansElement = selectionRect.width + rootPadding === rootRect.width;\n    if (isOverlappingRect || selectionSpansElement) {\n      selectionRects.splice(i--, 1);\n      selectionRectsLength--;\n      continue;\n    }\n    prevRect = selectionRect;\n  }\n  return selectionRects;\n}\n\n/**\n * Creates an object containing all the styles and their values provided in the CSS string.\n * @param css - The CSS string of styles and their values.\n * @returns The styleObject containing all the styles and their values.\n */\nfunction getStyleObjectFromRawCSS(css) {\n  const styleObject = {};\n  if (!css) {\n    return styleObject;\n  }\n  const styles = css.split(';');\n  for (const style of styles) {\n    if (style !== '') {\n      const [key, value] = style.split(/:([^]+)/); // split on first colon\n      if (key && value) {\n        styleObject[key.trim()] = value.trim();\n      }\n    }\n  }\n  return styleObject;\n}\n\n/**\n * Given a CSS string, returns an object from the style cache.\n * @param css - The CSS property as a string.\n * @returns The value of the given CSS property.\n */\nfunction getStyleObjectFromCSS(css) {\n  let value = CSS_TO_STYLES.get(css);\n  if (value === undefined) {\n    value = getStyleObjectFromRawCSS(css);\n    CSS_TO_STYLES.set(css, value);\n  }\n  {\n    // Freeze the value in DEV to prevent accidental mutations\n    Object.freeze(value);\n  }\n  return value;\n}\n\n/**\n * Gets the CSS styles from the style object.\n * @param styles - The style object containing the styles to get.\n * @returns A string containing the CSS styles and their values.\n */\nfunction getCSSFromStyleObject(styles) {\n  let css = '';\n  for (const style in styles) {\n    if (style) {\n      css += `${style}: ${styles[style]};`;\n    }\n  }\n  return css;\n}\n\n/**\n * Generally used to append text content to HTML and JSON. Grabs the text content and \"slices\"\n * it to be generated into the new TextNode.\n * @param selection - The selection containing the node whose TextNode is to be edited.\n * @param textNode - The TextNode to be edited.\n * @returns The updated TextNode.\n */\nfunction $sliceSelectedTextNodeContent(selection, textNode) {\n  const anchorAndFocus = selection.getStartEndPoints();\n  if (textNode.isSelected(selection) && !textNode.isSegmented() && !textNode.isToken() && anchorAndFocus !== null) {\n    const [anchor, focus] = anchorAndFocus;\n    const isBackward = selection.isBackward();\n    const anchorNode = anchor.getNode();\n    const focusNode = focus.getNode();\n    const isAnchor = textNode.is(anchorNode);\n    const isFocus = textNode.is(focusNode);\n    if (isAnchor || isFocus) {\n      const [anchorOffset, focusOffset] = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getCharacterOffsets)(selection);\n      const isSame = anchorNode.is(focusNode);\n      const isFirst = textNode.is(isBackward ? focusNode : anchorNode);\n      const isLast = textNode.is(isBackward ? anchorNode : focusNode);\n      let startOffset = 0;\n      let endOffset = undefined;\n      if (isSame) {\n        startOffset = anchorOffset > focusOffset ? focusOffset : anchorOffset;\n        endOffset = anchorOffset > focusOffset ? anchorOffset : focusOffset;\n      } else if (isFirst) {\n        const offset = isBackward ? focusOffset : anchorOffset;\n        startOffset = offset;\n        endOffset = undefined;\n      } else if (isLast) {\n        const offset = isBackward ? anchorOffset : focusOffset;\n        startOffset = 0;\n        endOffset = offset;\n      }\n      textNode.__text = textNode.__text.slice(startOffset, endOffset);\n      return textNode;\n    }\n  }\n  return textNode;\n}\n\n/**\n * Determines if the current selection is at the end of the node.\n * @param point - The point of the selection to test.\n * @returns true if the provided point offset is in the last possible position, false otherwise.\n */\nfunction $isAtNodeEnd(point) {\n  if (point.type === 'text') {\n    return point.offset === point.getNode().getTextContentSize();\n  }\n  const node = point.getNode();\n  if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(node)) {\n    formatDevErrorMessage(`isAtNodeEnd: node must be a TextNode or ElementNode`);\n  }\n  return point.offset === node.getChildrenSize();\n}\n\n/**\n * Trims text from a node in order to shorten it, eg. to enforce a text's max length. If it deletes text\n * that is an ancestor of the anchor then it will leave 2 indents, otherwise, if no text content exists, it deletes\n * the TextNode. It will move the focus to either the end of any left over text or beginning of a new TextNode.\n * @param editor - The lexical editor.\n * @param anchor - The anchor of the current selection, where the selection should be pointing.\n * @param delCount - The amount of characters to delete. Useful as a dynamic variable eg. textContentSize - maxLength;\n */\nfunction $trimTextContentFromAnchor(editor, anchor, delCount) {\n  // Work from the current selection anchor point\n  let currentNode = anchor.getNode();\n  let remaining = delCount;\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(currentNode)) {\n    const descendantNode = currentNode.getDescendantByIndex(anchor.offset);\n    if (descendantNode !== null) {\n      currentNode = descendantNode;\n    }\n  }\n  while (remaining > 0 && currentNode !== null) {\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(currentNode)) {\n      const lastDescendant = currentNode.getLastDescendant();\n      if (lastDescendant !== null) {\n        currentNode = lastDescendant;\n      }\n    }\n    let nextNode = currentNode.getPreviousSibling();\n    let additionalElementWhitespace = 0;\n    if (nextNode === null) {\n      let parent = currentNode.getParentOrThrow();\n      let parentSibling = parent.getPreviousSibling();\n      while (parentSibling === null) {\n        parent = parent.getParent();\n        if (parent === null) {\n          nextNode = null;\n          break;\n        }\n        parentSibling = parent.getPreviousSibling();\n      }\n      if (parent !== null) {\n        additionalElementWhitespace = parent.isInline() ? 0 : 2;\n        nextNode = parentSibling;\n      }\n    }\n    let text = currentNode.getTextContent();\n    // If the text is empty, we need to consider adding in two line breaks to match\n    // the content if we were to get it from its parent.\n    if (text === '' && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(currentNode) && !currentNode.isInline()) {\n      // TODO: should this be handled in core?\n      text = '\\n\\n';\n    }\n    const currentNodeSize = text.length;\n    if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(currentNode) || remaining >= currentNodeSize) {\n      const parent = currentNode.getParent();\n      currentNode.remove();\n      if (parent != null && parent.getChildrenSize() === 0 && !(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRootNode)(parent)) {\n        parent.remove();\n      }\n      remaining -= currentNodeSize + additionalElementWhitespace;\n      currentNode = nextNode;\n    } else {\n      const key = currentNode.getKey();\n      // See if we can just revert it to what was in the last editor state\n      const prevTextContent = editor.getEditorState().read(() => {\n        const prevNode = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getNodeByKey)(key);\n        if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(prevNode) && prevNode.isSimpleText()) {\n          return prevNode.getTextContent();\n        }\n        return null;\n      });\n      const offset = currentNodeSize - remaining;\n      const slicedText = text.slice(0, offset);\n      if (prevTextContent !== null && prevTextContent !== text) {\n        const prevSelection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getPreviousSelection)();\n        let target = currentNode;\n        if (!currentNode.isSimpleText()) {\n          const textNode = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createTextNode)(prevTextContent);\n          currentNode.replace(textNode);\n          target = textNode;\n        } else {\n          currentNode.setTextContent(prevTextContent);\n        }\n        if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(prevSelection) && prevSelection.isCollapsed()) {\n          const prevOffset = prevSelection.anchor.offset;\n          target.select(prevOffset, prevOffset);\n        }\n      } else if (currentNode.isSimpleText()) {\n        // Split text\n        const isSelected = anchor.key === key;\n        let anchorOffset = anchor.offset;\n        // Move offset to end if it's less than the remaining number, otherwise\n        // we'll have a negative splitStart.\n        if (anchorOffset < remaining) {\n          anchorOffset = currentNodeSize;\n        }\n        const splitStart = isSelected ? anchorOffset - remaining : 0;\n        const splitEnd = isSelected ? anchorOffset : offset;\n        if (isSelected && splitStart === 0) {\n          const [excessNode] = currentNode.splitText(splitStart, splitEnd);\n          excessNode.remove();\n        } else {\n          const [, excessNode] = currentNode.splitText(splitStart, splitEnd);\n          excessNode.remove();\n        }\n      } else {\n        const textNode = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createTextNode)(slicedText);\n        currentNode.replace(textNode);\n      }\n      remaining = 0;\n    }\n  }\n}\n\n/**\n * Gets the TextNode's style object and adds the styles to the CSS.\n * @param node - The TextNode to add styles to.\n */\nfunction $addNodeStyle(node) {\n  const CSSText = node.getStyle();\n  const styles = getStyleObjectFromRawCSS(CSSText);\n  CSS_TO_STYLES.set(CSSText, styles);\n}\n\n/**\n * Applies the provided styles to the given TextNode, ElementNode, or\n * collapsed RangeSelection.\n *\n * @param target - The TextNode, ElementNode, or collapsed RangeSelection to apply the styles to\n * @param patch - The patch to apply, which can include multiple styles. \\\\{CSSProperty: value\\\\} . Can also accept a function that returns the new property value.\n */\nfunction $patchStyle(target, patch) {\n  if (!((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(target) ? target.isCollapsed() : (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(target) || (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(target))) {\n    formatDevErrorMessage(`$patchStyle must only be called with a TextNode, ElementNode, or collapsed RangeSelection`);\n  }\n  const prevStyles = getStyleObjectFromCSS((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(target) ? target.style : (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(target) ? target.getStyle() : target.getTextStyle());\n  const newStyles = Object.entries(patch).reduce((styles, [key, value]) => {\n    if (typeof value === 'function') {\n      styles[key] = value(prevStyles[key], target);\n    } else if (value === null) {\n      delete styles[key];\n    } else {\n      styles[key] = value;\n    }\n    return styles;\n  }, {\n    ...prevStyles\n  });\n  const newCSSText = getCSSFromStyleObject(newStyles);\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(target) || (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(target)) {\n    target.setStyle(newCSSText);\n  } else {\n    target.setTextStyle(newCSSText);\n  }\n  CSS_TO_STYLES.set(newCSSText, newStyles);\n}\n\n/**\n * Applies the provided styles to the TextNodes in the provided Selection.\n * Will update partially selected TextNodes by splitting the TextNode and applying\n * the styles to the appropriate one.\n * @param selection - The selected node(s) to update.\n * @param patch - The patch to apply, which can include multiple styles. \\\\{CSSProperty: value\\\\} . Can also accept a function that returns the new property value.\n */\nfunction $patchStyleText(selection, patch) {\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection) && selection.isCollapsed()) {\n    $patchStyle(selection, patch);\n    const emptyNode = selection.anchor.getNode();\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(emptyNode) && emptyNode.isEmpty()) {\n      $patchStyle(emptyNode, patch);\n    }\n  }\n  $forEachSelectedTextNode(textNode => {\n    $patchStyle(textNode, patch);\n  });\n}\nfunction $forEachSelectedTextNode(fn) {\n  const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n  if (!selection) {\n    return;\n  }\n  const slicedTextNodes = new Map();\n  const getSliceIndices = node => slicedTextNodes.get(node.getKey()) || [0, node.getTextContentSize()];\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n    for (const slice of (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$caretRangeFromSelection)(selection).getTextSlices()) {\n      if (slice) {\n        slicedTextNodes.set(slice.caret.origin.getKey(), slice.getSliceIndices());\n      }\n    }\n  }\n  const selectedNodes = selection.getNodes();\n  for (const selectedNode of selectedNodes) {\n    if (!((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(selectedNode) && selectedNode.canHaveFormat())) {\n      continue;\n    }\n    const [startOffset, endOffset] = getSliceIndices(selectedNode);\n    // No actual text is selected, so do nothing.\n    if (endOffset === startOffset) {\n      continue;\n    }\n\n    // The entire node is selected or a token/segment, so just format it\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTokenOrSegmented)(selectedNode) || startOffset === 0 && endOffset === selectedNode.getTextContentSize()) {\n      fn(selectedNode);\n    } else {\n      // The node is partially selected, so split it into two or three nodes\n      // and style the selected one.\n      const splitNodes = selectedNode.splitText(startOffset, endOffset);\n      const replacement = splitNodes[startOffset === 0 ? 0 : 1];\n      fn(replacement);\n    }\n  }\n  // Prior to NodeCaret #7046 this would have been a side-effect\n  // so we do this for test compatibility.\n  // TODO: we may want to consider simplifying by removing this\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection) && selection.anchor.type === 'text' && selection.focus.type === 'text' && selection.anchor.key === selection.focus.key) {\n    $ensureForwardRangeSelection(selection);\n  }\n}\n\n/**\n * Ensure that the given RangeSelection is not backwards. If it\n * is backwards, then the anchor and focus points will be swapped\n * in-place. Ensuring that the selection is a writable RangeSelection\n * is the responsibility of the caller (e.g. in a read-only context\n * you will want to clone $getSelection() before using this).\n *\n * @param selection a writable RangeSelection\n */\nfunction $ensureForwardRangeSelection(selection) {\n  if (selection.isBackward()) {\n    const {\n      anchor,\n      focus\n    } = selection;\n    // stash for the in-place swap\n    const {\n      key,\n      offset,\n      type\n    } = anchor;\n    anchor.set(focus.key, focus.offset, focus.type);\n    focus.set(key, offset, type);\n  }\n}\n\nfunction $copyBlockFormatIndent(srcNode, destNode) {\n  const format = srcNode.getFormatType();\n  const indent = srcNode.getIndent();\n  if (format !== destNode.getFormatType()) {\n    destNode.setFormat(format);\n  }\n  if (indent !== destNode.getIndent()) {\n    destNode.setIndent(indent);\n  }\n}\n\n/**\n * Converts all nodes in the selection that are of one block type to another.\n * @param selection - The selected blocks to be converted.\n * @param $createElement - The function that creates the node. eg. $createParagraphNode.\n * @param $afterCreateElement - The function that updates the new node based on the previous one ($copyBlockFormatIndent by default)\n */\nfunction $setBlocksType(selection, $createElement, $afterCreateElement = $copyBlockFormatIndent) {\n  if (selection === null) {\n    return;\n  }\n  // Selections tend to not include their containing blocks so we effectively\n  // expand it here\n  const anchorAndFocus = selection.getStartEndPoints();\n  const blockMap = new Map();\n  let newSelection = null;\n  if (anchorAndFocus) {\n    const [anchor, focus] = anchorAndFocus;\n    newSelection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createRangeSelection)();\n    newSelection.anchor.set(anchor.key, anchor.offset, anchor.type);\n    newSelection.focus.set(focus.key, focus.offset, focus.type);\n    const anchorBlock = $getAncestor(anchor.getNode(), lexical__WEBPACK_IMPORTED_MODULE_0__.INTERNAL_$isBlock);\n    const focusBlock = $getAncestor(focus.getNode(), lexical__WEBPACK_IMPORTED_MODULE_0__.INTERNAL_$isBlock);\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(anchorBlock)) {\n      blockMap.set(anchorBlock.getKey(), anchorBlock);\n    }\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(focusBlock)) {\n      blockMap.set(focusBlock.getKey(), focusBlock);\n    }\n  }\n  for (const node of selection.getNodes()) {\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(node) && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.INTERNAL_$isBlock)(node)) {\n      blockMap.set(node.getKey(), node);\n    }\n  }\n  for (const [key, prevNode] of blockMap) {\n    const element = $createElement();\n    $afterCreateElement(prevNode, element);\n    prevNode.replace(element, true);\n    if (newSelection) {\n      if (key === newSelection.anchor.key) {\n        newSelection.anchor.set(element.getKey(), newSelection.anchor.offset, newSelection.anchor.type);\n      }\n      if (key === newSelection.focus.key) {\n        newSelection.focus.set(element.getKey(), newSelection.focus.offset, newSelection.focus.type);\n      }\n    }\n  }\n  if (newSelection && selection.is((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)())) {\n    (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$setSelection)(newSelection);\n  }\n}\nfunction isPointAttached(point) {\n  return point.getNode().isAttached();\n}\nfunction $removeParentEmptyElements(startingNode) {\n  let node = startingNode;\n  while (node !== null && !(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRootOrShadowRoot)(node)) {\n    const latest = node.getLatest();\n    const parentNode = node.getParent();\n    if (latest.getChildrenSize() === 0) {\n      node.remove(true);\n    }\n    node = parentNode;\n  }\n}\n\n/**\n * @deprecated\n * Wraps all nodes in the selection into another node of the type returned by createElement.\n * @param selection - The selection of nodes to be wrapped.\n * @param createElement - A function that creates the wrapping ElementNode. eg. $createParagraphNode.\n * @param wrappingElement - An element to append the wrapped selection and its children to.\n */\nfunction $wrapNodes(selection, createElement, wrappingElement = null) {\n  const anchorAndFocus = selection.getStartEndPoints();\n  const anchor = anchorAndFocus ? anchorAndFocus[0] : null;\n  const nodes = selection.getNodes();\n  const nodesLength = nodes.length;\n  if (anchor !== null && (nodesLength === 0 || nodesLength === 1 && anchor.type === 'element' && anchor.getNode().getChildrenSize() === 0)) {\n    const target = anchor.type === 'text' ? anchor.getNode().getParentOrThrow() : anchor.getNode();\n    const children = target.getChildren();\n    let element = createElement();\n    element.setFormat(target.getFormatType());\n    element.setIndent(target.getIndent());\n    children.forEach(child => element.append(child));\n    if (wrappingElement) {\n      element = wrappingElement.append(element);\n    }\n    target.replace(element);\n    return;\n  }\n  let topLevelNode = null;\n  let descendants = [];\n  for (let i = 0; i < nodesLength; i++) {\n    const node = nodes[i];\n    // Determine whether wrapping has to be broken down into multiple chunks. This can happen if the\n    // user selected multiple Root-like nodes that have to be treated separately as if they are\n    // their own branch. I.e. you don't want to wrap a whole table, but rather the contents of each\n    // of each of the cell nodes.\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRootOrShadowRoot)(node)) {\n      $wrapNodesImpl(selection, descendants, descendants.length, createElement, wrappingElement);\n      descendants = [];\n      topLevelNode = node;\n    } else if (topLevelNode === null || topLevelNode !== null && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$hasAncestor)(node, topLevelNode)) {\n      descendants.push(node);\n    } else {\n      $wrapNodesImpl(selection, descendants, descendants.length, createElement, wrappingElement);\n      descendants = [node];\n    }\n  }\n  $wrapNodesImpl(selection, descendants, descendants.length, createElement, wrappingElement);\n}\n\n/**\n * Wraps each node into a new ElementNode.\n * @param selection - The selection of nodes to wrap.\n * @param nodes - An array of nodes, generally the descendants of the selection.\n * @param nodesLength - The length of nodes.\n * @param createElement - A function that creates the wrapping ElementNode. eg. $createParagraphNode.\n * @param wrappingElement - An element to wrap all the nodes into.\n * @returns\n */\nfunction $wrapNodesImpl(selection, nodes, nodesLength, createElement, wrappingElement = null) {\n  if (nodes.length === 0) {\n    return;\n  }\n  const firstNode = nodes[0];\n  const elementMapping = new Map();\n  const elements = [];\n  // The below logic is to find the right target for us to\n  // either insertAfter/insertBefore/append the corresponding\n  // elements to. This is made more complicated due to nested\n  // structures.\n  let target = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(firstNode) ? firstNode : firstNode.getParentOrThrow();\n  if (target.isInline()) {\n    target = target.getParentOrThrow();\n  }\n  let targetIsPrevSibling = false;\n  while (target !== null) {\n    const prevSibling = target.getPreviousSibling();\n    if (prevSibling !== null) {\n      target = prevSibling;\n      targetIsPrevSibling = true;\n      break;\n    }\n    target = target.getParentOrThrow();\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRootOrShadowRoot)(target)) {\n      break;\n    }\n  }\n  const emptyElements = new Set();\n\n  // Find any top level empty elements\n  for (let i = 0; i < nodesLength; i++) {\n    const node = nodes[i];\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(node) && node.getChildrenSize() === 0) {\n      emptyElements.add(node.getKey());\n    }\n  }\n  const movedNodes = new Set();\n\n  // Move out all leaf nodes into our elements array.\n  // If we find a top level empty element, also move make\n  // an element for that.\n  for (let i = 0; i < nodesLength; i++) {\n    const node = nodes[i];\n    let parent = node.getParent();\n    if (parent !== null && parent.isInline()) {\n      parent = parent.getParent();\n    }\n    if (parent !== null && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isLeafNode)(node) && !movedNodes.has(node.getKey())) {\n      const parentKey = parent.getKey();\n      if (elementMapping.get(parentKey) === undefined) {\n        const targetElement = createElement();\n        targetElement.setFormat(parent.getFormatType());\n        targetElement.setIndent(parent.getIndent());\n        elements.push(targetElement);\n        elementMapping.set(parentKey, targetElement);\n        // Move node and its siblings to the new\n        // element.\n        parent.getChildren().forEach(child => {\n          targetElement.append(child);\n          movedNodes.add(child.getKey());\n          if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(child)) {\n            // Skip nested leaf nodes if the parent has already been moved\n            child.getChildrenKeys().forEach(key => movedNodes.add(key));\n          }\n        });\n        $removeParentEmptyElements(parent);\n      }\n    } else if (emptyElements.has(node.getKey())) {\n      if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(node)) {\n        formatDevErrorMessage(`Expected node in emptyElements to be an ElementNode`);\n      }\n      const targetElement = createElement();\n      targetElement.setFormat(node.getFormatType());\n      targetElement.setIndent(node.getIndent());\n      elements.push(targetElement);\n      node.remove(true);\n    }\n  }\n  if (wrappingElement !== null) {\n    for (let i = 0; i < elements.length; i++) {\n      const element = elements[i];\n      wrappingElement.append(element);\n    }\n  }\n  let lastElement = null;\n\n  // If our target is Root-like, let's see if we can re-adjust\n  // so that the target is the first child instead.\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRootOrShadowRoot)(target)) {\n    if (targetIsPrevSibling) {\n      if (wrappingElement !== null) {\n        target.insertAfter(wrappingElement);\n      } else {\n        for (let i = elements.length - 1; i >= 0; i--) {\n          const element = elements[i];\n          target.insertAfter(element);\n        }\n      }\n    } else {\n      const firstChild = target.getFirstChild();\n      if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(firstChild)) {\n        target = firstChild;\n      }\n      if (firstChild === null) {\n        if (wrappingElement) {\n          target.append(wrappingElement);\n        } else {\n          for (let i = 0; i < elements.length; i++) {\n            const element = elements[i];\n            target.append(element);\n            lastElement = element;\n          }\n        }\n      } else {\n        if (wrappingElement !== null) {\n          firstChild.insertBefore(wrappingElement);\n        } else {\n          for (let i = 0; i < elements.length; i++) {\n            const element = elements[i];\n            firstChild.insertBefore(element);\n            lastElement = element;\n          }\n        }\n      }\n    }\n  } else {\n    if (wrappingElement) {\n      target.insertAfter(wrappingElement);\n    } else {\n      for (let i = elements.length - 1; i >= 0; i--) {\n        const element = elements[i];\n        target.insertAfter(element);\n        lastElement = element;\n      }\n    }\n  }\n  const prevSelection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getPreviousSelection)();\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(prevSelection) && isPointAttached(prevSelection.anchor) && isPointAttached(prevSelection.focus)) {\n    (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$setSelection)(prevSelection.clone());\n  } else if (lastElement !== null) {\n    lastElement.selectEnd();\n  } else {\n    selection.dirty = true;\n  }\n}\n\n/**\n * Determines if the default character selection should be overridden. Used with DecoratorNodes\n * @param selection - The selection whose default character selection may need to be overridden.\n * @param isBackward - Is the selection backwards (the focus comes before the anchor)?\n * @returns true if it should be overridden, false if not.\n */\nfunction $shouldOverrideDefaultCharacterSelection(selection, isBackward) {\n  const focusCaret = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$caretFromPoint)(selection.focus, isBackward ? 'previous' : 'next');\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isExtendableTextPointCaret)(focusCaret)) {\n    return false;\n  }\n  for (const nextCaret of (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$extendCaretToRange)(focusCaret)) {\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isChildCaret)(nextCaret)) {\n      return !nextCaret.origin.isInline();\n    } else if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(nextCaret.origin)) {\n      continue;\n    } else if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isDecoratorNode)(nextCaret.origin)) {\n      return true;\n    }\n    break;\n  }\n  return false;\n}\n\n/**\n * Moves the selection according to the arguments.\n * @param selection - The selected text or nodes.\n * @param isHoldingShift - Is the shift key being held down during the operation.\n * @param isBackward - Is the selection selected backwards (the focus comes before the anchor)?\n * @param granularity - The distance to adjust the current selection.\n */\nfunction $moveCaretSelection(selection, isHoldingShift, isBackward, granularity) {\n  selection.modify(isHoldingShift ? 'extend' : 'move', isBackward, granularity);\n}\n\n/**\n * Tests a parent element for right to left direction.\n * @param selection - The selection whose parent is to be tested.\n * @returns true if the selections' parent element has a direction of 'rtl' (right to left), false otherwise.\n */\nfunction $isParentElementRTL(selection) {\n  const anchorNode = selection.anchor.getNode();\n  const parent = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRootNode)(anchorNode) ? anchorNode : anchorNode.getParentOrThrow();\n  return parent.getDirection() === 'rtl';\n}\n\n/**\n * Moves selection by character according to arguments.\n * @param selection - The selection of the characters to move.\n * @param isHoldingShift - Is the shift key being held down during the operation.\n * @param isBackward - Is the selection backward (the focus comes before the anchor)?\n */\nfunction $moveCharacter(selection, isHoldingShift, isBackward) {\n  const isRTL = $isParentElementRTL(selection);\n  $moveCaretSelection(selection, isHoldingShift, isBackward ? !isRTL : isRTL, 'character');\n}\n\n/**\n * Returns the current value of a CSS property for Nodes, if set. If not set, it returns the defaultValue.\n * @param node - The node whose style value to get.\n * @param styleProperty - The CSS style property.\n * @param defaultValue - The default value for the property.\n * @returns The value of the property for node.\n */\nfunction $getNodeStyleValueForProperty(node, styleProperty, defaultValue) {\n  const css = node.getStyle();\n  const styleObject = getStyleObjectFromCSS(css);\n  if (styleObject !== null) {\n    return styleObject[styleProperty] || defaultValue;\n  }\n  return defaultValue;\n}\n\n/**\n * Returns the current value of a CSS property for TextNodes in the Selection, if set. If not set, it returns the defaultValue.\n * If all TextNodes do not have the same value, it returns an empty string.\n * @param selection - The selection of TextNodes whose value to find.\n * @param styleProperty - The CSS style property.\n * @param defaultValue - The default value for the property, defaults to an empty string.\n * @returns The value of the property for the selected TextNodes.\n */\nfunction $getSelectionStyleValueForProperty(selection, styleProperty, defaultValue = '') {\n  let styleValue = null;\n  const nodes = selection.getNodes();\n  const anchor = selection.anchor;\n  const focus = selection.focus;\n  const isBackward = selection.isBackward();\n  const endOffset = isBackward ? focus.offset : anchor.offset;\n  const endNode = isBackward ? focus.getNode() : anchor.getNode();\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection) && selection.isCollapsed() && selection.style !== '') {\n    const css = selection.style;\n    const styleObject = getStyleObjectFromCSS(css);\n    if (styleObject !== null && styleProperty in styleObject) {\n      return styleObject[styleProperty];\n    }\n  }\n  for (let i = 0; i < nodes.length; i++) {\n    const node = nodes[i];\n\n    // if no actual characters in the end node are selected, we don't\n    // include it in the selection for purposes of determining style\n    // value\n    if (i !== 0 && endOffset === 0 && node.is(endNode)) {\n      continue;\n    }\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(node)) {\n      const nodeStyleValue = $getNodeStyleValueForProperty(node, styleProperty, defaultValue);\n      if (styleValue === null) {\n        styleValue = nodeStyleValue;\n      } else if (styleValue !== nodeStyleValue) {\n        // multiple text nodes are in the selection and they don't all\n        // have the same style.\n        styleValue = '';\n        break;\n      }\n    }\n  }\n  return styleValue === null ? defaultValue : styleValue;\n}\nfunction $getAncestor(node, predicate) {\n  let parent = node;\n  while (parent !== null && parent.getParent() !== null && !predicate(parent)) {\n    parent = parent.getParentOrThrow();\n  }\n  return predicate(parent) ? parent : null;\n}\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\n/** @deprecated renamed to {@link $trimTextContentFromAnchor} by @lexical/eslint-plugin rules-of-lexical */\nconst trimTextContentFromAnchor = $trimTextContentFromAnchor;\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@lexical/selection/LexicalSelection.dev.mjs\n");

/***/ }),

/***/ "(rsc)/./node_modules/@lexical/table/LexicalTable.dev.mjs":
/*!**********************************************************!*\
  !*** ./node_modules/@lexical/table/LexicalTable.dev.mjs ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   $computeTableMap: () => (/* binding */ $computeTableMap),\n/* harmony export */   $computeTableMapSkipCellCheck: () => (/* binding */ $computeTableMapSkipCellCheck),\n/* harmony export */   $createTableCellNode: () => (/* binding */ $createTableCellNode),\n/* harmony export */   $createTableNode: () => (/* binding */ $createTableNode),\n/* harmony export */   $createTableNodeWithDimensions: () => (/* binding */ $createTableNodeWithDimensions),\n/* harmony export */   $createTableRowNode: () => (/* binding */ $createTableRowNode),\n/* harmony export */   $createTableSelection: () => (/* binding */ $createTableSelection),\n/* harmony export */   $createTableSelectionFrom: () => (/* binding */ $createTableSelectionFrom),\n/* harmony export */   $deleteTableColumn: () => (/* binding */ $deleteTableColumn),\n/* harmony export */   $deleteTableColumn__EXPERIMENTAL: () => (/* binding */ $deleteTableColumn__EXPERIMENTAL),\n/* harmony export */   $deleteTableRow__EXPERIMENTAL: () => (/* binding */ $deleteTableRow__EXPERIMENTAL),\n/* harmony export */   $findCellNode: () => (/* binding */ $findCellNode),\n/* harmony export */   $findTableNode: () => (/* binding */ $findTableNode),\n/* harmony export */   $getElementForTableNode: () => (/* binding */ $getElementForTableNode),\n/* harmony export */   $getNodeTriplet: () => (/* binding */ $getNodeTriplet),\n/* harmony export */   $getTableAndElementByKey: () => (/* binding */ $getTableAndElementByKey),\n/* harmony export */   $getTableCellNodeFromLexicalNode: () => (/* binding */ $getTableCellNodeFromLexicalNode),\n/* harmony export */   $getTableCellNodeRect: () => (/* binding */ $getTableCellNodeRect),\n/* harmony export */   $getTableColumnIndexFromTableCellNode: () => (/* binding */ $getTableColumnIndexFromTableCellNode),\n/* harmony export */   $getTableNodeFromLexicalNodeOrThrow: () => (/* binding */ $getTableNodeFromLexicalNodeOrThrow),\n/* harmony export */   $getTableRowIndexFromTableCellNode: () => (/* binding */ $getTableRowIndexFromTableCellNode),\n/* harmony export */   $getTableRowNodeFromTableCellNodeOrThrow: () => (/* binding */ $getTableRowNodeFromTableCellNodeOrThrow),\n/* harmony export */   $insertTableColumn: () => (/* binding */ $insertTableColumn),\n/* harmony export */   $insertTableColumn__EXPERIMENTAL: () => (/* binding */ $insertTableColumn__EXPERIMENTAL),\n/* harmony export */   $insertTableRow: () => (/* binding */ $insertTableRow),\n/* harmony export */   $insertTableRow__EXPERIMENTAL: () => (/* binding */ $insertTableRow__EXPERIMENTAL),\n/* harmony export */   $isScrollableTablesActive: () => (/* binding */ $isScrollableTablesActive),\n/* harmony export */   $isTableCellNode: () => (/* binding */ $isTableCellNode),\n/* harmony export */   $isTableNode: () => (/* binding */ $isTableNode),\n/* harmony export */   $isTableRowNode: () => (/* binding */ $isTableRowNode),\n/* harmony export */   $isTableSelection: () => (/* binding */ $isTableSelection),\n/* harmony export */   $removeTableRowAtIndex: () => (/* binding */ $removeTableRowAtIndex),\n/* harmony export */   $unmergeCell: () => (/* binding */ $unmergeCell),\n/* harmony export */   INSERT_TABLE_COMMAND: () => (/* binding */ INSERT_TABLE_COMMAND),\n/* harmony export */   TableCellHeaderStates: () => (/* binding */ TableCellHeaderStates),\n/* harmony export */   TableCellNode: () => (/* binding */ TableCellNode),\n/* harmony export */   TableNode: () => (/* binding */ TableNode),\n/* harmony export */   TableObserver: () => (/* binding */ TableObserver),\n/* harmony export */   TableRowNode: () => (/* binding */ TableRowNode),\n/* harmony export */   applyTableHandlers: () => (/* binding */ applyTableHandlers),\n/* harmony export */   getDOMCellFromTarget: () => (/* binding */ getDOMCellFromTarget),\n/* harmony export */   getTableElement: () => (/* binding */ getTableElement),\n/* harmony export */   getTableObserverFromTableElement: () => (/* binding */ getTableObserverFromTableElement),\n/* harmony export */   registerTableCellUnmergeTransform: () => (/* binding */ registerTableCellUnmergeTransform),\n/* harmony export */   registerTablePlugin: () => (/* binding */ registerTablePlugin),\n/* harmony export */   registerTableSelectionObserver: () => (/* binding */ registerTableSelectionObserver),\n/* harmony export */   setScrollableTablesActive: () => (/* binding */ setScrollableTablesActive)\n/* harmony export */ });\n/* harmony import */ var _lexical_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lexical/utils */ \"(rsc)/./node_modules/@lexical/utils/LexicalUtils.dev.mjs\");\n/* harmony import */ var lexical__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lexical */ \"(rsc)/./node_modules/lexical/Lexical.dev.mjs\");\n/* harmony import */ var _lexical_clipboard__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lexical/clipboard */ \"(rsc)/./node_modules/@lexical/clipboard/LexicalClipboard.dev.mjs\");\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\n\n\n\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\nconst PIXEL_VALUE_REG_EXP = /^(\\d+(?:\\.\\d+)?)px$/;\n\n// .PlaygroundEditorTheme__tableCell width value from\n// packages/lexical-playground/src/themes/PlaygroundEditorTheme.css\nconst COLUMN_WIDTH = 75;\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\nconst TableCellHeaderStates = {\n  BOTH: 3,\n  COLUMN: 2,\n  NO_STATUS: 0,\n  ROW: 1\n};\n/** @noInheritDoc */\nclass TableCellNode extends lexical__WEBPACK_IMPORTED_MODULE_0__.ElementNode {\n  /** @internal */\n\n  /** @internal */\n\n  /** @internal */\n\n  /** @internal */\n\n  /** @internal */\n\n  /** @internal */\n\n  static getType() {\n    return 'tablecell';\n  }\n  static clone(node) {\n    return new TableCellNode(node.__headerState, node.__colSpan, node.__width, node.__key);\n  }\n  afterCloneFrom(node) {\n    super.afterCloneFrom(node);\n    this.__rowSpan = node.__rowSpan;\n    this.__backgroundColor = node.__backgroundColor;\n    this.__verticalAlign = node.__verticalAlign;\n  }\n  static importDOM() {\n    return {\n      td: node => ({\n        conversion: $convertTableCellNodeElement,\n        priority: 0\n      }),\n      th: node => ({\n        conversion: $convertTableCellNodeElement,\n        priority: 0\n      })\n    };\n  }\n  static importJSON(serializedNode) {\n    return $createTableCellNode().updateFromJSON(serializedNode);\n  }\n  updateFromJSON(serializedNode) {\n    return super.updateFromJSON(serializedNode).setHeaderStyles(serializedNode.headerState).setColSpan(serializedNode.colSpan || 1).setRowSpan(serializedNode.rowSpan || 1).setWidth(serializedNode.width || undefined).setBackgroundColor(serializedNode.backgroundColor || null).setVerticalAlign(serializedNode.verticalAlign || undefined);\n  }\n  constructor(headerState = TableCellHeaderStates.NO_STATUS, colSpan = 1, width, key) {\n    super(key);\n    this.__colSpan = colSpan;\n    this.__rowSpan = 1;\n    this.__headerState = headerState;\n    this.__width = width;\n    this.__backgroundColor = null;\n    this.__verticalAlign = undefined;\n  }\n  createDOM(config) {\n    const element = document.createElement(this.getTag());\n    if (this.__width) {\n      element.style.width = `${this.__width}px`;\n    }\n    if (this.__colSpan > 1) {\n      element.colSpan = this.__colSpan;\n    }\n    if (this.__rowSpan > 1) {\n      element.rowSpan = this.__rowSpan;\n    }\n    if (this.__backgroundColor !== null) {\n      element.style.backgroundColor = this.__backgroundColor;\n    }\n    if (isValidVerticalAlign(this.__verticalAlign)) {\n      element.style.verticalAlign = this.__verticalAlign;\n    }\n    (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.addClassNamesToElement)(element, config.theme.tableCell, this.hasHeader() && config.theme.tableCellHeader);\n    return element;\n  }\n  exportDOM(editor) {\n    const output = super.exportDOM(editor);\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(output.element)) {\n      const element = output.element;\n      element.setAttribute('data-temporary-table-cell-lexical-key', this.getKey());\n      element.style.border = '1px solid black';\n      if (this.__colSpan > 1) {\n        element.colSpan = this.__colSpan;\n      }\n      if (this.__rowSpan > 1) {\n        element.rowSpan = this.__rowSpan;\n      }\n      element.style.width = `${this.getWidth() || COLUMN_WIDTH}px`;\n      element.style.verticalAlign = this.getVerticalAlign() || 'top';\n      element.style.textAlign = 'start';\n      if (this.__backgroundColor === null && this.hasHeader()) {\n        element.style.backgroundColor = '#f2f3f5';\n      }\n    }\n    return output;\n  }\n  exportJSON() {\n    return {\n      ...super.exportJSON(),\n      ...(isValidVerticalAlign(this.__verticalAlign) && {\n        verticalAlign: this.__verticalAlign\n      }),\n      backgroundColor: this.getBackgroundColor(),\n      colSpan: this.__colSpan,\n      headerState: this.__headerState,\n      rowSpan: this.__rowSpan,\n      width: this.getWidth()\n    };\n  }\n  getColSpan() {\n    return this.getLatest().__colSpan;\n  }\n  setColSpan(colSpan) {\n    const self = this.getWritable();\n    self.__colSpan = colSpan;\n    return self;\n  }\n  getRowSpan() {\n    return this.getLatest().__rowSpan;\n  }\n  setRowSpan(rowSpan) {\n    const self = this.getWritable();\n    self.__rowSpan = rowSpan;\n    return self;\n  }\n  getTag() {\n    return this.hasHeader() ? 'th' : 'td';\n  }\n  setHeaderStyles(headerState, mask = TableCellHeaderStates.BOTH) {\n    const self = this.getWritable();\n    self.__headerState = headerState & mask | self.__headerState & ~mask;\n    return self;\n  }\n  getHeaderStyles() {\n    return this.getLatest().__headerState;\n  }\n  setWidth(width) {\n    const self = this.getWritable();\n    self.__width = width;\n    return self;\n  }\n  getWidth() {\n    return this.getLatest().__width;\n  }\n  getBackgroundColor() {\n    return this.getLatest().__backgroundColor;\n  }\n  setBackgroundColor(newBackgroundColor) {\n    const self = this.getWritable();\n    self.__backgroundColor = newBackgroundColor;\n    return self;\n  }\n  getVerticalAlign() {\n    return this.getLatest().__verticalAlign;\n  }\n  setVerticalAlign(newVerticalAlign) {\n    const self = this.getWritable();\n    self.__verticalAlign = newVerticalAlign || undefined;\n    return self;\n  }\n  toggleHeaderStyle(headerStateToToggle) {\n    const self = this.getWritable();\n    if ((self.__headerState & headerStateToToggle) === headerStateToToggle) {\n      self.__headerState -= headerStateToToggle;\n    } else {\n      self.__headerState += headerStateToToggle;\n    }\n    return self;\n  }\n  hasHeaderState(headerState) {\n    return (this.getHeaderStyles() & headerState) === headerState;\n  }\n  hasHeader() {\n    return this.getLatest().__headerState !== TableCellHeaderStates.NO_STATUS;\n  }\n  updateDOM(prevNode) {\n    return prevNode.__headerState !== this.__headerState || prevNode.__width !== this.__width || prevNode.__colSpan !== this.__colSpan || prevNode.__rowSpan !== this.__rowSpan || prevNode.__backgroundColor !== this.__backgroundColor || prevNode.__verticalAlign !== this.__verticalAlign;\n  }\n  isShadowRoot() {\n    return true;\n  }\n  collapseAtStart() {\n    return true;\n  }\n  canBeEmpty() {\n    return false;\n  }\n  canIndent() {\n    return false;\n  }\n}\nfunction isValidVerticalAlign(verticalAlign) {\n  return verticalAlign === 'middle' || verticalAlign === 'bottom';\n}\nfunction $convertTableCellNodeElement(domNode) {\n  const domNode_ = domNode;\n  const nodeName = domNode.nodeName.toLowerCase();\n  let width = undefined;\n  if (PIXEL_VALUE_REG_EXP.test(domNode_.style.width)) {\n    width = parseFloat(domNode_.style.width);\n  }\n  const tableCellNode = $createTableCellNode(nodeName === 'th' ? TableCellHeaderStates.ROW : TableCellHeaderStates.NO_STATUS, domNode_.colSpan, width);\n  tableCellNode.__rowSpan = domNode_.rowSpan;\n  const backgroundColor = domNode_.style.backgroundColor;\n  if (backgroundColor !== '') {\n    tableCellNode.__backgroundColor = backgroundColor;\n  }\n  const verticalAlign = domNode_.style.verticalAlign;\n  if (isValidVerticalAlign(verticalAlign)) {\n    tableCellNode.__verticalAlign = verticalAlign;\n  }\n  const style = domNode_.style;\n  const textDecoration = (style && style.textDecoration || '').split(' ');\n  const hasBoldFontWeight = style.fontWeight === '700' || style.fontWeight === 'bold';\n  const hasLinethroughTextDecoration = textDecoration.includes('line-through');\n  const hasItalicFontStyle = style.fontStyle === 'italic';\n  const hasUnderlineTextDecoration = textDecoration.includes('underline');\n  return {\n    after: childLexicalNodes => {\n      const result = [];\n      let paragraphNode = null;\n      const removeSingleLineBreakNode = () => {\n        if (paragraphNode) {\n          const firstChild = paragraphNode.getFirstChild();\n          if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isLineBreakNode)(firstChild) && paragraphNode.getChildrenSize() === 1) {\n            firstChild.remove();\n          }\n        }\n      };\n      for (const child of childLexicalNodes) {\n        if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isInlineElementOrDecoratorNode)(child) || (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(child) || (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isLineBreakNode)(child)) {\n          if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(child)) {\n            if (hasBoldFontWeight) {\n              child.toggleFormat('bold');\n            }\n            if (hasLinethroughTextDecoration) {\n              child.toggleFormat('strikethrough');\n            }\n            if (hasItalicFontStyle) {\n              child.toggleFormat('italic');\n            }\n            if (hasUnderlineTextDecoration) {\n              child.toggleFormat('underline');\n            }\n          }\n          if (paragraphNode) {\n            paragraphNode.append(child);\n          } else {\n            paragraphNode = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)().append(child);\n            result.push(paragraphNode);\n          }\n        } else {\n          result.push(child);\n          removeSingleLineBreakNode();\n          paragraphNode = null;\n        }\n      }\n      removeSingleLineBreakNode();\n      if (result.length === 0) {\n        result.push((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)());\n      }\n      return result;\n    },\n    node: tableCellNode\n  };\n}\nfunction $createTableCellNode(headerState = TableCellHeaderStates.NO_STATUS, colSpan = 1, width) {\n  return (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$applyNodeReplacement)(new TableCellNode(headerState, colSpan, width));\n}\nfunction $isTableCellNode(node) {\n  return node instanceof TableCellNode;\n}\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\nconst INSERT_TABLE_COMMAND = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.createCommand)('INSERT_TABLE_COMMAND');\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\n// Do not require this module directly! Use normal `invariant` calls.\n\nfunction formatDevErrorMessage(message) {\n  throw new Error(message);\n}\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\n/** @noInheritDoc */\nclass TableRowNode extends lexical__WEBPACK_IMPORTED_MODULE_0__.ElementNode {\n  /** @internal */\n\n  static getType() {\n    return 'tablerow';\n  }\n  static clone(node) {\n    return new TableRowNode(node.__height, node.__key);\n  }\n  static importDOM() {\n    return {\n      tr: node => ({\n        conversion: $convertTableRowElement,\n        priority: 0\n      })\n    };\n  }\n  static importJSON(serializedNode) {\n    return $createTableRowNode().updateFromJSON(serializedNode);\n  }\n  updateFromJSON(serializedNode) {\n    return super.updateFromJSON(serializedNode).setHeight(serializedNode.height);\n  }\n  constructor(height, key) {\n    super(key);\n    this.__height = height;\n  }\n  exportJSON() {\n    const height = this.getHeight();\n    return {\n      ...super.exportJSON(),\n      ...(height === undefined ? undefined : {\n        height\n      })\n    };\n  }\n  createDOM(config) {\n    const element = document.createElement('tr');\n    if (this.__height) {\n      element.style.height = `${this.__height}px`;\n    }\n    (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.addClassNamesToElement)(element, config.theme.tableRow);\n    return element;\n  }\n  extractWithChild(child, selection, destination) {\n    return destination === 'html';\n  }\n  isShadowRoot() {\n    return true;\n  }\n  setHeight(height) {\n    const self = this.getWritable();\n    self.__height = height;\n    return self;\n  }\n  getHeight() {\n    return this.getLatest().__height;\n  }\n  updateDOM(prevNode) {\n    return prevNode.__height !== this.__height;\n  }\n  canBeEmpty() {\n    return false;\n  }\n  canIndent() {\n    return false;\n  }\n}\nfunction $convertTableRowElement(domNode) {\n  const domNode_ = domNode;\n  let height = undefined;\n  if (PIXEL_VALUE_REG_EXP.test(domNode_.style.height)) {\n    height = parseFloat(domNode_.style.height);\n  }\n  return {\n    after: children => (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$descendantsMatching)(children, $isTableCellNode),\n    node: $createTableRowNode(height)\n  };\n}\nfunction $createTableRowNode(height) {\n  return (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$applyNodeReplacement)(new TableRowNode(height));\n}\nfunction $isTableRowNode(node) {\n  return node instanceof TableRowNode;\n}\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\nconst CAN_USE_DOM = typeof window !== 'undefined' && typeof window.document !== 'undefined' && typeof window.document.createElement !== 'undefined';\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\nconst documentMode = CAN_USE_DOM && 'documentMode' in document ? document.documentMode : null;\nconst IS_FIREFOX = CAN_USE_DOM && /^(?!.*Seamonkey)(?=.*Firefox).*/i.test(navigator.userAgent);\nCAN_USE_DOM && 'InputEvent' in window && !documentMode ? 'getTargetRanges' in new window.InputEvent('input') : false;\n\nfunction $createTableNodeWithDimensions(rowCount, columnCount, includeHeaders = true) {\n  const tableNode = $createTableNode();\n  for (let iRow = 0; iRow < rowCount; iRow++) {\n    const tableRowNode = $createTableRowNode();\n    for (let iColumn = 0; iColumn < columnCount; iColumn++) {\n      let headerState = TableCellHeaderStates.NO_STATUS;\n      if (typeof includeHeaders === 'object') {\n        if (iRow === 0 && includeHeaders.rows) {\n          headerState |= TableCellHeaderStates.ROW;\n        }\n        if (iColumn === 0 && includeHeaders.columns) {\n          headerState |= TableCellHeaderStates.COLUMN;\n        }\n      } else if (includeHeaders) {\n        if (iRow === 0) {\n          headerState |= TableCellHeaderStates.ROW;\n        }\n        if (iColumn === 0) {\n          headerState |= TableCellHeaderStates.COLUMN;\n        }\n      }\n      const tableCellNode = $createTableCellNode(headerState);\n      const paragraphNode = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)();\n      paragraphNode.append((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createTextNode)());\n      tableCellNode.append(paragraphNode);\n      tableRowNode.append(tableCellNode);\n    }\n    tableNode.append(tableRowNode);\n  }\n  return tableNode;\n}\nfunction $getTableCellNodeFromLexicalNode(startingNode) {\n  const node = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(startingNode, n => $isTableCellNode(n));\n  if ($isTableCellNode(node)) {\n    return node;\n  }\n  return null;\n}\nfunction $getTableRowNodeFromTableCellNodeOrThrow(startingNode) {\n  const node = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(startingNode, n => $isTableRowNode(n));\n  if ($isTableRowNode(node)) {\n    return node;\n  }\n  throw new Error('Expected table cell to be inside of table row.');\n}\nfunction $getTableNodeFromLexicalNodeOrThrow(startingNode) {\n  const node = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(startingNode, n => $isTableNode(n));\n  if ($isTableNode(node)) {\n    return node;\n  }\n  throw new Error('Expected table cell to be inside of table.');\n}\nfunction $getTableRowIndexFromTableCellNode(tableCellNode) {\n  const tableRowNode = $getTableRowNodeFromTableCellNodeOrThrow(tableCellNode);\n  const tableNode = $getTableNodeFromLexicalNodeOrThrow(tableRowNode);\n  return tableNode.getChildren().findIndex(n => n.is(tableRowNode));\n}\nfunction $getTableColumnIndexFromTableCellNode(tableCellNode) {\n  const tableRowNode = $getTableRowNodeFromTableCellNodeOrThrow(tableCellNode);\n  return tableRowNode.getChildren().findIndex(n => n.is(tableCellNode));\n}\nfunction $getTableCellSiblingsFromTableCellNode(tableCellNode, table) {\n  const tableNode = $getTableNodeFromLexicalNodeOrThrow(tableCellNode);\n  const {\n    x,\n    y\n  } = tableNode.getCordsFromCellNode(tableCellNode, table);\n  return {\n    above: tableNode.getCellNodeFromCords(x, y - 1, table),\n    below: tableNode.getCellNodeFromCords(x, y + 1, table),\n    left: tableNode.getCellNodeFromCords(x - 1, y, table),\n    right: tableNode.getCellNodeFromCords(x + 1, y, table)\n  };\n}\nfunction $removeTableRowAtIndex(tableNode, indexToDelete) {\n  const tableRows = tableNode.getChildren();\n  if (indexToDelete >= tableRows.length || indexToDelete < 0) {\n    throw new Error('Expected table cell to be inside of table row.');\n  }\n  const targetRowNode = tableRows[indexToDelete];\n  targetRowNode.remove();\n  return tableNode;\n}\nfunction $insertTableRow(tableNode, targetIndex, shouldInsertAfter = true, rowCount, table) {\n  const tableRows = tableNode.getChildren();\n  if (targetIndex >= tableRows.length || targetIndex < 0) {\n    throw new Error('Table row target index out of range');\n  }\n  const targetRowNode = tableRows[targetIndex];\n  if ($isTableRowNode(targetRowNode)) {\n    for (let r = 0; r < rowCount; r++) {\n      const tableRowCells = targetRowNode.getChildren();\n      const tableColumnCount = tableRowCells.length;\n      const newTableRowNode = $createTableRowNode();\n      for (let c = 0; c < tableColumnCount; c++) {\n        const tableCellFromTargetRow = tableRowCells[c];\n        if (!$isTableCellNode(tableCellFromTargetRow)) {\n          formatDevErrorMessage(`Expected table cell`);\n        }\n        const {\n          above,\n          below\n        } = $getTableCellSiblingsFromTableCellNode(tableCellFromTargetRow, table);\n        let headerState = TableCellHeaderStates.NO_STATUS;\n        const width = above && above.getWidth() || below && below.getWidth() || undefined;\n        if (above && above.hasHeaderState(TableCellHeaderStates.COLUMN) || below && below.hasHeaderState(TableCellHeaderStates.COLUMN)) {\n          headerState |= TableCellHeaderStates.COLUMN;\n        }\n        const tableCellNode = $createTableCellNode(headerState, 1, width);\n        tableCellNode.append((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)());\n        newTableRowNode.append(tableCellNode);\n      }\n      if (shouldInsertAfter) {\n        targetRowNode.insertAfter(newTableRowNode);\n      } else {\n        targetRowNode.insertBefore(newTableRowNode);\n      }\n    }\n  } else {\n    throw new Error('Row before insertion index does not exist.');\n  }\n  return tableNode;\n}\nconst getHeaderState = (currentState, possibleState) => {\n  if (currentState === TableCellHeaderStates.BOTH || currentState === possibleState) {\n    return possibleState;\n  }\n  return TableCellHeaderStates.NO_STATUS;\n};\n\n/**\n * Inserts a table row before or after the current focus cell node,\n * taking into account any spans. If successful, returns the\n * inserted table row node.\n */\nfunction $insertTableRow__EXPERIMENTAL(insertAfter = true) {\n  const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n  if (!((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection) || $isTableSelection(selection))) {\n    formatDevErrorMessage(`Expected a RangeSelection or TableSelection`);\n  }\n  const anchor = selection.anchor.getNode();\n  const focus = selection.focus.getNode();\n  const [anchorCell] = $getNodeTriplet(anchor);\n  const [focusCell,, grid] = $getNodeTriplet(focus);\n  const [gridMap, focusCellMap, anchorCellMap] = $computeTableMap(grid, focusCell, anchorCell);\n  const columnCount = gridMap[0].length;\n  const {\n    startRow: anchorStartRow\n  } = anchorCellMap;\n  const {\n    startRow: focusStartRow\n  } = focusCellMap;\n  let insertedRow = null;\n  if (insertAfter) {\n    const insertAfterEndRow = Math.max(focusStartRow + focusCell.__rowSpan, anchorStartRow + anchorCell.__rowSpan) - 1;\n    const insertAfterEndRowMap = gridMap[insertAfterEndRow];\n    const newRow = $createTableRowNode();\n    for (let i = 0; i < columnCount; i++) {\n      const {\n        cell,\n        startRow\n      } = insertAfterEndRowMap[i];\n      if (startRow + cell.__rowSpan - 1 <= insertAfterEndRow) {\n        const currentCell = insertAfterEndRowMap[i].cell;\n        const currentCellHeaderState = currentCell.__headerState;\n        const headerState = getHeaderState(currentCellHeaderState, TableCellHeaderStates.COLUMN);\n        newRow.append($createTableCellNode(headerState).append((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)()));\n      } else {\n        cell.setRowSpan(cell.__rowSpan + 1);\n      }\n    }\n    const insertAfterEndRowNode = grid.getChildAtIndex(insertAfterEndRow);\n    if (!$isTableRowNode(insertAfterEndRowNode)) {\n      formatDevErrorMessage(`insertAfterEndRow is not a TableRowNode`);\n    }\n    insertAfterEndRowNode.insertAfter(newRow);\n    insertedRow = newRow;\n  } else {\n    const insertBeforeStartRow = Math.min(focusStartRow, anchorStartRow);\n    const insertBeforeStartRowMap = gridMap[insertBeforeStartRow];\n    const newRow = $createTableRowNode();\n    for (let i = 0; i < columnCount; i++) {\n      const {\n        cell,\n        startRow\n      } = insertBeforeStartRowMap[i];\n      if (startRow === insertBeforeStartRow) {\n        const currentCell = insertBeforeStartRowMap[i].cell;\n        const currentCellHeaderState = currentCell.__headerState;\n        const headerState = getHeaderState(currentCellHeaderState, TableCellHeaderStates.COLUMN);\n        newRow.append($createTableCellNode(headerState).append((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)()));\n      } else {\n        cell.setRowSpan(cell.__rowSpan + 1);\n      }\n    }\n    const insertBeforeStartRowNode = grid.getChildAtIndex(insertBeforeStartRow);\n    if (!$isTableRowNode(insertBeforeStartRowNode)) {\n      formatDevErrorMessage(`insertBeforeStartRow is not a TableRowNode`);\n    }\n    insertBeforeStartRowNode.insertBefore(newRow);\n    insertedRow = newRow;\n  }\n  return insertedRow;\n}\nfunction $insertTableColumn(tableNode, targetIndex, shouldInsertAfter = true, columnCount, table) {\n  const tableRows = tableNode.getChildren();\n  const tableCellsToBeInserted = [];\n  for (let r = 0; r < tableRows.length; r++) {\n    const currentTableRowNode = tableRows[r];\n    if ($isTableRowNode(currentTableRowNode)) {\n      for (let c = 0; c < columnCount; c++) {\n        const tableRowChildren = currentTableRowNode.getChildren();\n        if (targetIndex >= tableRowChildren.length || targetIndex < 0) {\n          throw new Error('Table column target index out of range');\n        }\n        const targetCell = tableRowChildren[targetIndex];\n        if (!$isTableCellNode(targetCell)) {\n          formatDevErrorMessage(`Expected table cell`);\n        }\n        const {\n          left,\n          right\n        } = $getTableCellSiblingsFromTableCellNode(targetCell, table);\n        let headerState = TableCellHeaderStates.NO_STATUS;\n        if (left && left.hasHeaderState(TableCellHeaderStates.ROW) || right && right.hasHeaderState(TableCellHeaderStates.ROW)) {\n          headerState |= TableCellHeaderStates.ROW;\n        }\n        const newTableCell = $createTableCellNode(headerState);\n        newTableCell.append((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)());\n        tableCellsToBeInserted.push({\n          newTableCell,\n          targetCell\n        });\n      }\n    }\n  }\n  tableCellsToBeInserted.forEach(({\n    newTableCell,\n    targetCell\n  }) => {\n    if (shouldInsertAfter) {\n      targetCell.insertAfter(newTableCell);\n    } else {\n      targetCell.insertBefore(newTableCell);\n    }\n  });\n  return tableNode;\n}\n\n/**\n * Inserts a column before or after the current focus cell node,\n * taking into account any spans. If successful, returns the\n * first inserted cell node.\n */\nfunction $insertTableColumn__EXPERIMENTAL(insertAfter = true) {\n  const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n  if (!((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection) || $isTableSelection(selection))) {\n    formatDevErrorMessage(`Expected a RangeSelection or TableSelection`);\n  }\n  const anchor = selection.anchor.getNode();\n  const focus = selection.focus.getNode();\n  const [anchorCell] = $getNodeTriplet(anchor);\n  const [focusCell,, grid] = $getNodeTriplet(focus);\n  const [gridMap, focusCellMap, anchorCellMap] = $computeTableMap(grid, focusCell, anchorCell);\n  const rowCount = gridMap.length;\n  const startColumn = insertAfter ? Math.max(focusCellMap.startColumn, anchorCellMap.startColumn) : Math.min(focusCellMap.startColumn, anchorCellMap.startColumn);\n  const insertAfterColumn = insertAfter ? startColumn + focusCell.__colSpan - 1 : startColumn - 1;\n  const gridFirstChild = grid.getFirstChild();\n  if (!$isTableRowNode(gridFirstChild)) {\n    formatDevErrorMessage(`Expected firstTable child to be a row`);\n  }\n  let firstInsertedCell = null;\n  function $createTableCellNodeForInsertTableColumn(headerState = TableCellHeaderStates.NO_STATUS) {\n    const cell = $createTableCellNode(headerState).append((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)());\n    if (firstInsertedCell === null) {\n      firstInsertedCell = cell;\n    }\n    return cell;\n  }\n  let loopRow = gridFirstChild;\n  rowLoop: for (let i = 0; i < rowCount; i++) {\n    if (i !== 0) {\n      const currentRow = loopRow.getNextSibling();\n      if (!$isTableRowNode(currentRow)) {\n        formatDevErrorMessage(`Expected row nextSibling to be a row`);\n      }\n      loopRow = currentRow;\n    }\n    const rowMap = gridMap[i];\n    const currentCellHeaderState = rowMap[insertAfterColumn < 0 ? 0 : insertAfterColumn].cell.__headerState;\n    const headerState = getHeaderState(currentCellHeaderState, TableCellHeaderStates.ROW);\n    if (insertAfterColumn < 0) {\n      $insertFirst(loopRow, $createTableCellNodeForInsertTableColumn(headerState));\n      continue;\n    }\n    const {\n      cell: currentCell,\n      startColumn: currentStartColumn,\n      startRow: currentStartRow\n    } = rowMap[insertAfterColumn];\n    if (currentStartColumn + currentCell.__colSpan - 1 <= insertAfterColumn) {\n      let insertAfterCell = currentCell;\n      let insertAfterCellRowStart = currentStartRow;\n      let prevCellIndex = insertAfterColumn;\n      while (insertAfterCellRowStart !== i && insertAfterCell.__rowSpan > 1) {\n        prevCellIndex -= currentCell.__colSpan;\n        if (prevCellIndex >= 0) {\n          const {\n            cell: cell_,\n            startRow: startRow_\n          } = rowMap[prevCellIndex];\n          insertAfterCell = cell_;\n          insertAfterCellRowStart = startRow_;\n        } else {\n          loopRow.append($createTableCellNodeForInsertTableColumn(headerState));\n          continue rowLoop;\n        }\n      }\n      insertAfterCell.insertAfter($createTableCellNodeForInsertTableColumn(headerState));\n    } else {\n      currentCell.setColSpan(currentCell.__colSpan + 1);\n    }\n  }\n  if (firstInsertedCell !== null) {\n    $moveSelectionToCell(firstInsertedCell);\n  }\n  const colWidths = grid.getColWidths();\n  if (colWidths) {\n    const newColWidths = [...colWidths];\n    const columnIndex = insertAfterColumn < 0 ? 0 : insertAfterColumn;\n    const newWidth = newColWidths[columnIndex];\n    newColWidths.splice(columnIndex, 0, newWidth);\n    grid.setColWidths(newColWidths);\n  }\n  return firstInsertedCell;\n}\nfunction $deleteTableColumn(tableNode, targetIndex) {\n  const tableRows = tableNode.getChildren();\n  for (let i = 0; i < tableRows.length; i++) {\n    const currentTableRowNode = tableRows[i];\n    if ($isTableRowNode(currentTableRowNode)) {\n      const tableRowChildren = currentTableRowNode.getChildren();\n      if (targetIndex >= tableRowChildren.length || targetIndex < 0) {\n        throw new Error('Table column target index out of range');\n      }\n      tableRowChildren[targetIndex].remove();\n    }\n  }\n  return tableNode;\n}\nfunction $deleteTableRow__EXPERIMENTAL() {\n  const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n  if (!((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection) || $isTableSelection(selection))) {\n    formatDevErrorMessage(`Expected a RangeSelection or TableSelection`);\n  }\n  const [anchor, focus] = selection.isBackward() ? [selection.focus.getNode(), selection.anchor.getNode()] : [selection.anchor.getNode(), selection.focus.getNode()];\n  const [anchorCell,, grid] = $getNodeTriplet(anchor);\n  const [focusCell] = $getNodeTriplet(focus);\n  const [gridMap, anchorCellMap, focusCellMap] = $computeTableMap(grid, anchorCell, focusCell);\n  const {\n    startRow: anchorStartRow\n  } = anchorCellMap;\n  const {\n    startRow: focusStartRow\n  } = focusCellMap;\n  const focusEndRow = focusStartRow + focusCell.__rowSpan - 1;\n  if (gridMap.length === focusEndRow - anchorStartRow + 1) {\n    // Empty grid\n    grid.remove();\n    return;\n  }\n  const columnCount = gridMap[0].length;\n  const selectedRowCount = anchorCell.__rowSpan;\n  const nextRow = gridMap[focusEndRow + 1];\n  const nextRowNode = grid.getChildAtIndex(focusEndRow + 1);\n  for (let row = focusEndRow; row >= anchorStartRow; row--) {\n    for (let column = columnCount - 1; column >= 0; column--) {\n      const {\n        cell,\n        startRow: cellStartRow,\n        startColumn: cellStartColumn\n      } = gridMap[row][column];\n      if (cellStartColumn !== column) {\n        // Don't repeat work for the same Cell\n        continue;\n      }\n      // Rows overflowing top have to be trimmed\n      if (row === anchorStartRow && cellStartRow < anchorStartRow) {\n        const overflowTop = anchorStartRow - cellStartRow;\n        cell.setRowSpan(cell.__rowSpan - Math.min(selectedRowCount, cell.__rowSpan - overflowTop));\n      }\n      // Rows overflowing bottom have to be trimmed and moved to the next row\n      if (cellStartRow >= anchorStartRow && cellStartRow + cell.__rowSpan - 1 > focusEndRow) {\n        cell.setRowSpan(cell.__rowSpan - (focusEndRow - cellStartRow + 1));\n        if (!(nextRowNode !== null)) {\n          formatDevErrorMessage(`Expected nextRowNode not to be null`);\n        }\n        let insertAfterCell = null;\n        for (let columnIndex = 0; columnIndex < column; columnIndex++) {\n          const currentCellMap = nextRow[columnIndex];\n          const currentCell = currentCellMap.cell;\n          // Checking the cell having startRow as same as nextRow\n          if (currentCellMap.startRow === row + 1) {\n            insertAfterCell = currentCell;\n          }\n          if (currentCell.__colSpan > 1) {\n            columnIndex += currentCell.__colSpan - 1;\n          }\n        }\n        if (insertAfterCell === null) {\n          $insertFirst(nextRowNode, cell);\n        } else {\n          insertAfterCell.insertAfter(cell);\n        }\n      }\n    }\n    const rowNode = grid.getChildAtIndex(row);\n    if (!$isTableRowNode(rowNode)) {\n      formatDevErrorMessage(`Expected TableNode childAtIndex(${String(row)}) to be RowNode`);\n    }\n    rowNode.remove();\n  }\n  if (nextRow !== undefined) {\n    const {\n      cell\n    } = nextRow[0];\n    $moveSelectionToCell(cell);\n  } else {\n    const previousRow = gridMap[anchorStartRow - 1];\n    const {\n      cell\n    } = previousRow[0];\n    $moveSelectionToCell(cell);\n  }\n}\nfunction $deleteTableColumn__EXPERIMENTAL() {\n  const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n  if (!((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection) || $isTableSelection(selection))) {\n    formatDevErrorMessage(`Expected a RangeSelection or TableSelection`);\n  }\n  const anchor = selection.anchor.getNode();\n  const focus = selection.focus.getNode();\n  const [anchorCell,, grid] = $getNodeTriplet(anchor);\n  const [focusCell] = $getNodeTriplet(focus);\n  const [gridMap, anchorCellMap, focusCellMap] = $computeTableMap(grid, anchorCell, focusCell);\n  const {\n    startColumn: anchorStartColumn\n  } = anchorCellMap;\n  const {\n    startRow: focusStartRow,\n    startColumn: focusStartColumn\n  } = focusCellMap;\n  const startColumn = Math.min(anchorStartColumn, focusStartColumn);\n  const endColumn = Math.max(anchorStartColumn + anchorCell.__colSpan - 1, focusStartColumn + focusCell.__colSpan - 1);\n  const selectedColumnCount = endColumn - startColumn + 1;\n  const columnCount = gridMap[0].length;\n  if (columnCount === endColumn - startColumn + 1) {\n    // Empty grid\n    grid.selectPrevious();\n    grid.remove();\n    return;\n  }\n  const rowCount = gridMap.length;\n  for (let row = 0; row < rowCount; row++) {\n    for (let column = startColumn; column <= endColumn; column++) {\n      const {\n        cell,\n        startColumn: cellStartColumn\n      } = gridMap[row][column];\n      if (cellStartColumn < startColumn) {\n        if (column === startColumn) {\n          const overflowLeft = startColumn - cellStartColumn;\n          // Overflowing left\n          cell.setColSpan(cell.__colSpan -\n          // Possible overflow right too\n          Math.min(selectedColumnCount, cell.__colSpan - overflowLeft));\n        }\n      } else if (cellStartColumn + cell.__colSpan - 1 > endColumn) {\n        if (column === endColumn) {\n          // Overflowing right\n          const inSelectedArea = endColumn - cellStartColumn + 1;\n          cell.setColSpan(cell.__colSpan - inSelectedArea);\n        }\n      } else {\n        cell.remove();\n      }\n    }\n  }\n  const focusRowMap = gridMap[focusStartRow];\n  const nextColumn = anchorStartColumn > focusStartColumn ? focusRowMap[anchorStartColumn + anchorCell.__colSpan] : focusRowMap[focusStartColumn + focusCell.__colSpan];\n  if (nextColumn !== undefined) {\n    const {\n      cell\n    } = nextColumn;\n    $moveSelectionToCell(cell);\n  } else {\n    const previousRow = focusStartColumn < anchorStartColumn ? focusRowMap[focusStartColumn - 1] : focusRowMap[anchorStartColumn - 1];\n    const {\n      cell\n    } = previousRow;\n    $moveSelectionToCell(cell);\n  }\n  const colWidths = grid.getColWidths();\n  if (colWidths) {\n    const newColWidths = [...colWidths];\n    newColWidths.splice(startColumn, selectedColumnCount);\n    grid.setColWidths(newColWidths);\n  }\n}\nfunction $moveSelectionToCell(cell) {\n  const firstDescendant = cell.getFirstDescendant();\n  if (firstDescendant == null) {\n    cell.selectStart();\n  } else {\n    firstDescendant.getParentOrThrow().selectStart();\n  }\n}\nfunction $insertFirst(parent, node) {\n  const firstChild = parent.getFirstChild();\n  if (firstChild !== null) {\n    firstChild.insertBefore(node);\n  } else {\n    parent.append(node);\n  }\n}\nfunction $unmergeCell() {\n  const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n  if (!((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection) || $isTableSelection(selection))) {\n    formatDevErrorMessage(`Expected a RangeSelection or TableSelection`);\n  }\n  const anchor = selection.anchor.getNode();\n  const [cell, row, grid] = $getNodeTriplet(anchor);\n  const colSpan = cell.__colSpan;\n  const rowSpan = cell.__rowSpan;\n  if (colSpan === 1 && rowSpan === 1) {\n    return;\n  }\n  const [map, cellMap] = $computeTableMap(grid, cell, cell);\n  const {\n    startColumn,\n    startRow\n  } = cellMap;\n  // Create a heuristic for what the style of the unmerged cells should be\n  // based on whether every row or column already had that state before the\n  // unmerge.\n  const baseColStyle = cell.__headerState & TableCellHeaderStates.COLUMN;\n  const colStyles = Array.from({\n    length: colSpan\n  }, (_v, i) => {\n    let colStyle = baseColStyle;\n    for (let rowIdx = 0; colStyle !== 0 && rowIdx < map.length; rowIdx++) {\n      colStyle &= map[rowIdx][i + startColumn].cell.__headerState;\n    }\n    return colStyle;\n  });\n  const baseRowStyle = cell.__headerState & TableCellHeaderStates.ROW;\n  const rowStyles = Array.from({\n    length: rowSpan\n  }, (_v, i) => {\n    let rowStyle = baseRowStyle;\n    for (let colIdx = 0; rowStyle !== 0 && colIdx < map[0].length; colIdx++) {\n      rowStyle &= map[i + startRow][colIdx].cell.__headerState;\n    }\n    return rowStyle;\n  });\n  if (colSpan > 1) {\n    for (let i = 1; i < colSpan; i++) {\n      cell.insertAfter($createTableCellNode(colStyles[i] | rowStyles[0]).append((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)()));\n    }\n    cell.setColSpan(1);\n  }\n  if (rowSpan > 1) {\n    let currentRowNode;\n    for (let i = 1; i < rowSpan; i++) {\n      const currentRow = startRow + i;\n      const currentRowMap = map[currentRow];\n      currentRowNode = (currentRowNode || row).getNextSibling();\n      if (!$isTableRowNode(currentRowNode)) {\n        formatDevErrorMessage(`Expected row next sibling to be a row`);\n      }\n      let insertAfterCell = null;\n      for (let column = 0; column < startColumn; column++) {\n        const currentCellMap = currentRowMap[column];\n        const currentCell = currentCellMap.cell;\n        if (currentCellMap.startRow === currentRow) {\n          insertAfterCell = currentCell;\n        }\n        if (currentCell.__colSpan > 1) {\n          column += currentCell.__colSpan - 1;\n        }\n      }\n      if (insertAfterCell === null) {\n        for (let j = colSpan - 1; j >= 0; j--) {\n          $insertFirst(currentRowNode, $createTableCellNode(colStyles[j] | rowStyles[i]).append((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)()));\n        }\n      } else {\n        for (let j = colSpan - 1; j >= 0; j--) {\n          insertAfterCell.insertAfter($createTableCellNode(colStyles[j] | rowStyles[i]).append((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)()));\n        }\n      }\n    }\n    cell.setRowSpan(1);\n  }\n}\nfunction $computeTableMap(tableNode, cellA, cellB) {\n  const [tableMap, cellAValue, cellBValue] = $computeTableMapSkipCellCheck(tableNode, cellA, cellB);\n  if (!(cellAValue !== null)) {\n    formatDevErrorMessage(`Anchor not found in Table`);\n  }\n  if (!(cellBValue !== null)) {\n    formatDevErrorMessage(`Focus not found in Table`);\n  }\n  return [tableMap, cellAValue, cellBValue];\n}\nfunction $computeTableMapSkipCellCheck(tableNode, cellA, cellB) {\n  const tableMap = [];\n  let cellAValue = null;\n  let cellBValue = null;\n  function getMapRow(i) {\n    let row = tableMap[i];\n    if (row === undefined) {\n      tableMap[i] = row = [];\n    }\n    return row;\n  }\n  const gridChildren = tableNode.getChildren();\n  for (let rowIdx = 0; rowIdx < gridChildren.length; rowIdx++) {\n    const row = gridChildren[rowIdx];\n    if (!$isTableRowNode(row)) {\n      formatDevErrorMessage(`Expected TableNode children to be TableRowNode`);\n    }\n    const startMapRow = getMapRow(rowIdx);\n    for (let cell = row.getFirstChild(), colIdx = 0; cell != null; cell = cell.getNextSibling()) {\n      if (!$isTableCellNode(cell)) {\n        formatDevErrorMessage(`Expected TableRowNode children to be TableCellNode`);\n      } // Skip past any columns that were merged from a higher row\n      while (startMapRow[colIdx] !== undefined) {\n        colIdx++;\n      }\n      const value = {\n        cell,\n        startColumn: colIdx,\n        startRow: rowIdx\n      };\n      const {\n        __rowSpan: rowSpan,\n        __colSpan: colSpan\n      } = cell;\n      for (let j = 0; j < rowSpan; j++) {\n        if (rowIdx + j >= gridChildren.length) {\n          // The table is non-rectangular with a rowSpan\n          // below the last <tr> in the table.\n          // We should probably handle this with a node transform\n          // to ensure that tables are always rectangular but this\n          // will avoid crashes such as #6584\n          // Note that there are probably still latent bugs\n          // regarding colSpan or general cell count mismatches.\n          break;\n        }\n        const mapRow = getMapRow(rowIdx + j);\n        for (let i = 0; i < colSpan; i++) {\n          mapRow[colIdx + i] = value;\n        }\n      }\n      if (cellA !== null && cellAValue === null && cellA.is(cell)) {\n        cellAValue = value;\n      }\n      if (cellB !== null && cellBValue === null && cellB.is(cell)) {\n        cellBValue = value;\n      }\n    }\n  }\n  return [tableMap, cellAValue, cellBValue];\n}\nfunction $getNodeTriplet(source) {\n  let cell;\n  if (source instanceof TableCellNode) {\n    cell = source;\n  } else if ('__type' in source) {\n    const cell_ = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(source, $isTableCellNode);\n    if (!$isTableCellNode(cell_)) {\n      formatDevErrorMessage(`Expected to find a parent TableCellNode`);\n    }\n    cell = cell_;\n  } else {\n    const cell_ = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(source.getNode(), $isTableCellNode);\n    if (!$isTableCellNode(cell_)) {\n      formatDevErrorMessage(`Expected to find a parent TableCellNode`);\n    }\n    cell = cell_;\n  }\n  const row = cell.getParent();\n  if (!$isTableRowNode(row)) {\n    formatDevErrorMessage(`Expected TableCellNode to have a parent TableRowNode`);\n  }\n  const grid = row.getParent();\n  if (!$isTableNode(grid)) {\n    formatDevErrorMessage(`Expected TableRowNode to have a parent TableNode`);\n  }\n  return [cell, row, grid];\n}\nfunction $computeTableCellRectSpans(map, boundary) {\n  const {\n    minColumn,\n    maxColumn,\n    minRow,\n    maxRow\n  } = boundary;\n  let topSpan = 1;\n  let leftSpan = 1;\n  let rightSpan = 1;\n  let bottomSpan = 1;\n  const topRow = map[minRow];\n  const bottomRow = map[maxRow];\n  for (let col = minColumn; col <= maxColumn; col++) {\n    topSpan = Math.max(topSpan, topRow[col].cell.__rowSpan);\n    bottomSpan = Math.max(bottomSpan, bottomRow[col].cell.__rowSpan);\n  }\n  for (let row = minRow; row <= maxRow; row++) {\n    leftSpan = Math.max(leftSpan, map[row][minColumn].cell.__colSpan);\n    rightSpan = Math.max(rightSpan, map[row][maxColumn].cell.__colSpan);\n  }\n  return {\n    bottomSpan,\n    leftSpan,\n    rightSpan,\n    topSpan\n  };\n}\nfunction $computeTableCellRectBoundary(map, cellAMap, cellBMap) {\n  // Initial boundaries based on the anchor and focus cells\n  let minColumn = Math.min(cellAMap.startColumn, cellBMap.startColumn);\n  let minRow = Math.min(cellAMap.startRow, cellBMap.startRow);\n  let maxColumn = Math.max(cellAMap.startColumn + cellAMap.cell.__colSpan - 1, cellBMap.startColumn + cellBMap.cell.__colSpan - 1);\n  let maxRow = Math.max(cellAMap.startRow + cellAMap.cell.__rowSpan - 1, cellBMap.startRow + cellBMap.cell.__rowSpan - 1);\n\n  // Keep expanding until we have a complete rectangle\n  let hasChanges;\n  do {\n    hasChanges = false;\n\n    // Check all cells in the table\n    for (let row = 0; row < map.length; row++) {\n      for (let col = 0; col < map[0].length; col++) {\n        const cell = map[row][col];\n        if (!cell) {\n          continue;\n        }\n        const cellEndCol = cell.startColumn + cell.cell.__colSpan - 1;\n        const cellEndRow = cell.startRow + cell.cell.__rowSpan - 1;\n\n        // Check if this cell intersects with our current selection rectangle\n        const intersectsHorizontally = cell.startColumn <= maxColumn && cellEndCol >= minColumn;\n        const intersectsVertically = cell.startRow <= maxRow && cellEndRow >= minRow;\n\n        // If the cell intersects either horizontally or vertically\n        if (intersectsHorizontally && intersectsVertically) {\n          // Expand boundaries to include this cell completely\n          const newMinColumn = Math.min(minColumn, cell.startColumn);\n          const newMaxColumn = Math.max(maxColumn, cellEndCol);\n          const newMinRow = Math.min(minRow, cell.startRow);\n          const newMaxRow = Math.max(maxRow, cellEndRow);\n\n          // Check if boundaries changed\n          if (newMinColumn !== minColumn || newMaxColumn !== maxColumn || newMinRow !== minRow || newMaxRow !== maxRow) {\n            minColumn = newMinColumn;\n            maxColumn = newMaxColumn;\n            minRow = newMinRow;\n            maxRow = newMaxRow;\n            hasChanges = true;\n          }\n        }\n      }\n    }\n  } while (hasChanges);\n  return {\n    maxColumn,\n    maxRow,\n    minColumn,\n    minRow\n  };\n}\nfunction $getTableCellNodeRect(tableCellNode) {\n  const [cellNode,, gridNode] = $getNodeTriplet(tableCellNode);\n  const rows = gridNode.getChildren();\n  const rowCount = rows.length;\n  const columnCount = rows[0].getChildren().length;\n\n  // Create a matrix of the same size as the table to track the position of each cell\n  const cellMatrix = new Array(rowCount);\n  for (let i = 0; i < rowCount; i++) {\n    cellMatrix[i] = new Array(columnCount);\n  }\n  for (let rowIndex = 0; rowIndex < rowCount; rowIndex++) {\n    const row = rows[rowIndex];\n    const cells = row.getChildren();\n    let columnIndex = 0;\n    for (let cellIndex = 0; cellIndex < cells.length; cellIndex++) {\n      // Find the next available position in the matrix, skip the position of merged cells\n      while (cellMatrix[rowIndex][columnIndex]) {\n        columnIndex++;\n      }\n      const cell = cells[cellIndex];\n      const rowSpan = cell.__rowSpan || 1;\n      const colSpan = cell.__colSpan || 1;\n\n      // Put the cell into the corresponding position in the matrix\n      for (let i = 0; i < rowSpan; i++) {\n        for (let j = 0; j < colSpan; j++) {\n          cellMatrix[rowIndex + i][columnIndex + j] = cell;\n        }\n      }\n\n      // Return to the original index, row span and column span of the cell.\n      if (cellNode === cell) {\n        return {\n          colSpan,\n          columnIndex,\n          rowIndex,\n          rowSpan\n        };\n      }\n      columnIndex += colSpan;\n    }\n  }\n  return null;\n}\n\nfunction $getCellNodes(tableSelection) {\n  const [[anchorNode, anchorCell, anchorRow, anchorTable], [focusNode, focusCell, focusRow, focusTable]] = ['anchor', 'focus'].map(k => {\n    const node = tableSelection[k].getNode();\n    const cellNode = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(node, $isTableCellNode);\n    if (!$isTableCellNode(cellNode)) {\n      formatDevErrorMessage(`Expected TableSelection ${k} to be (or a child of) TableCellNode, got key ${node.getKey()} of type ${node.getType()}`);\n    }\n    const rowNode = cellNode.getParent();\n    if (!$isTableRowNode(rowNode)) {\n      formatDevErrorMessage(`Expected TableSelection ${k} cell parent to be a TableRowNode`);\n    }\n    const tableNode = rowNode.getParent();\n    if (!$isTableNode(tableNode)) {\n      formatDevErrorMessage(`Expected TableSelection ${k} row parent to be a TableNode`);\n    }\n    return [node, cellNode, rowNode, tableNode];\n  });\n  // TODO: nested tables may violate this\n  if (!anchorTable.is(focusTable)) {\n    formatDevErrorMessage(`Expected TableSelection anchor and focus to be in the same table`);\n  }\n  return {\n    anchorCell,\n    anchorNode,\n    anchorRow,\n    anchorTable,\n    focusCell,\n    focusNode,\n    focusRow,\n    focusTable\n  };\n}\nclass TableSelection {\n  constructor(tableKey, anchor, focus) {\n    this.anchor = anchor;\n    this.focus = focus;\n    anchor._selection = this;\n    focus._selection = this;\n    this._cachedNodes = null;\n    this.dirty = false;\n    this.tableKey = tableKey;\n  }\n  getStartEndPoints() {\n    return [this.anchor, this.focus];\n  }\n\n  /**\n   * {@link $createTableSelection} unfortunately makes it very easy to create\n   * nonsense selections, so we have a method to see if the selection probably\n   * makes sense.\n   *\n   * @returns true if the TableSelection is (probably) valid\n   */\n  isValid() {\n    return this.tableKey !== 'root' && this.anchor.key !== 'root' && this.anchor.type === 'element' && this.focus.key !== 'root' && this.focus.type === 'element';\n  }\n\n  /**\n   * Returns whether the Selection is \"backwards\", meaning the focus\n   * logically precedes the anchor in the EditorState.\n   * @returns true if the Selection is backwards, false otherwise.\n   */\n  isBackward() {\n    return this.focus.isBefore(this.anchor);\n  }\n  getCachedNodes() {\n    return this._cachedNodes;\n  }\n  setCachedNodes(nodes) {\n    this._cachedNodes = nodes;\n  }\n  is(selection) {\n    return $isTableSelection(selection) && this.tableKey === selection.tableKey && this.anchor.is(selection.anchor) && this.focus.is(selection.focus);\n  }\n  set(tableKey, anchorCellKey, focusCellKey) {\n    // note: closure compiler's acorn does not support ||=\n    this.dirty = this.dirty || tableKey !== this.tableKey || anchorCellKey !== this.anchor.key || focusCellKey !== this.focus.key;\n    this.tableKey = tableKey;\n    this.anchor.key = anchorCellKey;\n    this.focus.key = focusCellKey;\n    this._cachedNodes = null;\n  }\n  clone() {\n    return new TableSelection(this.tableKey, (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createPoint)(this.anchor.key, this.anchor.offset, this.anchor.type), (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createPoint)(this.focus.key, this.focus.offset, this.focus.type));\n  }\n  isCollapsed() {\n    return false;\n  }\n  extract() {\n    return this.getNodes();\n  }\n  insertRawText(text) {\n    // Do nothing?\n  }\n  insertText() {\n    // Do nothing?\n  }\n\n  /**\n   * Returns whether the provided TextFormatType is present on the Selection.\n   * This will be true if any paragraph in table cells has the specified format.\n   *\n   * @param type the TextFormatType to check for.\n   * @returns true if the provided format is currently toggled on on the Selection, false otherwise.\n   */\n  hasFormat(type) {\n    let format = 0;\n    const cellNodes = this.getNodes().filter($isTableCellNode);\n    cellNodes.forEach(cellNode => {\n      const paragraph = cellNode.getFirstChild();\n      if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isParagraphNode)(paragraph)) {\n        format |= paragraph.getTextFormat();\n      }\n    });\n    const formatFlag = lexical__WEBPACK_IMPORTED_MODULE_0__.TEXT_TYPE_TO_FORMAT[type];\n    return (format & formatFlag) !== 0;\n  }\n  insertNodes(nodes) {\n    const focusNode = this.focus.getNode();\n    if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(focusNode)) {\n      formatDevErrorMessage(`Expected TableSelection focus to be an ElementNode`);\n    }\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$normalizeSelection__EXPERIMENTAL)(focusNode.select(0, focusNode.getChildrenSize()));\n    selection.insertNodes(nodes);\n  }\n\n  // TODO Deprecate this method. It's confusing when used with colspan|rowspan\n  getShape() {\n    const {\n      anchorCell,\n      focusCell\n    } = $getCellNodes(this);\n    const anchorCellNodeRect = $getTableCellNodeRect(anchorCell);\n    if (!(anchorCellNodeRect !== null)) {\n      formatDevErrorMessage(`getCellRect: expected to find AnchorNode`);\n    }\n    const focusCellNodeRect = $getTableCellNodeRect(focusCell);\n    if (!(focusCellNodeRect !== null)) {\n      formatDevErrorMessage(`getCellRect: expected to find focusCellNode`);\n    }\n    const startX = Math.min(anchorCellNodeRect.columnIndex, focusCellNodeRect.columnIndex);\n    const stopX = Math.max(anchorCellNodeRect.columnIndex + anchorCellNodeRect.colSpan - 1, focusCellNodeRect.columnIndex + focusCellNodeRect.colSpan - 1);\n    const startY = Math.min(anchorCellNodeRect.rowIndex, focusCellNodeRect.rowIndex);\n    const stopY = Math.max(anchorCellNodeRect.rowIndex + anchorCellNodeRect.rowSpan - 1, focusCellNodeRect.rowIndex + focusCellNodeRect.rowSpan - 1);\n    return {\n      fromX: Math.min(startX, stopX),\n      fromY: Math.min(startY, stopY),\n      toX: Math.max(startX, stopX),\n      toY: Math.max(startY, stopY)\n    };\n  }\n  getNodes() {\n    if (!this.isValid()) {\n      return [];\n    }\n    const cachedNodes = this._cachedNodes;\n    if (cachedNodes !== null) {\n      return cachedNodes;\n    }\n    const {\n      anchorTable: tableNode,\n      anchorCell,\n      focusCell\n    } = $getCellNodes(this);\n    const focusCellGrid = focusCell.getParents()[1];\n    if (focusCellGrid !== tableNode) {\n      if (!tableNode.isParentOf(focusCell)) {\n        // focus is on higher Grid level than anchor\n        const gridParent = tableNode.getParent();\n        if (!(gridParent != null)) {\n          formatDevErrorMessage(`Expected gridParent to have a parent`);\n        }\n        this.set(this.tableKey, gridParent.getKey(), focusCell.getKey());\n      } else {\n        // anchor is on higher Grid level than focus\n        const focusCellParent = focusCellGrid.getParent();\n        if (!(focusCellParent != null)) {\n          formatDevErrorMessage(`Expected focusCellParent to have a parent`);\n        }\n        this.set(this.tableKey, focusCell.getKey(), focusCellParent.getKey());\n      }\n      return this.getNodes();\n    }\n\n    // TODO Mapping the whole Grid every time not efficient. We need to compute the entire state only\n    // once (on load) and iterate on it as updates occur. However, to do this we need to have the\n    // ability to store a state. Killing TableSelection and moving the logic to the plugin would make\n    // this possible.\n    const [map, cellAMap, cellBMap] = $computeTableMap(tableNode, anchorCell, focusCell);\n    const {\n      minColumn,\n      maxColumn,\n      minRow,\n      maxRow\n    } = $computeTableCellRectBoundary(map, cellAMap, cellBMap);\n\n    // We use a Map here because merged cells in the grid would otherwise\n    // show up multiple times in the nodes array\n    const nodeMap = new Map([[tableNode.getKey(), tableNode]]);\n    let lastRow = null;\n    for (let i = minRow; i <= maxRow; i++) {\n      for (let j = minColumn; j <= maxColumn; j++) {\n        const {\n          cell\n        } = map[i][j];\n        const currentRow = cell.getParent();\n        if (!$isTableRowNode(currentRow)) {\n          formatDevErrorMessage(`Expected TableCellNode parent to be a TableRowNode`);\n        }\n        if (currentRow !== lastRow) {\n          nodeMap.set(currentRow.getKey(), currentRow);\n          lastRow = currentRow;\n        }\n        if (!nodeMap.has(cell.getKey())) {\n          $visitRecursively(cell, childNode => {\n            nodeMap.set(childNode.getKey(), childNode);\n          });\n        }\n      }\n    }\n    const nodes = Array.from(nodeMap.values());\n    if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.isCurrentlyReadOnlyMode)()) {\n      this._cachedNodes = nodes;\n    }\n    return nodes;\n  }\n  getTextContent() {\n    const nodes = this.getNodes().filter(node => $isTableCellNode(node));\n    let textContent = '';\n    for (let i = 0; i < nodes.length; i++) {\n      const node = nodes[i];\n      const row = node.__parent;\n      const nextRow = (nodes[i + 1] || {}).__parent;\n      textContent += node.getTextContent() + (nextRow !== row ? '\\n' : '\\t');\n    }\n    return textContent;\n  }\n}\nfunction $isTableSelection(x) {\n  return x instanceof TableSelection;\n}\nfunction $createTableSelection() {\n  // TODO this is a suboptimal design, it doesn't make sense to have\n  // a table selection that isn't associated with a table. This\n  // constructor should have required argumnets and in true we\n  // should check that they point to a table and are element points to\n  // cell nodes of that table.\n  const anchor = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createPoint)('root', 0, 'element');\n  const focus = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createPoint)('root', 0, 'element');\n  return new TableSelection('root', anchor, focus);\n}\nfunction $createTableSelectionFrom(tableNode, anchorCell, focusCell) {\n  const tableNodeKey = tableNode.getKey();\n  const anchorCellKey = anchorCell.getKey();\n  const focusCellKey = focusCell.getKey();\n  {\n    if (!tableNode.isAttached()) {\n      formatDevErrorMessage(`$createTableSelectionFrom: tableNode ${tableNodeKey} is not attached`);\n    }\n    if (!tableNode.is($findTableNode(anchorCell))) {\n      formatDevErrorMessage(`$createTableSelectionFrom: anchorCell ${anchorCellKey} is not in table ${tableNodeKey}`);\n    }\n    if (!tableNode.is($findTableNode(focusCell))) {\n      formatDevErrorMessage(`$createTableSelectionFrom: focusCell ${focusCellKey} is not in table ${tableNodeKey}`);\n    } // TODO: Check for rectangular grid\n  }\n  const prevSelection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n  const nextSelection = $isTableSelection(prevSelection) ? prevSelection.clone() : $createTableSelection();\n  nextSelection.set(tableNode.getKey(), anchorCell.getKey(), focusCell.getKey());\n  return nextSelection;\n}\n\n/**\n * Depth first visitor\n * @param node The starting node\n * @param $visit The function to call for each node. If the function returns false, then children of this node will not be explored\n */\nfunction $visitRecursively(node, $visit) {\n  const stack = [[node]];\n  for (let currentArray = stack.at(-1); currentArray !== undefined && stack.length > 0; currentArray = stack.at(-1)) {\n    const currentNode = currentArray.pop();\n    if (currentNode === undefined) {\n      stack.pop();\n    } else if ($visit(currentNode) !== false && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(currentNode)) {\n      stack.push(currentNode.getChildren());\n    }\n  }\n}\n\nfunction $getTableAndElementByKey(tableNodeKey, editor = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getEditor)()) {\n  const tableNode = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getNodeByKey)(tableNodeKey);\n  if (!$isTableNode(tableNode)) {\n    formatDevErrorMessage(`TableObserver: Expected tableNodeKey ${tableNodeKey} to be a TableNode`);\n  }\n  const tableElement = getTableElement(tableNode, editor.getElementByKey(tableNodeKey));\n  if (!(tableElement !== null)) {\n    formatDevErrorMessage(`TableObserver: Expected to find TableElement in DOM for key ${tableNodeKey}`);\n  }\n  return {\n    tableElement,\n    tableNode\n  };\n}\nclass TableObserver {\n  constructor(editor, tableNodeKey) {\n    this.isHighlightingCells = false;\n    this.anchorX = -1;\n    this.anchorY = -1;\n    this.focusX = -1;\n    this.focusY = -1;\n    this.listenersToRemove = new Set();\n    this.tableNodeKey = tableNodeKey;\n    this.editor = editor;\n    this.table = {\n      columns: 0,\n      domRows: [],\n      rows: 0\n    };\n    this.tableSelection = null;\n    this.anchorCellNodeKey = null;\n    this.focusCellNodeKey = null;\n    this.anchorCell = null;\n    this.focusCell = null;\n    this.hasHijackedSelectionStyles = false;\n    this.isSelecting = false;\n    this.pointerType = null;\n    this.shouldCheckSelection = false;\n    this.abortController = new AbortController();\n    this.listenerOptions = {\n      signal: this.abortController.signal\n    };\n    this.nextFocus = null;\n    this.trackTable();\n  }\n  getTable() {\n    return this.table;\n  }\n  removeListeners() {\n    this.abortController.abort('removeListeners');\n    Array.from(this.listenersToRemove).forEach(removeListener => removeListener());\n    this.listenersToRemove.clear();\n  }\n  $lookup() {\n    return $getTableAndElementByKey(this.tableNodeKey, this.editor);\n  }\n  trackTable() {\n    const observer = new MutationObserver(records => {\n      this.editor.getEditorState().read(() => {\n        let gridNeedsRedraw = false;\n        for (let i = 0; i < records.length; i++) {\n          const record = records[i];\n          const target = record.target;\n          const nodeName = target.nodeName;\n          if (nodeName === 'TABLE' || nodeName === 'TBODY' || nodeName === 'THEAD' || nodeName === 'TR') {\n            gridNeedsRedraw = true;\n            break;\n          }\n        }\n        if (!gridNeedsRedraw) {\n          return;\n        }\n        const {\n          tableNode,\n          tableElement\n        } = this.$lookup();\n        this.table = getTable(tableNode, tableElement);\n      }, {\n        editor: this.editor\n      });\n    });\n    this.editor.getEditorState().read(() => {\n      const {\n        tableNode,\n        tableElement\n      } = this.$lookup();\n      this.table = getTable(tableNode, tableElement);\n      observer.observe(tableElement, {\n        attributes: true,\n        childList: true,\n        subtree: true\n      });\n    }, {\n      editor: this.editor\n    });\n  }\n  $clearHighlight() {\n    const editor = this.editor;\n    this.isHighlightingCells = false;\n    this.anchorX = -1;\n    this.anchorY = -1;\n    this.focusX = -1;\n    this.focusY = -1;\n    this.tableSelection = null;\n    this.anchorCellNodeKey = null;\n    this.focusCellNodeKey = null;\n    this.anchorCell = null;\n    this.focusCell = null;\n    this.hasHijackedSelectionStyles = false;\n    this.$enableHighlightStyle();\n    const {\n      tableNode,\n      tableElement\n    } = this.$lookup();\n    const grid = getTable(tableNode, tableElement);\n    $updateDOMForSelection(editor, grid, null);\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)() !== null) {\n      (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$setSelection)(null);\n      editor.dispatchCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.SELECTION_CHANGE_COMMAND, undefined);\n    }\n  }\n  $enableHighlightStyle() {\n    const editor = this.editor;\n    const {\n      tableElement\n    } = this.$lookup();\n    (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.removeClassNamesFromElement)(tableElement, editor._config.theme.tableSelection);\n    tableElement.classList.remove('disable-selection');\n    this.hasHijackedSelectionStyles = false;\n  }\n  $disableHighlightStyle() {\n    const {\n      tableElement\n    } = this.$lookup();\n    (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.addClassNamesToElement)(tableElement, this.editor._config.theme.tableSelection);\n    this.hasHijackedSelectionStyles = true;\n  }\n  $updateTableTableSelection(selection) {\n    if (selection !== null) {\n      if (!(selection.tableKey === this.tableNodeKey)) {\n        formatDevErrorMessage(`TableObserver.$updateTableTableSelection: selection.tableKey !== this.tableNodeKey ('${selection.tableKey}' !== '${this.tableNodeKey}')`);\n      }\n      const editor = this.editor;\n      this.tableSelection = selection;\n      this.isHighlightingCells = true;\n      this.$disableHighlightStyle();\n      this.updateDOMSelection();\n      $updateDOMForSelection(editor, this.table, this.tableSelection);\n    } else {\n      this.$clearHighlight();\n    }\n  }\n\n  /**\n   * @internal\n   * Firefox has a strange behavior where pressing the down arrow key from\n   * above the table will move the caret after the table and then lexical\n   * will select the last cell instead of the first.\n   * We do still want to let the browser handle caret movement but we will\n   * use this property to \"tag\" the update so that we can recheck the\n   * selection after the event is processed.\n   */\n  setShouldCheckSelection() {\n    this.shouldCheckSelection = true;\n  }\n  /**\n   * @internal\n   */\n  getAndClearShouldCheckSelection() {\n    if (this.shouldCheckSelection) {\n      this.shouldCheckSelection = false;\n      return true;\n    }\n    return false;\n  }\n\n  /**\n   * @internal\n   * When handling mousemove events we track what the focus cell should be, but\n   * the DOM selection may end up somewhere else entirely. We don't have an elegant\n   * way to handle this after the DOM selection has been resolved in a\n   * SELECTION_CHANGE_COMMAND callback.\n   */\n  setNextFocus(nextFocus) {\n    this.nextFocus = nextFocus;\n  }\n\n  /** @internal */\n  getAndClearNextFocus() {\n    const {\n      nextFocus\n    } = this;\n    if (nextFocus !== null) {\n      this.nextFocus = null;\n    }\n    return nextFocus;\n  }\n\n  /** @internal */\n  updateDOMSelection() {\n    if (this.anchorCell !== null && this.focusCell !== null) {\n      const domSelection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.getDOMSelection)(this.editor._window);\n      // We are not using a native selection for tables, and if we\n      // set one then the reconciler will undo it.\n      // TODO - it would make sense to have one so that native\n      //        copy/paste worked. Right now we have to emulate with\n      //        keyboard events but it won't fire if trigged from the menu\n      if (domSelection && domSelection.rangeCount > 0) {\n        domSelection.removeAllRanges();\n      }\n    }\n  }\n  $setFocusCellForSelection(cell, ignoreStart = false) {\n    const editor = this.editor;\n    const {\n      tableNode\n    } = this.$lookup();\n    const cellX = cell.x;\n    const cellY = cell.y;\n    this.focusCell = cell;\n    if (!this.isHighlightingCells && (this.anchorX !== cellX || this.anchorY !== cellY || ignoreStart)) {\n      this.isHighlightingCells = true;\n      this.$disableHighlightStyle();\n    } else if (cellX === this.focusX && cellY === this.focusY) {\n      return false;\n    }\n    this.focusX = cellX;\n    this.focusY = cellY;\n    if (this.isHighlightingCells) {\n      const focusTableCellNode = $getNearestTableCellInTableFromDOMNode(tableNode, cell.elem);\n      if (this.tableSelection != null && this.anchorCellNodeKey != null && focusTableCellNode !== null) {\n        this.focusCellNodeKey = focusTableCellNode.getKey();\n        this.tableSelection = $createTableSelectionFrom(tableNode, this.$getAnchorTableCellOrThrow(), focusTableCellNode);\n        (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$setSelection)(this.tableSelection);\n        editor.dispatchCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.SELECTION_CHANGE_COMMAND, undefined);\n        $updateDOMForSelection(editor, this.table, this.tableSelection);\n        return true;\n      }\n    }\n    return false;\n  }\n  $getAnchorTableCell() {\n    return this.anchorCellNodeKey ? (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getNodeByKey)(this.anchorCellNodeKey) : null;\n  }\n  $getAnchorTableCellOrThrow() {\n    const anchorTableCell = this.$getAnchorTableCell();\n    if (!(anchorTableCell !== null)) {\n      formatDevErrorMessage(`TableObserver anchorTableCell is null`);\n    }\n    return anchorTableCell;\n  }\n  $getFocusTableCell() {\n    return this.focusCellNodeKey ? (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getNodeByKey)(this.focusCellNodeKey) : null;\n  }\n  $getFocusTableCellOrThrow() {\n    const focusTableCell = this.$getFocusTableCell();\n    if (!(focusTableCell !== null)) {\n      formatDevErrorMessage(`TableObserver focusTableCell is null`);\n    }\n    return focusTableCell;\n  }\n  $setAnchorCellForSelection(cell) {\n    this.isHighlightingCells = false;\n    this.anchorCell = cell;\n    this.anchorX = cell.x;\n    this.anchorY = cell.y;\n    const {\n      tableNode\n    } = this.$lookup();\n    const anchorTableCellNode = $getNearestTableCellInTableFromDOMNode(tableNode, cell.elem);\n    if (anchorTableCellNode !== null) {\n      const anchorNodeKey = anchorTableCellNode.getKey();\n      this.tableSelection = this.tableSelection != null ? this.tableSelection.clone() : $createTableSelection();\n      this.anchorCellNodeKey = anchorNodeKey;\n    }\n  }\n  $formatCells(type) {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (!$isTableSelection(selection)) {\n      formatDevErrorMessage(`Expected Table selection`);\n    }\n    const formatSelection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createRangeSelection)();\n    const anchor = formatSelection.anchor;\n    const focus = formatSelection.focus;\n    const cellNodes = selection.getNodes().filter($isTableCellNode);\n    if (!(cellNodes.length > 0)) {\n      formatDevErrorMessage(`No table cells present`);\n    }\n    const paragraph = cellNodes[0].getFirstChild();\n    const alignFormatWith = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isParagraphNode)(paragraph) ? paragraph.getFormatFlags(type, null) : null;\n    cellNodes.forEach(cellNode => {\n      anchor.set(cellNode.getKey(), 0, 'element');\n      focus.set(cellNode.getKey(), cellNode.getChildrenSize(), 'element');\n      formatSelection.formatText(type, alignFormatWith);\n    });\n    (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$setSelection)(selection);\n    this.editor.dispatchCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.SELECTION_CHANGE_COMMAND, undefined);\n  }\n  $clearText() {\n    const {\n      editor\n    } = this;\n    const tableNode = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getNodeByKey)(this.tableNodeKey);\n    if (!$isTableNode(tableNode)) {\n      throw new Error('Expected TableNode.');\n    }\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (!$isTableSelection(selection)) {\n      formatDevErrorMessage(`Expected TableSelection`);\n    }\n    const selectedNodes = selection.getNodes().filter($isTableCellNode);\n    if (selectedNodes.length === this.table.columns * this.table.rows) {\n      tableNode.selectPrevious();\n      const parent = tableNode.getParent();\n      // Delete entire table\n      tableNode.remove();\n      // Handle case when table was the only node\n      if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRootNode)(parent) && parent.isEmpty()) {\n        editor.dispatchCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.INSERT_PARAGRAPH_COMMAND, undefined);\n      }\n      return;\n    }\n    selectedNodes.forEach(cellNode => {\n      if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(cellNode)) {\n        const paragraphNode = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)();\n        const textNode = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createTextNode)();\n        paragraphNode.append(textNode);\n        cellNode.append(paragraphNode);\n        cellNode.getChildren().forEach(child => {\n          if (child !== paragraphNode) {\n            child.remove();\n          }\n        });\n      }\n    });\n    $updateDOMForSelection(editor, this.table, null);\n    (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$setSelection)(null);\n    editor.dispatchCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.SELECTION_CHANGE_COMMAND, undefined);\n  }\n}\n\nconst LEXICAL_ELEMENT_KEY = '__lexicalTableSelection';\nconst isPointerDownOnEvent = event => {\n  return (event.buttons & 1) === 1;\n};\nfunction isHTMLTableElement(el) {\n  return (0,lexical__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(el) && el.nodeName === 'TABLE';\n}\nfunction getTableElement(tableNode, dom) {\n  if (!dom) {\n    return dom;\n  }\n  const element = isHTMLTableElement(dom) ? dom : tableNode.getDOMSlot(dom).element;\n  if (!(element.nodeName === 'TABLE')) {\n    formatDevErrorMessage(`getTableElement: Expecting table in as DOM node for TableNode, not ${dom.nodeName}`);\n  }\n  return element;\n}\nfunction getEditorWindow(editor) {\n  return editor._window;\n}\nfunction $findParentTableCellNodeInTable(tableNode, node) {\n  for (let currentNode = node, lastTableCellNode = null; currentNode !== null; currentNode = currentNode.getParent()) {\n    if (tableNode.is(currentNode)) {\n      return lastTableCellNode;\n    } else if ($isTableCellNode(currentNode)) {\n      lastTableCellNode = currentNode;\n    }\n  }\n  return null;\n}\nconst ARROW_KEY_COMMANDS_WITH_DIRECTION = [[lexical__WEBPACK_IMPORTED_MODULE_0__.KEY_ARROW_DOWN_COMMAND, 'down'], [lexical__WEBPACK_IMPORTED_MODULE_0__.KEY_ARROW_UP_COMMAND, 'up'], [lexical__WEBPACK_IMPORTED_MODULE_0__.KEY_ARROW_LEFT_COMMAND, 'backward'], [lexical__WEBPACK_IMPORTED_MODULE_0__.KEY_ARROW_RIGHT_COMMAND, 'forward']];\nconst DELETE_TEXT_COMMANDS = [lexical__WEBPACK_IMPORTED_MODULE_0__.DELETE_WORD_COMMAND, lexical__WEBPACK_IMPORTED_MODULE_0__.DELETE_LINE_COMMAND, lexical__WEBPACK_IMPORTED_MODULE_0__.DELETE_CHARACTER_COMMAND];\nconst DELETE_KEY_COMMANDS = [lexical__WEBPACK_IMPORTED_MODULE_0__.KEY_BACKSPACE_COMMAND, lexical__WEBPACK_IMPORTED_MODULE_0__.KEY_DELETE_COMMAND];\nfunction applyTableHandlers(tableNode, element, editor, hasTabHandler) {\n  const rootElement = editor.getRootElement();\n  const editorWindow = getEditorWindow(editor);\n  if (!(rootElement !== null && editorWindow !== null)) {\n    formatDevErrorMessage(`applyTableHandlers: editor has no root element set`);\n  }\n  const tableObserver = new TableObserver(editor, tableNode.getKey());\n  const tableElement = getTableElement(tableNode, element);\n  attachTableObserverToTableElement(tableElement, tableObserver);\n  tableObserver.listenersToRemove.add(() => detatchTableObserverFromTableElement(tableElement, tableObserver));\n  const createPointerHandlers = () => {\n    if (tableObserver.isSelecting) {\n      return;\n    }\n    const onPointerUp = () => {\n      tableObserver.isSelecting = false;\n      editorWindow.removeEventListener('pointerup', onPointerUp);\n      editorWindow.removeEventListener('pointermove', onPointerMove);\n    };\n    const onPointerMove = moveEvent => {\n      if (!isPointerDownOnEvent(moveEvent) && tableObserver.isSelecting) {\n        tableObserver.isSelecting = false;\n        editorWindow.removeEventListener('pointerup', onPointerUp);\n        editorWindow.removeEventListener('pointermove', onPointerMove);\n        return;\n      }\n      if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.isDOMNode)(moveEvent.target)) {\n        return;\n      }\n      let focusCell = null;\n      // In firefox the moveEvent.target may be captured so we must always\n      // consult the coordinates #7245\n      const override = !(IS_FIREFOX || tableElement.contains(moveEvent.target));\n      if (override) {\n        focusCell = getDOMCellInTableFromTarget(tableElement, moveEvent.target);\n      } else {\n        for (const el of document.elementsFromPoint(moveEvent.clientX, moveEvent.clientY)) {\n          focusCell = getDOMCellInTableFromTarget(tableElement, el);\n          if (focusCell) {\n            break;\n          }\n        }\n      }\n      if (focusCell && (tableObserver.focusCell === null || focusCell.elem !== tableObserver.focusCell.elem)) {\n        tableObserver.setNextFocus({\n          focusCell,\n          override\n        });\n        editor.dispatchCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.SELECTION_CHANGE_COMMAND, undefined);\n      }\n    };\n    tableObserver.isSelecting = true;\n    editorWindow.addEventListener('pointerup', onPointerUp, tableObserver.listenerOptions);\n    editorWindow.addEventListener('pointermove', onPointerMove, tableObserver.listenerOptions);\n  };\n  const onPointerDown = event => {\n    tableObserver.pointerType = event.pointerType;\n    if (event.button !== 0 || !(0,lexical__WEBPACK_IMPORTED_MODULE_0__.isDOMNode)(event.target) || !editorWindow) {\n      return;\n    }\n    const targetCell = getDOMCellFromTarget(event.target);\n    if (targetCell !== null) {\n      editor.update(() => {\n        const prevSelection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getPreviousSelection)();\n        // We can't trust Firefox to do the right thing with the selection and\n        // we don't have a proper state machine to do this \"correctly\" but\n        // if we go ahead and make the table selection now it will work\n        if (IS_FIREFOX && event.shiftKey && $isSelectionInTable(prevSelection, tableNode) && ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(prevSelection) || $isTableSelection(prevSelection))) {\n          const prevAnchorNode = prevSelection.anchor.getNode();\n          const prevAnchorCell = $findParentTableCellNodeInTable(tableNode, prevSelection.anchor.getNode());\n          if (prevAnchorCell) {\n            tableObserver.$setAnchorCellForSelection($getObserverCellFromCellNodeOrThrow(tableObserver, prevAnchorCell));\n            tableObserver.$setFocusCellForSelection(targetCell);\n            stopEvent(event);\n          } else {\n            const newSelection = tableNode.isBefore(prevAnchorNode) ? tableNode.selectStart() : tableNode.selectEnd();\n            newSelection.anchor.set(prevSelection.anchor.key, prevSelection.anchor.offset, prevSelection.anchor.type);\n          }\n        } else {\n          tableObserver.$setAnchorCellForSelection(targetCell);\n        }\n      });\n    }\n    createPointerHandlers();\n  };\n  tableElement.addEventListener('pointerdown', onPointerDown, tableObserver.listenerOptions);\n  tableObserver.listenersToRemove.add(() => {\n    tableElement.removeEventListener('pointerdown', onPointerDown);\n  });\n  const onTripleClick = event => {\n    if (event.detail >= 3 && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.isDOMNode)(event.target)) {\n      const targetCell = getDOMCellFromTarget(event.target);\n      if (targetCell !== null) {\n        event.preventDefault();\n      }\n    }\n  };\n  tableElement.addEventListener('mousedown', onTripleClick, tableObserver.listenerOptions);\n  tableObserver.listenersToRemove.add(() => {\n    tableElement.removeEventListener('mousedown', onTripleClick);\n  });\n\n  // Clear selection when clicking outside of dom.\n  const pointerDownCallback = event => {\n    const target = event.target;\n    if (event.button !== 0 || !(0,lexical__WEBPACK_IMPORTED_MODULE_0__.isDOMNode)(target)) {\n      return;\n    }\n    editor.update(() => {\n      const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n      if ($isTableSelection(selection) && selection.tableKey === tableObserver.tableNodeKey && rootElement.contains(target)) {\n        tableObserver.$clearHighlight();\n      }\n    });\n  };\n  editorWindow.addEventListener('pointerdown', pointerDownCallback, tableObserver.listenerOptions);\n  tableObserver.listenersToRemove.add(() => {\n    editorWindow.removeEventListener('pointerdown', pointerDownCallback);\n  });\n  for (const [command, direction] of ARROW_KEY_COMMANDS_WITH_DIRECTION) {\n    tableObserver.listenersToRemove.add(editor.registerCommand(command, event => $handleArrowKey(editor, event, direction, tableNode, tableObserver), lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_HIGH));\n  }\n  tableObserver.listenersToRemove.add(editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.KEY_ESCAPE_COMMAND, event => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if ($isTableSelection(selection)) {\n      const focusCellNode = $findParentTableCellNodeInTable(tableNode, selection.focus.getNode());\n      if (focusCellNode !== null) {\n        stopEvent(event);\n        focusCellNode.selectEnd();\n        return true;\n      }\n    }\n    return false;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_HIGH));\n  const deleteTextHandler = command => () => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (!$isSelectionInTable(selection, tableNode)) {\n      return false;\n    }\n    if ($isTableSelection(selection)) {\n      tableObserver.$clearText();\n      return true;\n    } else if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      const tableCellNode = $findParentTableCellNodeInTable(tableNode, selection.anchor.getNode());\n      if (!$isTableCellNode(tableCellNode)) {\n        return false;\n      }\n      const anchorNode = selection.anchor.getNode();\n      const focusNode = selection.focus.getNode();\n      const isAnchorInside = tableNode.isParentOf(anchorNode);\n      const isFocusInside = tableNode.isParentOf(focusNode);\n      const selectionContainsPartialTable = isAnchorInside && !isFocusInside || isFocusInside && !isAnchorInside;\n      if (selectionContainsPartialTable) {\n        tableObserver.$clearText();\n        return true;\n      }\n      const nearestElementNode = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(selection.anchor.getNode(), n => (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(n));\n      const topLevelCellElementNode = nearestElementNode && (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(nearestElementNode, n => (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(n) && $isTableCellNode(n.getParent()));\n      if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(topLevelCellElementNode) || !(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(nearestElementNode)) {\n        return false;\n      }\n      if (command === lexical__WEBPACK_IMPORTED_MODULE_0__.DELETE_LINE_COMMAND && topLevelCellElementNode.getPreviousSibling() === null) {\n        // TODO: Fix Delete Line in Table Cells.\n        return true;\n      }\n    }\n    return false;\n  };\n  for (const command of DELETE_TEXT_COMMANDS) {\n    tableObserver.listenersToRemove.add(editor.registerCommand(command, deleteTextHandler(command), lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_CRITICAL));\n  }\n  const $deleteCellHandler = event => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (!($isTableSelection(selection) || (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection))) {\n      return false;\n    }\n\n    // If the selection is inside the table but should remove the whole table\n    // we expand the selection so that both the anchor and focus are outside\n    // the table and the editor's command listener will handle the delete\n    const isAnchorInside = tableNode.isParentOf(selection.anchor.getNode());\n    const isFocusInside = tableNode.isParentOf(selection.focus.getNode());\n    if (isAnchorInside !== isFocusInside) {\n      const tablePoint = isAnchorInside ? 'anchor' : 'focus';\n      const outerPoint = isAnchorInside ? 'focus' : 'anchor';\n      // Preserve the outer point\n      const {\n        key,\n        offset,\n        type\n      } = selection[outerPoint];\n      // Expand the selection around the table\n      const newSelection = tableNode[selection[tablePoint].isBefore(selection[outerPoint]) ? 'selectPrevious' : 'selectNext']();\n      // Restore the outer point of the selection\n      newSelection[outerPoint].set(key, offset, type);\n      // Let the base implementation handle the rest\n      return false;\n    }\n    if (!$isSelectionInTable(selection, tableNode)) {\n      return false;\n    }\n    if ($isTableSelection(selection)) {\n      if (event) {\n        event.preventDefault();\n        event.stopPropagation();\n      }\n      tableObserver.$clearText();\n      return true;\n    }\n    return false;\n  };\n  for (const command of DELETE_KEY_COMMANDS) {\n    tableObserver.listenersToRemove.add(editor.registerCommand(command, $deleteCellHandler, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_CRITICAL));\n  }\n  tableObserver.listenersToRemove.add(editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.CUT_COMMAND, event => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (selection) {\n      if (!($isTableSelection(selection) || (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection))) {\n        return false;\n      }\n      // Copying to the clipboard is async so we must capture the data\n      // before we delete it\n      void (0,_lexical_clipboard__WEBPACK_IMPORTED_MODULE_2__.copyToClipboard)(editor, (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.objectKlassEquals)(event, ClipboardEvent) ? event : null, (0,_lexical_clipboard__WEBPACK_IMPORTED_MODULE_2__.$getClipboardDataFromSelection)(selection));\n      const intercepted = $deleteCellHandler(event);\n      if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n        selection.removeText();\n        return true;\n      }\n      return intercepted;\n    }\n    return false;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_CRITICAL));\n  tableObserver.listenersToRemove.add(editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.FORMAT_TEXT_COMMAND, payload => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (!$isSelectionInTable(selection, tableNode)) {\n      return false;\n    }\n    if ($isTableSelection(selection)) {\n      tableObserver.$formatCells(payload);\n      return true;\n    } else if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      const tableCellNode = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(selection.anchor.getNode(), n => $isTableCellNode(n));\n      if (!$isTableCellNode(tableCellNode)) {\n        return false;\n      }\n    }\n    return false;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_CRITICAL));\n  tableObserver.listenersToRemove.add(editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.FORMAT_ELEMENT_COMMAND, formatType => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (!$isTableSelection(selection) || !$isSelectionInTable(selection, tableNode)) {\n      return false;\n    }\n    const anchorNode = selection.anchor.getNode();\n    const focusNode = selection.focus.getNode();\n    if (!$isTableCellNode(anchorNode) || !$isTableCellNode(focusNode)) {\n      return false;\n    }\n\n    // Align the table if the entire table is selected\n    if ($isFullTableSelection(selection, tableNode)) {\n      tableNode.setFormat(formatType);\n      return true;\n    }\n    const [tableMap, anchorCell, focusCell] = $computeTableMap(tableNode, anchorNode, focusNode);\n    const maxRow = Math.max(anchorCell.startRow + anchorCell.cell.__rowSpan - 1, focusCell.startRow + focusCell.cell.__rowSpan - 1);\n    const maxColumn = Math.max(anchorCell.startColumn + anchorCell.cell.__colSpan - 1, focusCell.startColumn + focusCell.cell.__colSpan - 1);\n    const minRow = Math.min(anchorCell.startRow, focusCell.startRow);\n    const minColumn = Math.min(anchorCell.startColumn, focusCell.startColumn);\n    const visited = new Set();\n    for (let i = minRow; i <= maxRow; i++) {\n      for (let j = minColumn; j <= maxColumn; j++) {\n        const cell = tableMap[i][j].cell;\n        if (visited.has(cell)) {\n          continue;\n        }\n        visited.add(cell);\n        cell.setFormat(formatType);\n        const cellChildren = cell.getChildren();\n        for (let k = 0; k < cellChildren.length; k++) {\n          const child = cellChildren[k];\n          if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(child) && !child.isInline()) {\n            child.setFormat(formatType);\n          }\n        }\n      }\n    }\n    return true;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_CRITICAL));\n  tableObserver.listenersToRemove.add(editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.CONTROLLED_TEXT_INSERTION_COMMAND, payload => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (!$isSelectionInTable(selection, tableNode)) {\n      return false;\n    }\n    if ($isTableSelection(selection)) {\n      tableObserver.$clearHighlight();\n      return false;\n    } else if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      const tableCellNode = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(selection.anchor.getNode(), n => $isTableCellNode(n));\n      if (!$isTableCellNode(tableCellNode)) {\n        return false;\n      }\n      if (typeof payload === 'string') {\n        const edgePosition = $getTableEdgeCursorPosition(editor, selection, tableNode);\n        if (edgePosition) {\n          $insertParagraphAtTableEdge(edgePosition, tableNode, [(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createTextNode)(payload)]);\n          return true;\n        }\n      }\n    }\n    return false;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_CRITICAL));\n  if (hasTabHandler) {\n    tableObserver.listenersToRemove.add(editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.KEY_TAB_COMMAND, event => {\n      const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n      if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection) || !selection.isCollapsed() || !$isSelectionInTable(selection, tableNode)) {\n        return false;\n      }\n      const tableCellNode = $findCellNode(selection.anchor.getNode());\n      if (tableCellNode === null || !tableNode.is($findTableNode(tableCellNode))) {\n        return false;\n      }\n      stopEvent(event);\n      $selectAdjacentCell(tableCellNode, event.shiftKey ? 'previous' : 'next');\n      return true;\n    }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_CRITICAL));\n  }\n  tableObserver.listenersToRemove.add(editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.FOCUS_COMMAND, payload => {\n    return tableNode.isSelected();\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_HIGH));\n  tableObserver.listenersToRemove.add(editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.SELECTION_INSERT_CLIPBOARD_NODES_COMMAND, selectionPayload => {\n    const {\n      nodes,\n      selection\n    } = selectionPayload;\n    const anchorAndFocus = selection.getStartEndPoints();\n    const isTableSelection = $isTableSelection(selection);\n    const isRangeSelection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection);\n    const isSelectionInsideOfGrid = isRangeSelection && (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(selection.anchor.getNode(), n => $isTableCellNode(n)) !== null && (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(selection.focus.getNode(), n => $isTableCellNode(n)) !== null || isTableSelection;\n    if (nodes.length !== 1 || !$isTableNode(nodes[0]) || !isSelectionInsideOfGrid || anchorAndFocus === null) {\n      return false;\n    }\n    const [anchor] = anchorAndFocus;\n    const newGrid = nodes[0];\n    const newGridRows = newGrid.getChildren();\n    const newColumnCount = newGrid.getFirstChildOrThrow().getChildrenSize();\n    const newRowCount = newGrid.getChildrenSize();\n    const gridCellNode = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(anchor.getNode(), n => $isTableCellNode(n));\n    const gridRowNode = gridCellNode && (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(gridCellNode, n => $isTableRowNode(n));\n    const gridNode = gridRowNode && (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(gridRowNode, n => $isTableNode(n));\n    if (!$isTableCellNode(gridCellNode) || !$isTableRowNode(gridRowNode) || !$isTableNode(gridNode)) {\n      return false;\n    }\n    const startY = gridRowNode.getIndexWithinParent();\n    const stopY = Math.min(gridNode.getChildrenSize() - 1, startY + newRowCount - 1);\n    const startX = gridCellNode.getIndexWithinParent();\n    const stopX = Math.min(gridRowNode.getChildrenSize() - 1, startX + newColumnCount - 1);\n    const fromX = Math.min(startX, stopX);\n    const fromY = Math.min(startY, stopY);\n    const toX = Math.max(startX, stopX);\n    const toY = Math.max(startY, stopY);\n    const gridRowNodes = gridNode.getChildren();\n    let newRowIdx = 0;\n    for (let r = fromY; r <= toY; r++) {\n      const currentGridRowNode = gridRowNodes[r];\n      if (!$isTableRowNode(currentGridRowNode)) {\n        return false;\n      }\n      const newGridRowNode = newGridRows[newRowIdx];\n      if (!$isTableRowNode(newGridRowNode)) {\n        return false;\n      }\n      const gridCellNodes = currentGridRowNode.getChildren();\n      const newGridCellNodes = newGridRowNode.getChildren();\n      let newColumnIdx = 0;\n      for (let c = fromX; c <= toX; c++) {\n        const currentGridCellNode = gridCellNodes[c];\n        if (!$isTableCellNode(currentGridCellNode)) {\n          return false;\n        }\n        const newGridCellNode = newGridCellNodes[newColumnIdx];\n        if (!$isTableCellNode(newGridCellNode)) {\n          return false;\n        }\n        const originalChildren = currentGridCellNode.getChildren();\n        newGridCellNode.getChildren().forEach(child => {\n          if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(child)) {\n            const paragraphNode = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)();\n            paragraphNode.append(child);\n            currentGridCellNode.append(child);\n          } else {\n            currentGridCellNode.append(child);\n          }\n        });\n        originalChildren.forEach(n => n.remove());\n        newColumnIdx++;\n      }\n      newRowIdx++;\n    }\n    return true;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_CRITICAL));\n  tableObserver.listenersToRemove.add(editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.SELECTION_CHANGE_COMMAND, () => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    const prevSelection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getPreviousSelection)();\n    const nextFocus = tableObserver.getAndClearNextFocus();\n    if (nextFocus !== null) {\n      const {\n        focusCell\n      } = nextFocus;\n      if ($isTableSelection(selection) && selection.tableKey === tableObserver.tableNodeKey) {\n        if (focusCell.x === tableObserver.focusX && focusCell.y === tableObserver.focusY) {\n          // The selection is already the correct table selection\n          return false;\n        } else {\n          tableObserver.$setFocusCellForSelection(focusCell);\n          return true;\n        }\n      } else if (focusCell !== tableObserver.anchorCell && $isSelectionInTable(selection, tableNode)) {\n        // The selection has crossed cells\n        tableObserver.$setFocusCellForSelection(focusCell);\n        return true;\n      }\n    }\n    const shouldCheckSelection = tableObserver.getAndClearShouldCheckSelection();\n    // If they pressed the down arrow with the selection outside of the\n    // table, and then the selection ends up in the table but not in the\n    // first cell, then move the selection to the first cell.\n    if (shouldCheckSelection && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(prevSelection) && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection) && selection.isCollapsed()) {\n      const anchor = selection.anchor.getNode();\n      const firstRow = tableNode.getFirstChild();\n      const anchorCell = $findCellNode(anchor);\n      if (anchorCell !== null && $isTableRowNode(firstRow)) {\n        const firstCell = firstRow.getFirstChild();\n        if ($isTableCellNode(firstCell) && tableNode.is((0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(anchorCell, node => node.is(tableNode) || node.is(firstCell)))) {\n          // The selection moved to the table, but not in the first cell\n          firstCell.selectStart();\n          return true;\n        }\n      }\n    }\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      const {\n        anchor,\n        focus\n      } = selection;\n      const anchorNode = anchor.getNode();\n      const focusNode = focus.getNode();\n      // Using explicit comparison with table node to ensure it's not a nested table\n      // as in that case we'll leave selection resolving to that table\n      const anchorCellNode = $findCellNode(anchorNode);\n      const focusCellNode = $findCellNode(focusNode);\n      const isAnchorInside = !!(anchorCellNode && tableNode.is($findTableNode(anchorCellNode)));\n      const isFocusInside = !!(focusCellNode && tableNode.is($findTableNode(focusCellNode)));\n      const isPartiallyWithinTable = isAnchorInside !== isFocusInside;\n      const isWithinTable = isAnchorInside && isFocusInside;\n      const isBackward = selection.isBackward();\n      if (isPartiallyWithinTable) {\n        const newSelection = selection.clone();\n        if (isFocusInside) {\n          const [tableMap] = $computeTableMap(tableNode, focusCellNode, focusCellNode);\n          const firstCell = tableMap[0][0].cell;\n          const lastCell = tableMap[tableMap.length - 1].at(-1).cell;\n          newSelection.focus.set(isBackward ? firstCell.getKey() : lastCell.getKey(), isBackward ? firstCell.getChildrenSize() : lastCell.getChildrenSize(), 'element');\n        } else if (isAnchorInside) {\n          const [tableMap] = $computeTableMap(tableNode, anchorCellNode, anchorCellNode);\n          const firstCell = tableMap[0][0].cell;\n          const lastCell = tableMap[tableMap.length - 1].at(-1).cell;\n          /**\n           * If isBackward, set the anchor to be at the end of the table so that when the cursor moves outside of\n           * the table in the backward direction, the entire table will be selected from its end.\n           * Otherwise, if forward, set the anchor to be at the start of the table so that when the focus is dragged\n           * outside th end of the table, it will start from the beginning of the table.\n           */\n          newSelection.anchor.set(isBackward ? lastCell.getKey() : firstCell.getKey(), isBackward ? lastCell.getChildrenSize() : 0, 'element');\n        }\n        (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$setSelection)(newSelection);\n        $addHighlightStyleToTable(editor, tableObserver);\n      } else if (isWithinTable) {\n        // Handle case when selection spans across multiple cells but still\n        // has range selection, then we convert it into table selection\n        if (!anchorCellNode.is(focusCellNode)) {\n          tableObserver.$setAnchorCellForSelection($getObserverCellFromCellNodeOrThrow(tableObserver, anchorCellNode));\n          tableObserver.$setFocusCellForSelection($getObserverCellFromCellNodeOrThrow(tableObserver, focusCellNode), true);\n        }\n\n        // Handle case when the pointer type is touch and the current and\n        // previous selection are collapsed, and the previous anchor and current\n        // focus cell nodes are different, then we convert it into table selection\n        if (tableObserver.pointerType === 'touch' && selection.isCollapsed() && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(prevSelection) && prevSelection.isCollapsed()) {\n          const prevAnchorCellNode = $findCellNode(prevSelection.anchor.getNode());\n          if (prevAnchorCellNode && !prevAnchorCellNode.is(focusCellNode)) {\n            tableObserver.$setAnchorCellForSelection($getObserverCellFromCellNodeOrThrow(tableObserver, prevAnchorCellNode));\n            tableObserver.$setFocusCellForSelection($getObserverCellFromCellNodeOrThrow(tableObserver, focusCellNode), true);\n            tableObserver.pointerType = null;\n          }\n        }\n      }\n    } else if (selection && $isTableSelection(selection) && selection.is(prevSelection) && selection.tableKey === tableNode.getKey()) {\n      // if selection goes outside of the table we need to change it to Range selection\n      const domSelection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.getDOMSelection)(editorWindow);\n      if (domSelection && domSelection.anchorNode && domSelection.focusNode) {\n        const focusNode = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getNearestNodeFromDOMNode)(domSelection.focusNode);\n        const isFocusOutside = focusNode && !tableNode.isParentOf(focusNode);\n        const anchorNode = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getNearestNodeFromDOMNode)(domSelection.anchorNode);\n        const isAnchorInside = anchorNode && tableNode.isParentOf(anchorNode);\n        if (isFocusOutside && isAnchorInside && domSelection.rangeCount > 0) {\n          const newSelection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createRangeSelectionFromDom)(domSelection, editor);\n          if (newSelection) {\n            newSelection.anchor.set(tableNode.getKey(), selection.isBackward() ? tableNode.getChildrenSize() : 0, 'element');\n            domSelection.removeAllRanges();\n            (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$setSelection)(newSelection);\n          }\n        }\n      }\n    }\n    if (selection && !selection.is(prevSelection) && ($isTableSelection(selection) || $isTableSelection(prevSelection)) && tableObserver.tableSelection && !tableObserver.tableSelection.is(prevSelection)) {\n      if ($isTableSelection(selection) && selection.tableKey === tableObserver.tableNodeKey) {\n        tableObserver.$updateTableTableSelection(selection);\n      } else if (!$isTableSelection(selection) && $isTableSelection(prevSelection) && prevSelection.tableKey === tableObserver.tableNodeKey) {\n        tableObserver.$updateTableTableSelection(null);\n      }\n      return false;\n    }\n    if (tableObserver.hasHijackedSelectionStyles && !tableNode.isSelected()) {\n      $removeHighlightStyleToTable(editor, tableObserver);\n    } else if (!tableObserver.hasHijackedSelectionStyles && tableNode.isSelected()) {\n      $addHighlightStyleToTable(editor, tableObserver);\n    }\n    return false;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_CRITICAL));\n  tableObserver.listenersToRemove.add(editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.INSERT_PARAGRAPH_COMMAND, () => {\n    const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n    if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection) || !selection.isCollapsed() || !$isSelectionInTable(selection, tableNode)) {\n      return false;\n    }\n    const edgePosition = $getTableEdgeCursorPosition(editor, selection, tableNode);\n    if (edgePosition) {\n      $insertParagraphAtTableEdge(edgePosition, tableNode);\n      return true;\n    }\n    return false;\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_CRITICAL));\n  return tableObserver;\n}\nfunction detatchTableObserverFromTableElement(tableElement, tableObserver) {\n  if (getTableObserverFromTableElement(tableElement) === tableObserver) {\n    delete tableElement[LEXICAL_ELEMENT_KEY];\n  }\n}\nfunction attachTableObserverToTableElement(tableElement, tableObserver) {\n  if (!(getTableObserverFromTableElement(tableElement) === null)) {\n    formatDevErrorMessage(`tableElement already has an attached TableObserver`);\n  }\n  tableElement[LEXICAL_ELEMENT_KEY] = tableObserver;\n}\nfunction getTableObserverFromTableElement(tableElement) {\n  return tableElement[LEXICAL_ELEMENT_KEY] || null;\n}\nfunction getDOMCellFromTarget(node) {\n  let currentNode = node;\n  while (currentNode != null) {\n    const nodeName = currentNode.nodeName;\n    if (nodeName === 'TD' || nodeName === 'TH') {\n      // @ts-expect-error: internal field\n      const cell = currentNode._cell;\n      if (cell === undefined) {\n        return null;\n      }\n      return cell;\n    }\n    currentNode = currentNode.parentNode;\n  }\n  return null;\n}\nfunction getDOMCellInTableFromTarget(table, node) {\n  if (!table.contains(node)) {\n    return null;\n  }\n  let cell = null;\n  for (let currentNode = node; currentNode != null; currentNode = currentNode.parentNode) {\n    if (currentNode === table) {\n      return cell;\n    }\n    const nodeName = currentNode.nodeName;\n    if (nodeName === 'TD' || nodeName === 'TH') {\n      // @ts-expect-error: internal field\n      cell = currentNode._cell || null;\n    }\n  }\n  return null;\n}\nfunction getTable(tableNode, dom) {\n  const tableElement = getTableElement(tableNode, dom);\n  const domRows = [];\n  const grid = {\n    columns: 0,\n    domRows,\n    rows: 0\n  };\n  let currentNode = tableElement.querySelector('tr');\n  let x = 0;\n  let y = 0;\n  domRows.length = 0;\n  while (currentNode != null) {\n    const nodeMame = currentNode.nodeName;\n    if (nodeMame === 'TD' || nodeMame === 'TH') {\n      const elem = currentNode;\n      const cell = {\n        elem,\n        hasBackgroundColor: elem.style.backgroundColor !== '',\n        highlighted: false,\n        x,\n        y\n      };\n\n      // @ts-expect-error: internal field\n      currentNode._cell = cell;\n      let row = domRows[y];\n      if (row === undefined) {\n        row = domRows[y] = [];\n      }\n      row[x] = cell;\n    } else {\n      const child = currentNode.firstChild;\n      if (child != null) {\n        currentNode = child;\n        continue;\n      }\n    }\n    const sibling = currentNode.nextSibling;\n    if (sibling != null) {\n      x++;\n      currentNode = sibling;\n      continue;\n    }\n    const parent = currentNode.parentNode;\n    if (parent != null) {\n      const parentSibling = parent.nextSibling;\n      if (parentSibling == null) {\n        break;\n      }\n      y++;\n      x = 0;\n      currentNode = parentSibling;\n    }\n  }\n  grid.columns = x + 1;\n  grid.rows = y + 1;\n  return grid;\n}\nfunction $updateDOMForSelection(editor, table, selection) {\n  const selectedCellNodes = new Set(selection ? selection.getNodes() : []);\n  $forEachTableCell(table, (cell, lexicalNode) => {\n    const elem = cell.elem;\n    if (selectedCellNodes.has(lexicalNode)) {\n      cell.highlighted = true;\n      $addHighlightToDOM(editor, cell);\n    } else {\n      cell.highlighted = false;\n      $removeHighlightFromDOM(editor, cell);\n      if (!elem.getAttribute('style')) {\n        elem.removeAttribute('style');\n      }\n    }\n  });\n}\nfunction $forEachTableCell(grid, cb) {\n  const {\n    domRows\n  } = grid;\n  for (let y = 0; y < domRows.length; y++) {\n    const row = domRows[y];\n    if (!row) {\n      continue;\n    }\n    for (let x = 0; x < row.length; x++) {\n      const cell = row[x];\n      if (!cell) {\n        continue;\n      }\n      const lexicalNode = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getNearestNodeFromDOMNode)(cell.elem);\n      if (lexicalNode !== null) {\n        cb(cell, lexicalNode, {\n          x,\n          y\n        });\n      }\n    }\n  }\n}\nfunction $addHighlightStyleToTable(editor, tableSelection) {\n  tableSelection.$disableHighlightStyle();\n  $forEachTableCell(tableSelection.table, cell => {\n    cell.highlighted = true;\n    $addHighlightToDOM(editor, cell);\n  });\n}\nfunction $removeHighlightStyleToTable(editor, tableObserver) {\n  tableObserver.$enableHighlightStyle();\n  $forEachTableCell(tableObserver.table, cell => {\n    const elem = cell.elem;\n    cell.highlighted = false;\n    $removeHighlightFromDOM(editor, cell);\n    if (!elem.getAttribute('style')) {\n      elem.removeAttribute('style');\n    }\n  });\n}\nfunction $selectAdjacentCell(tableCellNode, direction) {\n  const siblingMethod = direction === 'next' ? 'getNextSibling' : 'getPreviousSibling';\n  const childMethod = direction === 'next' ? 'getFirstChild' : 'getLastChild';\n  const sibling = tableCellNode[siblingMethod]();\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(sibling)) {\n    return sibling.selectEnd();\n  }\n  const parentRow = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(tableCellNode, $isTableRowNode);\n  if (!(parentRow !== null)) {\n    formatDevErrorMessage(`selectAdjacentCell: Cell not in table row`);\n  }\n  for (let nextRow = parentRow[siblingMethod](); $isTableRowNode(nextRow); nextRow = nextRow[siblingMethod]()) {\n    const child = nextRow[childMethod]();\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(child)) {\n      return child.selectEnd();\n    }\n  }\n  const parentTable = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(parentRow, $isTableNode);\n  if (!(parentTable !== null)) {\n    formatDevErrorMessage(`selectAdjacentCell: Row not in table`);\n  }\n  return direction === 'next' ? parentTable.selectNext() : parentTable.selectPrevious();\n}\nconst selectTableNodeInDirection = (tableObserver, tableNode, x, y, direction) => {\n  const isForward = direction === 'forward';\n  switch (direction) {\n    case 'backward':\n    case 'forward':\n      if (x !== (isForward ? tableObserver.table.columns - 1 : 0)) {\n        selectTableCellNode(tableNode.getCellNodeFromCordsOrThrow(x + (isForward ? 1 : -1), y, tableObserver.table), isForward);\n      } else {\n        if (y !== (isForward ? tableObserver.table.rows - 1 : 0)) {\n          selectTableCellNode(tableNode.getCellNodeFromCordsOrThrow(isForward ? 0 : tableObserver.table.columns - 1, y + (isForward ? 1 : -1), tableObserver.table), isForward);\n        } else if (!isForward) {\n          tableNode.selectPrevious();\n        } else {\n          tableNode.selectNext();\n        }\n      }\n      return true;\n    case 'up':\n      if (y !== 0) {\n        selectTableCellNode(tableNode.getCellNodeFromCordsOrThrow(x, y - 1, tableObserver.table), false);\n      } else {\n        tableNode.selectPrevious();\n      }\n      return true;\n    case 'down':\n      if (y !== tableObserver.table.rows - 1) {\n        selectTableCellNode(tableNode.getCellNodeFromCordsOrThrow(x, y + 1, tableObserver.table), true);\n      } else {\n        tableNode.selectNext();\n      }\n      return true;\n    default:\n      return false;\n  }\n};\nfunction getCorner(rect, cellValue) {\n  let colName;\n  let rowName;\n  if (cellValue.startColumn === rect.minColumn) {\n    colName = 'minColumn';\n  } else if (cellValue.startColumn + cellValue.cell.__colSpan - 1 === rect.maxColumn) {\n    colName = 'maxColumn';\n  } else {\n    return null;\n  }\n  if (cellValue.startRow === rect.minRow) {\n    rowName = 'minRow';\n  } else if (cellValue.startRow + cellValue.cell.__rowSpan - 1 === rect.maxRow) {\n    rowName = 'maxRow';\n  } else {\n    return null;\n  }\n  return [colName, rowName];\n}\nfunction getCornerOrThrow(rect, cellValue) {\n  const corner = getCorner(rect, cellValue);\n  if (!(corner !== null)) {\n    formatDevErrorMessage(`getCornerOrThrow: cell ${cellValue.cell.getKey()} is not at a corner of rect`);\n  }\n  return corner;\n}\nfunction oppositeCorner([colName, rowName]) {\n  return [colName === 'minColumn' ? 'maxColumn' : 'minColumn', rowName === 'minRow' ? 'maxRow' : 'minRow'];\n}\nfunction cellAtCornerOrThrow(tableMap, rect, [colName, rowName]) {\n  const rowNum = rect[rowName];\n  const rowMap = tableMap[rowNum];\n  if (!(rowMap !== undefined)) {\n    formatDevErrorMessage(`cellAtCornerOrThrow: ${rowName} = ${String(rowNum)} missing in tableMap`);\n  }\n  const colNum = rect[colName];\n  const cell = rowMap[colNum];\n  if (!(cell !== undefined)) {\n    formatDevErrorMessage(`cellAtCornerOrThrow: ${colName} = ${String(colNum)} missing in tableMap`);\n  }\n  return cell;\n}\nfunction $extractRectCorners(tableMap, anchorCellValue, newFocusCellValue) {\n  // We are sure that the focus now either contracts or expands the rect\n  // but both the anchor and focus might be moved to ensure a rectangle\n  // given a potentially ragged merge shape\n  const rect = $computeTableCellRectBoundary(tableMap, anchorCellValue, newFocusCellValue);\n  const anchorCorner = getCorner(rect, anchorCellValue);\n  if (anchorCorner) {\n    return [cellAtCornerOrThrow(tableMap, rect, anchorCorner), cellAtCornerOrThrow(tableMap, rect, oppositeCorner(anchorCorner))];\n  }\n  const newFocusCorner = getCorner(rect, newFocusCellValue);\n  if (newFocusCorner) {\n    return [cellAtCornerOrThrow(tableMap, rect, oppositeCorner(newFocusCorner)), cellAtCornerOrThrow(tableMap, rect, newFocusCorner)];\n  }\n  // TODO this doesn't have to be arbitrary, use the closest corner instead\n  const newAnchorCorner = ['minColumn', 'minRow'];\n  return [cellAtCornerOrThrow(tableMap, rect, newAnchorCorner), cellAtCornerOrThrow(tableMap, rect, oppositeCorner(newAnchorCorner))];\n}\nfunction $adjustFocusInDirection(tableObserver, tableMap, anchorCellValue, focusCellValue, direction) {\n  const rect = $computeTableCellRectBoundary(tableMap, anchorCellValue, focusCellValue);\n  const spans = $computeTableCellRectSpans(tableMap, rect);\n  const {\n    topSpan,\n    leftSpan,\n    bottomSpan,\n    rightSpan\n  } = spans;\n  const anchorCorner = getCornerOrThrow(rect, anchorCellValue);\n  const [focusColumn, focusRow] = oppositeCorner(anchorCorner);\n  let fCol = rect[focusColumn];\n  let fRow = rect[focusRow];\n  if (direction === 'forward') {\n    fCol += focusColumn === 'maxColumn' ? 1 : leftSpan;\n  } else if (direction === 'backward') {\n    fCol -= focusColumn === 'minColumn' ? 1 : rightSpan;\n  } else if (direction === 'down') {\n    fRow += focusRow === 'maxRow' ? 1 : topSpan;\n  } else if (direction === 'up') {\n    fRow -= focusRow === 'minRow' ? 1 : bottomSpan;\n  }\n  const targetRowMap = tableMap[fRow];\n  if (targetRowMap === undefined) {\n    return false;\n  }\n  const newFocusCellValue = targetRowMap[fCol];\n  if (newFocusCellValue === undefined) {\n    return false;\n  }\n  // We can be certain that anchorCellValue and newFocusCellValue are\n  // contained within the desired selection, but we are not certain if\n  // they need to be expanded or not to maintain a rectangular shape\n  const [finalAnchorCell, finalFocusCell] = $extractRectCorners(tableMap, anchorCellValue, newFocusCellValue);\n  const anchorDOM = $getObserverCellFromCellNodeOrThrow(tableObserver, finalAnchorCell.cell);\n  const focusDOM = $getObserverCellFromCellNodeOrThrow(tableObserver, finalFocusCell.cell);\n  tableObserver.$setAnchorCellForSelection(anchorDOM);\n  tableObserver.$setFocusCellForSelection(focusDOM, true);\n  return true;\n}\nfunction $isSelectionInTable(selection, tableNode) {\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection) || $isTableSelection(selection)) {\n    // TODO this should probably return false if there's an unrelated\n    //      shadow root between the node and the table (e.g. another table,\n    //      collapsible, etc.)\n    const isAnchorInside = tableNode.isParentOf(selection.anchor.getNode());\n    const isFocusInside = tableNode.isParentOf(selection.focus.getNode());\n    return isAnchorInside && isFocusInside;\n  }\n  return false;\n}\nfunction $isFullTableSelection(selection, tableNode) {\n  if ($isTableSelection(selection)) {\n    const anchorNode = selection.anchor.getNode();\n    const focusNode = selection.focus.getNode();\n    if (tableNode && anchorNode && focusNode) {\n      const [map] = $computeTableMap(tableNode, anchorNode, focusNode);\n      return anchorNode.getKey() === map[0][0].cell.getKey() && focusNode.getKey() === map[map.length - 1].at(-1).cell.getKey();\n    }\n  }\n  return false;\n}\nfunction selectTableCellNode(tableCell, fromStart) {\n  if (fromStart) {\n    tableCell.selectStart();\n  } else {\n    tableCell.selectEnd();\n  }\n}\nfunction $addHighlightToDOM(editor, cell) {\n  const element = cell.elem;\n  const editorThemeClasses = editor._config.theme;\n  const node = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getNearestNodeFromDOMNode)(element);\n  if (!$isTableCellNode(node)) {\n    formatDevErrorMessage(`Expected to find LexicalNode from Table Cell DOMNode`);\n  }\n  (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.addClassNamesToElement)(element, editorThemeClasses.tableCellSelected);\n}\nfunction $removeHighlightFromDOM(editor, cell) {\n  const element = cell.elem;\n  const node = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getNearestNodeFromDOMNode)(element);\n  if (!$isTableCellNode(node)) {\n    formatDevErrorMessage(`Expected to find LexicalNode from Table Cell DOMNode`);\n  }\n  const editorThemeClasses = editor._config.theme;\n  (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.removeClassNamesFromElement)(element, editorThemeClasses.tableCellSelected);\n}\nfunction $findCellNode(node) {\n  const cellNode = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(node, $isTableCellNode);\n  return $isTableCellNode(cellNode) ? cellNode : null;\n}\nfunction $findTableNode(node) {\n  const tableNode = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(node, $isTableNode);\n  return $isTableNode(tableNode) ? tableNode : null;\n}\nfunction $getBlockParentIfFirstNode(node) {\n  for (let prevNode = node, currentNode = node; currentNode !== null; prevNode = currentNode, currentNode = currentNode.getParent()) {\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(currentNode)) {\n      if (currentNode !== prevNode && currentNode.getFirstChild() !== prevNode) {\n        // Not the first child or the initial node\n        return null;\n      } else if (!currentNode.isInline()) {\n        return currentNode;\n      }\n    }\n  }\n  return null;\n}\nfunction $handleHorizontalArrowKeyRangeSelection(editor, event, selection, alter, isBackward, tableNode, tableObserver) {\n  const initialFocus = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$caretFromPoint)(selection.focus, isBackward ? 'previous' : 'next');\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isExtendableTextPointCaret)(initialFocus)) {\n    return false;\n  }\n  let lastCaret = initialFocus;\n  // TableCellNode is the only shadow root we are interested in piercing so\n  // we find the last internal caret and then check its parent\n  for (const nextCaret of (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$extendCaretToRange)(initialFocus).iterNodeCarets('shadowRoot')) {\n    if (!((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isSiblingCaret)(nextCaret) && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(nextCaret.origin))) {\n      return false;\n    }\n    lastCaret = nextCaret;\n  }\n  const lastCaretParent = lastCaret.getParentAtCaret();\n  if (!$isTableCellNode(lastCaretParent)) {\n    return false;\n  }\n  const anchorCell = lastCaretParent;\n  const focusCaret = $findNextTableCell((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSiblingCaret)(anchorCell, lastCaret.direction));\n  const anchorCellTable = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(anchorCell, $isTableNode);\n  if (!(anchorCellTable && anchorCellTable.is(tableNode))) {\n    return false;\n  }\n  const anchorCellDOM = editor.getElementByKey(anchorCell.getKey());\n  const anchorDOMCell = getDOMCellFromTarget(anchorCellDOM);\n  if (!anchorCellDOM || !anchorDOMCell) {\n    return false;\n  }\n  const anchorCellTableElement = $getElementForTableNode(editor, anchorCellTable);\n  tableObserver.table = anchorCellTableElement;\n  if (!focusCaret) {\n    if (alter === 'extend') {\n      // extend the selection from a range inside the cell to a table selection of the cell\n      tableObserver.$setAnchorCellForSelection(anchorDOMCell);\n      tableObserver.$setFocusCellForSelection(anchorDOMCell, true);\n    } else {\n      // exit the table\n      const outerFocusCaret = $getTableExitCaret((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSiblingCaret)(anchorCellTable, initialFocus.direction));\n      (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$setPointFromCaret)(selection.anchor, outerFocusCaret);\n      (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$setPointFromCaret)(selection.focus, outerFocusCaret);\n    }\n  } else if (alter === 'extend') {\n    const focusDOMCell = getDOMCellFromTarget(editor.getElementByKey(focusCaret.origin.getKey()));\n    if (!focusDOMCell) {\n      return false;\n    }\n    tableObserver.$setAnchorCellForSelection(anchorDOMCell);\n    tableObserver.$setFocusCellForSelection(focusDOMCell, true);\n  } else {\n    // alter === 'move'\n    const innerFocusCaret = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$normalizeCaret)(focusCaret);\n    (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$setPointFromCaret)(selection.anchor, innerFocusCaret);\n    (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$setPointFromCaret)(selection.focus, innerFocusCaret);\n  }\n  stopEvent(event);\n  return true;\n}\nfunction $getTableExitCaret(initialCaret) {\n  const adjacent = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getAdjacentChildCaret)(initialCaret);\n  return (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isChildCaret)(adjacent) ? (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$normalizeCaret)(adjacent) : initialCaret;\n}\nfunction $findNextTableCell(initialCaret) {\n  for (const nextCaret of (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$extendCaretToRange)(initialCaret).iterNodeCarets('root')) {\n    const {\n      origin\n    } = nextCaret;\n    if ($isTableCellNode(origin)) {\n      // not sure why ts isn't narrowing here (even if the guard is on nextCaret.origin)\n      // but returning a new caret is fine\n      if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isChildCaret)(nextCaret)) {\n        return (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getChildCaret)(origin, initialCaret.direction);\n      }\n    } else if (!$isTableRowNode(origin)) {\n      break;\n    }\n  }\n  return null;\n}\nfunction $handleArrowKey(editor, event, direction, tableNode, tableObserver) {\n  if ((direction === 'up' || direction === 'down') && isTypeaheadMenuInView(editor)) {\n    return false;\n  }\n  const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n  if (!$isSelectionInTable(selection, tableNode)) {\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      if (direction === 'backward') {\n        if (selection.focus.offset > 0) {\n          return false;\n        }\n        const parentNode = $getBlockParentIfFirstNode(selection.focus.getNode());\n        if (!parentNode) {\n          return false;\n        }\n        const siblingNode = parentNode.getPreviousSibling();\n        if (!$isTableNode(siblingNode)) {\n          return false;\n        }\n        stopEvent(event);\n        if (event.shiftKey) {\n          selection.focus.set(siblingNode.getParentOrThrow().getKey(), siblingNode.getIndexWithinParent(), 'element');\n        } else {\n          siblingNode.selectEnd();\n        }\n        return true;\n      } else if (event.shiftKey && (direction === 'up' || direction === 'down')) {\n        const focusNode = selection.focus.getNode();\n        const isTableUnselect = !selection.isCollapsed() && (direction === 'up' && !selection.isBackward() || direction === 'down' && selection.isBackward());\n        if (isTableUnselect) {\n          let focusParentNode = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(focusNode, n => $isTableNode(n));\n          if ($isTableCellNode(focusParentNode)) {\n            focusParentNode = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(focusParentNode, $isTableNode);\n          }\n          if (focusParentNode !== tableNode) {\n            return false;\n          }\n          if (!focusParentNode) {\n            return false;\n          }\n          const sibling = direction === 'down' ? focusParentNode.getNextSibling() : focusParentNode.getPreviousSibling();\n          if (!sibling) {\n            return false;\n          }\n          let newOffset = 0;\n          if (direction === 'up') {\n            if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(sibling)) {\n              newOffset = sibling.getChildrenSize();\n            }\n          }\n          let newFocusNode = sibling;\n          if (direction === 'up') {\n            if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(sibling)) {\n              const lastCell = sibling.getLastChild();\n              newFocusNode = lastCell ? lastCell : sibling;\n              newOffset = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(newFocusNode) ? newFocusNode.getTextContentSize() : 0;\n            }\n          }\n          const newSelection = selection.clone();\n          newSelection.focus.set(newFocusNode.getKey(), newOffset, (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(newFocusNode) ? 'text' : 'element');\n          (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$setSelection)(newSelection);\n          stopEvent(event);\n          return true;\n        } else if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRootOrShadowRoot)(focusNode)) {\n          const selectedNode = direction === 'up' ? selection.getNodes()[selection.getNodes().length - 1] : selection.getNodes()[0];\n          if (selectedNode) {\n            const tableCellNode = $findParentTableCellNodeInTable(tableNode, selectedNode);\n            if (tableCellNode !== null) {\n              const firstDescendant = tableNode.getFirstDescendant();\n              const lastDescendant = tableNode.getLastDescendant();\n              if (!firstDescendant || !lastDescendant) {\n                return false;\n              }\n              const [firstCellNode] = $getNodeTriplet(firstDescendant);\n              const [lastCellNode] = $getNodeTriplet(lastDescendant);\n              const firstCellCoords = tableNode.getCordsFromCellNode(firstCellNode, tableObserver.table);\n              const lastCellCoords = tableNode.getCordsFromCellNode(lastCellNode, tableObserver.table);\n              const firstCellDOM = tableNode.getDOMCellFromCordsOrThrow(firstCellCoords.x, firstCellCoords.y, tableObserver.table);\n              const lastCellDOM = tableNode.getDOMCellFromCordsOrThrow(lastCellCoords.x, lastCellCoords.y, tableObserver.table);\n              tableObserver.$setAnchorCellForSelection(firstCellDOM);\n              tableObserver.$setFocusCellForSelection(lastCellDOM, true);\n              return true;\n            }\n          }\n          return false;\n        } else {\n          let focusParentNode = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(focusNode, n => (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(n) && !n.isInline());\n          if ($isTableCellNode(focusParentNode)) {\n            focusParentNode = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(focusParentNode, $isTableNode);\n          }\n          if (!focusParentNode) {\n            return false;\n          }\n          const sibling = direction === 'down' ? focusParentNode.getNextSibling() : focusParentNode.getPreviousSibling();\n          if ($isTableNode(sibling) && tableObserver.tableNodeKey === sibling.getKey()) {\n            const firstDescendant = sibling.getFirstDescendant();\n            const lastDescendant = sibling.getLastDescendant();\n            if (!firstDescendant || !lastDescendant) {\n              return false;\n            }\n            const [firstCellNode] = $getNodeTriplet(firstDescendant);\n            const [lastCellNode] = $getNodeTriplet(lastDescendant);\n            const newSelection = selection.clone();\n            newSelection.focus.set((direction === 'up' ? firstCellNode : lastCellNode).getKey(), direction === 'up' ? 0 : lastCellNode.getChildrenSize(), 'element');\n            stopEvent(event);\n            (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$setSelection)(newSelection);\n            return true;\n          }\n        }\n      }\n    }\n    if (direction === 'down' && $isScrollableTablesActive(editor)) {\n      // Enable Firefox workaround\n      tableObserver.setShouldCheckSelection();\n    }\n    return false;\n  }\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n    if (direction === 'backward' || direction === 'forward') {\n      const alter = event.shiftKey ? 'extend' : 'move';\n      return $handleHorizontalArrowKeyRangeSelection(editor, event, selection, alter, direction === 'backward', tableNode, tableObserver);\n    }\n    if (selection.isCollapsed()) {\n      const {\n        anchor,\n        focus\n      } = selection;\n      const anchorCellNode = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(anchor.getNode(), $isTableCellNode);\n      const focusCellNode = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(focus.getNode(), $isTableCellNode);\n      if (!$isTableCellNode(anchorCellNode) || !anchorCellNode.is(focusCellNode)) {\n        return false;\n      }\n      const anchorCellTable = $findTableNode(anchorCellNode);\n      if (anchorCellTable !== tableNode && anchorCellTable != null) {\n        const anchorCellTableElement = getTableElement(anchorCellTable, editor.getElementByKey(anchorCellTable.getKey()));\n        if (anchorCellTableElement != null) {\n          tableObserver.table = getTable(anchorCellTable, anchorCellTableElement);\n          return $handleArrowKey(editor, event, direction, anchorCellTable, tableObserver);\n        }\n      }\n      const anchorCellDom = editor.getElementByKey(anchorCellNode.__key);\n      const anchorDOM = editor.getElementByKey(anchor.key);\n      if (anchorDOM == null || anchorCellDom == null) {\n        return false;\n      }\n      let edgeSelectionRect;\n      if (anchor.type === 'element') {\n        edgeSelectionRect = anchorDOM.getBoundingClientRect();\n      } else {\n        const domSelection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.getDOMSelection)(getEditorWindow(editor));\n        if (domSelection === null || domSelection.rangeCount === 0) {\n          return false;\n        }\n        const range = domSelection.getRangeAt(0);\n        edgeSelectionRect = range.getBoundingClientRect();\n      }\n      const edgeChild = direction === 'up' ? anchorCellNode.getFirstChild() : anchorCellNode.getLastChild();\n      if (edgeChild == null) {\n        return false;\n      }\n      const edgeChildDOM = editor.getElementByKey(edgeChild.__key);\n      if (edgeChildDOM == null) {\n        return false;\n      }\n      const edgeRect = edgeChildDOM.getBoundingClientRect();\n      const isExiting = direction === 'up' ? edgeRect.top > edgeSelectionRect.top - edgeSelectionRect.height : edgeSelectionRect.bottom + edgeSelectionRect.height > edgeRect.bottom;\n      if (isExiting) {\n        stopEvent(event);\n        const cords = tableNode.getCordsFromCellNode(anchorCellNode, tableObserver.table);\n        if (event.shiftKey) {\n          const cell = tableNode.getDOMCellFromCordsOrThrow(cords.x, cords.y, tableObserver.table);\n          tableObserver.$setAnchorCellForSelection(cell);\n          tableObserver.$setFocusCellForSelection(cell, true);\n        } else {\n          return selectTableNodeInDirection(tableObserver, tableNode, cords.x, cords.y, direction);\n        }\n        return true;\n      }\n    }\n  } else if ($isTableSelection(selection)) {\n    const {\n      anchor,\n      focus\n    } = selection;\n    const anchorCellNode = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(anchor.getNode(), $isTableCellNode);\n    const focusCellNode = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(focus.getNode(), $isTableCellNode);\n    const [tableNodeFromSelection] = selection.getNodes();\n    if (!$isTableNode(tableNodeFromSelection)) {\n      formatDevErrorMessage(`$handleArrowKey: TableSelection.getNodes()[0] expected to be TableNode`);\n    }\n    const tableElement = getTableElement(tableNodeFromSelection, editor.getElementByKey(tableNodeFromSelection.getKey()));\n    if (!$isTableCellNode(anchorCellNode) || !$isTableCellNode(focusCellNode) || !$isTableNode(tableNodeFromSelection) || tableElement == null) {\n      return false;\n    }\n    tableObserver.$updateTableTableSelection(selection);\n    const grid = getTable(tableNodeFromSelection, tableElement);\n    const cordsAnchor = tableNode.getCordsFromCellNode(anchorCellNode, grid);\n    const anchorCell = tableNode.getDOMCellFromCordsOrThrow(cordsAnchor.x, cordsAnchor.y, grid);\n    tableObserver.$setAnchorCellForSelection(anchorCell);\n    stopEvent(event);\n    if (event.shiftKey) {\n      const [tableMap, anchorValue, focusValue] = $computeTableMap(tableNode, anchorCellNode, focusCellNode);\n      return $adjustFocusInDirection(tableObserver, tableMap, anchorValue, focusValue, direction);\n    } else {\n      focusCellNode.selectEnd();\n    }\n    return true;\n  }\n  return false;\n}\nfunction stopEvent(event) {\n  event.preventDefault();\n  event.stopImmediatePropagation();\n  event.stopPropagation();\n}\nfunction isTypeaheadMenuInView(editor) {\n  // There is no inbuilt way to check if the component picker is in view\n  // but we can check if the root DOM element has the aria-controls attribute \"typeahead-menu\".\n  const root = editor.getRootElement();\n  if (!root) {\n    return false;\n  }\n  return root.hasAttribute('aria-controls') && root.getAttribute('aria-controls') === 'typeahead-menu';\n}\nfunction $insertParagraphAtTableEdge(edgePosition, tableNode, children) {\n  const paragraphNode = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)();\n  if (edgePosition === 'first') {\n    tableNode.insertBefore(paragraphNode);\n  } else {\n    tableNode.insertAfter(paragraphNode);\n  }\n  paragraphNode.append(...(children || []));\n  paragraphNode.selectEnd();\n}\nfunction $getTableEdgeCursorPosition(editor, selection, tableNode) {\n  const tableNodeParent = tableNode.getParent();\n  if (!tableNodeParent) {\n    return undefined;\n  }\n\n  // TODO: Add support for nested tables\n  const domSelection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.getDOMSelection)(getEditorWindow(editor));\n  if (!domSelection) {\n    return undefined;\n  }\n  const domAnchorNode = domSelection.anchorNode;\n  const tableNodeParentDOM = editor.getElementByKey(tableNodeParent.getKey());\n  const tableElement = getTableElement(tableNode, editor.getElementByKey(tableNode.getKey()));\n  // We are only interested in the scenario where the\n  // native selection anchor is:\n  // - at or inside the table's parent DOM\n  // - and NOT at or inside the table DOM\n  // It may be adjacent to the table DOM (e.g. in a wrapper)\n  if (!domAnchorNode || !tableNodeParentDOM || !tableElement || !tableNodeParentDOM.contains(domAnchorNode) || tableElement.contains(domAnchorNode)) {\n    return undefined;\n  }\n  const anchorCellNode = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(selection.anchor.getNode(), n => $isTableCellNode(n));\n  if (!anchorCellNode) {\n    return undefined;\n  }\n  const parentTable = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(anchorCellNode, n => $isTableNode(n));\n  if (!$isTableNode(parentTable) || !parentTable.is(tableNode)) {\n    return undefined;\n  }\n  const [tableMap, cellValue] = $computeTableMap(tableNode, anchorCellNode, anchorCellNode);\n  const firstCell = tableMap[0][0];\n  const lastCell = tableMap[tableMap.length - 1][tableMap[0].length - 1];\n  const {\n    startRow,\n    startColumn\n  } = cellValue;\n  const isAtFirstCell = startRow === firstCell.startRow && startColumn === firstCell.startColumn;\n  const isAtLastCell = startRow === lastCell.startRow && startColumn === lastCell.startColumn;\n  if (isAtFirstCell) {\n    return 'first';\n  } else if (isAtLastCell) {\n    return 'last';\n  } else {\n    return undefined;\n  }\n}\nfunction $getObserverCellFromCellNodeOrThrow(tableObserver, tableCellNode) {\n  const {\n    tableNode\n  } = tableObserver.$lookup();\n  const currentCords = tableNode.getCordsFromCellNode(tableCellNode, tableObserver.table);\n  return tableNode.getDOMCellFromCordsOrThrow(currentCords.x, currentCords.y, tableObserver.table);\n}\nfunction $getNearestTableCellInTableFromDOMNode(tableNode, startingDOM, editorState) {\n  return $findParentTableCellNodeInTable(tableNode, (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getNearestNodeFromDOMNode)(startingDOM, editorState));\n}\n\nfunction updateColgroup(dom, config, colCount, colWidths) {\n  const colGroup = dom.querySelector('colgroup');\n  if (!colGroup) {\n    return;\n  }\n  const cols = [];\n  for (let i = 0; i < colCount; i++) {\n    const col = document.createElement('col');\n    const width = colWidths && colWidths[i];\n    if (width) {\n      col.style.width = `${width}px`;\n    }\n    cols.push(col);\n  }\n  colGroup.replaceChildren(...cols);\n}\nfunction setRowStriping(dom, config, rowStriping) {\n  if (rowStriping) {\n    (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.addClassNamesToElement)(dom, config.theme.tableRowStriping);\n    dom.setAttribute('data-lexical-row-striping', 'true');\n  } else {\n    (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.removeClassNamesFromElement)(dom, config.theme.tableRowStriping);\n    dom.removeAttribute('data-lexical-row-striping');\n  }\n}\nfunction setFrozenColumns(dom, config, frozenColumnCount) {\n  if (frozenColumnCount > 0) {\n    (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.addClassNamesToElement)(dom, config.theme.tableFrozenColumn);\n    dom.setAttribute('data-lexical-frozen-column', 'true');\n  } else {\n    (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.removeClassNamesFromElement)(dom, config.theme.tableFrozenColumn);\n    dom.removeAttribute('data-lexical-frozen-column');\n  }\n}\nfunction setFrozenRows(dom, config, frozenRowCount) {\n  if (frozenRowCount > 0) {\n    (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.addClassNamesToElement)(dom, config.theme.tableFrozenRow);\n    dom.setAttribute('data-lexical-frozen-row', 'true');\n  } else {\n    (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.removeClassNamesFromElement)(dom, config.theme.tableFrozenRow);\n    dom.removeAttribute('data-lexical-frozen-row');\n  }\n}\nfunction alignTableElement(dom, config, formatType) {\n  if (!config.theme.tableAlignment) {\n    return;\n  }\n  const removeClasses = [];\n  const addClasses = [];\n  for (const format of ['center', 'right']) {\n    const classes = config.theme.tableAlignment[format];\n    if (!classes) {\n      continue;\n    }\n    (format === formatType ? addClasses : removeClasses).push(classes);\n  }\n  (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.removeClassNamesFromElement)(dom, ...removeClasses);\n  (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.addClassNamesToElement)(dom, ...addClasses);\n}\nconst scrollableEditors = new WeakSet();\nfunction $isScrollableTablesActive(editor = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getEditor)()) {\n  return scrollableEditors.has(editor);\n}\nfunction setScrollableTablesActive(editor, active) {\n  if (active) {\n    if (!editor._config.theme.tableScrollableWrapper) {\n      console.warn('TableNode: hasHorizontalScroll is active but theme.tableScrollableWrapper is not defined.');\n    }\n    scrollableEditors.add(editor);\n  } else {\n    scrollableEditors.delete(editor);\n  }\n}\n\n/** @noInheritDoc */\nclass TableNode extends lexical__WEBPACK_IMPORTED_MODULE_0__.ElementNode {\n  /** @internal */\n\n  static getType() {\n    return 'table';\n  }\n  getColWidths() {\n    const self = this.getLatest();\n    return self.__colWidths;\n  }\n  setColWidths(colWidths) {\n    const self = this.getWritable();\n    // NOTE: Node properties should be immutable. Freeze to prevent accidental mutation.\n    self.__colWidths = colWidths !== undefined && true ? Object.freeze(colWidths) : colWidths;\n    return self;\n  }\n  static clone(node) {\n    return new TableNode(node.__key);\n  }\n  afterCloneFrom(prevNode) {\n    super.afterCloneFrom(prevNode);\n    this.__colWidths = prevNode.__colWidths;\n    this.__rowStriping = prevNode.__rowStriping;\n    this.__frozenColumnCount = prevNode.__frozenColumnCount;\n    this.__frozenRowCount = prevNode.__frozenRowCount;\n  }\n  static importDOM() {\n    return {\n      table: _node => ({\n        conversion: $convertTableElement,\n        priority: 1\n      })\n    };\n  }\n  static importJSON(serializedNode) {\n    return $createTableNode().updateFromJSON(serializedNode);\n  }\n  updateFromJSON(serializedNode) {\n    return super.updateFromJSON(serializedNode).setRowStriping(serializedNode.rowStriping || false).setFrozenColumns(serializedNode.frozenColumnCount || 0).setFrozenRows(serializedNode.frozenRowCount || 0).setColWidths(serializedNode.colWidths);\n  }\n  constructor(key) {\n    super(key);\n    this.__rowStriping = false;\n    this.__frozenColumnCount = 0;\n    this.__frozenRowCount = 0;\n  }\n  exportJSON() {\n    return {\n      ...super.exportJSON(),\n      colWidths: this.getColWidths(),\n      frozenColumnCount: this.__frozenColumnCount ? this.__frozenColumnCount : undefined,\n      frozenRowCount: this.__frozenRowCount ? this.__frozenRowCount : undefined,\n      rowStriping: this.__rowStriping ? this.__rowStriping : undefined\n    };\n  }\n  extractWithChild(child, selection, destination) {\n    return destination === 'html';\n  }\n  getDOMSlot(element) {\n    const tableElement = !isHTMLTableElement(element) ? element.querySelector('table') : element;\n    if (!isHTMLTableElement(tableElement)) {\n      formatDevErrorMessage(`TableNode.getDOMSlot: createDOM() did not return a table`);\n    }\n    return super.getDOMSlot(element).withElement(tableElement).withAfter(tableElement.querySelector('colgroup'));\n  }\n  createDOM(config, editor) {\n    const tableElement = document.createElement('table');\n    if (this.__style) {\n      tableElement.style.cssText = this.__style;\n    }\n    const colGroup = document.createElement('colgroup');\n    tableElement.appendChild(colGroup);\n    (0,lexical__WEBPACK_IMPORTED_MODULE_0__.setDOMUnmanaged)(colGroup);\n    (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.addClassNamesToElement)(tableElement, config.theme.table);\n    this.updateTableElement(null, tableElement, config);\n    if ($isScrollableTablesActive(editor)) {\n      const wrapperElement = document.createElement('div');\n      const classes = config.theme.tableScrollableWrapper;\n      if (classes) {\n        (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.addClassNamesToElement)(wrapperElement, classes);\n      } else {\n        wrapperElement.style.cssText = 'overflow-x: auto;';\n      }\n      wrapperElement.appendChild(tableElement);\n      return wrapperElement;\n    }\n    return tableElement;\n  }\n  updateTableElement(prevNode, tableElement, config) {\n    if (this.__style !== (prevNode ? prevNode.__style : '')) {\n      tableElement.style.cssText = this.__style;\n    }\n    if (this.__rowStriping !== (prevNode ? prevNode.__rowStriping : false)) {\n      setRowStriping(tableElement, config, this.__rowStriping);\n    }\n    if (this.__frozenColumnCount !== (prevNode ? prevNode.__frozenColumnCount : 0)) {\n      setFrozenColumns(tableElement, config, this.__frozenColumnCount);\n    }\n    if (this.__frozenRowCount !== (prevNode ? prevNode.__frozenRowCount : 0)) {\n      setFrozenRows(tableElement, config, this.__frozenRowCount);\n    }\n    updateColgroup(tableElement, config, this.getColumnCount(), this.getColWidths());\n    alignTableElement(tableElement, config, this.getFormatType());\n  }\n  updateDOM(prevNode, dom, config) {\n    this.updateTableElement(prevNode, this.getDOMSlot(dom).element, config);\n    return false;\n  }\n  exportDOM(editor) {\n    const superExport = super.exportDOM(editor);\n    const {\n      element\n    } = superExport;\n    return {\n      after: tableElement => {\n        if (superExport.after) {\n          tableElement = superExport.after(tableElement);\n        }\n        if (!isHTMLTableElement(tableElement) && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(tableElement)) {\n          tableElement = tableElement.querySelector('table');\n        }\n        if (!isHTMLTableElement(tableElement)) {\n          return null;\n        }\n        alignTableElement(tableElement, editor._config, this.getFormatType());\n\n        // Scan the table map to build a map of table cell key to the columns it needs\n        const [tableMap] = $computeTableMapSkipCellCheck(this, null, null);\n        const cellValues = new Map();\n        for (const mapRow of tableMap) {\n          for (const mapValue of mapRow) {\n            const key = mapValue.cell.getKey();\n            if (!cellValues.has(key)) {\n              cellValues.set(key, {\n                colSpan: mapValue.cell.getColSpan(),\n                startColumn: mapValue.startColumn\n              });\n            }\n          }\n        }\n\n        // scan the DOM to find the table cell keys that were used and mark those columns\n        const knownColumns = new Set();\n        for (const cellDOM of tableElement.querySelectorAll(':scope > tr > [data-temporary-table-cell-lexical-key]')) {\n          const key = cellDOM.getAttribute('data-temporary-table-cell-lexical-key');\n          if (key) {\n            const cellSpan = cellValues.get(key);\n            cellDOM.removeAttribute('data-temporary-table-cell-lexical-key');\n            if (cellSpan) {\n              cellValues.delete(key);\n              for (let i = 0; i < cellSpan.colSpan; i++) {\n                knownColumns.add(i + cellSpan.startColumn);\n              }\n            }\n          }\n        }\n\n        // Compute the colgroup and columns in the export\n        const colGroup = tableElement.querySelector(':scope > colgroup');\n        if (colGroup) {\n          // Only include the <col /> for rows that are in the output\n          const cols = Array.from(tableElement.querySelectorAll(':scope > colgroup > col')).filter((dom, i) => knownColumns.has(i));\n          colGroup.replaceChildren(...cols);\n        }\n\n        // Wrap direct descendant rows in a tbody for export\n        const rows = tableElement.querySelectorAll(':scope > tr');\n        if (rows.length > 0) {\n          const tBody = document.createElement('tbody');\n          for (const row of rows) {\n            tBody.appendChild(row);\n          }\n          tableElement.append(tBody);\n        }\n        return tableElement;\n      },\n      element: !isHTMLTableElement(element) && (0,lexical__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element) ? element.querySelector('table') : element\n    };\n  }\n  canBeEmpty() {\n    return false;\n  }\n  isShadowRoot() {\n    return true;\n  }\n  getCordsFromCellNode(tableCellNode, table) {\n    const {\n      rows,\n      domRows\n    } = table;\n    for (let y = 0; y < rows; y++) {\n      const row = domRows[y];\n      if (row == null) {\n        continue;\n      }\n      for (let x = 0; x < row.length; x++) {\n        const cell = row[x];\n        if (cell == null) {\n          continue;\n        }\n        const {\n          elem\n        } = cell;\n        const cellNode = $getNearestTableCellInTableFromDOMNode(this, elem);\n        if (cellNode !== null && tableCellNode.is(cellNode)) {\n          return {\n            x,\n            y\n          };\n        }\n      }\n    }\n    throw new Error('Cell not found in table.');\n  }\n  getDOMCellFromCords(x, y, table) {\n    const {\n      domRows\n    } = table;\n    const row = domRows[y];\n    if (row == null) {\n      return null;\n    }\n    const index = x < row.length ? x : row.length - 1;\n    const cell = row[index];\n    if (cell == null) {\n      return null;\n    }\n    return cell;\n  }\n  getDOMCellFromCordsOrThrow(x, y, table) {\n    const cell = this.getDOMCellFromCords(x, y, table);\n    if (!cell) {\n      throw new Error('Cell not found at cords.');\n    }\n    return cell;\n  }\n  getCellNodeFromCords(x, y, table) {\n    const cell = this.getDOMCellFromCords(x, y, table);\n    if (cell == null) {\n      return null;\n    }\n    const node = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getNearestNodeFromDOMNode)(cell.elem);\n    if ($isTableCellNode(node)) {\n      return node;\n    }\n    return null;\n  }\n  getCellNodeFromCordsOrThrow(x, y, table) {\n    const node = this.getCellNodeFromCords(x, y, table);\n    if (!node) {\n      throw new Error('Node at cords not TableCellNode.');\n    }\n    return node;\n  }\n  getRowStriping() {\n    return Boolean(this.getLatest().__rowStriping);\n  }\n  setRowStriping(newRowStriping) {\n    const self = this.getWritable();\n    self.__rowStriping = newRowStriping;\n    return self;\n  }\n  setFrozenColumns(columnCount) {\n    const self = this.getWritable();\n    self.__frozenColumnCount = columnCount;\n    return self;\n  }\n  getFrozenColumns() {\n    return this.getLatest().__frozenColumnCount;\n  }\n  setFrozenRows(rowCount) {\n    const self = this.getWritable();\n    self.__frozenRowCount = rowCount;\n    return self;\n  }\n  getFrozenRows() {\n    return this.getLatest().__frozenRowCount;\n  }\n  canSelectBefore() {\n    return true;\n  }\n  canIndent() {\n    return false;\n  }\n  getColumnCount() {\n    const firstRow = this.getFirstChild();\n    if (!firstRow) {\n      return 0;\n    }\n    let columnCount = 0;\n    firstRow.getChildren().forEach(cell => {\n      if ($isTableCellNode(cell)) {\n        columnCount += cell.getColSpan();\n      }\n    });\n    return columnCount;\n  }\n}\nfunction $getElementForTableNode(editor, tableNode) {\n  const tableElement = editor.getElementByKey(tableNode.getKey());\n  if (!(tableElement !== null)) {\n    formatDevErrorMessage(`$getElementForTableNode: Table Element Not Found`);\n  }\n  return getTable(tableNode, tableElement);\n}\nfunction $convertTableElement(domNode) {\n  const tableNode = $createTableNode();\n  if (domNode.hasAttribute('data-lexical-row-striping')) {\n    tableNode.setRowStriping(true);\n  }\n  const colGroup = domNode.querySelector(':scope > colgroup');\n  if (colGroup) {\n    let columns = [];\n    for (const col of colGroup.querySelectorAll(':scope > col')) {\n      let width = col.style.width || '';\n      if (!PIXEL_VALUE_REG_EXP.test(width)) {\n        // Also support deprecated width attribute for google docs\n        width = col.getAttribute('width') || '';\n        if (!/^\\d+$/.test(width)) {\n          columns = undefined;\n          break;\n        }\n      }\n      columns.push(parseFloat(width));\n    }\n    if (columns) {\n      tableNode.setColWidths(columns);\n    }\n  }\n  return {\n    after: children => (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$descendantsMatching)(children, $isTableRowNode),\n    node: tableNode\n  };\n}\nfunction $createTableNode() {\n  return (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$applyNodeReplacement)(new TableNode());\n}\nfunction $isTableNode(node) {\n  return node instanceof TableNode;\n}\n\nfunction $insertTableCommandListener({\n  rows,\n  columns,\n  includeHeaders\n}) {\n  const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n  if (!selection || !(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n    return false;\n  }\n\n  // Prevent nested tables by checking if we're already inside a table\n  if ($findTableNode(selection.anchor.getNode())) {\n    return false;\n  }\n  const tableNode = $createTableNodeWithDimensions(Number(rows), Number(columns), includeHeaders);\n  (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$insertNodeToNearestRoot)(tableNode);\n  const firstDescendant = tableNode.getFirstDescendant();\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextNode)(firstDescendant)) {\n    firstDescendant.select();\n  }\n  return true;\n}\nfunction $tableCellTransform(node) {\n  if (!$isTableRowNode(node.getParent())) {\n    // TableCellNode must be a child of TableRowNode.\n    node.remove();\n  } else if (node.isEmpty()) {\n    // TableCellNode should never be empty\n    node.append((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)());\n  }\n}\nfunction $tableRowTransform(node) {\n  if (!$isTableNode(node.getParent())) {\n    // TableRowNode must be a child of TableNode.\n    // TODO: Future support of tbody/thead/tfoot may change this\n    node.remove();\n  } else {\n    (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$unwrapAndFilterDescendants)(node, $isTableCellNode);\n  }\n}\nfunction $tableTransform(node) {\n  // TableRowNode is the only valid child for TableNode\n  // TODO: Future support of tbody/thead/tfoot/caption may change this\n  (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$unwrapAndFilterDescendants)(node, $isTableRowNode);\n  const [gridMap] = $computeTableMapSkipCellCheck(node, null, null);\n  const maxRowLength = gridMap.reduce((curLength, row) => {\n    return Math.max(curLength, row.length);\n  }, 0);\n  const rowNodes = node.getChildren();\n  for (let i = 0; i < gridMap.length; ++i) {\n    const rowNode = rowNodes[i];\n    if (!rowNode) {\n      continue;\n    }\n    if (!$isTableRowNode(rowNode)) {\n      formatDevErrorMessage(`TablePlugin: Expecting all children of TableNode to be TableRowNode, found ${rowNode.constructor.name} (type ${rowNode.getType()})`);\n    }\n    const rowLength = gridMap[i].reduce((acc, cell) => cell ? 1 + acc : acc, 0);\n    if (rowLength === maxRowLength) {\n      continue;\n    }\n    for (let j = rowLength; j < maxRowLength; ++j) {\n      // TODO: inherit header state from another header or body\n      const newCell = $createTableCellNode();\n      newCell.append((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)());\n      rowNode.append(newCell);\n    }\n  }\n}\nfunction $tableClickCommand(event) {\n  if (event.detail < 3 || !(0,lexical__WEBPACK_IMPORTED_MODULE_0__.isDOMNode)(event.target)) {\n    return false;\n  }\n  const startNode = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getNearestNodeFromDOMNode)(event.target);\n  if (startNode === null) {\n    return false;\n  }\n  const blockNode = (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$findMatchingParent)(startNode, node => (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(node) && !node.isInline());\n  if (blockNode === null) {\n    return false;\n  }\n  const rootNode = blockNode.getParent();\n  if (!$isTableCellNode(rootNode)) {\n    return false;\n  }\n  blockNode.select(0);\n  return true;\n}\n\n/**\n * Register a transform to ensure that all TableCellNode have a colSpan and rowSpan of 1.\n * This should only be registered when you do not want to support merged cells.\n *\n * @param editor The editor\n * @returns An unregister callback\n */\nfunction registerTableCellUnmergeTransform(editor) {\n  return editor.registerNodeTransform(TableCellNode, node => {\n    if (node.getColSpan() > 1 || node.getRowSpan() > 1) {\n      // When we have rowSpan we have to map the entire Table to understand where the new Cells\n      // fit best; let's analyze all Cells at once to save us from further transform iterations\n      const [,, gridNode] = $getNodeTriplet(node);\n      const [gridMap] = $computeTableMap(gridNode, node, node);\n      // TODO this function expects Tables to be normalized. Look into this once it exists\n      const rowsCount = gridMap.length;\n      const columnsCount = gridMap[0].length;\n      let row = gridNode.getFirstChild();\n      if (!$isTableRowNode(row)) {\n        formatDevErrorMessage(`Expected TableNode first child to be a RowNode`);\n      }\n      const unmerged = [];\n      for (let i = 0; i < rowsCount; i++) {\n        if (i !== 0) {\n          row = row.getNextSibling();\n          if (!$isTableRowNode(row)) {\n            formatDevErrorMessage(`Expected TableNode first child to be a RowNode`);\n          }\n        }\n        let lastRowCell = null;\n        for (let j = 0; j < columnsCount; j++) {\n          const cellMap = gridMap[i][j];\n          const cell = cellMap.cell;\n          if (cellMap.startRow === i && cellMap.startColumn === j) {\n            lastRowCell = cell;\n            unmerged.push(cell);\n          } else if (cell.getColSpan() > 1 || cell.getRowSpan() > 1) {\n            if (!$isTableCellNode(cell)) {\n              formatDevErrorMessage(`Expected TableNode cell to be a TableCellNode`);\n            }\n            const newCell = $createTableCellNode(cell.__headerState);\n            if (lastRowCell !== null) {\n              lastRowCell.insertAfter(newCell);\n            } else {\n              (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.$insertFirst)(row, newCell);\n            }\n          }\n        }\n      }\n      for (const cell of unmerged) {\n        cell.setColSpan(1);\n        cell.setRowSpan(1);\n      }\n    }\n  });\n}\nfunction registerTableSelectionObserver(editor, hasTabHandler = true) {\n  const tableSelections = new Map();\n  const initializeTableNode = (tableNode, nodeKey, dom) => {\n    const tableElement = getTableElement(tableNode, dom);\n    const tableSelection = applyTableHandlers(tableNode, tableElement, editor, hasTabHandler);\n    tableSelections.set(nodeKey, [tableSelection, tableElement]);\n  };\n  const unregisterMutationListener = editor.registerMutationListener(TableNode, nodeMutations => {\n    editor.getEditorState().read(() => {\n      for (const [nodeKey, mutation] of nodeMutations) {\n        const tableSelection = tableSelections.get(nodeKey);\n        if (mutation === 'created' || mutation === 'updated') {\n          const {\n            tableNode,\n            tableElement\n          } = $getTableAndElementByKey(nodeKey);\n          if (tableSelection === undefined) {\n            initializeTableNode(tableNode, nodeKey, tableElement);\n          } else if (tableElement !== tableSelection[1]) {\n            // The update created a new DOM node, destroy the existing TableObserver\n            tableSelection[0].removeListeners();\n            tableSelections.delete(nodeKey);\n            initializeTableNode(tableNode, nodeKey, tableElement);\n          }\n        } else if (mutation === 'destroyed') {\n          if (tableSelection !== undefined) {\n            tableSelection[0].removeListeners();\n            tableSelections.delete(nodeKey);\n          }\n        }\n      }\n    }, {\n      editor\n    });\n  }, {\n    skipInitialization: false\n  });\n  return () => {\n    unregisterMutationListener();\n    // Hook might be called multiple times so cleaning up tables listeners as well,\n    // as it'll be reinitialized during recurring call\n    for (const [, [tableSelection]] of tableSelections) {\n      tableSelection.removeListeners();\n    }\n  };\n}\n\n/**\n * Register the INSERT_TABLE_COMMAND listener and the table integrity transforms. The\n * table selection observer should be registered separately after this with\n * {@link registerTableSelectionObserver}.\n *\n * @param editor The editor\n * @returns An unregister callback\n */\nfunction registerTablePlugin(editor) {\n  if (!editor.hasNodes([TableNode])) {\n    {\n      formatDevErrorMessage(`TablePlugin: TableNode is not registered on editor`);\n    }\n  }\n  return (0,_lexical_utils__WEBPACK_IMPORTED_MODULE_1__.mergeRegister)(editor.registerCommand(INSERT_TABLE_COMMAND, $insertTableCommandListener, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.SELECTION_INSERT_CLIPBOARD_NODES_COMMAND, ({\n    nodes,\n    selection\n  }) => {\n    if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n      return false;\n    }\n    const isInsideTableCell = $findTableNode(selection.anchor.getNode()) !== null;\n    return isInsideTableCell && nodes.some($isTableNode);\n  }, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerCommand(lexical__WEBPACK_IMPORTED_MODULE_0__.CLICK_COMMAND, $tableClickCommand, lexical__WEBPACK_IMPORTED_MODULE_0__.COMMAND_PRIORITY_EDITOR), editor.registerNodeTransform(TableNode, $tableTransform), editor.registerNodeTransform(TableRowNode, $tableRowTransform), editor.registerNodeTransform(TableCellNode, $tableCellTransform));\n}\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@lexical/table/LexicalTable.dev.mjs\n");

/***/ }),

/***/ "(rsc)/./node_modules/@lexical/utils/LexicalUtils.dev.mjs":
/*!**********************************************************!*\
  !*** ./node_modules/@lexical/utils/LexicalUtils.dev.mjs ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   $descendantsMatching: () => (/* binding */ $descendantsMatching),\n/* harmony export */   $dfs: () => (/* binding */ $dfs),\n/* harmony export */   $dfsIterator: () => (/* binding */ $dfsIterator),\n/* harmony export */   $filter: () => (/* binding */ $filter),\n/* harmony export */   $findMatchingParent: () => (/* binding */ $findMatchingParent),\n/* harmony export */   $firstToLastIterator: () => (/* binding */ $firstToLastIterator),\n/* harmony export */   $getAdjacentCaret: () => (/* binding */ $getAdjacentCaret),\n/* harmony export */   $getAdjacentSiblingOrParentSiblingCaret: () => (/* binding */ $getAdjacentSiblingOrParentSiblingCaret),\n/* harmony export */   $getDepth: () => (/* binding */ $getDepth),\n/* harmony export */   $getNearestBlockElementAncestorOrThrow: () => (/* binding */ $getNearestBlockElementAncestorOrThrow),\n/* harmony export */   $getNearestNodeOfType: () => (/* binding */ $getNearestNodeOfType),\n/* harmony export */   $getNextRightPreorderNode: () => (/* binding */ $getNextRightPreorderNode),\n/* harmony export */   $getNextSiblingOrParentSibling: () => (/* binding */ $getNextSiblingOrParentSibling),\n/* harmony export */   $insertFirst: () => (/* binding */ $insertFirst),\n/* harmony export */   $insertNodeToNearestRoot: () => (/* binding */ $insertNodeToNearestRoot),\n/* harmony export */   $insertNodeToNearestRootAtCaret: () => (/* binding */ $insertNodeToNearestRootAtCaret),\n/* harmony export */   $isEditorIsNestedEditor: () => (/* binding */ $isEditorIsNestedEditor),\n/* harmony export */   $lastToFirstIterator: () => (/* binding */ $lastToFirstIterator),\n/* harmony export */   $restoreEditorState: () => (/* binding */ $restoreEditorState),\n/* harmony export */   $reverseDfs: () => (/* binding */ $reverseDfs),\n/* harmony export */   $reverseDfsIterator: () => (/* binding */ $reverseDfsIterator),\n/* harmony export */   $splitNode: () => (/* reexport safe */ lexical__WEBPACK_IMPORTED_MODULE_0__.$splitNode),\n/* harmony export */   $unwrapAndFilterDescendants: () => (/* binding */ $unwrapAndFilterDescendants),\n/* harmony export */   $unwrapNode: () => (/* binding */ $unwrapNode),\n/* harmony export */   $wrapNodeInElement: () => (/* binding */ $wrapNodeInElement),\n/* harmony export */   CAN_USE_BEFORE_INPUT: () => (/* binding */ CAN_USE_BEFORE_INPUT),\n/* harmony export */   CAN_USE_DOM: () => (/* binding */ CAN_USE_DOM),\n/* harmony export */   IS_ANDROID: () => (/* binding */ IS_ANDROID),\n/* harmony export */   IS_ANDROID_CHROME: () => (/* binding */ IS_ANDROID_CHROME),\n/* harmony export */   IS_APPLE: () => (/* binding */ IS_APPLE),\n/* harmony export */   IS_APPLE_WEBKIT: () => (/* binding */ IS_APPLE_WEBKIT),\n/* harmony export */   IS_CHROME: () => (/* binding */ IS_CHROME),\n/* harmony export */   IS_FIREFOX: () => (/* binding */ IS_FIREFOX),\n/* harmony export */   IS_IOS: () => (/* binding */ IS_IOS),\n/* harmony export */   IS_SAFARI: () => (/* binding */ IS_SAFARI),\n/* harmony export */   addClassNamesToElement: () => (/* binding */ addClassNamesToElement),\n/* harmony export */   calculateZoomLevel: () => (/* binding */ calculateZoomLevel),\n/* harmony export */   isBlockDomNode: () => (/* reexport safe */ lexical__WEBPACK_IMPORTED_MODULE_0__.isBlockDomNode),\n/* harmony export */   isHTMLAnchorElement: () => (/* reexport safe */ lexical__WEBPACK_IMPORTED_MODULE_0__.isHTMLAnchorElement),\n/* harmony export */   isHTMLElement: () => (/* reexport safe */ lexical__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement),\n/* harmony export */   isInlineDomNode: () => (/* reexport safe */ lexical__WEBPACK_IMPORTED_MODULE_0__.isInlineDomNode),\n/* harmony export */   isMimeType: () => (/* binding */ isMimeType),\n/* harmony export */   makeStateWrapper: () => (/* binding */ makeStateWrapper),\n/* harmony export */   markSelection: () => (/* binding */ markSelection),\n/* harmony export */   mediaFileReader: () => (/* binding */ mediaFileReader),\n/* harmony export */   mergeRegister: () => (/* binding */ mergeRegister),\n/* harmony export */   objectKlassEquals: () => (/* binding */ objectKlassEquals),\n/* harmony export */   positionNodeOnRange: () => (/* binding */ mlcPositionNodeOnRange),\n/* harmony export */   registerNestedElementResolver: () => (/* binding */ registerNestedElementResolver),\n/* harmony export */   removeClassNamesFromElement: () => (/* binding */ removeClassNamesFromElement),\n/* harmony export */   selectionAlwaysOnDisplay: () => (/* binding */ selectionAlwaysOnDisplay)\n/* harmony export */ });\n/* harmony import */ var lexical__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lexical */ \"(rsc)/./node_modules/lexical/Lexical.dev.mjs\");\n/* harmony import */ var _lexical_selection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lexical/selection */ \"(rsc)/./node_modules/@lexical/selection/LexicalSelection.dev.mjs\");\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\n\n\n\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\n// Do not require this module directly! Use normal `invariant` calls.\n\nfunction formatDevErrorMessage(message) {\n  throw new Error(message);\n}\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\nconst CAN_USE_DOM$1 = typeof window !== 'undefined' && typeof window.document !== 'undefined' && typeof window.document.createElement !== 'undefined';\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\nconst documentMode = CAN_USE_DOM$1 && 'documentMode' in document ? document.documentMode : null;\nconst IS_APPLE$1 = CAN_USE_DOM$1 && /Mac|iPod|iPhone|iPad/.test(navigator.platform);\nconst IS_FIREFOX$1 = CAN_USE_DOM$1 && /^(?!.*Seamonkey)(?=.*Firefox).*/i.test(navigator.userAgent);\nconst CAN_USE_BEFORE_INPUT$1 = CAN_USE_DOM$1 && 'InputEvent' in window && !documentMode ? 'getTargetRanges' in new window.InputEvent('input') : false;\nconst IS_SAFARI$1 = CAN_USE_DOM$1 && /Version\\/[\\d.]+.*Safari/.test(navigator.userAgent);\nconst IS_IOS$1 = CAN_USE_DOM$1 && /iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream;\nconst IS_ANDROID$1 = CAN_USE_DOM$1 && /Android/.test(navigator.userAgent);\n\n// Keep these in case we need to use them in the future.\n// export const IS_WINDOWS: boolean = CAN_USE_DOM && /Win/.test(navigator.platform);\nconst IS_CHROME$1 = CAN_USE_DOM$1 && /^(?=.*Chrome).*/i.test(navigator.userAgent);\n// export const canUseTextInputEvent: boolean = CAN_USE_DOM && 'TextEvent' in window && !documentMode;\n\nconst IS_ANDROID_CHROME$1 = CAN_USE_DOM$1 && IS_ANDROID$1 && IS_CHROME$1;\nconst IS_APPLE_WEBKIT$1 = CAN_USE_DOM$1 && /AppleWebKit\\/[\\d.]+/.test(navigator.userAgent) && !IS_CHROME$1;\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\nfunction normalizeClassNames(...classNames) {\n  const rval = [];\n  for (const className of classNames) {\n    if (className && typeof className === 'string') {\n      for (const [s] of className.matchAll(/\\S+/g)) {\n        rval.push(s);\n      }\n    }\n  }\n  return rval;\n}\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\n/**\n * Returns a function that will execute all functions passed when called. It is generally used\n * to register multiple lexical listeners and then tear them down with a single function call, such\n * as React's useEffect hook.\n * @example\n * ```ts\n * useEffect(() => {\n *   return mergeRegister(\n *     editor.registerCommand(...registerCommand1 logic),\n *     editor.registerCommand(...registerCommand2 logic),\n *     editor.registerCommand(...registerCommand3 logic)\n *   )\n * }, [editor])\n * ```\n * In this case, useEffect is returning the function returned by mergeRegister as a cleanup\n * function to be executed after either the useEffect runs again (due to one of its dependencies\n * updating) or the component it resides in unmounts.\n * Note the functions don't neccesarily need to be in an array as all arguments\n * are considered to be the func argument and spread from there.\n * The order of cleanup is the reverse of the argument order. Generally it is\n * expected that the first \"acquire\" will be \"released\" last (LIFO order),\n * because a later step may have some dependency on an earlier one.\n * @param func - An array of cleanup functions meant to be executed by the returned function.\n * @returns the function which executes all the passed cleanup functions.\n */\nfunction mergeRegister(...func) {\n  return () => {\n    for (let i = func.length - 1; i >= 0; i--) {\n      func[i]();\n    }\n    // Clean up the references and make future calls a no-op\n    func.length = 0;\n  };\n}\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\nfunction px(value) {\n  return `${value}px`;\n}\n\nconst mutationObserverConfig = {\n  attributes: true,\n  characterData: true,\n  childList: true,\n  subtree: true\n};\nfunction prependDOMNode(parent, node) {\n  parent.insertBefore(node, parent.firstChild);\n}\n\n/**\n * Place one or multiple newly created Nodes at the passed Range's position.\n * Multiple nodes will only be created when the Range spans multiple lines (aka\n * client rects).\n *\n * This function can come particularly useful to highlight particular parts of\n * the text without interfering with the EditorState, that will often replicate\n * the state across collab and clipboard.\n *\n * This function accounts for DOM updates which can modify the passed Range.\n * Hence, the function return to remove the listener.\n */\nfunction mlcPositionNodeOnRange(editor, range, onReposition) {\n  let rootDOMNode = null;\n  let parentDOMNode = null;\n  let observer = null;\n  let lastNodes = [];\n  const wrapperNode = document.createElement('div');\n  wrapperNode.style.position = 'relative';\n  function position() {\n    if (!(rootDOMNode !== null)) {\n      formatDevErrorMessage(`Unexpected null rootDOMNode`);\n    }\n    if (!(parentDOMNode !== null)) {\n      formatDevErrorMessage(`Unexpected null parentDOMNode`);\n    }\n    const {\n      left: parentLeft,\n      top: parentTop\n    } = parentDOMNode.getBoundingClientRect();\n    const rects = (0,_lexical_selection__WEBPACK_IMPORTED_MODULE_1__.createRectsFromDOMRange)(editor, range);\n    if (!wrapperNode.isConnected) {\n      prependDOMNode(parentDOMNode, wrapperNode);\n    }\n    let hasRepositioned = false;\n    for (let i = 0; i < rects.length; i++) {\n      const rect = rects[i];\n      // Try to reuse the previously created Node when possible, no need to\n      // remove/create on the most common case reposition case\n      const rectNode = lastNodes[i] || document.createElement('div');\n      const rectNodeStyle = rectNode.style;\n      if (rectNodeStyle.position !== 'absolute') {\n        rectNodeStyle.position = 'absolute';\n        hasRepositioned = true;\n      }\n      const left = px(rect.left - parentLeft);\n      if (rectNodeStyle.left !== left) {\n        rectNodeStyle.left = left;\n        hasRepositioned = true;\n      }\n      const top = px(rect.top - parentTop);\n      if (rectNodeStyle.top !== top) {\n        rectNode.style.top = top;\n        hasRepositioned = true;\n      }\n      const width = px(rect.width);\n      if (rectNodeStyle.width !== width) {\n        rectNode.style.width = width;\n        hasRepositioned = true;\n      }\n      const height = px(rect.height);\n      if (rectNodeStyle.height !== height) {\n        rectNode.style.height = height;\n        hasRepositioned = true;\n      }\n      if (rectNode.parentNode !== wrapperNode) {\n        wrapperNode.append(rectNode);\n        hasRepositioned = true;\n      }\n      lastNodes[i] = rectNode;\n    }\n    while (lastNodes.length > rects.length) {\n      lastNodes.pop();\n    }\n    if (hasRepositioned) {\n      onReposition(lastNodes);\n    }\n  }\n  function stop() {\n    parentDOMNode = null;\n    rootDOMNode = null;\n    if (observer !== null) {\n      observer.disconnect();\n    }\n    observer = null;\n    wrapperNode.remove();\n    for (const node of lastNodes) {\n      node.remove();\n    }\n    lastNodes = [];\n  }\n  function restart() {\n    const currentRootDOMNode = editor.getRootElement();\n    if (currentRootDOMNode === null) {\n      return stop();\n    }\n    const currentParentDOMNode = currentRootDOMNode.parentElement;\n    if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(currentParentDOMNode)) {\n      return stop();\n    }\n    stop();\n    rootDOMNode = currentRootDOMNode;\n    parentDOMNode = currentParentDOMNode;\n    observer = new MutationObserver(mutations => {\n      const nextRootDOMNode = editor.getRootElement();\n      const nextParentDOMNode = nextRootDOMNode && nextRootDOMNode.parentElement;\n      if (nextRootDOMNode !== rootDOMNode || nextParentDOMNode !== parentDOMNode) {\n        return restart();\n      }\n      for (const mutation of mutations) {\n        if (!wrapperNode.contains(mutation.target)) {\n          // TODO throttle\n          return position();\n        }\n      }\n    });\n    observer.observe(currentParentDOMNode, mutationObserverConfig);\n    position();\n  }\n  const removeRootListener = editor.registerRootListener(restart);\n  return () => {\n    removeRootListener();\n    stop();\n  };\n}\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\nfunction rangeTargetFromPoint(point, node, dom) {\n  if (point.type === 'text' || !(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(node)) {\n    const textDOM = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.getDOMTextNode)(dom) || dom;\n    return [textDOM, point.offset];\n  } else {\n    const slot = node.getDOMSlot(dom);\n    return [slot.element, slot.getFirstChildOffset() + point.offset];\n  }\n}\nfunction rangeFromPoints(editor, anchor, anchorNode, anchorDOM, focus, focusNode, focusDOM) {\n  const editorDocument = editor._window ? editor._window.document : document;\n  const range = editorDocument.createRange();\n  if (focusNode.isBefore(anchorNode)) {\n    range.setStart(...rangeTargetFromPoint(focus, focusNode, focusDOM));\n    range.setEnd(...rangeTargetFromPoint(anchor, anchorNode, anchorDOM));\n  } else {\n    range.setStart(...rangeTargetFromPoint(anchor, anchorNode, anchorDOM));\n    range.setEnd(...rangeTargetFromPoint(focus, focusNode, focusDOM));\n  }\n  return range;\n}\n/**\n * Place one or multiple newly created Nodes at the current selection. Multiple\n * nodes will only be created when the selection spans multiple lines (aka\n * client rects).\n *\n * This function can come useful when you want to show the selection but the\n * editor has been focused away.\n */\nfunction markSelection(editor, onReposition) {\n  let previousAnchorNode = null;\n  let previousAnchorNodeDOM = null;\n  let previousAnchorOffset = null;\n  let previousFocusNode = null;\n  let previousFocusNodeDOM = null;\n  let previousFocusOffset = null;\n  let removeRangeListener = () => {};\n  function compute(editorState) {\n    editorState.read(() => {\n      const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)();\n      if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n        // TODO\n        previousAnchorNode = null;\n        previousAnchorOffset = null;\n        previousFocusNode = null;\n        previousFocusOffset = null;\n        removeRangeListener();\n        removeRangeListener = () => {};\n        return;\n      }\n      const {\n        anchor,\n        focus\n      } = selection;\n      const currentAnchorNode = anchor.getNode();\n      const currentAnchorNodeKey = currentAnchorNode.getKey();\n      const currentAnchorOffset = anchor.offset;\n      const currentFocusNode = focus.getNode();\n      const currentFocusNodeKey = currentFocusNode.getKey();\n      const currentFocusOffset = focus.offset;\n      const currentAnchorNodeDOM = editor.getElementByKey(currentAnchorNodeKey);\n      const currentFocusNodeDOM = editor.getElementByKey(currentFocusNodeKey);\n      const differentAnchorDOM = previousAnchorNode === null || currentAnchorNodeDOM !== previousAnchorNodeDOM || currentAnchorOffset !== previousAnchorOffset || currentAnchorNodeKey !== previousAnchorNode.getKey();\n      const differentFocusDOM = previousFocusNode === null || currentFocusNodeDOM !== previousFocusNodeDOM || currentFocusOffset !== previousFocusOffset || currentFocusNodeKey !== previousFocusNode.getKey();\n      if ((differentAnchorDOM || differentFocusDOM) && currentAnchorNodeDOM !== null && currentFocusNodeDOM !== null) {\n        const range = rangeFromPoints(editor, anchor, currentAnchorNode, currentAnchorNodeDOM, focus, currentFocusNode, currentFocusNodeDOM);\n        removeRangeListener();\n        removeRangeListener = mlcPositionNodeOnRange(editor, range, domNodes => {\n          if (onReposition === undefined) {\n            for (const domNode of domNodes) {\n              const domNodeStyle = domNode.style;\n              if (domNodeStyle.background !== 'Highlight') {\n                domNodeStyle.background = 'Highlight';\n              }\n              if (domNodeStyle.color !== 'HighlightText') {\n                domNodeStyle.color = 'HighlightText';\n              }\n              if (domNodeStyle.marginTop !== px(-1.5)) {\n                domNodeStyle.marginTop = px(-1.5);\n              }\n              if (domNodeStyle.paddingTop !== px(4)) {\n                domNodeStyle.paddingTop = px(4);\n              }\n              if (domNodeStyle.paddingBottom !== px(0)) {\n                domNodeStyle.paddingBottom = px(0);\n              }\n            }\n          } else {\n            onReposition(domNodes);\n          }\n        });\n      }\n      previousAnchorNode = currentAnchorNode;\n      previousAnchorNodeDOM = currentAnchorNodeDOM;\n      previousAnchorOffset = currentAnchorOffset;\n      previousFocusNode = currentFocusNode;\n      previousFocusNodeDOM = currentFocusNodeDOM;\n      previousFocusOffset = currentFocusOffset;\n    });\n  }\n  compute(editor.getEditorState());\n  return mergeRegister(editor.registerUpdateListener(({\n    editorState\n  }) => compute(editorState)), () => {\n    removeRangeListener();\n  });\n}\n\n/**\n * Copyright (c) Meta Platforms, Inc. and affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n *\n */\n\nfunction selectionAlwaysOnDisplay(editor) {\n  let removeSelectionMark = null;\n  const onSelectionChange = () => {\n    const domSelection = getSelection();\n    const domAnchorNode = domSelection && domSelection.anchorNode;\n    const editorRootElement = editor.getRootElement();\n    const isSelectionInsideEditor = domAnchorNode !== null && editorRootElement !== null && editorRootElement.contains(domAnchorNode);\n    if (isSelectionInsideEditor) {\n      if (removeSelectionMark !== null) {\n        removeSelectionMark();\n        removeSelectionMark = null;\n      }\n    } else {\n      if (removeSelectionMark === null) {\n        removeSelectionMark = markSelection(editor);\n      }\n    }\n  };\n  document.addEventListener('selectionchange', onSelectionChange);\n  return () => {\n    if (removeSelectionMark !== null) {\n      removeSelectionMark();\n    }\n    document.removeEventListener('selectionchange', onSelectionChange);\n  };\n}\n\n// Hotfix to export these with inlined types #5918\nconst CAN_USE_BEFORE_INPUT = CAN_USE_BEFORE_INPUT$1;\nconst CAN_USE_DOM = CAN_USE_DOM$1;\nconst IS_ANDROID = IS_ANDROID$1;\nconst IS_ANDROID_CHROME = IS_ANDROID_CHROME$1;\nconst IS_APPLE = IS_APPLE$1;\nconst IS_APPLE_WEBKIT = IS_APPLE_WEBKIT$1;\nconst IS_CHROME = IS_CHROME$1;\nconst IS_FIREFOX = IS_FIREFOX$1;\nconst IS_IOS = IS_IOS$1;\nconst IS_SAFARI = IS_SAFARI$1;\n\n/**\n * Takes an HTML element and adds the classNames passed within an array,\n * ignoring any non-string types. A space can be used to add multiple classes\n * eg. addClassNamesToElement(element, ['element-inner active', true, null])\n * will add both 'element-inner' and 'active' as classes to that element.\n * @param element - The element in which the classes are added\n * @param classNames - An array defining the class names to add to the element\n */\nfunction addClassNamesToElement(element, ...classNames) {\n  const classesToAdd = normalizeClassNames(...classNames);\n  if (classesToAdd.length > 0) {\n    element.classList.add(...classesToAdd);\n  }\n}\n\n/**\n * Takes an HTML element and removes the classNames passed within an array,\n * ignoring any non-string types. A space can be used to remove multiple classes\n * eg. removeClassNamesFromElement(element, ['active small', true, null])\n * will remove both the 'active' and 'small' classes from that element.\n * @param element - The element in which the classes are removed\n * @param classNames - An array defining the class names to remove from the element\n */\nfunction removeClassNamesFromElement(element, ...classNames) {\n  const classesToRemove = normalizeClassNames(...classNames);\n  if (classesToRemove.length > 0) {\n    element.classList.remove(...classesToRemove);\n  }\n}\n\n/**\n * Returns true if the file type matches the types passed within the acceptableMimeTypes array, false otherwise.\n * The types passed must be strings and are CASE-SENSITIVE.\n * eg. if file is of type 'text' and acceptableMimeTypes = ['TEXT', 'IMAGE'] the function will return false.\n * @param file - The file you want to type check.\n * @param acceptableMimeTypes - An array of strings of types which the file is checked against.\n * @returns true if the file is an acceptable mime type, false otherwise.\n */\nfunction isMimeType(file, acceptableMimeTypes) {\n  for (const acceptableType of acceptableMimeTypes) {\n    if (file.type.startsWith(acceptableType)) {\n      return true;\n    }\n  }\n  return false;\n}\n\n/**\n * Lexical File Reader with:\n *  1. MIME type support\n *  2. batched results (HistoryPlugin compatibility)\n *  3. Order aware (respects the order when multiple Files are passed)\n *\n * const filesResult = await mediaFileReader(files, ['image/']);\n * filesResult.forEach(file => editor.dispatchCommand('INSERT_IMAGE', \\\\{\n *   src: file.result,\n * \\\\}));\n */\nfunction mediaFileReader(files, acceptableMimeTypes) {\n  const filesIterator = files[Symbol.iterator]();\n  return new Promise((resolve, reject) => {\n    const processed = [];\n    const handleNextFile = () => {\n      const {\n        done,\n        value: file\n      } = filesIterator.next();\n      if (done) {\n        return resolve(processed);\n      }\n      const fileReader = new FileReader();\n      fileReader.addEventListener('error', reject);\n      fileReader.addEventListener('load', () => {\n        const result = fileReader.result;\n        if (typeof result === 'string') {\n          processed.push({\n            file,\n            result\n          });\n        }\n        handleNextFile();\n      });\n      if (isMimeType(file, acceptableMimeTypes)) {\n        fileReader.readAsDataURL(file);\n      } else {\n        handleNextFile();\n      }\n    };\n    handleNextFile();\n  });\n}\n/**\n * \"Depth-First Search\" starts at the root/top node of a tree and goes as far as it can down a branch end\n * before backtracking and finding a new path. Consider solving a maze by hugging either wall, moving down a\n * branch until you hit a dead-end (leaf) and backtracking to find the nearest branching path and repeat.\n * It will then return all the nodes found in the search in an array of objects.\n * @param startNode - The node to start the search, if omitted, it will start at the root node.\n * @param endNode - The node to end the search, if omitted, it will find all descendants of the startingNode.\n * @returns An array of objects of all the nodes found by the search, including their depth into the tree.\n * \\\\{depth: number, node: LexicalNode\\\\} It will always return at least 1 node (the start node).\n */\nfunction $dfs(startNode, endNode) {\n  return Array.from($dfsIterator(startNode, endNode));\n}\n\n/**\n * Get the adjacent caret in the same direction\n *\n * @param caret A caret or null\n * @returns `caret.getAdjacentCaret()` or `null`\n */\nfunction $getAdjacentCaret(caret) {\n  return caret ? caret.getAdjacentCaret() : null;\n}\n\n/**\n * $dfs iterator (right to left). Tree traversal is done on the fly as new values are requested with O(1) memory.\n * @param startNode - The node to start the search, if omitted, it will start at the root node.\n * @param endNode - The node to end the search, if omitted, it will find all descendants of the startingNode.\n * @returns An iterator, each yielded value is a DFSNode. It will always return at least 1 node (the start node).\n */\nfunction $reverseDfs(startNode, endNode) {\n  return Array.from($reverseDfsIterator(startNode, endNode));\n}\n\n/**\n * $dfs iterator (left to right). Tree traversal is done on the fly as new values are requested with O(1) memory.\n * @param startNode - The node to start the search, if omitted, it will start at the root node.\n * @param endNode - The node to end the search, if omitted, it will find all descendants of the startingNode.\n * @returns An iterator, each yielded value is a DFSNode. It will always return at least 1 node (the start node).\n */\nfunction $dfsIterator(startNode, endNode) {\n  return $dfsCaretIterator('next', startNode, endNode);\n}\nfunction $getEndCaret(startNode, direction) {\n  const rval = $getAdjacentSiblingOrParentSiblingCaret((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSiblingCaret)(startNode, direction));\n  return rval && rval[0];\n}\nfunction $dfsCaretIterator(direction, startNode, endNode) {\n  const root = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getRoot)();\n  const start = startNode || root;\n  const startCaret = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(start) ? (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getChildCaret)(start, direction) : (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSiblingCaret)(start, direction);\n  const startDepth = $getDepth(start);\n  const endCaret = endNode ? (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getAdjacentChildCaret)((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getChildCaretOrSelf)((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSiblingCaret)(endNode, direction))) : $getEndCaret(start, direction);\n  let depth = startDepth;\n  return (0,lexical__WEBPACK_IMPORTED_MODULE_0__.makeStepwiseIterator)({\n    hasNext: state => state !== null,\n    initial: startCaret,\n    map: state => ({\n      depth,\n      node: state.origin\n    }),\n    step: state => {\n      if (state.isSameNodeCaret(endCaret)) {\n        return null;\n      }\n      if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isChildCaret)(state)) {\n        depth++;\n      }\n      const rval = $getAdjacentSiblingOrParentSiblingCaret(state);\n      if (!rval || rval[0].isSameNodeCaret(endCaret)) {\n        return null;\n      }\n      depth += rval[1];\n      return rval[0];\n    }\n  });\n}\n\n/**\n * Returns the Node sibling when this exists, otherwise the closest parent sibling. For example\n * R -> P -> T1, T2\n *   -> P2\n * returns T2 for node T1, P2 for node T2, and null for node P2.\n * @param node LexicalNode.\n * @returns An array (tuple) containing the found Lexical node and the depth difference, or null, if this node doesn't exist.\n */\nfunction $getNextSiblingOrParentSibling(node) {\n  const rval = $getAdjacentSiblingOrParentSiblingCaret((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSiblingCaret)(node, 'next'));\n  return rval && [rval[0].origin, rval[1]];\n}\nfunction $getDepth(node) {\n  let depth = -1;\n  for (let innerNode = node; innerNode !== null; innerNode = innerNode.getParent()) {\n    depth++;\n  }\n  return depth;\n}\n\n/**\n * Performs a right-to-left preorder tree traversal.\n * From the starting node it goes to the rightmost child, than backtracks to parent and finds new rightmost path.\n * It will return the next node in traversal sequence after the startingNode.\n * The traversal is similar to $dfs functions above, but the nodes are visited right-to-left, not left-to-right.\n * @param startingNode - The node to start the search.\n * @returns The next node in pre-order right to left traversal sequence or `null`, if the node does not exist\n */\nfunction $getNextRightPreorderNode(startingNode) {\n  const startCaret = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getChildCaretOrSelf)((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSiblingCaret)(startingNode, 'previous'));\n  const next = $getAdjacentSiblingOrParentSiblingCaret(startCaret, 'root');\n  return next && next[0].origin;\n}\n\n/**\n * $dfs iterator (right to left). Tree traversal is done on the fly as new values are requested with O(1) memory.\n * @param startNode - The node to start the search, if omitted, it will start at the root node.\n * @param endNode - The node to end the search, if omitted, it will find all descendants of the startingNode.\n * @returns An iterator, each yielded value is a DFSNode. It will always return at least 1 node (the start node).\n */\nfunction $reverseDfsIterator(startNode, endNode) {\n  return $dfsCaretIterator('previous', startNode, endNode);\n}\n\n/**\n * Takes a node and traverses up its ancestors (toward the root node)\n * in order to find a specific type of node.\n * @param node - the node to begin searching.\n * @param klass - an instance of the type of node to look for.\n * @returns the node of type klass that was passed, or null if none exist.\n */\nfunction $getNearestNodeOfType(node, klass) {\n  let parent = node;\n  while (parent != null) {\n    if (parent instanceof klass) {\n      return parent;\n    }\n    parent = parent.getParent();\n  }\n  return null;\n}\n\n/**\n * Returns the element node of the nearest ancestor, otherwise throws an error.\n * @param startNode - The starting node of the search\n * @returns The ancestor node found\n */\nfunction $getNearestBlockElementAncestorOrThrow(startNode) {\n  const blockNode = $findMatchingParent(startNode, node => (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(node) && !node.isInline());\n  if (!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(blockNode)) {\n    {\n      formatDevErrorMessage(`Expected node ${startNode.__key} to have closest block element node.`);\n    }\n  }\n  return blockNode;\n}\n/**\n * Starts with a node and moves up the tree (toward the root node) to find a matching node based on\n * the search parameters of the findFn. (Consider JavaScripts' .find() function where a testing function must be\n * passed as an argument. eg. if( (node) => node.__type === 'div') ) return true; otherwise return false\n * @param startingNode - The node where the search starts.\n * @param findFn - A testing function that returns true if the current node satisfies the testing parameters.\n * @returns A parent node that matches the findFn parameters, or null if one wasn't found.\n */\nconst $findMatchingParent = (startingNode, findFn) => {\n  let curr = startingNode;\n  while (curr !== (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getRoot)() && curr != null) {\n    if (findFn(curr)) {\n      return curr;\n    }\n    curr = curr.getParent();\n  }\n  return null;\n};\n\n/**\n * Attempts to resolve nested element nodes of the same type into a single node of that type.\n * It is generally used for marks/commenting\n * @param editor - The lexical editor\n * @param targetNode - The target for the nested element to be extracted from.\n * @param cloneNode - See {@link $createMarkNode}\n * @param handleOverlap - Handles any overlap between the node to extract and the targetNode\n * @returns The lexical editor\n */\nfunction registerNestedElementResolver(editor, targetNode, cloneNode, handleOverlap) {\n  const $isTargetNode = node => {\n    return node instanceof targetNode;\n  };\n  const $findMatch = node => {\n    // First validate we don't have any children that are of the target,\n    // as we need to handle them first.\n    const children = node.getChildren();\n    for (let i = 0; i < children.length; i++) {\n      const child = children[i];\n      if ($isTargetNode(child)) {\n        return null;\n      }\n    }\n    let parentNode = node;\n    let childNode = node;\n    while (parentNode !== null) {\n      childNode = parentNode;\n      parentNode = parentNode.getParent();\n      if ($isTargetNode(parentNode)) {\n        return {\n          child: childNode,\n          parent: parentNode\n        };\n      }\n    }\n    return null;\n  };\n  const $elementNodeTransform = node => {\n    const match = $findMatch(node);\n    if (match !== null) {\n      const {\n        child,\n        parent\n      } = match;\n\n      // Simple path, we can move child out and siblings into a new parent.\n\n      if (child.is(node)) {\n        handleOverlap(parent, node);\n        const nextSiblings = child.getNextSiblings();\n        const nextSiblingsLength = nextSiblings.length;\n        parent.insertAfter(child);\n        if (nextSiblingsLength !== 0) {\n          const newParent = cloneNode(parent);\n          child.insertAfter(newParent);\n          for (let i = 0; i < nextSiblingsLength; i++) {\n            newParent.append(nextSiblings[i]);\n          }\n        }\n        if (!parent.canBeEmpty() && parent.getChildrenSize() === 0) {\n          parent.remove();\n        }\n      }\n    }\n  };\n  return editor.registerNodeTransform(targetNode, $elementNodeTransform);\n}\n\n/**\n * Clones the editor and marks it as dirty to be reconciled. If there was a selection,\n * it would be set back to its previous state, or null otherwise.\n * @param editor - The lexical editor\n * @param editorState - The editor's state\n */\nfunction $restoreEditorState(editor, editorState) {\n  const FULL_RECONCILE = 2;\n  const nodeMap = new Map();\n  const activeEditorState = editor._pendingEditorState;\n  for (const [key, node] of editorState._nodeMap) {\n    nodeMap.set(key, (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$cloneWithProperties)(node));\n  }\n  if (activeEditorState) {\n    activeEditorState._nodeMap = nodeMap;\n  }\n  editor._dirtyType = FULL_RECONCILE;\n  const selection = editorState._selection;\n  (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$setSelection)(selection === null ? null : selection.clone());\n}\n\n/**\n * If the selected insertion area is the root/shadow root node (see {@link lexical!$isRootOrShadowRoot}),\n * the node will be appended there, otherwise, it will be inserted before the insertion area.\n * If there is no selection where the node is to be inserted, it will be appended after any current nodes\n * within the tree, as a child of the root node. A paragraph will then be added after the inserted node and selected.\n * @param node - The node to be inserted\n * @returns The node after its insertion\n */\nfunction $insertNodeToNearestRoot(node) {\n  const selection = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSelection)() || (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getPreviousSelection)();\n  let initialCaret;\n  if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isRangeSelection)(selection)) {\n    initialCaret = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$caretFromPoint)(selection.focus, 'next');\n  } else {\n    if (selection != null) {\n      const nodes = selection.getNodes();\n      const lastNode = nodes[nodes.length - 1];\n      if (lastNode) {\n        initialCaret = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSiblingCaret)(lastNode, 'next');\n      }\n    }\n    initialCaret = initialCaret || (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getChildCaret)((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getRoot)(), 'previous').getFlipped().insert((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)());\n  }\n  const insertCaret = $insertNodeToNearestRootAtCaret(node, initialCaret);\n  const adjacent = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getAdjacentChildCaret)(insertCaret);\n  const selectionCaret = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isChildCaret)(adjacent) ? (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$normalizeCaret)(adjacent) : insertCaret;\n  (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$setSelectionFromCaretRange)((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getCollapsedCaretRange)(selectionCaret));\n  return node.getLatest();\n}\n\n/**\n * If the insertion caret is the root/shadow root node (see {@link lexical!$isRootOrShadowRoot}),\n * the node will be inserted there, otherwise the parent nodes will be split according to the\n * given options.\n * @param node - The node to be inserted\n * @param caret - The location to insert or split from\n * @returns The node after its insertion\n */\nfunction $insertNodeToNearestRootAtCaret(node, caret, options) {\n  let insertCaret = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getCaretInDirection)(caret, 'next');\n  for (let nextCaret = insertCaret; nextCaret; nextCaret = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$splitAtPointCaretNext)(nextCaret, options)) {\n    insertCaret = nextCaret;\n  }\n  if (!!(0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isTextPointCaret)(insertCaret)) {\n    formatDevErrorMessage(`$insertNodeToNearestRootAtCaret: An unattached TextNode can not be split`);\n  }\n  insertCaret.insert(node.isInline() ? (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$createParagraphNode)().append(node) : node);\n  return (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getCaretInDirection)((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSiblingCaret)(node.getLatest(), 'next'), caret.direction);\n}\n\n/**\n * Wraps the node into another node created from a createElementNode function, eg. $createParagraphNode\n * @param node - Node to be wrapped.\n * @param createElementNode - Creates a new lexical element to wrap the to-be-wrapped node and returns it.\n * @returns A new lexical element with the previous node appended within (as a child, including its children).\n */\nfunction $wrapNodeInElement(node, createElementNode) {\n  const elementNode = createElementNode();\n  node.replace(elementNode);\n  elementNode.append(node);\n  return elementNode;\n}\n\n// eslint-disable-next-line @typescript-eslint/no-explicit-any\n\n/**\n * @param object = The instance of the type\n * @param objectClass = The class of the type\n * @returns Whether the object is has the same Klass of the objectClass, ignoring the difference across window (e.g. different iframs)\n */\nfunction objectKlassEquals(object, objectClass) {\n  return object !== null ? Object.getPrototypeOf(object).constructor.name === objectClass.name : false;\n}\n\n/**\n * Filter the nodes\n * @param nodes Array of nodes that needs to be filtered\n * @param filterFn A filter function that returns node if the current node satisfies the condition otherwise null\n * @returns Array of filtered nodes\n */\n\nfunction $filter(nodes, filterFn) {\n  const result = [];\n  for (let i = 0; i < nodes.length; i++) {\n    const node = filterFn(nodes[i]);\n    if (node !== null) {\n      result.push(node);\n    }\n  }\n  return result;\n}\n/**\n * Appends the node before the first child of the parent node\n * @param parent A parent node\n * @param node Node that needs to be appended\n */\nfunction $insertFirst(parent, node) {\n  (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getChildCaret)(parent, 'next').insert(node);\n}\nlet NEEDS_MANUAL_ZOOM = IS_FIREFOX || !CAN_USE_DOM ? false : undefined;\nfunction needsManualZoom() {\n  if (NEEDS_MANUAL_ZOOM === undefined) {\n    // If the browser implements standardized CSS zoom, then the client rect\n    // will be wider after zoom is applied\n    // https://chromestatus.com/feature/5198254868529152\n    // https://github.com/facebook/lexical/issues/6863\n    const div = document.createElement('div');\n    div.style.cssText = 'position: absolute; opacity: 0; width: 100px; left: -1000px;';\n    document.body.appendChild(div);\n    const noZoom = div.getBoundingClientRect();\n    div.style.setProperty('zoom', '2');\n    NEEDS_MANUAL_ZOOM = div.getBoundingClientRect().width === noZoom.width;\n    document.body.removeChild(div);\n  }\n  return NEEDS_MANUAL_ZOOM;\n}\n\n/**\n * Calculates the zoom level of an element as a result of using\n * css zoom property. For browsers that implement standardized CSS\n * zoom (Firefox, Chrome >= 128), this will always return 1.\n * @param element\n */\nfunction calculateZoomLevel(element) {\n  let zoom = 1;\n  if (needsManualZoom()) {\n    while (element) {\n      zoom *= Number(window.getComputedStyle(element).getPropertyValue('zoom'));\n      element = element.parentElement;\n    }\n  }\n  return zoom;\n}\n\n/**\n * Checks if the editor is a nested editor created by LexicalNestedComposer\n */\nfunction $isEditorIsNestedEditor(editor) {\n  return editor._parentEditor !== null;\n}\n\n/**\n * A depth first last-to-first traversal of root that stops at each node that matches\n * $predicate and ensures that its parent is root. This is typically used to discard\n * invalid or unsupported wrapping nodes. For example, a TableNode must only have\n * TableRowNode as children, but an importer might add invalid nodes based on\n * caption, tbody, thead, etc. and this will unwrap and discard those.\n *\n * @param root The root to start the traversal\n * @param $predicate Should return true for nodes that are permitted to be children of root\n * @returns true if this unwrapped or removed any nodes\n */\nfunction $unwrapAndFilterDescendants(root, $predicate) {\n  return $unwrapAndFilterDescendantsImpl(root, $predicate, null);\n}\nfunction $unwrapAndFilterDescendantsImpl(root, $predicate, $onSuccess) {\n  let didMutate = false;\n  for (const node of $lastToFirstIterator(root)) {\n    if ($predicate(node)) {\n      if ($onSuccess !== null) {\n        $onSuccess(node);\n      }\n      continue;\n    }\n    didMutate = true;\n    if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(node)) {\n      $unwrapAndFilterDescendantsImpl(node, $predicate, $onSuccess || (child => node.insertAfter(child)));\n    }\n    node.remove();\n  }\n  return didMutate;\n}\n\n/**\n * A depth first traversal of the children array that stops at and collects\n * each node that `$predicate` matches. This is typically used to discard\n * invalid or unsupported wrapping nodes on a children array in the `after`\n * of an {@link lexical!DOMConversionOutput}. For example, a TableNode must only have\n * TableRowNode as children, but an importer might add invalid nodes based on\n * caption, tbody, thead, etc. and this will unwrap and discard those.\n *\n * This function is read-only and performs no mutation operations, which makes\n * it suitable for import and export purposes but likely not for any in-place\n * mutation. You should use {@link $unwrapAndFilterDescendants} for in-place\n * mutations such as node transforms.\n *\n * @param children The children to traverse\n * @param $predicate Should return true for nodes that are permitted to be children of root\n * @returns The children or their descendants that match $predicate\n */\n\nfunction $descendantsMatching(children, $predicate) {\n  const result = [];\n  const stack = Array.from(children).reverse();\n  for (let child = stack.pop(); child !== undefined; child = stack.pop()) {\n    if ($predicate(child)) {\n      result.push(child);\n    } else if ((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$isElementNode)(child)) {\n      for (const grandchild of $lastToFirstIterator(child)) {\n        stack.push(grandchild);\n      }\n    }\n  }\n  return result;\n}\n\n/**\n * Return an iterator that yields each child of node from first to last, taking\n * care to preserve the next sibling before yielding the value in case the caller\n * removes the yielded node.\n *\n * @param node The node whose children to iterate\n * @returns An iterator of the node's children\n */\nfunction $firstToLastIterator(node) {\n  return $childIterator((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getChildCaret)(node, 'next'));\n}\n\n/**\n * Return an iterator that yields each child of node from last to first, taking\n * care to preserve the previous sibling before yielding the value in case the caller\n * removes the yielded node.\n *\n * @param node The node whose children to iterate\n * @returns An iterator of the node's children\n */\nfunction $lastToFirstIterator(node) {\n  return $childIterator((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getChildCaret)(node, 'previous'));\n}\nfunction $childIterator(startCaret) {\n  const seen = new Set() ;\n  return (0,lexical__WEBPACK_IMPORTED_MODULE_0__.makeStepwiseIterator)({\n    hasNext: lexical__WEBPACK_IMPORTED_MODULE_0__.$isSiblingCaret,\n    initial: startCaret.getAdjacentCaret(),\n    map: caret => {\n      const origin = caret.origin.getLatest();\n      if (seen !== null) {\n        const key = origin.getKey();\n        if (!!seen.has(key)) {\n          formatDevErrorMessage(`$childIterator: Cycle detected, node with key ${String(key)} has already been traversed`);\n        }\n        seen.add(key);\n      }\n      return origin;\n    },\n    step: caret => caret.getAdjacentCaret()\n  });\n}\n\n/**\n * Replace this node with its children\n *\n * @param node The ElementNode to unwrap and remove\n */\nfunction $unwrapNode(node) {\n  (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$rewindSiblingCaret)((0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getSiblingCaret)(node, 'next')).splice(1, node.getChildren());\n}\n\n/**\n * Returns the Node sibling when this exists, otherwise the closest parent sibling. For example\n * R -> P -> T1, T2\n *   -> P2\n * returns T2 for node T1, P2 for node T2, and null for node P2.\n * @param node LexicalNode.\n * @returns An array (tuple) containing the found Lexical node and the depth difference, or null, if this node doesn't exist.\n */\nfunction $getAdjacentSiblingOrParentSiblingCaret(startCaret, rootMode = 'root') {\n  let depthDiff = 0;\n  let caret = startCaret;\n  let nextCaret = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getAdjacentChildCaret)(caret);\n  while (nextCaret === null) {\n    depthDiff--;\n    nextCaret = caret.getParentCaret(rootMode);\n    if (!nextCaret) {\n      return null;\n    }\n    caret = nextCaret;\n    nextCaret = (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getAdjacentChildCaret)(caret);\n  }\n  return nextCaret && [nextCaret, depthDiff];\n}\n\n/**\n * A wrapper that creates bound functions and methods for the\n * StateConfig to save some boilerplate when defining methods\n * or exporting only the accessors from your modules rather\n * than exposing the StateConfig directly.\n */\n\n/**\n * EXPERIMENTAL\n *\n * A convenience interface for working with {@link $getState} and\n * {@link $setState}.\n *\n * @param stateConfig The stateConfig to wrap with convenience functionality\n * @returns a StateWrapper\n */\nfunction makeStateWrapper(stateConfig) {\n  const $get = node => (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$getState)(node, stateConfig);\n  const $set = (node, valueOrUpdater) => (0,lexical__WEBPACK_IMPORTED_MODULE_0__.$setState)(node, stateConfig, valueOrUpdater);\n  return {\n    $get,\n    $set,\n    accessors: [$get, $set],\n    makeGetterMethod: () => function $getter() {\n      return $get(this);\n    },\n    makeSetterMethod: () => function $setter(valueOrUpdater) {\n      return $set(this, valueOrUpdater);\n    },\n    stateConfig\n  };\n}\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@lexical/utils/LexicalUtils.dev.mjs\n");

/***/ })

};
;