"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(self["webpackChunk_N_E"] = self["webpackChunk_N_E"] || []).push([["_app-pages-browser_node_modules_date-fns_locale_bg_js"],{

/***/ "(app-pages-browser)/./node_modules/date-fns/isSameWeek.js":
/*!*********************************************!*\
  !*** ./node_modules/date-fns/isSameWeek.js ***!
  \*********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval(__webpack_require__.ts("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   isSameWeek: () => (/* binding */ isSameWeek)\n/* harmony export */ });\n/* harmony import */ var _lib_normalizeDates_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_lib/normalizeDates.js */ \"(app-pages-browser)/./node_modules/date-fns/_lib/normalizeDates.js\");\n/* harmony import */ var _startOfWeek_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./startOfWeek.js */ \"(app-pages-browser)/./node_modules/date-fns/startOfWeek.js\");\n\n\n/**\n * The {@link isSameWeek} function options.\n */ /**\n * @name isSameWeek\n * @category Week Helpers\n * @summary Are the given dates in the same week (and month and year)?\n *\n * @description\n * Are the given dates in the same week (and month and year)?\n *\n * @param laterDate - The first date to check\n * @param earlierDate - The second date to check\n * @param options - An object with options\n *\n * @returns The dates are in the same week (and month and year)\n *\n * @example\n * // Are 31 August 2014 and 4 September 2014 in the same week?\n * const result = isSameWeek(new Date(2014, 7, 31), new Date(2014, 8, 4))\n * //=> true\n *\n * @example\n * // If week starts with Monday,\n * // are 31 August 2014 and 4 September 2014 in the same week?\n * const result = isSameWeek(new Date(2014, 7, 31), new Date(2014, 8, 4), {\n *   weekStartsOn: 1\n * })\n * //=> false\n *\n * @example\n * // Are 1 January 2014 and 1 January 2015 in the same week?\n * const result = isSameWeek(new Date(2014, 0, 1), new Date(2015, 0, 1))\n * //=> false\n */ function isSameWeek(laterDate, earlierDate, options) {\n    const [laterDate_, earlierDate_] = (0,_lib_normalizeDates_js__WEBPACK_IMPORTED_MODULE_0__.normalizeDates)(options === null || options === void 0 ? void 0 : options.in, laterDate, earlierDate);\n    return +(0,_startOfWeek_js__WEBPACK_IMPORTED_MODULE_1__.startOfWeek)(laterDate_, options) === +(0,_startOfWeek_js__WEBPACK_IMPORTED_MODULE_1__.startOfWeek)(earlierDate_, options);\n}\n// Fallback for modularized imports:\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isSameWeek);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(app-pages-browser)/./node_modules/date-fns/isSameWeek.js\n"));

/***/ }),

/***/ "(app-pages-browser)/./node_modules/date-fns/locale/bg.js":
/*!********************************************!*\
  !*** ./node_modules/date-fns/locale/bg.js ***!
  \********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval(__webpack_require__.ts("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   bg: () => (/* binding */ bg),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _bg_lib_formatDistance_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./bg/_lib/formatDistance.js */ \"(app-pages-browser)/./node_modules/date-fns/locale/bg/_lib/formatDistance.js\");\n/* harmony import */ var _bg_lib_formatLong_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./bg/_lib/formatLong.js */ \"(app-pages-browser)/./node_modules/date-fns/locale/bg/_lib/formatLong.js\");\n/* harmony import */ var _bg_lib_formatRelative_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./bg/_lib/formatRelative.js */ \"(app-pages-browser)/./node_modules/date-fns/locale/bg/_lib/formatRelative.js\");\n/* harmony import */ var _bg_lib_localize_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./bg/_lib/localize.js */ \"(app-pages-browser)/./node_modules/date-fns/locale/bg/_lib/localize.js\");\n/* harmony import */ var _bg_lib_match_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./bg/_lib/match.js */ \"(app-pages-browser)/./node_modules/date-fns/locale/bg/_lib/match.js\");\n\n\n\n\n\n/**\n * @category Locales\n * @summary Bulgarian locale.\n * @language Bulgarian\n * @iso-639-2 bul\n * @author Nikolay Stoynov [@arvigeus](https://github.com/arvigeus)\n * @author Tsvetan Ovedenski [@fintara](https://github.com/fintara)\n */ const bg = {\n    code: \"bg\",\n    formatDistance: _bg_lib_formatDistance_js__WEBPACK_IMPORTED_MODULE_0__.formatDistance,\n    formatLong: _bg_lib_formatLong_js__WEBPACK_IMPORTED_MODULE_1__.formatLong,\n    formatRelative: _bg_lib_formatRelative_js__WEBPACK_IMPORTED_MODULE_2__.formatRelative,\n    localize: _bg_lib_localize_js__WEBPACK_IMPORTED_MODULE_3__.localize,\n    match: _bg_lib_match_js__WEBPACK_IMPORTED_MODULE_4__.match,\n    options: {\n        weekStartsOn: 1 /* Monday */ ,\n        firstWeekContainsDate: 1\n    }\n};\n// Fallback for modularized imports:\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (bg);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(app-pages-browser)/./node_modules/date-fns/locale/bg.js\n"));

/***/ }),

/***/ "(app-pages-browser)/./node_modules/date-fns/locale/bg/_lib/formatDistance.js":
/*!****************************************************************!*\
  !*** ./node_modules/date-fns/locale/bg/_lib/formatDistance.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval(__webpack_require__.ts("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   formatDistance: () => (/* binding */ formatDistance)\n/* harmony export */ });\nconst formatDistanceLocale = {\n    lessThanXSeconds: {\n        one: \"по-малко от секунда\",\n        other: \"по-малко от {{count}} секунди\"\n    },\n    xSeconds: {\n        one: \"1 секунда\",\n        other: \"{{count}} секунди\"\n    },\n    halfAMinute: \"половин минута\",\n    lessThanXMinutes: {\n        one: \"по-малко от минута\",\n        other: \"по-малко от {{count}} минути\"\n    },\n    xMinutes: {\n        one: \"1 минута\",\n        other: \"{{count}} минути\"\n    },\n    aboutXHours: {\n        one: \"около час\",\n        other: \"около {{count}} часа\"\n    },\n    xHours: {\n        one: \"1 час\",\n        other: \"{{count}} часа\"\n    },\n    xDays: {\n        one: \"1 ден\",\n        other: \"{{count}} дни\"\n    },\n    aboutXWeeks: {\n        one: \"около седмица\",\n        other: \"около {{count}} седмици\"\n    },\n    xWeeks: {\n        one: \"1 седмица\",\n        other: \"{{count}} седмици\"\n    },\n    aboutXMonths: {\n        one: \"около месец\",\n        other: \"около {{count}} месеца\"\n    },\n    xMonths: {\n        one: \"1 месец\",\n        other: \"{{count}} месеца\"\n    },\n    aboutXYears: {\n        one: \"около година\",\n        other: \"около {{count}} години\"\n    },\n    xYears: {\n        one: \"1 година\",\n        other: \"{{count}} години\"\n    },\n    overXYears: {\n        one: \"над година\",\n        other: \"над {{count}} години\"\n    },\n    almostXYears: {\n        one: \"почти година\",\n        other: \"почти {{count}} години\"\n    }\n};\nconst formatDistance = (token, count, options)=>{\n    let result;\n    const tokenValue = formatDistanceLocale[token];\n    if (typeof tokenValue === \"string\") {\n        result = tokenValue;\n    } else if (count === 1) {\n        result = tokenValue.one;\n    } else {\n        result = tokenValue.other.replace(\"{{count}}\", String(count));\n    }\n    if (options === null || options === void 0 ? void 0 : options.addSuffix) {\n        if (options.comparison && options.comparison > 0) {\n            return \"след \" + result;\n        } else {\n            return \"преди \" + result;\n        }\n    }\n    return result;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(app-pages-browser)/./node_modules/date-fns/locale/bg/_lib/formatDistance.js\n"));

/***/ }),

/***/ "(app-pages-browser)/./node_modules/date-fns/locale/bg/_lib/formatLong.js":
/*!************************************************************!*\
  !*** ./node_modules/date-fns/locale/bg/_lib/formatLong.js ***!
  \************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval(__webpack_require__.ts("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   formatLong: () => (/* binding */ formatLong)\n/* harmony export */ });\n/* harmony import */ var _lib_buildFormatLongFn_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../_lib/buildFormatLongFn.js */ \"(app-pages-browser)/./node_modules/date-fns/locale/_lib/buildFormatLongFn.js\");\n\nconst dateFormats = {\n    full: \"EEEE, dd MMMM yyyy\",\n    long: \"dd MMMM yyyy\",\n    medium: \"dd MMM yyyy\",\n    short: \"dd.MM.yyyy\"\n};\nconst timeFormats = {\n    full: \"HH:mm:ss zzzz\",\n    long: \"HH:mm:ss z\",\n    medium: \"HH:mm:ss\",\n    short: \"H:mm\"\n};\nconst dateTimeFormats = {\n    any: \"{{date}} {{time}}\"\n};\nconst formatLong = {\n    date: (0,_lib_buildFormatLongFn_js__WEBPACK_IMPORTED_MODULE_0__.buildFormatLongFn)({\n        formats: dateFormats,\n        defaultWidth: \"full\"\n    }),\n    time: (0,_lib_buildFormatLongFn_js__WEBPACK_IMPORTED_MODULE_0__.buildFormatLongFn)({\n        formats: timeFormats,\n        defaultWidth: \"full\"\n    }),\n    dateTime: (0,_lib_buildFormatLongFn_js__WEBPACK_IMPORTED_MODULE_0__.buildFormatLongFn)({\n        formats: dateTimeFormats,\n        defaultWidth: \"any\"\n    })\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(app-pages-browser)/./node_modules/date-fns/locale/bg/_lib/formatLong.js\n"));

/***/ }),

/***/ "(app-pages-browser)/./node_modules/date-fns/locale/bg/_lib/formatRelative.js":
/*!****************************************************************!*\
  !*** ./node_modules/date-fns/locale/bg/_lib/formatRelative.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval(__webpack_require__.ts("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   formatRelative: () => (/* binding */ formatRelative)\n/* harmony export */ });\n/* harmony import */ var _isSameWeek_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../isSameWeek.js */ \"(app-pages-browser)/./node_modules/date-fns/isSameWeek.js\");\n/* harmony import */ var _toDate_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../toDate.js */ \"(app-pages-browser)/./node_modules/date-fns/toDate.js\");\n\n\n// Adapted from the `ru` translation\nconst weekdays = [\n    \"неделя\",\n    \"понеделник\",\n    \"вторник\",\n    \"сряда\",\n    \"четвъртък\",\n    \"петък\",\n    \"събота\"\n];\nfunction lastWeek(day) {\n    const weekday = weekdays[day];\n    switch(day){\n        case 0:\n        case 3:\n        case 6:\n            return \"'миналата \" + weekday + \" в' p\";\n        case 1:\n        case 2:\n        case 4:\n        case 5:\n            return \"'миналия \" + weekday + \" в' p\";\n    }\n}\nfunction thisWeek(day) {\n    const weekday = weekdays[day];\n    if (day === 2 /* Tue */ ) {\n        return \"'във \" + weekday + \" в' p\";\n    } else {\n        return \"'в \" + weekday + \" в' p\";\n    }\n}\nfunction nextWeek(day) {\n    const weekday = weekdays[day];\n    switch(day){\n        case 0:\n        case 3:\n        case 6:\n            return \"'следващата \" + weekday + \" в' p\";\n        case 1:\n        case 2:\n        case 4:\n        case 5:\n            return \"'следващия \" + weekday + \" в' p\";\n    }\n}\nconst lastWeekFormatToken = (dirtyDate, baseDate, options)=>{\n    const date = (0,_toDate_js__WEBPACK_IMPORTED_MODULE_0__.toDate)(dirtyDate);\n    const day = date.getDay();\n    if ((0,_isSameWeek_js__WEBPACK_IMPORTED_MODULE_1__.isSameWeek)(date, baseDate, options)) {\n        return thisWeek(day);\n    } else {\n        return lastWeek(day);\n    }\n};\nconst nextWeekFormatToken = (dirtyDate, baseDate, options)=>{\n    const date = (0,_toDate_js__WEBPACK_IMPORTED_MODULE_0__.toDate)(dirtyDate);\n    const day = date.getDay();\n    if ((0,_isSameWeek_js__WEBPACK_IMPORTED_MODULE_1__.isSameWeek)(date, baseDate, options)) {\n        return thisWeek(day);\n    } else {\n        return nextWeek(day);\n    }\n};\nconst formatRelativeLocale = {\n    lastWeek: lastWeekFormatToken,\n    yesterday: \"'вчера в' p\",\n    today: \"'днес в' p\",\n    tomorrow: \"'утре в' p\",\n    nextWeek: nextWeekFormatToken,\n    other: \"P\"\n};\nconst formatRelative = (token, date, baseDate, options)=>{\n    const format = formatRelativeLocale[token];\n    if (typeof format === \"function\") {\n        return format(date, baseDate, options);\n    }\n    return format;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(app-pages-browser)/./node_modules/date-fns/locale/bg/_lib/formatRelative.js\n"));

/***/ }),

/***/ "(app-pages-browser)/./node_modules/date-fns/locale/bg/_lib/localize.js":
/*!**********************************************************!*\
  !*** ./node_modules/date-fns/locale/bg/_lib/localize.js ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval(__webpack_require__.ts("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   localize: () => (/* binding */ localize)\n/* harmony export */ });\n/* harmony import */ var _lib_buildLocalizeFn_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../_lib/buildLocalizeFn.js */ \"(app-pages-browser)/./node_modules/date-fns/locale/_lib/buildLocalizeFn.js\");\n\nconst eraValues = {\n    narrow: [\n        \"пр.н.е.\",\n        \"н.е.\"\n    ],\n    abbreviated: [\n        \"преди н. е.\",\n        \"н. е.\"\n    ],\n    wide: [\n        \"преди новата ера\",\n        \"новата ера\"\n    ]\n};\nconst quarterValues = {\n    narrow: [\n        \"1\",\n        \"2\",\n        \"3\",\n        \"4\"\n    ],\n    abbreviated: [\n        \"1-во тримес.\",\n        \"2-ро тримес.\",\n        \"3-то тримес.\",\n        \"4-то тримес.\"\n    ],\n    wide: [\n        \"1-во тримесечие\",\n        \"2-ро тримесечие\",\n        \"3-то тримесечие\",\n        \"4-то тримесечие\"\n    ]\n};\nconst monthValues = {\n    abbreviated: [\n        \"яну\",\n        \"фев\",\n        \"мар\",\n        \"апр\",\n        \"май\",\n        \"юни\",\n        \"юли\",\n        \"авг\",\n        \"сеп\",\n        \"окт\",\n        \"ное\",\n        \"дек\"\n    ],\n    wide: [\n        \"януари\",\n        \"февруари\",\n        \"март\",\n        \"април\",\n        \"май\",\n        \"юни\",\n        \"юли\",\n        \"август\",\n        \"септември\",\n        \"октомври\",\n        \"ноември\",\n        \"декември\"\n    ]\n};\nconst dayValues = {\n    narrow: [\n        \"Н\",\n        \"П\",\n        \"В\",\n        \"С\",\n        \"Ч\",\n        \"П\",\n        \"С\"\n    ],\n    short: [\n        \"нд\",\n        \"пн\",\n        \"вт\",\n        \"ср\",\n        \"чт\",\n        \"пт\",\n        \"сб\"\n    ],\n    abbreviated: [\n        \"нед\",\n        \"пон\",\n        \"вто\",\n        \"сря\",\n        \"чет\",\n        \"пет\",\n        \"съб\"\n    ],\n    wide: [\n        \"неделя\",\n        \"понеделник\",\n        \"вторник\",\n        \"сряда\",\n        \"четвъртък\",\n        \"петък\",\n        \"събота\"\n    ]\n};\nconst dayPeriodValues = {\n    wide: {\n        am: \"преди обяд\",\n        pm: \"след обяд\",\n        midnight: \"в полунощ\",\n        noon: \"на обяд\",\n        morning: \"сутринта\",\n        afternoon: \"следобед\",\n        evening: \"вечерта\",\n        night: \"през нощта\"\n    }\n};\nfunction isFeminine(unit) {\n    return unit === \"year\" || unit === \"week\" || unit === \"minute\" || unit === \"second\";\n}\nfunction isNeuter(unit) {\n    return unit === \"quarter\";\n}\nfunction numberWithSuffix(number, unit, masculine, feminine, neuter) {\n    const suffix = isNeuter(unit) ? neuter : isFeminine(unit) ? feminine : masculine;\n    return number + \"-\" + suffix;\n}\nconst ordinalNumber = (dirtyNumber, options)=>{\n    const number = Number(dirtyNumber);\n    const unit = options === null || options === void 0 ? void 0 : options.unit;\n    if (number === 0) {\n        return numberWithSuffix(0, unit, \"ев\", \"ева\", \"ево\");\n    } else if (number % 1000 === 0) {\n        return numberWithSuffix(number, unit, \"ен\", \"на\", \"но\");\n    } else if (number % 100 === 0) {\n        return numberWithSuffix(number, unit, \"тен\", \"тна\", \"тно\");\n    }\n    const rem100 = number % 100;\n    if (rem100 > 20 || rem100 < 10) {\n        switch(rem100 % 10){\n            case 1:\n                return numberWithSuffix(number, unit, \"ви\", \"ва\", \"во\");\n            case 2:\n                return numberWithSuffix(number, unit, \"ри\", \"ра\", \"ро\");\n            case 7:\n            case 8:\n                return numberWithSuffix(number, unit, \"ми\", \"ма\", \"мо\");\n        }\n    }\n    return numberWithSuffix(number, unit, \"ти\", \"та\", \"то\");\n};\nconst localize = {\n    ordinalNumber,\n    era: (0,_lib_buildLocalizeFn_js__WEBPACK_IMPORTED_MODULE_0__.buildLocalizeFn)({\n        values: eraValues,\n        defaultWidth: \"wide\"\n    }),\n    quarter: (0,_lib_buildLocalizeFn_js__WEBPACK_IMPORTED_MODULE_0__.buildLocalizeFn)({\n        values: quarterValues,\n        defaultWidth: \"wide\",\n        argumentCallback: (quarter)=>quarter - 1\n    }),\n    month: (0,_lib_buildLocalizeFn_js__WEBPACK_IMPORTED_MODULE_0__.buildLocalizeFn)({\n        values: monthValues,\n        defaultWidth: \"wide\"\n    }),\n    day: (0,_lib_buildLocalizeFn_js__WEBPACK_IMPORTED_MODULE_0__.buildLocalizeFn)({\n        values: dayValues,\n        defaultWidth: \"wide\"\n    }),\n    dayPeriod: (0,_lib_buildLocalizeFn_js__WEBPACK_IMPORTED_MODULE_0__.buildLocalizeFn)({\n        values: dayPeriodValues,\n        defaultWidth: \"wide\"\n    })\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(app-pages-browser)/./node_modules/date-fns/locale/bg/_lib/localize.js\n"));

/***/ }),

/***/ "(app-pages-browser)/./node_modules/date-fns/locale/bg/_lib/match.js":
/*!*******************************************************!*\
  !*** ./node_modules/date-fns/locale/bg/_lib/match.js ***!
  \*******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval(__webpack_require__.ts("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   match: () => (/* binding */ match)\n/* harmony export */ });\n/* harmony import */ var _lib_buildMatchFn_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../_lib/buildMatchFn.js */ \"(app-pages-browser)/./node_modules/date-fns/locale/_lib/buildMatchFn.js\");\n/* harmony import */ var _lib_buildMatchPatternFn_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../_lib/buildMatchPatternFn.js */ \"(app-pages-browser)/./node_modules/date-fns/locale/_lib/buildMatchPatternFn.js\");\n\n\nconst matchOrdinalNumberPattern = /^(\\d+)(-?[врмт][аи]|-?т?(ен|на)|-?(ев|ева))?/i;\nconst parseOrdinalNumberPattern = /\\d+/i;\nconst matchEraPatterns = {\n    narrow: /^((пр)?н\\.?\\s?е\\.?)/i,\n    abbreviated: /^((пр)?н\\.?\\s?е\\.?)/i,\n    wide: /^(преди новата ера|новата ера|нова ера)/i\n};\nconst parseEraPatterns = {\n    any: [\n        /^п/i,\n        /^н/i\n    ]\n};\nconst matchQuarterPatterns = {\n    narrow: /^[1234]/i,\n    abbreviated: /^[1234](-?[врт]?o?)? тримес.?/i,\n    wide: /^[1234](-?[врт]?о?)? тримесечие/i\n};\nconst parseQuarterPatterns = {\n    any: [\n        /1/i,\n        /2/i,\n        /3/i,\n        /4/i\n    ]\n};\nconst matchDayPatterns = {\n    narrow: /^[нпвсч]/i,\n    short: /^(нд|пн|вт|ср|чт|пт|сб)/i,\n    abbreviated: /^(нед|пон|вто|сря|чет|пет|съб)/i,\n    wide: /^(неделя|понеделник|вторник|сряда|четвъртък|петък|събота)/i\n};\nconst parseDayPatterns = {\n    narrow: [\n        /^н/i,\n        /^п/i,\n        /^в/i,\n        /^с/i,\n        /^ч/i,\n        /^п/i,\n        /^с/i\n    ],\n    any: [\n        /^н[ед]/i,\n        /^п[он]/i,\n        /^вт/i,\n        /^ср/i,\n        /^ч[ет]/i,\n        /^п[ет]/i,\n        /^с[ъб]/i\n    ]\n};\nconst matchMonthPatterns = {\n    abbreviated: /^(яну|фев|мар|апр|май|юни|юли|авг|сеп|окт|ное|дек)/i,\n    wide: /^(януари|февруари|март|април|май|юни|юли|август|септември|октомври|ноември|декември)/i\n};\nconst parseMonthPatterns = {\n    any: [\n        /^я/i,\n        /^ф/i,\n        /^мар/i,\n        /^ап/i,\n        /^май/i,\n        /^юн/i,\n        /^юл/i,\n        /^ав/i,\n        /^се/i,\n        /^окт/i,\n        /^но/i,\n        /^де/i\n    ]\n};\nconst matchDayPeriodPatterns = {\n    any: /^(преди о|след о|в по|на о|през|веч|сут|следо)/i\n};\nconst parseDayPeriodPatterns = {\n    any: {\n        am: /^преди о/i,\n        pm: /^след о/i,\n        midnight: /^в пол/i,\n        noon: /^на об/i,\n        morning: /^сут/i,\n        afternoon: /^следо/i,\n        evening: /^веч/i,\n        night: /^през н/i\n    }\n};\nconst match = {\n    ordinalNumber: (0,_lib_buildMatchPatternFn_js__WEBPACK_IMPORTED_MODULE_0__.buildMatchPatternFn)({\n        matchPattern: matchOrdinalNumberPattern,\n        parsePattern: parseOrdinalNumberPattern,\n        valueCallback: (value)=>parseInt(value, 10)\n    }),\n    era: (0,_lib_buildMatchFn_js__WEBPACK_IMPORTED_MODULE_1__.buildMatchFn)({\n        matchPatterns: matchEraPatterns,\n        defaultMatchWidth: \"wide\",\n        parsePatterns: parseEraPatterns,\n        defaultParseWidth: \"any\"\n    }),\n    quarter: (0,_lib_buildMatchFn_js__WEBPACK_IMPORTED_MODULE_1__.buildMatchFn)({\n        matchPatterns: matchQuarterPatterns,\n        defaultMatchWidth: \"wide\",\n        parsePatterns: parseQuarterPatterns,\n        defaultParseWidth: \"any\",\n        valueCallback: (index)=>index + 1\n    }),\n    month: (0,_lib_buildMatchFn_js__WEBPACK_IMPORTED_MODULE_1__.buildMatchFn)({\n        matchPatterns: matchMonthPatterns,\n        defaultMatchWidth: \"wide\",\n        parsePatterns: parseMonthPatterns,\n        defaultParseWidth: \"any\"\n    }),\n    day: (0,_lib_buildMatchFn_js__WEBPACK_IMPORTED_MODULE_1__.buildMatchFn)({\n        matchPatterns: matchDayPatterns,\n        defaultMatchWidth: \"wide\",\n        parsePatterns: parseDayPatterns,\n        defaultParseWidth: \"any\"\n    }),\n    dayPeriod: (0,_lib_buildMatchFn_js__WEBPACK_IMPORTED_MODULE_1__.buildMatchFn)({\n        matchPatterns: matchDayPeriodPatterns,\n        defaultMatchWidth: \"any\",\n        parsePatterns: parseDayPeriodPatterns,\n        defaultParseWidth: \"any\"\n    })\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(app-pages-browser)/./node_modules/date-fns/locale/bg/_lib/match.js\n"));

/***/ })

}]);