"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(self["webpackChunk_N_E"] = self["webpackChunk_N_E"] || []).push([["_app-pages-browser_node_modules_date-fns_locale_lv_js"],{

/***/ "(app-pages-browser)/./node_modules/date-fns/isSameWeek.js":
/*!*********************************************!*\
  !*** ./node_modules/date-fns/isSameWeek.js ***!
  \*********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval(__webpack_require__.ts("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   isSameWeek: () => (/* binding */ isSameWeek)\n/* harmony export */ });\n/* harmony import */ var _lib_normalizeDates_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_lib/normalizeDates.js */ \"(app-pages-browser)/./node_modules/date-fns/_lib/normalizeDates.js\");\n/* harmony import */ var _startOfWeek_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./startOfWeek.js */ \"(app-pages-browser)/./node_modules/date-fns/startOfWeek.js\");\n\n\n/**\n * The {@link isSameWeek} function options.\n */ /**\n * @name isSameWeek\n * @category Week Helpers\n * @summary Are the given dates in the same week (and month and year)?\n *\n * @description\n * Are the given dates in the same week (and month and year)?\n *\n * @param laterDate - The first date to check\n * @param earlierDate - The second date to check\n * @param options - An object with options\n *\n * @returns The dates are in the same week (and month and year)\n *\n * @example\n * // Are 31 August 2014 and 4 September 2014 in the same week?\n * const result = isSameWeek(new Date(2014, 7, 31), new Date(2014, 8, 4))\n * //=> true\n *\n * @example\n * // If week starts with Monday,\n * // are 31 August 2014 and 4 September 2014 in the same week?\n * const result = isSameWeek(new Date(2014, 7, 31), new Date(2014, 8, 4), {\n *   weekStartsOn: 1\n * })\n * //=> false\n *\n * @example\n * // Are 1 January 2014 and 1 January 2015 in the same week?\n * const result = isSameWeek(new Date(2014, 0, 1), new Date(2015, 0, 1))\n * //=> false\n */ function isSameWeek(laterDate, earlierDate, options) {\n    const [laterDate_, earlierDate_] = (0,_lib_normalizeDates_js__WEBPACK_IMPORTED_MODULE_0__.normalizeDates)(options === null || options === void 0 ? void 0 : options.in, laterDate, earlierDate);\n    return +(0,_startOfWeek_js__WEBPACK_IMPORTED_MODULE_1__.startOfWeek)(laterDate_, options) === +(0,_startOfWeek_js__WEBPACK_IMPORTED_MODULE_1__.startOfWeek)(earlierDate_, options);\n}\n// Fallback for modularized imports:\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isSameWeek);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(app-pages-browser)/./node_modules/date-fns/isSameWeek.js\n"));

/***/ }),

/***/ "(app-pages-browser)/./node_modules/date-fns/locale/lv.js":
/*!********************************************!*\
  !*** ./node_modules/date-fns/locale/lv.js ***!
  \********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval(__webpack_require__.ts("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   lv: () => (/* binding */ lv)\n/* harmony export */ });\n/* harmony import */ var _lv_lib_formatDistance_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lv/_lib/formatDistance.js */ \"(app-pages-browser)/./node_modules/date-fns/locale/lv/_lib/formatDistance.js\");\n/* harmony import */ var _lv_lib_formatLong_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./lv/_lib/formatLong.js */ \"(app-pages-browser)/./node_modules/date-fns/locale/lv/_lib/formatLong.js\");\n/* harmony import */ var _lv_lib_formatRelative_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./lv/_lib/formatRelative.js */ \"(app-pages-browser)/./node_modules/date-fns/locale/lv/_lib/formatRelative.js\");\n/* harmony import */ var _lv_lib_localize_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./lv/_lib/localize.js */ \"(app-pages-browser)/./node_modules/date-fns/locale/lv/_lib/localize.js\");\n/* harmony import */ var _lv_lib_match_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./lv/_lib/match.js */ \"(app-pages-browser)/./node_modules/date-fns/locale/lv/_lib/match.js\");\n\n\n\n\n\n/**\n * @category Locales\n * @summary Latvian locale (Latvia).\n * @language Latvian\n * @iso-639-2 lav\n * @author Rūdolfs Puķītis [@prudolfs](https://github.com/prudolfs)\n */ const lv = {\n    code: \"lv\",\n    formatDistance: _lv_lib_formatDistance_js__WEBPACK_IMPORTED_MODULE_0__.formatDistance,\n    formatLong: _lv_lib_formatLong_js__WEBPACK_IMPORTED_MODULE_1__.formatLong,\n    formatRelative: _lv_lib_formatRelative_js__WEBPACK_IMPORTED_MODULE_2__.formatRelative,\n    localize: _lv_lib_localize_js__WEBPACK_IMPORTED_MODULE_3__.localize,\n    match: _lv_lib_match_js__WEBPACK_IMPORTED_MODULE_4__.match,\n    options: {\n        weekStartsOn: 1 /* Monday */ ,\n        firstWeekContainsDate: 4\n    }\n};\n// Fallback for modularized imports:\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (lv);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKGFwcC1wYWdlcy1icm93c2VyKS8uL25vZGVfbW9kdWxlcy9kYXRlLWZucy9sb2NhbGUvbHYuanMiLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7OztBQUE2RDtBQUNSO0FBQ1E7QUFDWjtBQUNOO0FBRTNDOzs7Ozs7Q0FNQyxHQUNNLE1BQU1LLEtBQUs7SUFDaEJDLE1BQU07SUFDTk4sZ0JBQWdCQSxxRUFBY0E7SUFDOUJDLFlBQVlBLDZEQUFVQTtJQUN0QkMsZ0JBQWdCQSxxRUFBY0E7SUFDOUJDLFVBQVVBLHlEQUFRQTtJQUNsQkMsT0FBT0EsbURBQUtBO0lBQ1pHLFNBQVM7UUFDUEMsY0FBYyxFQUFFLFVBQVU7UUFDMUJDLHVCQUF1QjtJQUN6QjtBQUNGLEVBQUU7QUFFRixvQ0FBb0M7QUFDcEMsaUVBQWVKLEVBQUVBLEVBQUMiLCJzb3VyY2VzIjpbIi9Vc2Vycy9nZW9yZ2lqa3VsaWFzdmlsaS9Eb2N1bWVudHMvR2l0SHViL3l1bW1lci1hcHBzL3BheWxvYWQtY21zL25vZGVfbW9kdWxlcy9kYXRlLWZucy9sb2NhbGUvbHYuanMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgZm9ybWF0RGlzdGFuY2UgfSBmcm9tIFwiLi9sdi9fbGliL2Zvcm1hdERpc3RhbmNlLmpzXCI7XG5pbXBvcnQgeyBmb3JtYXRMb25nIH0gZnJvbSBcIi4vbHYvX2xpYi9mb3JtYXRMb25nLmpzXCI7XG5pbXBvcnQgeyBmb3JtYXRSZWxhdGl2ZSB9IGZyb20gXCIuL2x2L19saWIvZm9ybWF0UmVsYXRpdmUuanNcIjtcbmltcG9ydCB7IGxvY2FsaXplIH0gZnJvbSBcIi4vbHYvX2xpYi9sb2NhbGl6ZS5qc1wiO1xuaW1wb3J0IHsgbWF0Y2ggfSBmcm9tIFwiLi9sdi9fbGliL21hdGNoLmpzXCI7XG5cbi8qKlxuICogQGNhdGVnb3J5IExvY2FsZXNcbiAqIEBzdW1tYXJ5IExhdHZpYW4gbG9jYWxlIChMYXR2aWEpLlxuICogQGxhbmd1YWdlIExhdHZpYW5cbiAqIEBpc28tNjM5LTIgbGF2XG4gKiBAYXV0aG9yIFLFq2RvbGZzIFB1xLfEq3RpcyBbQHBydWRvbGZzXShodHRwczovL2dpdGh1Yi5jb20vcHJ1ZG9sZnMpXG4gKi9cbmV4cG9ydCBjb25zdCBsdiA9IHtcbiAgY29kZTogXCJsdlwiLFxuICBmb3JtYXREaXN0YW5jZTogZm9ybWF0RGlzdGFuY2UsXG4gIGZvcm1hdExvbmc6IGZvcm1hdExvbmcsXG4gIGZvcm1hdFJlbGF0aXZlOiBmb3JtYXRSZWxhdGl2ZSxcbiAgbG9jYWxpemU6IGxvY2FsaXplLFxuICBtYXRjaDogbWF0Y2gsXG4gIG9wdGlvbnM6IHtcbiAgICB3ZWVrU3RhcnRzT246IDEgLyogTW9uZGF5ICovLFxuICAgIGZpcnN0V2Vla0NvbnRhaW5zRGF0ZTogNCxcbiAgfSxcbn07XG5cbi8vIEZhbGxiYWNrIGZvciBtb2R1bGFyaXplZCBpbXBvcnRzOlxuZXhwb3J0IGRlZmF1bHQgbHY7XG4iXSwibmFtZXMiOlsiZm9ybWF0RGlzdGFuY2UiLCJmb3JtYXRMb25nIiwiZm9ybWF0UmVsYXRpdmUiLCJsb2NhbGl6ZSIsIm1hdGNoIiwibHYiLCJjb2RlIiwib3B0aW9ucyIsIndlZWtTdGFydHNPbiIsImZpcnN0V2Vla0NvbnRhaW5zRGF0ZSJdLCJpZ25vcmVMaXN0IjpbMF0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(app-pages-browser)/./node_modules/date-fns/locale/lv.js\n"));

/***/ }),

/***/ "(app-pages-browser)/./node_modules/date-fns/locale/lv/_lib/formatDistance.js":
/*!****************************************************************!*\
  !*** ./node_modules/date-fns/locale/lv/_lib/formatDistance.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval(__webpack_require__.ts("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   formatDistance: () => (/* binding */ formatDistance)\n/* harmony export */ });\nfunction buildLocalizeTokenFn(schema) {\n    return (count, options)=>{\n        if (count === 1) {\n            if (options === null || options === void 0 ? void 0 : options.addSuffix) {\n                return schema.one[0].replace(\"{{time}}\", schema.one[2]);\n            } else {\n                return schema.one[0].replace(\"{{time}}\", schema.one[1]);\n            }\n        } else {\n            const rem = count % 10 === 1 && count % 100 !== 11;\n            if (options === null || options === void 0 ? void 0 : options.addSuffix) {\n                return schema.other[0].replace(\"{{time}}\", rem ? schema.other[3] : schema.other[4]).replace(\"{{count}}\", String(count));\n            } else {\n                return schema.other[0].replace(\"{{time}}\", rem ? schema.other[1] : schema.other[2]).replace(\"{{count}}\", String(count));\n            }\n        }\n    };\n}\nconst formatDistanceLocale = {\n    lessThanXSeconds: buildLocalizeTokenFn({\n        one: [\n            \"mazāk par {{time}}\",\n            \"sekundi\",\n            \"sekundi\"\n        ],\n        other: [\n            \"mazāk nekā {{count}} {{time}}\",\n            \"sekunde\",\n            \"sekundes\",\n            \"sekundes\",\n            \"sekundēm\"\n        ]\n    }),\n    xSeconds: buildLocalizeTokenFn({\n        one: [\n            \"1 {{time}}\",\n            \"sekunde\",\n            \"sekundes\"\n        ],\n        other: [\n            \"{{count}} {{time}}\",\n            \"sekunde\",\n            \"sekundes\",\n            \"sekundes\",\n            \"sekundēm\"\n        ]\n    }),\n    halfAMinute: (_count, options)=>{\n        if (options === null || options === void 0 ? void 0 : options.addSuffix) {\n            return \"pusminūtes\";\n        } else {\n            return \"pusminūte\";\n        }\n    },\n    lessThanXMinutes: buildLocalizeTokenFn({\n        one: [\n            \"mazāk par {{time}}\",\n            \"minūti\",\n            \"minūti\"\n        ],\n        other: [\n            \"mazāk nekā {{count}} {{time}}\",\n            \"minūte\",\n            \"minūtes\",\n            \"minūtes\",\n            \"minūtēm\"\n        ]\n    }),\n    xMinutes: buildLocalizeTokenFn({\n        one: [\n            \"1 {{time}}\",\n            \"minūte\",\n            \"minūtes\"\n        ],\n        other: [\n            \"{{count}} {{time}}\",\n            \"minūte\",\n            \"minūtes\",\n            \"minūtes\",\n            \"minūtēm\"\n        ]\n    }),\n    aboutXHours: buildLocalizeTokenFn({\n        one: [\n            \"apmēram 1 {{time}}\",\n            \"stunda\",\n            \"stundas\"\n        ],\n        other: [\n            \"apmēram {{count}} {{time}}\",\n            \"stunda\",\n            \"stundas\",\n            \"stundas\",\n            \"stundām\"\n        ]\n    }),\n    xHours: buildLocalizeTokenFn({\n        one: [\n            \"1 {{time}}\",\n            \"stunda\",\n            \"stundas\"\n        ],\n        other: [\n            \"{{count}} {{time}}\",\n            \"stunda\",\n            \"stundas\",\n            \"stundas\",\n            \"stundām\"\n        ]\n    }),\n    xDays: buildLocalizeTokenFn({\n        one: [\n            \"1 {{time}}\",\n            \"diena\",\n            \"dienas\"\n        ],\n        other: [\n            \"{{count}} {{time}}\",\n            \"diena\",\n            \"dienas\",\n            \"dienas\",\n            \"dienām\"\n        ]\n    }),\n    aboutXWeeks: buildLocalizeTokenFn({\n        one: [\n            \"apmēram 1 {{time}}\",\n            \"nedēļa\",\n            \"nedēļas\"\n        ],\n        other: [\n            \"apmēram {{count}} {{time}}\",\n            \"nedēļa\",\n            \"nedēļu\",\n            \"nedēļas\",\n            \"nedēļām\"\n        ]\n    }),\n    xWeeks: buildLocalizeTokenFn({\n        one: [\n            \"1 {{time}}\",\n            \"nedēļa\",\n            \"nedēļas\"\n        ],\n        other: [\n            \"{{count}} {{time}}\",\n            \"nedēļa\",\n            \"nedēļu\",\n            \"nedēļas\",\n            \"nedēļām\"\n        ]\n    }),\n    aboutXMonths: buildLocalizeTokenFn({\n        one: [\n            \"apmēram 1 {{time}}\",\n            \"mēnesis\",\n            \"mēneša\"\n        ],\n        other: [\n            \"apmēram {{count}} {{time}}\",\n            \"mēnesis\",\n            \"mēneši\",\n            \"mēneša\",\n            \"mēnešiem\"\n        ]\n    }),\n    xMonths: buildLocalizeTokenFn({\n        one: [\n            \"1 {{time}}\",\n            \"mēnesis\",\n            \"mēneša\"\n        ],\n        other: [\n            \"{{count}} {{time}}\",\n            \"mēnesis\",\n            \"mēneši\",\n            \"mēneša\",\n            \"mēnešiem\"\n        ]\n    }),\n    aboutXYears: buildLocalizeTokenFn({\n        one: [\n            \"apmēram 1 {{time}}\",\n            \"gads\",\n            \"gada\"\n        ],\n        other: [\n            \"apmēram {{count}} {{time}}\",\n            \"gads\",\n            \"gadi\",\n            \"gada\",\n            \"gadiem\"\n        ]\n    }),\n    xYears: buildLocalizeTokenFn({\n        one: [\n            \"1 {{time}}\",\n            \"gads\",\n            \"gada\"\n        ],\n        other: [\n            \"{{count}} {{time}}\",\n            \"gads\",\n            \"gadi\",\n            \"gada\",\n            \"gadiem\"\n        ]\n    }),\n    overXYears: buildLocalizeTokenFn({\n        one: [\n            \"ilgāk par 1 {{time}}\",\n            \"gadu\",\n            \"gadu\"\n        ],\n        other: [\n            \"vairāk nekā {{count}} {{time}}\",\n            \"gads\",\n            \"gadi\",\n            \"gada\",\n            \"gadiem\"\n        ]\n    }),\n    almostXYears: buildLocalizeTokenFn({\n        one: [\n            \"gandrīz 1 {{time}}\",\n            \"gads\",\n            \"gada\"\n        ],\n        other: [\n            \"vairāk nekā {{count}} {{time}}\",\n            \"gads\",\n            \"gadi\",\n            \"gada\",\n            \"gadiem\"\n        ]\n    })\n};\nconst formatDistance = (token, count, options)=>{\n    const result = formatDistanceLocale[token](count, options);\n    if (options === null || options === void 0 ? void 0 : options.addSuffix) {\n        if (options.comparison && options.comparison > 0) {\n            return \"pēc \" + result;\n        } else {\n            return \"pirms \" + result;\n        }\n    }\n    return result;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(app-pages-browser)/./node_modules/date-fns/locale/lv/_lib/formatDistance.js\n"));

/***/ }),

/***/ "(app-pages-browser)/./node_modules/date-fns/locale/lv/_lib/formatLong.js":
/*!************************************************************!*\
  !*** ./node_modules/date-fns/locale/lv/_lib/formatLong.js ***!
  \************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval(__webpack_require__.ts("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   formatLong: () => (/* binding */ formatLong)\n/* harmony export */ });\n/* harmony import */ var _lib_buildFormatLongFn_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../_lib/buildFormatLongFn.js */ \"(app-pages-browser)/./node_modules/date-fns/locale/_lib/buildFormatLongFn.js\");\n\nconst dateFormats = {\n    full: \"EEEE, y. 'gada' d. MMMM\",\n    long: \"y. 'gada' d. MMMM\",\n    medium: \"dd.MM.y.\",\n    short: \"dd.MM.y.\"\n};\nconst timeFormats = {\n    full: \"HH:mm:ss zzzz\",\n    long: \"HH:mm:ss z\",\n    medium: \"HH:mm:ss\",\n    short: \"HH:mm\"\n};\nconst dateTimeFormats = {\n    full: \"{{date}} 'plkst.' {{time}}\",\n    long: \"{{date}} 'plkst.' {{time}}\",\n    medium: \"{{date}}, {{time}}\",\n    short: \"{{date}}, {{time}}\"\n};\nconst formatLong = {\n    date: (0,_lib_buildFormatLongFn_js__WEBPACK_IMPORTED_MODULE_0__.buildFormatLongFn)({\n        formats: dateFormats,\n        defaultWidth: \"full\"\n    }),\n    time: (0,_lib_buildFormatLongFn_js__WEBPACK_IMPORTED_MODULE_0__.buildFormatLongFn)({\n        formats: timeFormats,\n        defaultWidth: \"full\"\n    }),\n    dateTime: (0,_lib_buildFormatLongFn_js__WEBPACK_IMPORTED_MODULE_0__.buildFormatLongFn)({\n        formats: dateTimeFormats,\n        defaultWidth: \"full\"\n    })\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKGFwcC1wYWdlcy1icm93c2VyKS8uL25vZGVfbW9kdWxlcy9kYXRlLWZucy9sb2NhbGUvbHYvX2xpYi9mb3JtYXRMb25nLmpzIiwibWFwcGluZ3MiOiI7Ozs7O0FBQW9FO0FBRXBFLE1BQU1DLGNBQWM7SUFDbEJDLE1BQU07SUFDTkMsTUFBTTtJQUNOQyxRQUFRO0lBQ1JDLE9BQU87QUFDVDtBQUVBLE1BQU1DLGNBQWM7SUFDbEJKLE1BQU07SUFDTkMsTUFBTTtJQUNOQyxRQUFRO0lBQ1JDLE9BQU87QUFDVDtBQUVBLE1BQU1FLGtCQUFrQjtJQUN0QkwsTUFBTTtJQUNOQyxNQUFNO0lBQ05DLFFBQVE7SUFDUkMsT0FBTztBQUNUO0FBRU8sTUFBTUcsYUFBYTtJQUN4QkMsTUFBTVQsNEVBQWlCQSxDQUFDO1FBQ3RCVSxTQUFTVDtRQUNUVSxjQUFjO0lBQ2hCO0lBRUFDLE1BQU1aLDRFQUFpQkEsQ0FBQztRQUN0QlUsU0FBU0o7UUFDVEssY0FBYztJQUNoQjtJQUVBRSxVQUFVYiw0RUFBaUJBLENBQUM7UUFDMUJVLFNBQVNIO1FBQ1RJLGNBQWM7SUFDaEI7QUFDRixFQUFFIiwic291cmNlcyI6WyIvVXNlcnMvZ2Vvcmdpamt1bGlhc3ZpbGkvRG9jdW1lbnRzL0dpdEh1Yi95dW1tZXItYXBwcy9wYXlsb2FkLWNtcy9ub2RlX21vZHVsZXMvZGF0ZS1mbnMvbG9jYWxlL2x2L19saWIvZm9ybWF0TG9uZy5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBidWlsZEZvcm1hdExvbmdGbiB9IGZyb20gXCIuLi8uLi9fbGliL2J1aWxkRm9ybWF0TG9uZ0ZuLmpzXCI7XG5cbmNvbnN0IGRhdGVGb3JtYXRzID0ge1xuICBmdWxsOiBcIkVFRUUsIHkuICdnYWRhJyBkLiBNTU1NXCIsXG4gIGxvbmc6IFwieS4gJ2dhZGEnIGQuIE1NTU1cIixcbiAgbWVkaXVtOiBcImRkLk1NLnkuXCIsXG4gIHNob3J0OiBcImRkLk1NLnkuXCIsXG59O1xuXG5jb25zdCB0aW1lRm9ybWF0cyA9IHtcbiAgZnVsbDogXCJISDptbTpzcyB6enp6XCIsXG4gIGxvbmc6IFwiSEg6bW06c3MgelwiLFxuICBtZWRpdW06IFwiSEg6bW06c3NcIixcbiAgc2hvcnQ6IFwiSEg6bW1cIixcbn07XG5cbmNvbnN0IGRhdGVUaW1lRm9ybWF0cyA9IHtcbiAgZnVsbDogXCJ7e2RhdGV9fSAncGxrc3QuJyB7e3RpbWV9fVwiLFxuICBsb25nOiBcInt7ZGF0ZX19ICdwbGtzdC4nIHt7dGltZX19XCIsXG4gIG1lZGl1bTogXCJ7e2RhdGV9fSwge3t0aW1lfX1cIixcbiAgc2hvcnQ6IFwie3tkYXRlfX0sIHt7dGltZX19XCIsXG59O1xuXG5leHBvcnQgY29uc3QgZm9ybWF0TG9uZyA9IHtcbiAgZGF0ZTogYnVpbGRGb3JtYXRMb25nRm4oe1xuICAgIGZvcm1hdHM6IGRhdGVGb3JtYXRzLFxuICAgIGRlZmF1bHRXaWR0aDogXCJmdWxsXCIsXG4gIH0pLFxuXG4gIHRpbWU6IGJ1aWxkRm9ybWF0TG9uZ0ZuKHtcbiAgICBmb3JtYXRzOiB0aW1lRm9ybWF0cyxcbiAgICBkZWZhdWx0V2lkdGg6IFwiZnVsbFwiLFxuICB9KSxcblxuICBkYXRlVGltZTogYnVpbGRGb3JtYXRMb25nRm4oe1xuICAgIGZvcm1hdHM6IGRhdGVUaW1lRm9ybWF0cyxcbiAgICBkZWZhdWx0V2lkdGg6IFwiZnVsbFwiLFxuICB9KSxcbn07XG4iXSwibmFtZXMiOlsiYnVpbGRGb3JtYXRMb25nRm4iLCJkYXRlRm9ybWF0cyIsImZ1bGwiLCJsb25nIiwibWVkaXVtIiwic2hvcnQiLCJ0aW1lRm9ybWF0cyIsImRhdGVUaW1lRm9ybWF0cyIsImZvcm1hdExvbmciLCJkYXRlIiwiZm9ybWF0cyIsImRlZmF1bHRXaWR0aCIsInRpbWUiLCJkYXRlVGltZSJdLCJpZ25vcmVMaXN0IjpbMF0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(app-pages-browser)/./node_modules/date-fns/locale/lv/_lib/formatLong.js\n"));

/***/ }),

/***/ "(app-pages-browser)/./node_modules/date-fns/locale/lv/_lib/formatRelative.js":
/*!****************************************************************!*\
  !*** ./node_modules/date-fns/locale/lv/_lib/formatRelative.js ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval(__webpack_require__.ts("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   formatRelative: () => (/* binding */ formatRelative)\n/* harmony export */ });\n/* harmony import */ var _isSameWeek_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../isSameWeek.js */ \"(app-pages-browser)/./node_modules/date-fns/isSameWeek.js\");\n\nconst weekdays = [\n    \"svētdienā\",\n    \"pirmdienā\",\n    \"otrdienā\",\n    \"trešdienā\",\n    \"ceturtdienā\",\n    \"piektdienā\",\n    \"sestdienā\"\n];\nconst formatRelativeLocale = {\n    lastWeek: (date, baseDate, options)=>{\n        if ((0,_isSameWeek_js__WEBPACK_IMPORTED_MODULE_0__.isSameWeek)(date, baseDate, options)) {\n            return \"eeee 'plkst.' p\";\n        }\n        const weekday = weekdays[date.getDay()];\n        return \"'Pagājušā \" + weekday + \" plkst.' p\";\n    },\n    yesterday: \"'Vakar plkst.' p\",\n    today: \"'Šodien plkst.' p\",\n    tomorrow: \"'Rīt plkst.' p\",\n    nextWeek: (date, baseDate, options)=>{\n        if ((0,_isSameWeek_js__WEBPACK_IMPORTED_MODULE_0__.isSameWeek)(date, baseDate, options)) {\n            return \"eeee 'plkst.' p\";\n        }\n        const weekday = weekdays[date.getDay()];\n        return \"'Nākamajā \" + weekday + \" plkst.' p\";\n    },\n    other: \"P\"\n};\nconst formatRelative = (token, date, baseDate, options)=>{\n    const format = formatRelativeLocale[token];\n    if (typeof format === \"function\") {\n        return format(date, baseDate, options);\n    }\n    return format;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(app-pages-browser)/./node_modules/date-fns/locale/lv/_lib/formatRelative.js\n"));

/***/ }),

/***/ "(app-pages-browser)/./node_modules/date-fns/locale/lv/_lib/localize.js":
/*!**********************************************************!*\
  !*** ./node_modules/date-fns/locale/lv/_lib/localize.js ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval(__webpack_require__.ts("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   localize: () => (/* binding */ localize)\n/* harmony export */ });\n/* harmony import */ var _lib_buildLocalizeFn_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../_lib/buildLocalizeFn.js */ \"(app-pages-browser)/./node_modules/date-fns/locale/_lib/buildLocalizeFn.js\");\n\nconst eraValues = {\n    narrow: [\n        \"p.m.ē\",\n        \"m.ē\"\n    ],\n    abbreviated: [\n        \"p. m. ē.\",\n        \"m. ē.\"\n    ],\n    wide: [\n        \"pirms mūsu ēras\",\n        \"mūsu ērā\"\n    ]\n};\nconst quarterValues = {\n    narrow: [\n        \"1\",\n        \"2\",\n        \"3\",\n        \"4\"\n    ],\n    abbreviated: [\n        \"1. cet.\",\n        \"2. cet.\",\n        \"3. cet.\",\n        \"4. cet.\"\n    ],\n    wide: [\n        \"pirmais ceturksnis\",\n        \"otrais ceturksnis\",\n        \"trešais ceturksnis\",\n        \"ceturtais ceturksnis\"\n    ]\n};\nconst formattingQuarterValues = {\n    narrow: [\n        \"1\",\n        \"2\",\n        \"3\",\n        \"4\"\n    ],\n    abbreviated: [\n        \"1. cet.\",\n        \"2. cet.\",\n        \"3. cet.\",\n        \"4. cet.\"\n    ],\n    wide: [\n        \"pirmajā ceturksnī\",\n        \"otrajā ceturksnī\",\n        \"trešajā ceturksnī\",\n        \"ceturtajā ceturksnī\"\n    ]\n};\nconst monthValues = {\n    narrow: [\n        \"J\",\n        \"F\",\n        \"M\",\n        \"A\",\n        \"M\",\n        \"J\",\n        \"J\",\n        \"A\",\n        \"S\",\n        \"O\",\n        \"N\",\n        \"D\"\n    ],\n    abbreviated: [\n        \"janv.\",\n        \"febr.\",\n        \"marts\",\n        \"apr.\",\n        \"maijs\",\n        \"jūn.\",\n        \"jūl.\",\n        \"aug.\",\n        \"sept.\",\n        \"okt.\",\n        \"nov.\",\n        \"dec.\"\n    ],\n    wide: [\n        \"janvāris\",\n        \"februāris\",\n        \"marts\",\n        \"aprīlis\",\n        \"maijs\",\n        \"jūnijs\",\n        \"jūlijs\",\n        \"augusts\",\n        \"septembris\",\n        \"oktobris\",\n        \"novembris\",\n        \"decembris\"\n    ]\n};\nconst formattingMonthValues = {\n    narrow: [\n        \"J\",\n        \"F\",\n        \"M\",\n        \"A\",\n        \"M\",\n        \"J\",\n        \"J\",\n        \"A\",\n        \"S\",\n        \"O\",\n        \"N\",\n        \"D\"\n    ],\n    abbreviated: [\n        \"janv.\",\n        \"febr.\",\n        \"martā\",\n        \"apr.\",\n        \"maijs\",\n        \"jūn.\",\n        \"jūl.\",\n        \"aug.\",\n        \"sept.\",\n        \"okt.\",\n        \"nov.\",\n        \"dec.\"\n    ],\n    wide: [\n        \"janvārī\",\n        \"februārī\",\n        \"martā\",\n        \"aprīlī\",\n        \"maijā\",\n        \"jūnijā\",\n        \"jūlijā\",\n        \"augustā\",\n        \"septembrī\",\n        \"oktobrī\",\n        \"novembrī\",\n        \"decembrī\"\n    ]\n};\nconst dayValues = {\n    narrow: [\n        \"S\",\n        \"P\",\n        \"O\",\n        \"T\",\n        \"C\",\n        \"P\",\n        \"S\"\n    ],\n    short: [\n        \"Sv\",\n        \"P\",\n        \"O\",\n        \"T\",\n        \"C\",\n        \"Pk\",\n        \"S\"\n    ],\n    abbreviated: [\n        \"svētd.\",\n        \"pirmd.\",\n        \"otrd.\",\n        \"trešd.\",\n        \"ceturtd.\",\n        \"piektd.\",\n        \"sestd.\"\n    ],\n    wide: [\n        \"svētdiena\",\n        \"pirmdiena\",\n        \"otrdiena\",\n        \"trešdiena\",\n        \"ceturtdiena\",\n        \"piektdiena\",\n        \"sestdiena\"\n    ]\n};\nconst formattingDayValues = {\n    narrow: [\n        \"S\",\n        \"P\",\n        \"O\",\n        \"T\",\n        \"C\",\n        \"P\",\n        \"S\"\n    ],\n    short: [\n        \"Sv\",\n        \"P\",\n        \"O\",\n        \"T\",\n        \"C\",\n        \"Pk\",\n        \"S\"\n    ],\n    abbreviated: [\n        \"svētd.\",\n        \"pirmd.\",\n        \"otrd.\",\n        \"trešd.\",\n        \"ceturtd.\",\n        \"piektd.\",\n        \"sestd.\"\n    ],\n    wide: [\n        \"svētdienā\",\n        \"pirmdienā\",\n        \"otrdienā\",\n        \"trešdienā\",\n        \"ceturtdienā\",\n        \"piektdienā\",\n        \"sestdienā\"\n    ]\n};\nconst dayPeriodValues = {\n    narrow: {\n        am: \"am\",\n        pm: \"pm\",\n        midnight: \"pusn.\",\n        noon: \"pusd.\",\n        morning: \"rīts\",\n        afternoon: \"diena\",\n        evening: \"vakars\",\n        night: \"nakts\"\n    },\n    abbreviated: {\n        am: \"am\",\n        pm: \"pm\",\n        midnight: \"pusn.\",\n        noon: \"pusd.\",\n        morning: \"rīts\",\n        afternoon: \"pēcpusd.\",\n        evening: \"vakars\",\n        night: \"nakts\"\n    },\n    wide: {\n        am: \"am\",\n        pm: \"pm\",\n        midnight: \"pusnakts\",\n        noon: \"pusdienlaiks\",\n        morning: \"rīts\",\n        afternoon: \"pēcpusdiena\",\n        evening: \"vakars\",\n        night: \"nakts\"\n    }\n};\nconst formattingDayPeriodValues = {\n    narrow: {\n        am: \"am\",\n        pm: \"pm\",\n        midnight: \"pusn.\",\n        noon: \"pusd.\",\n        morning: \"rītā\",\n        afternoon: \"dienā\",\n        evening: \"vakarā\",\n        night: \"naktī\"\n    },\n    abbreviated: {\n        am: \"am\",\n        pm: \"pm\",\n        midnight: \"pusn.\",\n        noon: \"pusd.\",\n        morning: \"rītā\",\n        afternoon: \"pēcpusd.\",\n        evening: \"vakarā\",\n        night: \"naktī\"\n    },\n    wide: {\n        am: \"am\",\n        pm: \"pm\",\n        midnight: \"pusnaktī\",\n        noon: \"pusdienlaikā\",\n        morning: \"rītā\",\n        afternoon: \"pēcpusdienā\",\n        evening: \"vakarā\",\n        night: \"naktī\"\n    }\n};\nconst ordinalNumber = (dirtyNumber, _options)=>{\n    const number = Number(dirtyNumber);\n    return number + \".\";\n};\nconst localize = {\n    ordinalNumber,\n    era: (0,_lib_buildLocalizeFn_js__WEBPACK_IMPORTED_MODULE_0__.buildLocalizeFn)({\n        values: eraValues,\n        defaultWidth: \"wide\"\n    }),\n    quarter: (0,_lib_buildLocalizeFn_js__WEBPACK_IMPORTED_MODULE_0__.buildLocalizeFn)({\n        values: quarterValues,\n        defaultWidth: \"wide\",\n        formattingValues: formattingQuarterValues,\n        defaultFormattingWidth: \"wide\",\n        argumentCallback: (quarter)=>quarter - 1\n    }),\n    month: (0,_lib_buildLocalizeFn_js__WEBPACK_IMPORTED_MODULE_0__.buildLocalizeFn)({\n        values: monthValues,\n        defaultWidth: \"wide\",\n        formattingValues: formattingMonthValues,\n        defaultFormattingWidth: \"wide\"\n    }),\n    day: (0,_lib_buildLocalizeFn_js__WEBPACK_IMPORTED_MODULE_0__.buildLocalizeFn)({\n        values: dayValues,\n        defaultWidth: \"wide\",\n        formattingValues: formattingDayValues,\n        defaultFormattingWidth: \"wide\"\n    }),\n    dayPeriod: (0,_lib_buildLocalizeFn_js__WEBPACK_IMPORTED_MODULE_0__.buildLocalizeFn)({\n        values: dayPeriodValues,\n        defaultWidth: \"wide\",\n        formattingValues: formattingDayPeriodValues,\n        defaultFormattingWidth: \"wide\"\n    })\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(app-pages-browser)/./node_modules/date-fns/locale/lv/_lib/localize.js\n"));

/***/ }),

/***/ "(app-pages-browser)/./node_modules/date-fns/locale/lv/_lib/match.js":
/*!*******************************************************!*\
  !*** ./node_modules/date-fns/locale/lv/_lib/match.js ***!
  \*******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval(__webpack_require__.ts("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   match: () => (/* binding */ match)\n/* harmony export */ });\n/* harmony import */ var _lib_buildMatchFn_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../_lib/buildMatchFn.js */ \"(app-pages-browser)/./node_modules/date-fns/locale/_lib/buildMatchFn.js\");\n/* harmony import */ var _lib_buildMatchPatternFn_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../_lib/buildMatchPatternFn.js */ \"(app-pages-browser)/./node_modules/date-fns/locale/_lib/buildMatchPatternFn.js\");\n\n\nconst matchOrdinalNumberPattern = /^(\\d+)\\./i;\nconst parseOrdinalNumberPattern = /\\d+/i;\nconst matchEraPatterns = {\n    narrow: /^(p\\.m\\.ē|m\\.ē)/i,\n    abbreviated: /^(p\\. m\\. ē\\.|m\\. ē\\.)/i,\n    wide: /^(pirms mūsu ēras|mūsu ērā)/i\n};\nconst parseEraPatterns = {\n    any: [\n        /^p/i,\n        /^m/i\n    ]\n};\nconst matchQuarterPatterns = {\n    narrow: /^[1234]/i,\n    abbreviated: /^[1234](\\. cet\\.)/i,\n    wide: /^(pirma(is|jā)|otra(is|jā)|treša(is|jā)|ceturta(is|jā)) ceturksn(is|ī)/i\n};\nconst parseQuarterPatterns = {\n    narrow: [\n        /^1/i,\n        /^2/i,\n        /^3/i,\n        /^4/i\n    ],\n    abbreviated: [\n        /^1/i,\n        /^2/i,\n        /^3/i,\n        /^4/i\n    ],\n    wide: [\n        /^p/i,\n        /^o/i,\n        /^t/i,\n        /^c/i\n    ]\n};\nconst matchMonthPatterns = {\n    narrow: /^[jfmasond]/i,\n    abbreviated: /^(janv\\.|febr\\.|marts|apr\\.|maijs|jūn\\.|jūl\\.|aug\\.|sept\\.|okt\\.|nov\\.|dec\\.)/i,\n    wide: /^(janvār(is|ī)|februār(is|ī)|mart[sā]|aprīl(is|ī)|maij[sā]|jūnij[sā]|jūlij[sā]|august[sā]|septembr(is|ī)|oktobr(is|ī)|novembr(is|ī)|decembr(is|ī))/i\n};\nconst parseMonthPatterns = {\n    narrow: [\n        /^j/i,\n        /^f/i,\n        /^m/i,\n        /^a/i,\n        /^m/i,\n        /^j/i,\n        /^j/i,\n        /^a/i,\n        /^s/i,\n        /^o/i,\n        /^n/i,\n        /^d/i\n    ],\n    any: [\n        /^ja/i,\n        /^f/i,\n        /^mar/i,\n        /^ap/i,\n        /^mai/i,\n        /^jūn/i,\n        /^jūl/i,\n        /^au/i,\n        /^s/i,\n        /^o/i,\n        /^n/i,\n        /^d/i\n    ]\n};\nconst matchDayPatterns = {\n    narrow: /^[spotc]/i,\n    short: /^(sv|pi|o|t|c|pk|s)/i,\n    abbreviated: /^(svētd\\.|pirmd\\.|otrd.\\|trešd\\.|ceturtd\\.|piektd\\.|sestd\\.)/i,\n    wide: /^(svētdien(a|ā)|pirmdien(a|ā)|otrdien(a|ā)|trešdien(a|ā)|ceturtdien(a|ā)|piektdien(a|ā)|sestdien(a|ā))/i\n};\nconst parseDayPatterns = {\n    narrow: [\n        /^s/i,\n        /^p/i,\n        /^o/i,\n        /^t/i,\n        /^c/i,\n        /^p/i,\n        /^s/i\n    ],\n    any: [\n        /^sv/i,\n        /^pi/i,\n        /^o/i,\n        /^t/i,\n        /^c/i,\n        /^p/i,\n        /^se/i\n    ]\n};\nconst matchDayPeriodPatterns = {\n    narrow: /^(am|pm|pusn\\.|pusd\\.|rīt(s|ā)|dien(a|ā)|vakar(s|ā)|nakt(s|ī))/,\n    abbreviated: /^(am|pm|pusn\\.|pusd\\.|rīt(s|ā)|pēcpusd\\.|vakar(s|ā)|nakt(s|ī))/,\n    wide: /^(am|pm|pusnakt(s|ī)|pusdienlaik(s|ā)|rīt(s|ā)|pēcpusdien(a|ā)|vakar(s|ā)|nakt(s|ī))/i\n};\nconst parseDayPeriodPatterns = {\n    any: {\n        am: /^am/i,\n        pm: /^pm/i,\n        midnight: /^pusn/i,\n        noon: /^pusd/i,\n        morning: /^r/i,\n        afternoon: /^(d|pēc)/i,\n        evening: /^v/i,\n        night: /^n/i\n    }\n};\nconst match = {\n    ordinalNumber: (0,_lib_buildMatchPatternFn_js__WEBPACK_IMPORTED_MODULE_0__.buildMatchPatternFn)({\n        matchPattern: matchOrdinalNumberPattern,\n        parsePattern: parseOrdinalNumberPattern,\n        valueCallback: (value)=>parseInt(value, 10)\n    }),\n    era: (0,_lib_buildMatchFn_js__WEBPACK_IMPORTED_MODULE_1__.buildMatchFn)({\n        matchPatterns: matchEraPatterns,\n        defaultMatchWidth: \"wide\",\n        parsePatterns: parseEraPatterns,\n        defaultParseWidth: \"any\"\n    }),\n    quarter: (0,_lib_buildMatchFn_js__WEBPACK_IMPORTED_MODULE_1__.buildMatchFn)({\n        matchPatterns: matchQuarterPatterns,\n        defaultMatchWidth: \"wide\",\n        parsePatterns: parseQuarterPatterns,\n        defaultParseWidth: \"wide\",\n        valueCallback: (index)=>index + 1\n    }),\n    month: (0,_lib_buildMatchFn_js__WEBPACK_IMPORTED_MODULE_1__.buildMatchFn)({\n        matchPatterns: matchMonthPatterns,\n        defaultMatchWidth: \"wide\",\n        parsePatterns: parseMonthPatterns,\n        defaultParseWidth: \"any\"\n    }),\n    day: (0,_lib_buildMatchFn_js__WEBPACK_IMPORTED_MODULE_1__.buildMatchFn)({\n        matchPatterns: matchDayPatterns,\n        defaultMatchWidth: \"wide\",\n        parsePatterns: parseDayPatterns,\n        defaultParseWidth: \"any\"\n    }),\n    dayPeriod: (0,_lib_buildMatchFn_js__WEBPACK_IMPORTED_MODULE_1__.buildMatchFn)({\n        matchPatterns: matchDayPeriodPatterns,\n        defaultMatchWidth: \"wide\",\n        parsePatterns: parseDayPeriodPatterns,\n        defaultParseWidth: \"any\"\n    })\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKGFwcC1wYWdlcy1icm93c2VyKS8uL25vZGVfbW9kdWxlcy9kYXRlLWZucy9sb2NhbGUvbHYvX2xpYi9tYXRjaC5qcyIsIm1hcHBpbmdzIjoiOzs7Ozs7QUFBMEQ7QUFDYztBQUV4RSxNQUFNRSw0QkFBNEI7QUFDbEMsTUFBTUMsNEJBQTRCO0FBRWxDLE1BQU1DLG1CQUFtQjtJQUN2QkMsUUFBUTtJQUNSQyxhQUFhO0lBQ2JDLE1BQU07QUFDUjtBQUNBLE1BQU1DLG1CQUFtQjtJQUN2QkMsS0FBSztRQUFDO1FBQU87S0FBTTtBQUNyQjtBQUVBLE1BQU1DLHVCQUF1QjtJQUMzQkwsUUFBUTtJQUNSQyxhQUFhO0lBQ2JDLE1BQU07QUFDUjtBQUNBLE1BQU1JLHVCQUF1QjtJQUMzQk4sUUFBUTtRQUFDO1FBQU87UUFBTztRQUFPO0tBQU07SUFDcENDLGFBQWE7UUFBQztRQUFPO1FBQU87UUFBTztLQUFNO0lBQ3pDQyxNQUFNO1FBQUM7UUFBTztRQUFPO1FBQU87S0FBTTtBQUNwQztBQUVBLE1BQU1LLHFCQUFxQjtJQUN6QlAsUUFBUTtJQUNSQyxhQUNFO0lBQ0ZDLE1BQU07QUFDUjtBQUNBLE1BQU1NLHFCQUFxQjtJQUN6QlIsUUFBUTtRQUNOO1FBQ0E7UUFDQTtRQUNBO1FBQ0E7UUFDQTtRQUNBO1FBQ0E7UUFDQTtRQUNBO1FBQ0E7UUFDQTtLQUNEO0lBRURJLEtBQUs7UUFDSDtRQUNBO1FBQ0E7UUFDQTtRQUNBO1FBQ0E7UUFDQTtRQUNBO1FBQ0E7UUFDQTtRQUNBO1FBQ0E7S0FDRDtBQUNIO0FBRUEsTUFBTUssbUJBQW1CO0lBQ3ZCVCxRQUFRO0lBQ1JVLE9BQU87SUFDUFQsYUFBYTtJQUNiQyxNQUFNO0FBQ1I7QUFDQSxNQUFNUyxtQkFBbUI7SUFDdkJYLFFBQVE7UUFBQztRQUFPO1FBQU87UUFBTztRQUFPO1FBQU87UUFBTztLQUFNO0lBQ3pESSxLQUFLO1FBQUM7UUFBUTtRQUFRO1FBQU87UUFBTztRQUFPO1FBQU87S0FBTztBQUMzRDtBQUVBLE1BQU1RLHlCQUF5QjtJQUM3QlosUUFBUTtJQUNSQyxhQUFhO0lBQ2JDLE1BQU07QUFDUjtBQUNBLE1BQU1XLHlCQUF5QjtJQUM3QlQsS0FBSztRQUNIVSxJQUFJO1FBQ0pDLElBQUk7UUFDSkMsVUFBVTtRQUNWQyxNQUFNO1FBQ05DLFNBQVM7UUFDVEMsV0FBVztRQUNYQyxTQUFTO1FBQ1RDLE9BQU87SUFDVDtBQUNGO0FBRU8sTUFBTUMsUUFBUTtJQUNuQkMsZUFBZTNCLGdGQUFtQkEsQ0FBQztRQUNqQzRCLGNBQWMzQjtRQUNkNEIsY0FBYzNCO1FBQ2Q0QixlQUFlLENBQUNDLFFBQVVDLFNBQVNELE9BQU87SUFDNUM7SUFFQUUsS0FBS2xDLGtFQUFZQSxDQUFDO1FBQ2hCbUMsZUFBZS9CO1FBQ2ZnQyxtQkFBbUI7UUFDbkJDLGVBQWU3QjtRQUNmOEIsbUJBQW1CO0lBQ3JCO0lBRUFDLFNBQVN2QyxrRUFBWUEsQ0FBQztRQUNwQm1DLGVBQWV6QjtRQUNmMEIsbUJBQW1CO1FBQ25CQyxlQUFlMUI7UUFDZjJCLG1CQUFtQjtRQUNuQlAsZUFBZSxDQUFDUyxRQUFVQSxRQUFRO0lBQ3BDO0lBRUFDLE9BQU96QyxrRUFBWUEsQ0FBQztRQUNsQm1DLGVBQWV2QjtRQUNmd0IsbUJBQW1CO1FBQ25CQyxlQUFleEI7UUFDZnlCLG1CQUFtQjtJQUNyQjtJQUVBSSxLQUFLMUMsa0VBQVlBLENBQUM7UUFDaEJtQyxlQUFlckI7UUFDZnNCLG1CQUFtQjtRQUNuQkMsZUFBZXJCO1FBQ2ZzQixtQkFBbUI7SUFDckI7SUFFQUssV0FBVzNDLGtFQUFZQSxDQUFDO1FBQ3RCbUMsZUFBZWxCO1FBQ2ZtQixtQkFBbUI7UUFDbkJDLGVBQWVuQjtRQUNmb0IsbUJBQW1CO0lBQ3JCO0FBQ0YsRUFBRSIsInNvdXJjZXMiOlsiL1VzZXJzL2dlb3JnaWprdWxpYXN2aWxpL0RvY3VtZW50cy9HaXRIdWIveXVtbWVyLWFwcHMvcGF5bG9hZC1jbXMvbm9kZV9tb2R1bGVzL2RhdGUtZm5zL2xvY2FsZS9sdi9fbGliL21hdGNoLmpzIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGJ1aWxkTWF0Y2hGbiB9IGZyb20gXCIuLi8uLi9fbGliL2J1aWxkTWF0Y2hGbi5qc1wiO1xuaW1wb3J0IHsgYnVpbGRNYXRjaFBhdHRlcm5GbiB9IGZyb20gXCIuLi8uLi9fbGliL2J1aWxkTWF0Y2hQYXR0ZXJuRm4uanNcIjtcblxuY29uc3QgbWF0Y2hPcmRpbmFsTnVtYmVyUGF0dGVybiA9IC9eKFxcZCspXFwuL2k7XG5jb25zdCBwYXJzZU9yZGluYWxOdW1iZXJQYXR0ZXJuID0gL1xcZCsvaTtcblxuY29uc3QgbWF0Y2hFcmFQYXR0ZXJucyA9IHtcbiAgbmFycm93OiAvXihwXFwubVxcLsSTfG1cXC7EkykvaSxcbiAgYWJicmV2aWF0ZWQ6IC9eKHBcXC4gbVxcLiDEk1xcLnxtXFwuIMSTXFwuKS9pLFxuICB3aWRlOiAvXihwaXJtcyBtxatzdSDEk3Jhc3xtxatzdSDEk3LEgSkvaSxcbn07XG5jb25zdCBwYXJzZUVyYVBhdHRlcm5zID0ge1xuICBhbnk6IFsvXnAvaSwgL15tL2ldLFxufTtcblxuY29uc3QgbWF0Y2hRdWFydGVyUGF0dGVybnMgPSB7XG4gIG5hcnJvdzogL15bMTIzNF0vaSxcbiAgYWJicmV2aWF0ZWQ6IC9eWzEyMzRdKFxcLiBjZXRcXC4pL2ksXG4gIHdpZGU6IC9eKHBpcm1hKGlzfGrEgSl8b3RyYShpc3xqxIEpfHRyZcWhYShpc3xqxIEpfGNldHVydGEoaXN8asSBKSkgY2V0dXJrc24oaXN8xKspL2ksXG59O1xuY29uc3QgcGFyc2VRdWFydGVyUGF0dGVybnMgPSB7XG4gIG5hcnJvdzogWy9eMS9pLCAvXjIvaSwgL14zL2ksIC9eNC9pXSxcbiAgYWJicmV2aWF0ZWQ6IFsvXjEvaSwgL14yL2ksIC9eMy9pLCAvXjQvaV0sXG4gIHdpZGU6IFsvXnAvaSwgL15vL2ksIC9edC9pLCAvXmMvaV0sXG59O1xuXG5jb25zdCBtYXRjaE1vbnRoUGF0dGVybnMgPSB7XG4gIG5hcnJvdzogL15bamZtYXNvbmRdL2ksXG4gIGFiYnJldmlhdGVkOlxuICAgIC9eKGphbnZcXC58ZmViclxcLnxtYXJ0c3xhcHJcXC58bWFpanN8asWrblxcLnxqxatsXFwufGF1Z1xcLnxzZXB0XFwufG9rdFxcLnxub3ZcXC58ZGVjXFwuKS9pLFxuICB3aWRlOiAvXihqYW52xIFyKGlzfMSrKXxmZWJydcSBcihpc3zEqyl8bWFydFtzxIFdfGFwcsSrbChpc3zEqyl8bWFpaltzxIFdfGrFq25paltzxIFdfGrFq2xpaltzxIFdfGF1Z3VzdFtzxIFdfHNlcHRlbWJyKGlzfMSrKXxva3RvYnIoaXN8xKspfG5vdmVtYnIoaXN8xKspfGRlY2VtYnIoaXN8xKspKS9pLFxufTtcbmNvbnN0IHBhcnNlTW9udGhQYXR0ZXJucyA9IHtcbiAgbmFycm93OiBbXG4gICAgL15qL2ksXG4gICAgL15mL2ksXG4gICAgL15tL2ksXG4gICAgL15hL2ksXG4gICAgL15tL2ksXG4gICAgL15qL2ksXG4gICAgL15qL2ksXG4gICAgL15hL2ksXG4gICAgL15zL2ksXG4gICAgL15vL2ksXG4gICAgL15uL2ksXG4gICAgL15kL2ksXG4gIF0sXG5cbiAgYW55OiBbXG4gICAgL15qYS9pLFxuICAgIC9eZi9pLFxuICAgIC9ebWFyL2ksXG4gICAgL15hcC9pLFxuICAgIC9ebWFpL2ksXG4gICAgL15qxatuL2ksXG4gICAgL15qxatsL2ksXG4gICAgL15hdS9pLFxuICAgIC9ecy9pLFxuICAgIC9eby9pLFxuICAgIC9ebi9pLFxuICAgIC9eZC9pLFxuICBdLFxufTtcblxuY29uc3QgbWF0Y2hEYXlQYXR0ZXJucyA9IHtcbiAgbmFycm93OiAvXltzcG90Y10vaSxcbiAgc2hvcnQ6IC9eKHN2fHBpfG98dHxjfHBrfHMpL2ksXG4gIGFiYnJldmlhdGVkOiAvXihzdsSTdGRcXC58cGlybWRcXC58b3RyZC5cXHx0cmXFoWRcXC58Y2V0dXJ0ZFxcLnxwaWVrdGRcXC58c2VzdGRcXC4pL2ksXG4gIHdpZGU6IC9eKHN2xJN0ZGllbihhfMSBKXxwaXJtZGllbihhfMSBKXxvdHJkaWVuKGF8xIEpfHRyZcWhZGllbihhfMSBKXxjZXR1cnRkaWVuKGF8xIEpfHBpZWt0ZGllbihhfMSBKXxzZXN0ZGllbihhfMSBKSkvaSxcbn07XG5jb25zdCBwYXJzZURheVBhdHRlcm5zID0ge1xuICBuYXJyb3c6IFsvXnMvaSwgL15wL2ksIC9eby9pLCAvXnQvaSwgL15jL2ksIC9ecC9pLCAvXnMvaV0sXG4gIGFueTogWy9ec3YvaSwgL15waS9pLCAvXm8vaSwgL150L2ksIC9eYy9pLCAvXnAvaSwgL15zZS9pXSxcbn07XG5cbmNvbnN0IG1hdGNoRGF5UGVyaW9kUGF0dGVybnMgPSB7XG4gIG5hcnJvdzogL14oYW18cG18cHVzblxcLnxwdXNkXFwufHLEq3Qoc3zEgSl8ZGllbihhfMSBKXx2YWthcihzfMSBKXxuYWt0KHN8xKspKS8sXG4gIGFiYnJldmlhdGVkOiAvXihhbXxwbXxwdXNuXFwufHB1c2RcXC58csSrdChzfMSBKXxwxJNjcHVzZFxcLnx2YWthcihzfMSBKXxuYWt0KHN8xKspKS8sXG4gIHdpZGU6IC9eKGFtfHBtfHB1c25ha3Qoc3zEqyl8cHVzZGllbmxhaWsoc3zEgSl8csSrdChzfMSBKXxwxJNjcHVzZGllbihhfMSBKXx2YWthcihzfMSBKXxuYWt0KHN8xKspKS9pLFxufTtcbmNvbnN0IHBhcnNlRGF5UGVyaW9kUGF0dGVybnMgPSB7XG4gIGFueToge1xuICAgIGFtOiAvXmFtL2ksXG4gICAgcG06IC9ecG0vaSxcbiAgICBtaWRuaWdodDogL15wdXNuL2ksXG4gICAgbm9vbjogL15wdXNkL2ksXG4gICAgbW9ybmluZzogL15yL2ksXG4gICAgYWZ0ZXJub29uOiAvXihkfHDEk2MpL2ksXG4gICAgZXZlbmluZzogL152L2ksXG4gICAgbmlnaHQ6IC9ebi9pLFxuICB9LFxufTtcblxuZXhwb3J0IGNvbnN0IG1hdGNoID0ge1xuICBvcmRpbmFsTnVtYmVyOiBidWlsZE1hdGNoUGF0dGVybkZuKHtcbiAgICBtYXRjaFBhdHRlcm46IG1hdGNoT3JkaW5hbE51bWJlclBhdHRlcm4sXG4gICAgcGFyc2VQYXR0ZXJuOiBwYXJzZU9yZGluYWxOdW1iZXJQYXR0ZXJuLFxuICAgIHZhbHVlQ2FsbGJhY2s6ICh2YWx1ZSkgPT4gcGFyc2VJbnQodmFsdWUsIDEwKSxcbiAgfSksXG5cbiAgZXJhOiBidWlsZE1hdGNoRm4oe1xuICAgIG1hdGNoUGF0dGVybnM6IG1hdGNoRXJhUGF0dGVybnMsXG4gICAgZGVmYXVsdE1hdGNoV2lkdGg6IFwid2lkZVwiLFxuICAgIHBhcnNlUGF0dGVybnM6IHBhcnNlRXJhUGF0dGVybnMsXG4gICAgZGVmYXVsdFBhcnNlV2lkdGg6IFwiYW55XCIsXG4gIH0pLFxuXG4gIHF1YXJ0ZXI6IGJ1aWxkTWF0Y2hGbih7XG4gICAgbWF0Y2hQYXR0ZXJuczogbWF0Y2hRdWFydGVyUGF0dGVybnMsXG4gICAgZGVmYXVsdE1hdGNoV2lkdGg6IFwid2lkZVwiLFxuICAgIHBhcnNlUGF0dGVybnM6IHBhcnNlUXVhcnRlclBhdHRlcm5zLFxuICAgIGRlZmF1bHRQYXJzZVdpZHRoOiBcIndpZGVcIixcbiAgICB2YWx1ZUNhbGxiYWNrOiAoaW5kZXgpID0+IGluZGV4ICsgMSxcbiAgfSksXG5cbiAgbW9udGg6IGJ1aWxkTWF0Y2hGbih7XG4gICAgbWF0Y2hQYXR0ZXJuczogbWF0Y2hNb250aFBhdHRlcm5zLFxuICAgIGRlZmF1bHRNYXRjaFdpZHRoOiBcIndpZGVcIixcbiAgICBwYXJzZVBhdHRlcm5zOiBwYXJzZU1vbnRoUGF0dGVybnMsXG4gICAgZGVmYXVsdFBhcnNlV2lkdGg6IFwiYW55XCIsXG4gIH0pLFxuXG4gIGRheTogYnVpbGRNYXRjaEZuKHtcbiAgICBtYXRjaFBhdHRlcm5zOiBtYXRjaERheVBhdHRlcm5zLFxuICAgIGRlZmF1bHRNYXRjaFdpZHRoOiBcIndpZGVcIixcbiAgICBwYXJzZVBhdHRlcm5zOiBwYXJzZURheVBhdHRlcm5zLFxuICAgIGRlZmF1bHRQYXJzZVdpZHRoOiBcImFueVwiLFxuICB9KSxcblxuICBkYXlQZXJpb2Q6IGJ1aWxkTWF0Y2hGbih7XG4gICAgbWF0Y2hQYXR0ZXJuczogbWF0Y2hEYXlQZXJpb2RQYXR0ZXJucyxcbiAgICBkZWZhdWx0TWF0Y2hXaWR0aDogXCJ3aWRlXCIsXG4gICAgcGFyc2VQYXR0ZXJuczogcGFyc2VEYXlQZXJpb2RQYXR0ZXJucyxcbiAgICBkZWZhdWx0UGFyc2VXaWR0aDogXCJhbnlcIixcbiAgfSksXG59O1xuIl0sIm5hbWVzIjpbImJ1aWxkTWF0Y2hGbiIsImJ1aWxkTWF0Y2hQYXR0ZXJuRm4iLCJtYXRjaE9yZGluYWxOdW1iZXJQYXR0ZXJuIiwicGFyc2VPcmRpbmFsTnVtYmVyUGF0dGVybiIsIm1hdGNoRXJhUGF0dGVybnMiLCJuYXJyb3ciLCJhYmJyZXZpYXRlZCIsIndpZGUiLCJwYXJzZUVyYVBhdHRlcm5zIiwiYW55IiwibWF0Y2hRdWFydGVyUGF0dGVybnMiLCJwYXJzZVF1YXJ0ZXJQYXR0ZXJucyIsIm1hdGNoTW9udGhQYXR0ZXJucyIsInBhcnNlTW9udGhQYXR0ZXJucyIsIm1hdGNoRGF5UGF0dGVybnMiLCJzaG9ydCIsInBhcnNlRGF5UGF0dGVybnMiLCJtYXRjaERheVBlcmlvZFBhdHRlcm5zIiwicGFyc2VEYXlQZXJpb2RQYXR0ZXJucyIsImFtIiwicG0iLCJtaWRuaWdodCIsIm5vb24iLCJtb3JuaW5nIiwiYWZ0ZXJub29uIiwiZXZlbmluZyIsIm5pZ2h0IiwibWF0Y2giLCJvcmRpbmFsTnVtYmVyIiwibWF0Y2hQYXR0ZXJuIiwicGFyc2VQYXR0ZXJuIiwidmFsdWVDYWxsYmFjayIsInZhbHVlIiwicGFyc2VJbnQiLCJlcmEiLCJtYXRjaFBhdHRlcm5zIiwiZGVmYXVsdE1hdGNoV2lkdGgiLCJwYXJzZVBhdHRlcm5zIiwiZGVmYXVsdFBhcnNlV2lkdGgiLCJxdWFydGVyIiwiaW5kZXgiLCJtb250aCIsImRheSIsImRheVBlcmlvZCJdLCJpZ25vcmVMaXN0IjpbMF0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(app-pages-browser)/./node_modules/date-fns/locale/lv/_lib/match.js\n"));

/***/ })

}]);